function [psnr, iter] = gme_ransac_psnr(seq_in, mv_path, pC, pR, nFrm)

%% input file
[fid_seq_in message]= fopen(seq_in,'rb');

%% parameters of a synthetic motion field
%
blkSiz = 8; % block size
bC=pC/blkSiz; % number of column in blocks
bR=pR/blkSiz; % number of row in blocks

% get the coordinates
[coorBlkY,coorBlkX]=ndgrid(1:bR,1:bC);
coorX = coorBlkX.*blkSiz-blkSiz/2;
coorY = coorBlkY.*blkSiz-blkSiz/2;

GM_TRAN = 1;  % translational model
GM_ISOT = 2;  % isotripic model
GM_AFFI = 3;  % affine model
GM_PERS = 4;  % perspective model
HALFPIX=2; % Half pixel
ITER_RANSAC = 1000;

for ii = 1:nFrm
    % get one frame from YUV sequence (YUV: 411 format) 
    [yCurr, uCurr, vCurr] = readOneFrame(fid_seq_in, pR, pC);
    if ii > 1
        %% get input noisy motion field
        [npx, npy] = readMVs(mv_path,ii, bC, bR, HALFPIX);

        %% GME with ransac
        rcoorX = coorX + npx;
        rcoorY = coorY + npy;
        [ranM, nIter] = ranGME(GM_PERS, rcoorX(:), rcoorY(:), coorX(:), coorY(:), ITER_RANSAC);

        if ~isempty(ranM)
            psnr(ii-1)=psnrGMC(yPrev, yCurr, ranM(1:end-1)'); 
            iter(ii-1)=nIter;
        else
            psnr(ii-1)=psnr(ii-2); 
            iter(ii-1)=iter(ii-2);
        end
%             psnr(ii-1)=0;
%             iter(ii-1)=0;
    end
    yPrev = yCurr;  % copy it as a reference frame
end

fclose(fid_seq_in);

% the PSNR after applying global motion compensation.
function psnr = psnrGMC(yPrev, yCurr, M)
yWarp=gmeTF(yCurr, M, 1);
D=yWarp-yPrev;
[pR, pC] = size(D);
mse=sum(D(:).*D(:))/(pC*pR);
psnr=10*log10(255^2/mse); % PSNR for affine motion model
