%
% exhaustive search for 8x8 block
%
function [mv] = motionEst(seq_in, MOT_PATH, nColumn, nRow, nFrm)

[fid_seq_in message]= fopen(seq_in,'rb');

mbSize = 8;
p = 16;

height = nRow; nH = height/mbSize;
width = nColumn; nW = width/mbSize;

for i = 1:nH
    coorBlkX(i, :) = 1:nW;
end
for i = 1:nW
    coorBlkY(:,i) = nH:-1:1;
end

for ii = 1:1:nFrm
    disp(sprintf('ME - #%d,', ii));
    
    if ii == 1
        [prev_y, prev_u, prev_v] = readOneFrame(fid_seq_in, nRow, nColumn);
        continue;
    else
        [curr_y, curr_u, curr_v] = readOneFrame(fid_seq_in, nRow, nColumn);
    end
    %
    % Exhaustive search
    %
    [motionVect, computations] = motionEstES(double(curr_y),...
        double(prev_y),mbSize,p);
    
    % extend to be half-pixel precision
    motionVect = motionVect.*2;
    
    mvFout = sprintf('%s\\matlab_mv_%d.txt', MOT_PATH, ii);
    csvwrite(mvFout, motionVect);
    
    % set the current frame as the reference frame
    prev_y = curr_y;
end

fclose(fid_seq_in);


disp('done!');

