function rates = loadFRBOtherRates_FRB(dates)

dates = dates(:);

% The data have been extracted already, so we just load the raw version of
% the rates
input = ['data/FRB/DAILY_RATES.mat'];
file = dir(input);

% If for some reason the rates were not extracted beforehand, an error
% message is displayed
if isempty(file)
  error('You must extract the data first!');
else
  load(input);
  rates.date = datenum(rates.date,'yyyy-mm-dd');
  % If the 3-month rate is zero, typically it means that the data for this
  % day are not available, so we remove them (this is true for other rates
  % too)
  rates(rates.tcmnom_m3 == 0,:) = [];
end

% We compute the continuously compounded rates needed to obtain the forward
% rate
% See the following website for more details on these calculations: 
% https://home.treasury.gov/policy-issues/financing-the-government/interest-rate-statistics/interest-rates-frequently-asked-questions
rate_m3  = log( ( 1 + interp1(rates.date,rates.tcmnom_m3,dates,'previous')./100./4 ).^4 );
rate_y1  = log( ( 1 + interp1(rates.date,rates.tcmnom_y1,dates,'previous')./100./2 ).^2 );
rate_y2  = log( ( 1 + interp1(rates.date,rates.tcmnom_y2,dates,'previous')./100./2 ).^2 );
rate_y3  = log( ( 1 + interp1(rates.date,rates.tcmnom_y3,dates,'previous')./100./2 ).^2 );
rate_y5  = log( ( 1 + interp1(rates.date,rates.tcmnom_y5,dates,'previous')./100./2 ).^2 );
rate_y7  = log( ( 1 + interp1(rates.date,rates.tcmnom_y7,dates,'previous')./100./2 ).^2 );
rate_y10 = log( ( 1 + interp1(rates.date,rates.tcmnom_y10,dates,'previous')./100./2 ).^2 );
rate_y20 = log( ( 1 + interp1(rates.date,rates.tcmnom_y20,dates,'previous')./100./2 ).^2 );
rate_y30 = log( ( 1 + interp1(rates.date,rates.tcmnom_y30,dates,'previous')./100./2 ).^2 );

% Hack: if the 30-year rate is missing, we replace it with the 20-year rate
rate_y30(rate_y30 == 0) = rate_y20(rate_y30 == 0);

% We create a matrix that contains all the rates
M = [dates(:), ...
     rate_m3(:), ...
     rate_y1(:), ...
     rate_y2(:), ...
     rate_y3(:), ...
     rate_y5(:), ...
     rate_y7(:), ...
     rate_y10(:), ...
     rate_y30(:)];

% And we create a table based on that matrix
rates = dataset2table(dataset({M, 'Date', 'Rate_3m', 'Rate_1y', 'Rate_2y', 'Rate_3y', 'Rate_5y', 'Rate_7y', 'Rate_10y', 'Rate_30y'}));

end
