function rates = loadFRBShortRate_FRB(dates)

dates = dates(:);

% The data have been extracted already, so we just load the raw version of
% the rates
input = ['data/FRB/DAILY_RATES.mat'];
file = dir(input);

% If for some reason the rates were not extracted beforehand, an error
% message is displayed
if isempty(file)
  error('You must extract the data first!');
else
  load(input);
  rates.date = datenum(rates.date,'yyyy-mm-dd');
  % If the 3-month rate is zero, typically it means that the data for this
  % day are not available, so we remove them (this is true for other rates
  % too)
  rates(rates.tcmnom_m3 == 0,:) = [];
end

% We compute the continuously compounded rates needed to obtain the forward
% rate
% See the following website for more details on these calculations: 
% https://home.treasury.gov/policy-issues/financing-the-government/interest-rate-statistics/interest-rates-frequently-asked-questions
rate = log( (1 + interp1(rates.date,rates.tcmnom_m3,dates,'previous')./100./4).^4 );

% We create a table based on the computed rates
rates = dataset2table(dataset({[dates(:), rate(:)], 'Date', 'Rate'}));

end
