function CPI = loadInflationIndexLevel_FRED(dates)

dates = dates(:);

% The data have been extracted already, so we just load the raw version of
% the rates
input = ['data/FRED/CPIAUCSL.mat'];
file = dir(input);

% If for some reason the rates were not extracted beforehand, an error
% message is displayed
if isempty(file)
  error('You must extract the data first!');
else
  load(input);
end

% We find the right index value and inflation rate based on the calendar 
% provided
inflation = interp1(CPIAUCSL.Date,CPIAUCSL.Rate,dates);
cpi       = interp1(CPIAUCSL.Date,CPIAUCSL.CPI,dates);

CPI.Date  = dates(:);
CPI.Rate  = inflation(:);
CPI.Index = cpi(:);

% We create a table based on the computed rates
CPI = struct2table(CPI);

end