function FEDTARGET = loadIntendedFedFundsRate_FRED(dates)

dates = dates(:);

% The data have been extracted already, so we just load the raw version of
% the rates
input1 = ['data/FRED/DFEDTAR.mat'];
input2 = ['data/FRED/DFEDTARL.mat'];
input3 = ['data/FRED/DFEDTARU.mat'];
file1 = dir(input1);
file2 = dir(input2);
file3 = dir(input3);

% If for some reason the rates were not extracted beforehand, an error
% message is displayed
if isempty(file1) || isempty(file2) || isempty(file3)
  error('You must extract the data first!');
else
  load(input1);
  load(input2);
  load(input3);
end

% We take the average of the upper and lower bounds 
DFEDTARU.Rate = (DFEDTARU.Rate + DFEDTARL.Rate)./2;
DFEDTAR       = [DFEDTAR;DFEDTARU];

% We find the right index value, returns, and yields based on the calendar
% provided
intfedfundsrate = interp1(datenum(DFEDTAR.Date),DFEDTAR.Rate,dates)./100;

FEDTARGET.Date  = dates(:);
FEDTARGET.Rate  = intfedfundsrate(:);

% We create a table with the data
FEDTARGET = struct2table(FEDTARGET);

end

