function SPX = loadSPX_Bloomberg(dates)

dates = dates(:);

% The data have been extracted already, so we just load the raw version of
% the rates
input = ['data/Bloomberg/SPX.mat'];
file = dir(input);

% If for some reason the rates were not extracted beforehand, an error
% message is displayed
if isempty(file)
  error('You must extract the data first!');
else
  load(input);
end

% We compute monthly return and dividend yield
SPX.Return        = [NaN;diff(log(SPX.Index))];
SPX.DividendYield = SPX.DividendPayment./SPX.Index;

% We smooth the yields by using the 12-month sum of the payouts (as
% commonly done)
for di = 12:length(SPX.Date)
  SPX.DividendYield(di) = sum(SPX.DividendPayment(di-11:di))./SPX.Index(di);
end

% We find the right index value, returns, and yields based on the calendar
% provided
indexvalue  = interp1(datenum(SPX.Date),SPX.Index,dates);
returns     = interp1(datenum(SPX.Date),SPX.Return,dates);
yield       = interp1(datenum(SPX.Date),SPX.DividendYield,dates);

SP500.Date          = dates(:);
SP500.Index         = indexvalue(:);
SP500.Return        = returns(:);
SP500.DividendYield = yield(:);

% We create a table with the data
SPX = struct2table(SP500);

end