function fig = figData(dates)

FEDTARGET         = loadIntendedFedFundsRate_FRED(dates);
CPI               = loadInflationIndexLevel_FRED(dates);
SHORTRATES        = loadFRBShortRate_FRB(dates);
RATES             = loadFRBOtherRates_FRB(dates);
SPX               = loadSPX_Bloomberg(dates);
SPX.ExcessReturn  = SPX.Return - SHORTRATES.Rate/12;

fig = figure('units','pixels','outerposition',[0 0 1000 1200]);
load('lib/colormap_default');

subplot(5,1,1)
plot(FEDTARGET.Date,FEDTARGET.Rate,'LineWidth',2,'Color',cc(1,:));
ylim([0,0.15]);
datetick('x','yyyy');
xlim([dates(1),dates(end)]);
title('Intended Federal Funds Rate')
set(gca,'fontsize', 10)

subplot(5,1,2)
plot(CPI.Date,CPI.Rate,'LineWidth',2,'Color',cc(1,:));
ylim([-0.02,0.02]);
datetick('x','yyyy');
xlim([dates(1),dates(end)]);
title('Inflation Rate')
set(gca,'fontsize', 10)

subplot(5,1,3)
plot(RATES.Date,table2array(RATES(:,2)),'k-','LineWidth',2,'Color',cc(1,:));
hold on
plot(RATES.Date,table2array(RATES(:,3)),'k-','LineWidth',2,'Color',cc(33,:));
plot(RATES.Date,table2array(RATES(:,4)),'k-','LineWidth',2,'Color',cc(66,:));
plot(RATES.Date,table2array(RATES(:,5)),'k-','LineWidth',2,'Color',cc(100,:));
plot(RATES.Date,table2array(RATES(:,6)),'k-','LineWidth',2,'Color',cc(133,:));
plot(RATES.Date,table2array(RATES(:,7)),'k-','LineWidth',2,'Color',cc(166,:));
plot(RATES.Date,table2array(RATES(:,8)),'k-','LineWidth',2,'Color',cc(200,:));
plot(RATES.Date,table2array(RATES(:,9)),'k-','LineWidth',2,'Color',cc(233,:));
hold off
ylim([0,0.16]);
datetick('x','yyyy');
xlim([dates(1),dates(end)]);
title('Term Structure')
set(gca,'fontsize', 10)
legend('3-month','1-year','2-year','3-year','5-year','7-year','10-year','30-year','orientation','horizontal');

subplot(5,1,4)
plot(SPX.Date,SPX.DividendYield,'k-','LineWidth',2,'Color',cc(1,:));
ylim([0,0.06]);
datetick('x','yyyy');
xlim([dates(1),dates(end)]);
title('Dividend Yield')
set(gca,'fontsize', 10)

subplot(5,1,5)
plot(SPX.Date,SPX.Return,'k-','LineWidth',2,'Color',cc(1,:));
ylim([-0.25,0.25]);
datetick('x','yyyy');
xlim([dates(1),dates(end)]);
title('Stock Index Returns')
set(gca,'fontsize', 10)

end