function [fig1] = figExample(dates,paths,id)

FEDTARGET         = loadIntendedFedFundsRate_FRED(dates);
CPI               = loadInflationIndexLevel_FRED(dates);
SHORTRATES        = loadFRBShortRate_FRB(dates);
RATES             = loadFRBOtherRates_FRB(dates);
SPX               = loadSPX_Bloomberg(dates);
SPX.ExcessReturn  = SPX.Return - SHORTRATES.Rate/12;

set(0,'DefaultFigureColor', 'w');

%%

fig1 = figure('units','pixels','outerposition',[0 0 1000 1000]);
tt = parula(256);

subplot(4,2,1)
plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,paths.Inflation(id,2:end),'m:','linewidth',2,'color',tt(1,:))
hold on
plot(CPI.Date,(CPI.Rate),'k-','linewidth',2)
hold off
legend('$\mathcal{M}_4$','interpreter','latex','orientation','horizontal','location','northwest')
title('Inflation Rate');
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
set(gca,'fontsize', 10)
ylim([-0.02,0.02]);

%%

subplot(4,2,2)
plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,paths.ShortRate(id,2:end),'m:','linewidth',2,'color',tt(1,:))
hold on
plot(SHORTRATES.Date,SHORTRATES.Rate,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Short Rate');
set(gca,'fontsize', 10)
ylim([0,0.12])

%%
subplot(4,2,6)
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,paths.Dividends(id,2:end),'m:','linewidth',2,'color',tt(1,:))
hold on
plot(SPX.Date,SPX.DividendYield,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Dividend Yield');
set(gca,'fontsize', 10)

%%

subplot(4,2,7)

plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,paths.IndexReturns(id,2:end),'m:','linewidth',2,'color',tt(1,:))
hold on
plot(SPX.Date,SPX.Return,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Stock Index Returns');
set(gca,'fontsize', 10)
ylim([-0.25,0.25]);

%%

subplot(4,2,3)

plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,paths.ForwardRate.r1(id,2:end),'m:','linewidth',2,'color',tt(1,:))
hold on
plot(RATES.Date,RATES.Rate_1y,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('1-Year Risk-Free Rate');
set(gca,'fontsize', 10)
ylim([0,0.13])

subplot(4,2,4)

plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,paths.ForwardRate.r5(id,2:end),'m:','linewidth',2,'color',tt(1,:))
hold on
plot(RATES.Date,RATES.Rate_5y,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('5-Year Risk-Free Rate');
set(gca,'fontsize', 10)
ylim([0,0.15])

subplot(4,2,5)

plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,paths.ForwardRate.r30(id,2:end),'m:','linewidth',2,'color',tt(1,:))
hold on
plot(RATES.Date,RATES.Rate_30y,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('30-Year Risk-Free Rate');
set(gca,'fontsize', 10)
ylim([0,0.15])

end
