function fig = figFactors(dates)

RATES             = loadFRBOtherRates_FRB(dates);

forModel = ForwardRate('calendar',     RATES.Date, ...
                       'series',       RATES(:,2:end), ...
                       'maturities',   [1,2,3,5,7,10,30], ...
                       'scale_pvalues',false, ...
                       'model_restr',  3);

y    = forModel.transfseries;
F(:,1) = y(:,7) - y(:,1);
F(:,2) = y(:,7) + y(:,1) -2.*y(:,3);

fig = figure('units','pixels','outerposition',[0 0 1000 400]);
load('lib/colormap_default');

plot(dates,F(:,1),'k-','LineWidth',2,'Color',cc(1,:))
hold on
plot(dates,F(:,2),'k-','LineWidth',2,'Color',cc(166,:))
hold off
ylim([-0.03,0.06]);
datetick('x','yyyy');
xlim([dates(1),dates(end)]);
legend('Slope','Curvature','orientation','horizontal','location','southeast')
title('Forward Rate Factors')
set(gca,'fontsize', 10)

end