function fig1 = figFunnelofDoubtAll(dates,pathsW,pathsE,pathsA,pathsB)

% We load the data
FEDTARGET         = loadIntendedFedFundsRate_FRED(dates);
CPI               = loadInflationIndexLevel_FRED(dates);
SHORTRATES        = loadFRBShortRate_FRB(dates);
RATES             = loadFRBOtherRates_FRB(dates);
SPX               = loadSPX_Bloomberg(dates);
SPX.ExcessReturn  = SPX.Return - SHORTRATES.Rate/12;

fig1 = figure('units','pixels','outerposition',[0 0 1000 1200]);
load('lib/colormap_default');

%%
subplot(4,2,1)
mW = quantile(((pathsW.Inflation(:,2:end))),[0.5])';
qW = quantile(((pathsW.Inflation(:,2:end))),[0.05,0.95])';
mE = quantile(((pathsE.Inflation(:,2:end))),[0.5])';
qE = quantile(((pathsE.Inflation(:,2:end))),[0.05,0.95])';
mA = quantile(((pathsA.Inflation(:,2:end))),[0.5])';
qA = quantile(((pathsA.Inflation(:,2:end))),[0.05,0.95])';
mB = quantile(((pathsB.Inflation(:,2:end))),[0.5])';
qB = quantile(((pathsB.Inflation(:,2:end))),[0.05,0.95])';

plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,mW,'m-','linewidth',2,'color',cc(1,:))
hold on
plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,mE,'r-','linewidth',2,'color',cc(75,:))
plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,mA,'r-','linewidth',2,'color',cc(150,:))
plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,mB,'b-','linewidth',2,'color',cc(230,:))
plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,qW,'m--','linewidth',2,'color',cc(1,:))
plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,qE,'m--','linewidth',2,'color',cc(75,:))
plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,qA,'r--','linewidth',2,'color',cc(150,:))
plot(CPI.Date(end)+((1/12):(1/12):30).*365.25,qB,'b--','linewidth',2,'color',cc(230,:))
plot(CPI.Date,(CPI.Rate),'k-','linewidth',2)
hold off
legend('$\mathcal{M}_1$','$\mathcal{M}_2$','$\mathcal{M}_3$','$\mathcal{M}_4$','interpreter','latex','orientation','horizontal','location','southeast','NumColumns',2)
title('Panel A: Inflation Rate');
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
set(gca,'fontsize', 10)
ylim([-0.02,0.02]);


%%
subplot(4,2,2)
mW = quantile(((pathsW.ShortRate(:,2:end))),[0.5])';
qW = quantile(((pathsW.ShortRate(:,2:end))),[0.05,0.95])';
mE = quantile(((pathsE.ShortRate(:,2:end))),[0.5])';
qE = quantile(((pathsE.ShortRate(:,2:end))),[0.05,0.95])';
mA = quantile(((pathsA.ShortRate(:,2:end))),[0.5])';
qA = quantile(((pathsA.ShortRate(:,2:end))),[0.05,0.95])';
mB = quantile(((pathsB.ShortRate(:,2:end))),[0.5])';
qB = quantile(((pathsB.ShortRate(:,2:end))),[0.05,0.95])';

plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,mW,'m-','linewidth',2,'color',cc(1,:))
hold on
plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,mE,'r-','linewidth',2,'color',cc(75,:))
plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,mA,'r-','linewidth',2,'color',cc(150,:))
plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,mB,'b-','linewidth',2,'color',cc(230,:))
plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,qW,'m--','linewidth',2,'color',cc(1,:))
plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,qE,'m--','linewidth',2,'color',cc(75,:))
plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,qA,'r--','linewidth',2,'color',cc(150,:))
plot(SHORTRATES.Date(end)+((1/12):(1/12):30).*365.25,qB,'b--','linewidth',2,'color',cc(230,:))
plot(SHORTRATES.Date,SHORTRATES.Rate,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Panel B: Short Rate');
set(gca,'fontsize', 10)
ylim([0,0.12])

%%
subplot(4,2,6)
mW = quantile(((pathsW.Dividends(:,2:end))),[0.5])';
qW = quantile(((pathsW.Dividends(:,2:end))),[0.05,0.95])';
mE = quantile(((pathsE.Dividends(:,2:end))),[0.5])';
qE = quantile(((pathsE.Dividends(:,2:end))),[0.05,0.95])';
mA = quantile(((pathsA.Dividends(:,2:end))),[0.5])';
qA = quantile(((pathsA.Dividends(:,2:end))),[0.05,0.95])';
mB = quantile(((pathsB.Dividends(:,2:end))),[0.5])';
qB = quantile(((pathsB.Dividends(:,2:end))),[0.05,0.95])';

plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,mW,'m-','linewidth',2,'color',cc(1,:))
hold on
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,mE,'r-','linewidth',2,'color',cc(75,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,mA,'r-','linewidth',2,'color',cc(150,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,mB,'b-','linewidth',2,'color',cc(230,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,qW,'m--','linewidth',2,'color',cc(1,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,qE,'m--','linewidth',2,'color',cc(75,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,qA,'r--','linewidth',2,'color',cc(150,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,qB,'b--','linewidth',2,'color',cc(230,:))
plot(SPX.Date,SPX.DividendYield,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Panel F: Dividend Yield');
set(gca,'fontsize', 10)

%%
subplot(4,2,7)
mW = quantile(((pathsW.IndexReturns(:,2:end))),[0.5])';
qW = quantile(((pathsW.IndexReturns(:,2:end))),[0.05,0.95])';
mE = quantile(((pathsE.IndexReturns(:,2:end))),[0.5])';
qE = quantile(((pathsE.IndexReturns(:,2:end))),[0.05,0.95])';
mA = quantile(((pathsA.IndexReturns(:,2:end))),[0.5])';
qA = quantile(((pathsA.IndexReturns(:,2:end))),[0.05,0.95])';
mB = quantile(((pathsB.IndexReturns(:,2:end))),[0.5])';
qB = quantile(((pathsB.IndexReturns(:,2:end))),[0.05,0.95])';

plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,mW,'m-','linewidth',2,'color',cc(1,:))
hold on
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,mE,'r-','linewidth',2,'color',cc(75,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,mA,'r-','linewidth',2,'color',cc(150,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,mB,'b-','linewidth',2,'color',cc(230,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,qW,'m--','linewidth',2,'color',cc(1,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,qE,'m--','linewidth',2,'color',cc(75,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,qA,'r--','linewidth',2,'color',cc(150,:))
plot(SPX.Date(end)+((1/12):(1/12):30).*365.25,qB,'b--','linewidth',2,'color',cc(230,:))
plot(SPX.Date,(SPX.Return),'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Panel G: Stock Index Returns');
set(gca,'fontsize', 10)
ylim([-0.25,0.15]);

%%
subplot(4,2,3)

mW = quantile(((pathsW.ForwardRate.r1(:,2:end))),[0.5])';
qW = quantile(((pathsW.ForwardRate.r1(:,2:end))),[0.05,0.95])';
mE = quantile(((pathsE.ForwardRate.r1(:,2:end))),[0.5])';
qE = quantile(((pathsE.ForwardRate.r1(:,2:end))),[0.05,0.95])';
mA = quantile(((pathsA.ForwardRate.r1(:,2:end))),[0.5])';
qA = quantile(((pathsA.ForwardRate.r1(:,2:end))),[0.05,0.95])';
mB = quantile(((pathsB.ForwardRate.r1(:,2:end))),[0.5])';
qB = quantile(((pathsB.ForwardRate.r1(:,2:end))),[0.05,0.95])';

plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mW,'m-','linewidth',2,'color',cc(1,:))
hold on
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mE,'r-','linewidth',2,'color',cc(75,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mA,'r-','linewidth',2,'color',cc(150,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mB,'b-','linewidth',2,'color',cc(230,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qW,'m--','linewidth',2,'color',cc(1,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qE,'m--','linewidth',2,'color',cc(75,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qA,'r--','linewidth',2,'color',cc(150,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qB,'b--','linewidth',2,'color',cc(230,:))
plot(RATES.Date,RATES.Rate_1y,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Panel C: 1-Year Interest Rate');
set(gca,'fontsize', 10)
ylim([0,0.13])

%%
subplot(4,2,4)
mW = quantile(((pathsW.ForwardRate.r5(:,2:end))),[0.5])';
qW = quantile(((pathsW.ForwardRate.r5(:,2:end))),[0.05,0.95])';
mE = quantile(((pathsE.ForwardRate.r5(:,2:end))),[0.5])';
qE = quantile(((pathsE.ForwardRate.r5(:,2:end))),[0.05,0.95])';
mA = quantile(((pathsA.ForwardRate.r5(:,2:end))),[0.5])';
qA = quantile(((pathsA.ForwardRate.r5(:,2:end))),[0.05,0.95])';
mB = quantile(((pathsB.ForwardRate.r5(:,2:end))),[0.5])';
qB = quantile(((pathsB.ForwardRate.r5(:,2:end))),[0.05,0.95])';
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mW,'m-','linewidth',2,'color',cc(1,:))
hold on
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mE,'r-','linewidth',2,'color',cc(75,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mA,'r-','linewidth',2,'color',cc(150,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mB,'b-','linewidth',2,'color',cc(230,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qW,'m--','linewidth',2,'color',cc(1,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qE,'m--','linewidth',2,'color',cc(75,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qA,'r--','linewidth',2,'color',cc(150,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qB,'b--','linewidth',2,'color',cc(230,:))
plot(RATES.Date,RATES.Rate_5y,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Panel D: 5-Year Interest Rate');
set(gca,'fontsize', 10)
ylim([0,0.15])

%%
subplot(4,2,5)
mW = quantile(((pathsW.ForwardRate.r30(:,2:end))),[0.5])';
qW = quantile(((pathsW.ForwardRate.r30(:,2:end))),[0.05,0.95])';
mE = quantile(((pathsE.ForwardRate.r30(:,2:end))),[0.5])';
qE = quantile(((pathsE.ForwardRate.r30(:,2:end))),[0.05,0.95])';
mA = quantile(((pathsA.ForwardRate.r30(:,2:end))),[0.5])';
qA = quantile(((pathsA.ForwardRate.r30(:,2:end))),[0.05,0.95])';
mB = quantile(((pathsB.ForwardRate.r30(:,2:end))),[0.5])';
qB = quantile(((pathsB.ForwardRate.r30(:,2:end))),[0.05,0.95])';
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mW,'m-','linewidth',2,'color',cc(1,:))
hold on
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mE,'r-','linewidth',2,'color',cc(75,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mA,'r-','linewidth',2,'color',cc(150,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,mB,'b-','linewidth',2,'color',cc(230,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qW,'m--','linewidth',2,'color',cc(1,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qE,'m--','linewidth',2,'color',cc(75,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qA,'r--','linewidth',2,'color',cc(150,:))
plot(RATES.Date(end)+((1/12):(1/12):30).*365.25,qB,'b--','linewidth',2,'color',cc(230,:))
plot(RATES.Date,RATES.Rate_30y,'k-','linewidth',2)
hold off
datetick('x','yyyy');
xlim([dates(1),dates(end)+30*366]);
title('Panel E: 30-Year Interest Rate');
set(gca,'fontsize', 10)
ylim([0,0.15])

end
