function fig = figMonetary(dates)

FEDTARGET         = loadIntendedFedFundsRate_FRED(dates);

model = Monetary('calendar',FEDTARGET.Date, ...
                 'series',  FEDTARGET.Rate, ...
                 'scale_pvalues',false);

m     = model.regimes;
dates = model.calendar;

fig = figure('units','pixels','outerposition',[0 0 1000 300]);
load('lib/colormap_default');
cc = cc([1,75,133,230],:);

hold on;
for dm = 1:3
%   fill([dates(1),dates(1)+2,dates(1)+2,dates(1)], [1,2,2,1], [0.925-0.15.*dm,0.925-0.15.*dm,0.925-0.15.*dm], 'EdgeColor', 'none');
  fill([dates(1),dates(1)+2,dates(1)+2,dates(1)], [1,2,2,1], cc(dm+1,:), 'EdgeColor', 'none');
end
plot([dates(1),dates(1)],[1,1],'LineWidth',2,'Color','k');

dates = serialdates(dates);
for dm = 1:3
  tmp = find(m == dm)';

  peak_dates =    dates([tmp(1), tmp(find(diff(tmp) > 1) + 1)])';
  through_dates = dates([tmp(find(diff(tmp) > 1))+1, min(length(dates),tmp(end)+1)])';
  contractions = [peak_dates(:), through_dates(:)];
  contractions = [contractions, contractions(:,2:-1:1)];

  foreground = get(gca,'Children');
  ylimits = [0,0.15];
  ylimits = [ylimits(1)  ylimits(1)  ylimits(2)  ylimits(2)];
  for rn = 1:length(peak_dates)
%     handles(rn,1) = fill(contractions(rn,:), ylimits, [1-0.17.*dm,1-0.17.*dm,1-0.17.*dm], 'EdgeColor', 'none');
    handles(rn,1) = fill(contractions(rn,:), ylimits, cc(dm+1,:), 'EdgeColor', 'none');
  end
end
plot(dates+15,model.series,'LineWidth',2,'Color','k')
hold off
ylim([0,0.15]);
datetick('x','yyyy');
xlim([dates(1),dates(end)]);
legend('u','s','d','orientation','horizontal')
title('Intended Federal Funds Rate and Monetary Policy Regimes')
set(gca,'fontsize', 10)

end