function [fig1,fig2,fig3,fig4,fig5,fig6] = figTracePlots()

load('results/chains_Begin.mat')

factor{1} = 'Monetary';
factor{2} = 'Inflation';
factor{3} = 'ShortRate';
factor{4} = 'Dividends';
factor{5} = 'IndexReturns';
factor{6} = 'ForwardRate';

for df = 1:length(factor)
  variables{df} = fieldnames(chains.(factor{df}));
end

set(0,'DefaultFigureColor', 'w');

variables_names{1} = {'{\itp}_{uu}','{\itp}_{su}','{\itp}_{sd}','{\itp}_{dd}','{\itm}_0'};

fig1 = figure('units','pixels','outerposition',[0 0 1000 255]);
tt = colormap();
df = 1;
for dv = 1:4
  subplot(1,5,dv)
  plot(chains.(factor{df}).(variables{df}{dv}),'k-','linewidth',1.5,'color',tt(1,:))
  title(variables_names{df}{dv})
end
subplot(1,5,5)

variables_names{2} = {'{\mu}_{{\itq},u}','{\mu}_{{\itq},s}','{\mu}_{{\itq},d}','{\ita}_{{\itq}}','\sigma^2_{{\itq}}', ...
                      '\alpha_{\itq}','\beta_{\itq}','\gamma_{\itq}','{\itq}_0','\sigma^2_{{\itq},1}'};

fig2 = figure('units','pixels','outerposition',[0 0 1000 430]);
df = 2;
for dv = 1:8
  subplot(2,5,dv)
  if dv == 7
    plot(chains.(factor{df}).(variables{df}{dv})-chains.(factor{df}).(variables{df}{dv-1}),'k-','linewidth',1.5,'color',tt(1,:))
  else
    plot(chains.(factor{df}).(variables{df}{dv}),'k-','linewidth',1.5,'color',tt(1,:))
  end
  title(variables_names{df}{dv})
end

variables_names{3} = {'{\mu}_{{\itr},u}','{\mu}_{{\itr},s}','{\mu}_{{\itr},d}','{\ita}_{{\itr}}','\rho_{{\itr,q}}',...
                      '\sigma^2_{{\itr}}','\alpha_{\itr}','\beta_{\itr}','\gamma_{\itr}','{\itr}_0','\sigma^2_{{\itr},1}'};

fig3 = figure('units','pixels','outerposition',[0 0 1000 430]);
df = 3;
for dv = 1:9
  subplot(2,5,dv)
  if dv == 8
    plot(chains.(factor{df}).(variables{df}{dv})-chains.(factor{df}).(variables{df}{dv-1}),'k-','linewidth',1.5,'color',tt(1,:))
  else
    plot(chains.(factor{df}).(variables{df}{dv}),'k-','linewidth',1.5,'color',tt(1,:))
  end
  title(variables_names{df}{dv})
end

variables_names{4} = {'{\mu}_{{\itd},u}','{\mu}_{{\itd},s}','{\mu}_{{\itd},d}','{\ita}_{{\itd}}','\rho_{{\itq,d}}','\rho_{{\itr,d}}',...
                      '\sigma^2_{{\itd}}','\alpha_{\itd}','\beta_{\itd}','\gamma_{\itd}','{\itd}_0','\sigma^2_{{\itd},1}'};

fig4 = figure('units','pixels','outerposition',[0 0 1000 430]);
df = 4;
for dv = 1:10
  subplot(2,5,dv)
  if dv == 9
    plot(chains.(factor{df}).(variables{df}{dv})-chains.(factor{df}).(variables{df}{dv-1}),'k-','linewidth',1.5,'color',tt(1,:))
  else
    plot(chains.(factor{df}).(variables{df}{dv}),'k-','linewidth',1.5,'color',tt(1,:))
  end
  title(variables_names{df}{dv})
end

variables_names{5} = {'{\mu}_{{\ity},u}','{\mu}_{{\ity},s}','{\mu}_{{\ity},d}',...
                      '\sigma^2_{{\ity}}','\alpha_{\ity}','\beta_{\ity}','\gamma_{\ity}','\sigma^2_{{\ity},1}'};

fig5 = figure('units','pixels','outerposition',[0 0 1000 430]);
df = 5;
for dv = 1:7
  subplot(2,5,dv)
  if dv == 6
    plot(chains.(factor{df}).(variables{df}{dv})-chains.(factor{df}).(variables{df}{dv-1}),'k-','linewidth',1.5,'color',tt(1,:))
  else
    plot(chains.(factor{df}).(variables{df}{dv}),'k-','linewidth',1.5,'color',tt(1,:))
  end
  title(variables_names{df}{dv})
end

variables_names{6} = {'{\mu}_{{\itf_1}}','{\mu}_{{\itf_2}}','{\mu}_{{\itf_3}}','{\mu}_{{\itf_5}}','{\mu}_{{\itf_7}}', ...
                      '{\mu}_{{\itf_{10}}}','{\mu}_{{\itf_{30}}}','\sigma^2_{{\itf_1}}','\sigma^2_{{\itf_2}}','\sigma^2_{{\itf_3}}', ...
                      '\sigma^2_{{\itf_5}}','\sigma^2_{{\itf_7}}','\sigma^2_{{\itf_{10}}}','\sigma^2_{{\itf_{30}}}','a_{{\itf_1},1}', ... 
                      'a_{{\itf_2},1}','a_{{\itf_3},1}','a_{{\itf_5},1}','a_{{\itf_7},1}','a_{{\itf_{10}},1}','a_{{\itf_{30}},1}', ...
                      'a_{{\itf_1},2}','a_{{\itf_2},2}','a_{{\itf_3},2}','a_{{\itf_5},2}','a_{{\itf_7},2}','a_{{\itf_{10}},2}','a_{{\itf_{30}},2}', ...
                      '\mu_{{\itF_1}}','\mu_{{\itF_2}}','a_{{\itF_1}}','a_{{\itF_2}}','\sigma^{2}_{{\itF_1}}','\sigma^{ 2}_{{\itF_2}}'};

fig6 = figure('units','pixels','outerposition',[0 0 1000 1505]);
df = 6;
for dv = 1:34
  subplot(7,5,dv)
  if dv == 6
    plot(chains.(factor{df}).(variables{df}{dv})-chains.(factor{df}).(variables{df}{dv-1}),'k-','linewidth',1.5,'color',tt(1,:))
  else
    plot(chains.(factor{df}).(variables{df}{dv}),'k-','linewidth',1.5,'color',tt(1,:))
  end
  title(variables_names{df}{dv})
end

end