package fish;

import processing.core.*;

public class Fish extends PApplet {
	
	int pondX, pondY, pondWidth, pondHeight;
	int fishX, fishY, fishWidth, fishHeight, fishSpeed;
	boolean fishFlip;
	FishClass fish;

	public void setup() {
		smooth();
		size(1280, 1024);
		
		pondX = pondY = 10;
		pondWidth = (width) - 20;
		pondHeight = (height) - 20;
		
		fishWidth = 428;
		fishHeight = 263;
		fishX = (width / 2) - (fishWidth / 2) + pondX;
		fishY = (height / 2)  - (fishHeight / 2) + pondY;
		fishSpeed = 4;
		
		fish = new FishClass(fishX, fishY, fishWidth, fishHeight, fishSpeed, fishFlip, pondX, pondY, pondWidth, pondHeight, this);
	}
	
	public void draw() {
		background(255);
		drawPond();
		fish.update();
		fish.drawFish();
	}
	
	public void drawPond() {
		fill(184, 208, 222);
		rect(pondX, pondY, pondWidth, pondHeight);
	}
}
