package fish;

import processing.core.PApplet;

public class FishClass extends Fish { // extends Fish only to inherit same variables
	
	PApplet p;
	
	FishClass(int fishX, int fishY, int fishWidth, int fishHeight, int fishSpeed, boolean fishFlip, int pondX, int pondY, int pondWidth, int pondHeight, PApplet p) {
		this.pondX = pondX;
		this.pondY = pondY;
		this.pondWidth = pondWidth;
		this.pondHeight = pondHeight;
		this.fishX = fishX;
		this.fishY = fishY;
		this.fishWidth = fishWidth;
		this.fishHeight = fishHeight;
		this.fishSpeed = fishSpeed;
		this.fishFlip = fishFlip;
		this.p = p;
	}
	
	public void update() {
		fishX -= fishSpeed;
		
		if (fishX - pondX <= 0 || fishX - pondX >= pondWidth) {
			fishSpeed *= -1;
			fishFlip = !fishFlip;
			if (fishFlip) // account for asymmetrical flip offset
				fishX += fishWidth;
			else
				fishX -= fishWidth;
		}
	}
	
	public void drawFish() {
		p.translate(fishX, fishY);
		if (fishFlip)
			p.scale(-1, 1);
		
		p.fill(255, 123, 0);  
		p.beginShape();
		p.vertex((float) 1.7388535, (float)  136.0);
		p.bezierVertex((float) 3.0, (float)  138.0, (float)  8.686607, (float)  145.55557, (float)  1.7388535, (float)  136.0);
		p.bezierVertex((float) -5.2089005, (float)  126.44443, (float)  14.0, (float)  50.0, (float)  75.0, (float)  45.0);
		p.bezierVertex((float) 136.0, (float)  40.0, (float)  105.0, (float)  -5.0, (float)  186.0, (float)  0.0);
		p.bezierVertex((float) 267.0, (float)  5.0, (float)  239.0, (float)  56.0, (float)  252.0, (float)  61.0);
		p.bezierVertex((float) 265.0, (float)  66.0, (float)  257.0, (float)  63.0, (float)  267.0, (float)  67.0);
		p.bezierVertex((float) 277.0, (float)  71.0, (float)  286.0, (float)  35.0, (float)  316.0, (float)  50.0);
		p.bezierVertex((float) 346.0, (float)  65.0, (float)  328.0, (float)  87.0, (float)  328.0, (float)  87.0);
		p.bezierVertex((float) 328.0, (float)  87.0, (float)  344.0, (float)  98.0, (float)  344.0, (float)  98.0);
		p.bezierVertex((float) 344.0, (float)  98.0, (float)  381.0, (float)  45.0, (float)  407.0, (float)  61.0);
		p.bezierVertex((float) 433.0, (float)  77.0, (float)  440.0, (float)  223.0, (float)  397.0, (float)  214.0);
		p.bezierVertex((float) 354.0, (float)  205.0, (float)  348.0, (float)  188.0, (float)  344.0, (float)  188.0);
		p.bezierVertex((float) 340.0, (float)  188.0, (float)  336.0, (float)  189.0, (float)  327.0, (float)  198.0);
		p.bezierVertex((float) 318.0, (float)  207.0, (float)  333.0, (float)  222.0, (float)  312.0, (float)  237.0);
		p.bezierVertex((float) 291.0, (float)  252.0, (float)  269.0, (float)  224.0, (float)  270.0, (float)  225.0);
		p.bezierVertex((float) 271.0, (float)  226.0, (float)  246.0, (float)  234.0, (float)  220.0, (float)  227.0);
		p.bezierVertex((float) 194.0, (float)  220.0, (float)  218.0, (float)  255.0, (float)  179.0, (float)  260.0);
		p.bezierVertex((float) 140.0, (float)  265.0, (float)  139.0, (float)  219.0, (float)  131.0, (float)  223.0);
		p.bezierVertex((float) 123.0, (float)  227.0, (float)  67.0, (float)  227.0, (float)  31.0, (float)  196.0);
		p.bezierVertex((float) -5.0, (float)  165.0, (float)  90.0, (float)  163.0, (float)  49.0, (float)  154.0);
		p.bezierVertex((float) 8.0, (float)  145.0, (float)  4.0, (float)  152.0, (float)  1.0, (float)  136.0);
		p.endShape();
		//body

		p.fill(255);
		p.beginShape();
		p.vertex((float) 69.73013, (float)  117.0);
		p.bezierVertex((float) 48.160175, (float)  101.165276, (float)  69.73013, (float)  117.0, (float)  69.73013, (float)  117.0);
		p.bezierVertex((float) 47.0, (float)  101.0, (float)  74.49162, (float)  83.833405, (float)  73.0, (float)  83.0);
		p.bezierVertex((float) 103.57808, (float)  82.16659, (float)  93.34395, (float)  114.49978, (float)  69.73013, (float)  117.0);
		p.endShape();
		//eye

		p.fill(0);
		p.beginShape();
		p.vertex((float) 61.563538, (float)  103.00989);
		p.bezierVertex((float) 61.563538, (float)  103.00989, (float)  61.563538, (float)  103.00989, (float)  61.563538, (float)  103.00989);
		p.bezierVertex((float) 61.563538, (float)  103.00989, (float)  55.540504, (float)  124.86945, (float)  82.87586, (float)  113.93967);
		p.bezierVertex((float) 84.729126, (float)  86.61523, (float)  65.27003, (float)  103.00989, (float)  62.02687, (float)  101.643654);
		p.endShape();
		//eyeball

		p.fill(255);
		p.beginShape();
		p.vertex((float) 87.0, (float)  43.0);
		p.bezierVertex((float) 122.0, (float)  33.0, (float)  98.0, (float)  41.0, (float)  87.0, (float)  43.0);
		p.bezierVertex((float) 110.0, (float)  74.0, (float)  140.0, (float)  218.0, (float)  115.0, (float)  221.0);
		p.bezierVertex((float) 111.0, (float)  225.0, (float)  132.0, (float)  227.0, (float)  133.0, (float)  223.0);
		p.bezierVertex((float) 152.0, (float)  214.0, (float)  124.0, (float)  27.0, (float)  87.0, (float)  43.0);
		p.endShape();

		p.beginShape();
		p.vertex((float) 213.0, (float)  54.0);
		p.bezierVertex((float) 207.0, (float)  40.0, (float)  211.0, (float)  54.0, (float)  213.0, (float)  54.0);
		p.bezierVertex((float) 253.0, (float)  107.0, (float)  238.0, (float)  219.0, (float)  223.0, (float)  229.0);
		p.bezierVertex((float) 236.0, (float)  228.0, (float)  236.0, (float)  231.0, (float)  246.0, (float)  228.0);
		p.bezierVertex((float) 267.0, (float)  236.0, (float)  259.0, (float)  22.0, (float)  210.0, (float)  49.0);
		p.endShape();

		p.beginShape();
		p.vertex((float) 326.0, (float)  88.0);
		p.bezierVertex((float) 344.0, (float)  101.0, (float)  327.0, (float)  88.0, (float)  326.0, (float)  88.0);
		p.bezierVertex((float) 356.0, (float)  89.0, (float)  331.0, (float)  196.0, (float)  325.0, (float)  200.0);
		p.bezierVertex((float) 325.0, (float)  200.0, (float)  357.0, (float)  203.0, (float)  354.0, (float)  193.0);
		p.bezierVertex((float) 350.0, (float)  195.0, (float)  369.0, (float)  92.0, (float)  339.0, (float)  90.0);
		p.endShape();
		//stripes

		p.noFill();
		p.beginShape();
		p.vertex((float) 108.51926, (float)  165.0);
		p.bezierVertex((float) 108.51926, (float)  159.68849, (float)  108.0, (float)  165.0, (float)  108.51926, (float)  165.0);
		p.bezierVertex((float) 119.06379, (float)  180.93454, (float)  122.076515, (float)  203.95113, (float)  104.00016, (float)  219.00043);
		p.endShape();
		//gill

		p.fill(255, 123, 0);
		p.beginShape();
		p.vertex((float) 201.0, (float)  131.0);
		p.bezierVertex((float) 192.0, (float)  129.0, (float)  201.0, (float)  132.0, (float)  201.0, (float)  131.0);
		p.bezierVertex((float) 205.0, (float)  131.0, (float)  270.0, (float)  103.0, (float)  241.0, (float)  174.0);
		p.bezierVertex((float) 241.0, (float)  176.0, (float)  223.0, (float)  187.0, (float)  193.0, (float)  179.0);
		p.endShape();
		//middle fin

		p.noFill();
		p.beginShape();
		p.vertex((float) 94.0, (float)  43.0);
		p.bezierVertex((float) 91.0, (float)  44.0, (float)  94.0, (float)  43.0, (float)  94.0, (float)  43.0);
		p.bezierVertex((float) 94.0, (float)  43.0, (float)  164.0, (float)  22.0, (float)  242.0, (float)  56.0);
		p.endShape();
		//top fin divider

		p.fill(0);
		p.beginShape();
		p.vertex((float) 134.0, (float)  9.0);
		p.bezierVertex((float) 142.0, (float)  5.0, (float)  139.0, (float)  12.0, (float)  134.0, (float)  9.0);
		p.bezierVertex((float) 134.0, (float)  9.0, (float)  144.0, (float)  3.0, (float)  160.0, (float)  1.0);
		p.bezierVertex((float) 160.0, (float)  1.0, (float)  193.0, (float)  -5.0, (float)  226.0, (float)  10.0);
		p.bezierVertex((float) 226.0, (float)  10.0, (float)  244.0, (float)  20.0, (float)  242.0, (float)  24.0);
		p.bezierVertex((float) 245.0, (float)  25.0, (float)  178.0, (float)  -7.0, (float)  136.0, (float)  10.0);
		p.endShape();
		//top fin p.fill

		p.fill(0);
		p.beginShape();
		p.vertex((float) 149.0, (float)  251.0);
		p.bezierVertex((float) 149.0, (float)  251.0, (float)  149.0, (float)  251.0, (float)  149.0, (float)  251.0);
		p.bezierVertex((float) 171.0, (float)  273.0, (float)  197.0, (float)  253.0, (float)  197.0, (float)  253.0);
		p.bezierVertex((float) 197.0, (float)  253.0, (float)  164.0, (float)  258.0, (float)  149.0, (float)  251.0);
		p.endShape();
		//bottom fin p.fill

		p.fill(0);
		p.beginShape();
		p.vertex((float) 294.0, (float)  47.76195);
		p.bezierVertex((float) 294.0, (float)  47.76195, (float)  294.0, (float)  47.76195, (float)  294.0, (float)  47.76195);
		p.bezierVertex((float) 317.8485, (float)  36.68123, (float)  342.0, (float)  62.0, (float)  333.0, (float)  70.0);
		p.bezierVertex((float) 334.0, (float)  70.0, (float)  323.57214, (float)  44.99177, (float)  294.0, (float)  47.76195);
		p.endShape();
		//top right fin p.fill

		p.fill(0);
		p.beginShape();
		p.vertex((float) 286.0, (float)  237.0);
		p.bezierVertex((float) 286.0, (float)  237.0, (float)  286.0, (float)  237.0, (float)  286.0, (float)  237.0);
		p.bezierVertex((float) 303.0, (float)  251.0, (float)  316.0, (float)  232.0, (float)  316.0, (float)  232.0);
		p.bezierVertex((float) 316.0, (float)  232.0, (float)  290.0, (float)  240.0, (float)  288.0, (float)  237.0);
		p.endShape();
		//bottom right fin p.fill

		p.fill(0);
		p.beginShape();
		p.vertex((float) 234.0, (float)  127.0);
		p.bezierVertex((float) 234.0, (float)  127.0, (float)  234.0, (float)  127.0, (float)  234.0, (float)  127.0);
		p.bezierVertex((float) 263.0, (float)  139.0, (float)  240.0, (float)  177.0, (float)  236.0, (float)  177.0);
		p.bezierVertex((float) 236.0, (float)  177.0, (float)  245.0, (float)  132.0, (float)  234.0, (float)  128.0);
		p.endShape();
		//middle fin p.fill

		p.fill(0);
		p.beginShape();
		p.vertex((float) 405.0, (float)  60.0);
		p.bezierVertex((float) 405.0, (float)  60.0, (float)  405.0, (float)  60.0, (float)  405.0, (float)  60.0);
		p.bezierVertex((float) 441.0, (float)  80.0, (float)  431.0, (float)  214.0, (float)  412.0, (float)  209.0);
		p.bezierVertex((float) 412.0, (float)  207.0, (float)  431.0, (float)  159.0, (float)  402.0, (float)  62.0);
		p.endShape();
		//tail fin p.fill

		p.beginShape();
		p.vertex((float) 401.0, (float)  71.0);
		p.bezierVertex((float) 401.0, (float)  71.0, (float)  401.0, (float)  71.0, (float)  401.0, (float)  71.0);
		p.bezierVertex((float) 401.0, (float)  71.0, (float)  352.0, (float)  102.0, (float)  352.0, (float)  102.0);
		p.endShape();

		p.beginShape();
		p.vertex((float) 355.0, (float)  115.0);
		p.bezierVertex((float) 355.0, (float)  115.0, (float)  355.0, (float)  115.0, (float)  355.0, (float)  115.0);
		p.bezierVertex((float) 355.0, (float)  115.0, (float)  408.0, (float)  96.0, (float)  408.0, (float)  96.0);
		p.endShape();

		p.beginShape();
		p.vertex((float) 356.0, (float)  126.0);
		p.bezierVertex((float) 356.0, (float)  126.0, (float)  356.0, (float)  126.0, (float)  356.0, (float)  126.0);
		p.bezierVertex((float) 356.0, (float)  126.0, (float)  411.0, (float)  120.0, (float)  411.0, (float)  120.0);
		p.endShape();

		p.beginShape();
		p.vertex((float) 357.0, (float)  138.0);
		p.bezierVertex((float) 357.0, (float)  138.0, (float)  357.0, (float)  138.0, (float)  357.0, (float)  138.0);
		p.bezierVertex((float) 357.0, (float)  138.0, (float)  415.0, (float)  142.0, (float)  415.0, (float)  142.0);
		p.endShape();

		p.beginShape();
		p.vertex((float) 356.0, (float)  180.0);
		p.bezierVertex((float) 356.0, (float)  180.0, (float)  356.0, (float)  180.0, (float)  356.0, (float)  180.0);
		p.bezierVertex((float) 356.0, (float)  180.0, (float)  409.0, (float)  200.0, (float)  409.0, (float)  200.0);
		p.endShape();

		p.beginShape();
		p.vertex((float) 357.0, (float)  166.0);
		p.bezierVertex((float) 357.0, (float)  166.0, (float)  357.0, (float)  166.0, (float)  357.0, (float)  166.0);
		p.bezierVertex((float) 357.0, (float)  166.0, (float)  413.0, (float)  181.0, (float)  413.0, (float)  181.0);
		p.endShape();

		p.beginShape();
		p.vertex((float) 356.0, (float)  152.0);
		p.bezierVertex((float) 356.0, (float)  152.0, (float)  356.0, (float)  152.0, (float)  356.0, (float)  152.0);
		p.bezierVertex((float) 356.0, (float)  152.0, (float)  415.0, (float)  161.0, (float)  415.0, (float)  161.0);
		p.endShape();
		//tail fin deco
	}
}
