package testAppletDrawing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class TestAppletDrawing extends Applet
{
	Color faceColor;
	public void init()
	{
		faceColor = Color.yellow;
	}

	public void paint(Graphics g)
	{
		draw(g);
	}
	
	public void draw(Graphics g) {
		Dimension size = getSize();
		int d = Math.min(size.width, size.height); // face diameter
		int ed = d / 20; // eye diameter
		
		int x = (size.width - d) / 2;
		int y = (size.height - d) / 2;
		
		// draw face
		g.setColor(faceColor);
		g.fillOval(x, y, d, d);
		
		g.setColor(Color.blue);
		g.drawOval(x, y, d, d);
		
		// draw eyes
		g.fillOval(x + d / 3 - (ed / 2), y + d / 3 - (ed / 2), ed, ed);
		g.fillOval(x + 2 * d / 3 - (ed / 2), y + d / 3 - (ed / 2), ed, ed);
	
		// draw nose
		g.setColor(Color.red);
		g.fillOval(x + d / 2 - (ed / 4), y + d / 2 - (ed / 4), ed / 2, ed / 2);
		g.drawOval(x + d / 2 - (ed / 4), y + d / 2 - (ed / 4), ed / 2, ed / 2);
	
		// draw mouth
		g.drawArc(x + d/4,  y + 3 * (d / 5), d / 2, d / 3, 0, 180);
	}
}
