package lab4;

import processing.core.PApplet;

public class Ball {
	PApplet p;
	int bSize;
	int bColor;
	float posX, posY, velX, velY, wave, waveSpeed, amp, accX, accY, damp;
	
	Ball(PApplet p) {
		this.p = p;
		
		posX = p.random(p.width);
		posY = p.random(p.height);
		velX = p.random(-2, 2);
		velY = p.random(-2, 2);
		//wave = p.random(p.TWO_PI);
		//waveSpeed = p.random(0.1f, 0.4f);
		//amp = p.random(1, 4);
		accX = 1;
		accY = 1;
		damp = 0.95f;

		bSize = (int) p.random(16, 32);
		bColor = p.color(p.random(128) + 127, p.random(128), 0);

	}
	
	Ball(PApplet p, float posX, float posY, int bSize, int bColor) {
		this.p = p;
		
		velX = p.random(-2, 2);
		velY = p.random(-2, 2);
		//wave = p.random(p.TWO_PI);
		//waveSpeed = p.random(0.1f, 0.9f);
		//amp = p.random(1, 4);
		
		this.posX = posX;
		this.posY = posY;
		this.bSize = bSize;
		this.bColor = bColor;
	}
	
	public void update() {
		//wave += waveSpeed;
		velX += accX;
		velY += accY;
		posX += velX;
		posY += velY; //+ p.sin(wave) * amp;
		
		velX *= damp;
		velY *= damp;
		
		walls();
	}
	
	public void walls() {
		// right wall
		if (posX > p.width - bSize / 2) {
			posX = p.width - bSize / 2;
			velX *= -1;
		}
		// left wall
		if (posX < bSize / 2) {
			posX = bSize / 2;
			velX *= -1;
		}
		// top wall
		if (posY > p.height - bSize / 2) {
			posY = p.height - bSize / 2;
			velY *= -1;
		}
		// bottom wall
		if (posY < bSize / 2) {
			posY = bSize / 2;
			velY *= -1;
		}
		
	}
	
	public void detectCollision(Ball b) {
		if (p.dist(b.posX, b.posY, posX, posY) < b.bSize / 2 + bSize / 2) {
			float angle = p.atan2(b.posY - posY, b.posX - posX);
			b.velX = p.cos(angle);
			b.velY = p.sin(angle);
			velX = p.cos(angle - p.PI);
			velY = p.sin(angle - p.PI);
		}
	}
	
	public void drawMe() {
		//p.pushStyle();
			p.fill(bColor);
		p.pushMatrix();
			p.translate(posX, posY);
			p.ellipse(0, 0, bSize, bSize);
		p.popMatrix();
		//p.popStyle();
	}
}
