#pragma once

enum TRACK_TYPE {
  OPZ_KICK_TRACK,
  OPZ_SNARE_TRACK,
  OPZ_HIHAT_TRACK,
  OPZ_SAMPLE_TRACK,
  OPZ_BASS_TRACK,
  OPZ_LEAD_TRACK,
  OPZ_ARP_TRACK,
  OPZ_CHORD_TRACK,
  AUX_DRUM_TRACK,
  AUX_INST_TRACK,
  STANDARD_TRACK,
  STANDARD_DRUM_TRACK,
  STANDARD_BOTH,
  OPZ_INVALID_DRUM_TRACK,
  OPZ_INVALID_SAMPLE_TRACK,
  OPZ_INVALID_BASS_TRACK,
  NUM_TRACK_TYPES,
};

map<TRACK_TYPE,bool> TRACK_TYPE_IS_DRUM = {
  {OPZ_KICK_TRACK, true},
  {OPZ_SNARE_TRACK, true},
  {OPZ_HIHAT_TRACK, true},
  {OPZ_SAMPLE_TRACK, false},
  {OPZ_BASS_TRACK, false},
  {OPZ_LEAD_TRACK, false},
  {OPZ_ARP_TRACK, false},
  {OPZ_CHORD_TRACK, false},
  {AUX_DRUM_TRACK, true},
  {AUX_INST_TRACK, false},
  {STANDARD_TRACK, false},
  {STANDARD_DRUM_TRACK, true}
};

bool is_drum_track(int tt) {
  return TRACK_TYPE_IS_DRUM[static_cast<TRACK_TYPE>(tt)];
}

enum TE_ERROR_CODE {
  OK,
  INVALID_MIDI,
  INVALID_TIME_SIGS,
};

// drums are on channel 10
// 0 is all other channels
// more to be filled in later ...
// for i in range(128):
//   print("NONE, //{}".format(i))
static const TRACK_TYPE TE_DRUM_MAP[128] = {
  AUX_DRUM_TRACK, //0
  AUX_DRUM_TRACK, //1
  AUX_DRUM_TRACK, //2
  AUX_DRUM_TRACK, //3
  AUX_DRUM_TRACK, //4
  AUX_DRUM_TRACK, //5
  AUX_DRUM_TRACK, //6
  AUX_DRUM_TRACK, //7
  AUX_DRUM_TRACK, //8
  AUX_DRUM_TRACK, //9
  AUX_DRUM_TRACK, //10
  AUX_DRUM_TRACK, //11
  AUX_DRUM_TRACK, //12
  AUX_DRUM_TRACK, //13
  AUX_DRUM_TRACK, //14
  AUX_DRUM_TRACK, //15
  AUX_DRUM_TRACK, //16
  AUX_DRUM_TRACK, //17
  AUX_DRUM_TRACK, //18
  AUX_DRUM_TRACK, //19
  AUX_DRUM_TRACK, //20
  AUX_DRUM_TRACK, //21
  AUX_DRUM_TRACK, //22
  AUX_DRUM_TRACK, //23
  AUX_DRUM_TRACK, //24
  AUX_DRUM_TRACK, //25
  AUX_DRUM_TRACK, //26
  AUX_DRUM_TRACK, //27
  AUX_DRUM_TRACK, //28
  AUX_DRUM_TRACK, //29
  AUX_DRUM_TRACK, //30
  AUX_DRUM_TRACK, //31
  AUX_DRUM_TRACK, //32
  AUX_DRUM_TRACK, //33
  AUX_DRUM_TRACK, //34
  OPZ_KICK_TRACK, //35
  OPZ_KICK_TRACK, //36
  OPZ_SNARE_TRACK, //37
  OPZ_SNARE_TRACK, //38
  OPZ_SNARE_TRACK, //39
  OPZ_SNARE_TRACK, //40
  AUX_DRUM_TRACK, //41
  OPZ_HIHAT_TRACK, //42
  AUX_DRUM_TRACK, //43
  OPZ_HIHAT_TRACK, //44
  AUX_DRUM_TRACK, //45
  AUX_DRUM_TRACK, //46
  AUX_DRUM_TRACK, //47
  AUX_DRUM_TRACK, //48
  OPZ_HIHAT_TRACK, //49
  AUX_DRUM_TRACK, //50
  OPZ_HIHAT_TRACK, //51
  AUX_DRUM_TRACK, //52
  AUX_DRUM_TRACK, //53
  AUX_DRUM_TRACK, //54
  AUX_DRUM_TRACK, //55
  AUX_DRUM_TRACK, //56
  AUX_DRUM_TRACK, //57
  AUX_DRUM_TRACK, //58
  AUX_DRUM_TRACK, //59
  AUX_DRUM_TRACK, //60
  AUX_DRUM_TRACK, //61
  AUX_DRUM_TRACK, //62
  AUX_DRUM_TRACK, //63
  AUX_DRUM_TRACK, //64
  AUX_DRUM_TRACK, //65
  AUX_DRUM_TRACK, //66
  AUX_DRUM_TRACK, //67
  AUX_DRUM_TRACK, //68
  AUX_DRUM_TRACK, //69
  AUX_DRUM_TRACK, //70
  AUX_DRUM_TRACK, //71
  AUX_DRUM_TRACK, //72
  AUX_DRUM_TRACK, //73
  AUX_DRUM_TRACK, //74
  AUX_DRUM_TRACK, //75
  AUX_DRUM_TRACK, //76
  AUX_DRUM_TRACK, //77
  AUX_DRUM_TRACK, //78
  AUX_DRUM_TRACK, //79
  AUX_DRUM_TRACK, //80
  AUX_DRUM_TRACK, //81
  AUX_DRUM_TRACK, //82
  AUX_DRUM_TRACK, //83
  AUX_DRUM_TRACK, //84
  AUX_DRUM_TRACK, //85
  AUX_DRUM_TRACK, //86
  AUX_DRUM_TRACK, //87
  AUX_DRUM_TRACK, //88
  AUX_DRUM_TRACK, //89
  AUX_DRUM_TRACK, //90
  AUX_DRUM_TRACK, //91
  AUX_DRUM_TRACK, //92
  AUX_DRUM_TRACK, //93
  AUX_DRUM_TRACK, //94
  AUX_DRUM_TRACK, //95
  AUX_DRUM_TRACK, //96
  AUX_DRUM_TRACK, //97
  AUX_DRUM_TRACK, //98
  AUX_DRUM_TRACK, //99
  AUX_DRUM_TRACK, //100
  AUX_DRUM_TRACK, //101
  AUX_DRUM_TRACK, //102
  AUX_DRUM_TRACK, //103
  AUX_DRUM_TRACK, //104
  AUX_DRUM_TRACK, //105
  AUX_DRUM_TRACK, //106
  AUX_DRUM_TRACK, //107
  AUX_DRUM_TRACK, //108
  AUX_DRUM_TRACK, //109
  AUX_DRUM_TRACK, //110
  AUX_DRUM_TRACK, //111
  AUX_DRUM_TRACK, //112
  AUX_DRUM_TRACK, //113
  AUX_DRUM_TRACK, //114
  AUX_DRUM_TRACK, //115
  AUX_DRUM_TRACK, //116
  AUX_DRUM_TRACK, //117
  AUX_DRUM_TRACK, //118
  AUX_DRUM_TRACK, //119
  AUX_DRUM_TRACK, //120
  AUX_DRUM_TRACK, //121
  AUX_DRUM_TRACK, //122
  AUX_DRUM_TRACK, //123
  AUX_DRUM_TRACK, //124
  AUX_DRUM_TRACK, //125
  AUX_DRUM_TRACK, //126
  AUX_DRUM_TRACK, //127
};

static const TRACK_TYPE TE_INST_MAP[128] = {
  AUX_INST_TRACK, //0
  AUX_INST_TRACK, //1
  AUX_INST_TRACK, //2
  AUX_INST_TRACK, //3
  AUX_INST_TRACK, //4
  AUX_INST_TRACK, //5
  AUX_INST_TRACK, //6
  AUX_INST_TRACK, //7
  AUX_INST_TRACK, //8
  AUX_INST_TRACK, //9
  AUX_INST_TRACK, //10
  AUX_INST_TRACK, //11
  AUX_INST_TRACK, //12
  AUX_INST_TRACK, //13
  AUX_INST_TRACK, //14
  AUX_INST_TRACK, //15
  AUX_INST_TRACK, //16
  AUX_INST_TRACK, //17
  AUX_INST_TRACK, //18
  AUX_INST_TRACK, //19
  AUX_INST_TRACK, //20
  AUX_INST_TRACK, //21
  AUX_INST_TRACK, //22
  AUX_INST_TRACK, //23
  AUX_INST_TRACK, //24
  AUX_INST_TRACK, //25
  AUX_INST_TRACK, //26
  AUX_INST_TRACK, //27
  AUX_INST_TRACK, //28
  AUX_INST_TRACK, //29
  AUX_INST_TRACK, //30
  AUX_INST_TRACK, //31
  OPZ_BASS_TRACK, //32
  OPZ_BASS_TRACK, //33
  OPZ_BASS_TRACK, //34
  OPZ_BASS_TRACK, //35
  OPZ_BASS_TRACK, //36
  OPZ_BASS_TRACK, //37
  OPZ_BASS_TRACK, //38
  OPZ_BASS_TRACK, //39
  AUX_INST_TRACK, //40
  AUX_INST_TRACK, //41
  AUX_INST_TRACK, //42
  AUX_INST_TRACK, //43
  AUX_INST_TRACK, //44
  AUX_INST_TRACK, //45
  AUX_INST_TRACK, //46
  AUX_INST_TRACK, //47
  AUX_INST_TRACK, //48
  AUX_INST_TRACK, //49
  AUX_INST_TRACK, //50
  AUX_INST_TRACK, //51
  AUX_INST_TRACK, //52
  AUX_INST_TRACK, //53
  AUX_INST_TRACK, //54
  AUX_INST_TRACK, //55
  AUX_INST_TRACK, //56
  AUX_INST_TRACK, //57
  AUX_INST_TRACK, //58
  AUX_INST_TRACK, //59
  AUX_INST_TRACK, //60
  AUX_INST_TRACK, //61
  AUX_INST_TRACK, //62
  AUX_INST_TRACK, //63
  AUX_INST_TRACK, //64
  AUX_INST_TRACK, //65
  AUX_INST_TRACK, //66
  AUX_INST_TRACK, //67
  AUX_INST_TRACK, //68
  AUX_INST_TRACK, //69
  AUX_INST_TRACK, //70
  AUX_INST_TRACK, //71
  AUX_INST_TRACK, //72
  AUX_INST_TRACK, //73
  AUX_INST_TRACK, //74
  AUX_INST_TRACK, //75
  AUX_INST_TRACK, //76
  AUX_INST_TRACK, //77
  AUX_INST_TRACK, //78
  AUX_INST_TRACK, //79
  AUX_INST_TRACK, //80
  AUX_INST_TRACK, //81
  AUX_INST_TRACK, //82
  AUX_INST_TRACK, //83
  AUX_INST_TRACK, //84
  AUX_INST_TRACK, //85
  AUX_INST_TRACK, //86
  AUX_INST_TRACK, //87
  AUX_INST_TRACK, //88
  AUX_INST_TRACK, //89
  AUX_INST_TRACK, //90
  AUX_INST_TRACK, //91
  AUX_INST_TRACK, //92
  AUX_INST_TRACK, //93
  AUX_INST_TRACK, //94
  AUX_INST_TRACK, //95
  OPZ_SAMPLE_TRACK, //96
  OPZ_SAMPLE_TRACK, //97
  OPZ_SAMPLE_TRACK, //98
  OPZ_SAMPLE_TRACK, //99
  OPZ_SAMPLE_TRACK, //100
  OPZ_SAMPLE_TRACK, //101
  OPZ_SAMPLE_TRACK, //102
  OPZ_SAMPLE_TRACK, //103
  AUX_INST_TRACK, //104
  AUX_INST_TRACK, //105
  AUX_INST_TRACK, //106
  AUX_INST_TRACK, //107
  AUX_INST_TRACK, //108
  AUX_INST_TRACK, //109
  AUX_INST_TRACK, //110
  AUX_INST_TRACK, //111
  AUX_INST_TRACK, //112
  AUX_INST_TRACK, //113
  AUX_INST_TRACK, //114
  AUX_INST_TRACK, //115
  AUX_INST_TRACK, //116
  AUX_INST_TRACK, //117
  AUX_INST_TRACK, //118
  AUX_INST_TRACK, //119
  OPZ_SAMPLE_TRACK, //120
  OPZ_SAMPLE_TRACK, //121
  OPZ_SAMPLE_TRACK, //122
  OPZ_SAMPLE_TRACK, //123
  OPZ_SAMPLE_TRACK, //124
  OPZ_SAMPLE_TRACK, //125
  OPZ_SAMPLE_TRACK, //126
  OPZ_SAMPLE_TRACK, //127
};