Models can be downloaded using the link below:

https://drive.google.com/drive/folders/1t9ERcQQGnTuhUZqT9y5lyt04B2qNL6N5?usp=sharing

More documentation available here:

https://www.overleaf.com/read/vrfmjpmbgknd

For a demo of how to use the code see src/mmm_api/mmm_multi_step_demo.cpp

# Parameter Constraints and Considerations

There are two sampling methods: autoregressive generation, where we progressively sample musical material forwards in time on each track; and conditional generation (bar-infilling), where generated material is conditioned on past and future material.

Note that a single call the the model mmm:sample() may involve both autoregressive and conditional generation. These constraints are 

## Sample Param Constraints

1. tracks_per_step :
  - must be on range [1,number of tracks in piece]

2. bars_per_step :
  - must be on the range [1,model_dim]
  - for conditional generation it is ill-advised for the user to have bars_per_step == model_dim, as this means generation will not be conditioned on any bars

3. shuffle :
  - this only applies in cases where one or more tracks are conditionally generated (i.e. resample = False && 1+ selected_bars = True)

4. percentage :
  - this only applies in cases where one or more tracks are conditionally generated (i.e. resample = False && 1+ selected_bars = True)

## Status Constraints

1. density :
  - this control only applies to tracks which are being autoregressively generated (i.e. resample = True)

2. resample :
  - you can only enable autoregressive mode (resample = True) when all the bars are selected in a track.
  - note you may have autoregressive disabled when all bars are selected in a track

3. ignore :
  - bars which have 1+ selected_bars = True may not be ignored, as they are needed to condition the generation
