#pragma once

#include <map>
#include <tuple>
#include <vector>

// START OF NAMESPACE
namespace mmm {

std::map<std::tuple<int,int>,std::vector<int>> OPZ_DENSITY_QUANTILES = {
  {{9,0},{4,5,7,8,10,12,14,17,23,1073741824}},
  {{5,0},{2,3,4,4,6,6,8,10,13,1073741824}},
  {{7,0},{2,2,3,4,4,6,7,8,12,1073741824}},
  {{9,88},{2,3,4,5,6,7,8,11,14,1073741824}},
  {{6,66},{1,2,3,3,4,4,5,6,7,1073741824}},
  {{7,66},{1,2,3,3,4,4,5,6,8,1073741824}},
  {{6,49},{1,1,1,2,2,2,3,4,6,1073741824}},
  {{7,49},{1,1,2,2,3,3,4,4,6,1073741824}},
  {{4,33},{2,2,3,4,4,5,7,8,8,1073741824}},
  {{9,30},{3,5,6,8,11,13,16,20,28,1073741824}},
  {{0,0},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{2,0},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{1,0},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{6,27},{1,2,3,4,5,6,7,8,12,1073741824}},
  {{7,27},{2,3,4,6,6,8,10,12,18,1073741824}},
  {{5,50},{2,2,3,3,3,3,4,6,7,1073741824}},
  {{7,50},{1,2,2,3,3,3,4,6,8,1073741824}},
  {{8,0},{1,2,3,4,5,7,8,12,18,1073741824}},
  {{6,75},{1,2,3,3,4,4,5,6,8,1073741824}},
  {{7,75},{1,2,3,3,4,5,6,6,8,1073741824}},
  {{4,32},{1,2,2,3,4,4,4,5,7,1073741824}},
  {{9,24},{4,6,7,8,9,11,14,18,26,1073741824}},
  {{9,25},{5,7,8,11,13,17,21,27,36,1073741824}},
  {{6,26},{1,2,3,3,4,5,6,7,8,1073741824}},
  {{7,26},{2,2,3,4,5,6,7,9,12,1073741824}},
  {{6,91},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{7,91},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{6,71},{1,2,2,3,3,4,5,6,8,1073741824}},
  {{7,71},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{6,79},{1,2,3,4,4,5,6,8,9,1073741824}},
  {{7,79},{1,2,3,4,4,6,6,8,10,1073741824}},
  {{6,4},{1,2,3,3,4,4,6,7,9,1073741824}},
  {{7,4},{2,3,3,4,5,6,7,9,13,1073741824}},
  {{6,5},{1,2,3,4,4,5,6,8,10,1073741824}},
  {{7,5},{2,3,3,4,5,6,8,9,13,1073741824}},
  {{6,0},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{6,28},{3,4,5,6,7,8,9,12,16,1073741824}},
  {{7,28},{3,4,6,7,8,9,11,14,16,1073741824}},
  {{6,11},{1,2,3,3,4,4,5,6,8,1073741824}},
  {{7,11},{1,2,3,3,4,5,6,7,9,1073741824}},
  {{9,4},{3,4,5,6,8,9,10,12,16,1073741824}},
  {{6,40},{1,2,3,3,4,5,6,7,9,1073741824}},
  {{7,40},{1,2,3,3,4,5,6,7,10,1073741824}},
  {{9,48},{2,2,3,4,5,6,8,10,15,1073741824}},
  {{3,100},{1,2,2,3,4,4,5,7,8,1073741824}},
  {{4,38},{3,4,5,6,7,8,8,11,16,1073741824}},
  {{6,88},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{7,88},{1,2,3,3,4,5,6,7,9,1073741824}},
  {{5,56},{2,2,3,4,4,6,6,9,12,1073741824}},
  {{7,56},{1,2,2,3,4,4,5,6,9,1073741824}},
  {{6,57},{1,1,2,2,3,4,4,5,6,1073741824}},
  {{7,57},{1,2,2,3,3,4,4,6,7,1073741824}},
  {{8,115},{1,2,3,4,5,6,7,9,14,1073741824}},
  {{6,58},{1,2,2,2,3,4,4,5,6,1073741824}},
  {{7,58},{1,2,2,2,3,4,4,5,7,1073741824}},
  {{9,80},{2,4,5,7,10,14,17,23,33,1073741824}},
  {{7,80},{2,3,4,4,6,7,8,11,16,1073741824}},
  {{5,80},{2,3,4,6,7,8,12,15,21,1073741824}},
  {{3,126},{1,1,1,2,2,2,4,4,6,1073741824}},
  {{9,19},{3,5,6,8,9,11,13,16,20,1073741824}},
  {{9,56},{2,4,5,6,8,9,12,14,18,1073741824}},
  {{5,73},{2,2,3,4,4,6,6,8,11,1073741824}},
  {{7,73},{1,2,2,3,3,4,4,6,7,1073741824}},
  {{6,22},{1,2,3,3,4,4,5,6,8,1073741824}},
  {{7,22},{1,2,3,3,4,5,6,7,9,1073741824}},
  {{9,60},{2,3,4,6,7,8,11,13,18,1073741824}},
  {{6,73},{1,2,2,3,3,4,4,5,7,1073741824}},
  {{3,96},{1,2,3,4,5,6,8,10,16,1073741824}},
  {{6,106},{2,3,4,5,7,8,10,12,16,1073741824}},
  {{7,106},{2,4,5,7,8,9,12,15,18,1073741824}},
  {{6,30},{1,2,3,4,5,7,9,12,16,1073741824}},
  {{7,30},{2,3,4,6,8,10,12,16,21,1073741824}},
  {{6,29},{1,2,2,4,5,6,8,10,15,1073741824}},
  {{7,29},{2,3,4,5,7,8,11,15,18,1073741824}},
  {{9,83},{2,4,7,10,12,13,16,21,52,1073741824}},
  {{4,34},{2,3,4,5,6,8,8,8,12,1073741824}},
  {{8,32},{1,2,2,4,5,7,9,13,20,1073741824}},
  {{3,99},{1,2,3,4,4,6,7,8,11,1073741824}},
  {{6,48},{1,1,2,2,3,4,5,6,8,1073741824}},
  {{7,48},{1,2,2,3,3,4,6,7,10,1073741824}},
  {{6,50},{1,1,2,2,2,3,4,6,8,1073741824}},
  {{7,1},{2,3,4,4,6,7,9,12,16,1073741824}},
  {{4,35},{1,2,3,3,4,4,5,6,8,1073741824}},
  {{9,52},{2,3,3,4,5,6,8,10,15,1073741824}},
  {{9,1},{4,6,7,9,10,12,15,18,23,1073741824}},
  {{6,119},{1,1,1,1,1,1,1,2,3,1073741824}},
  {{7,119},{1,1,1,1,1,1,2,2,4,1073741824}},
  {{9,89},{2,2,3,3,4,4,5,6,7,1073741824}},
  {{7,52},{1,2,2,2,3,3,4,5,7,1073741824}},
  {{6,65},{1,2,3,3,4,4,5,6,7,1073741824}},
  {{7,65},{1,2,3,3,4,5,5,6,8,1073741824}},
  {{9,16},{2,3,4,4,6,7,10,13,18,1073741824}},
  {{6,21},{1,2,3,3,4,5,6,7,8,1073741824}},
  {{7,21},{2,3,3,4,6,6,8,10,14,1073741824}},
  {{4,37},{2,3,4,4,5,6,8,8,10,1073741824}},
  {{8,16},{1,2,3,4,5,8,9,13,19,1073741824}},
  {{9,5},{3,4,5,6,8,9,11,13,16,1073741824}},
  {{5,25},{3,5,6,8,9,12,12,16,24,1073741824}},
  {{7,25},{3,4,6,7,8,10,12,16,24,1073741824}},
  {{7,62},{2,3,3,4,5,6,8,9,14,1073741824}},
  {{6,52},{1,1,2,2,3,3,4,4,6,1073741824}},
  {{9,27},{3,5,6,8,9,12,15,19,28,1073741824}},
  {{9,46},{3,4,6,7,8,9,11,14,18,1073741824}},
  {{9,49},{1,2,3,3,4,4,5,6,9,1073741824}},
  {{5,60},{1,2,2,3,4,4,6,7,9,1073741824}},
  {{7,60},{1,2,2,2,3,4,4,6,8,1073741824}},
  {{9,73},{2,4,5,6,8,9,11,14,18,1073741824}},
  {{5,9},{2,3,3,4,5,6,7,9,12,1073741824}},
  {{7,9},{1,2,2,3,4,4,6,7,10,1073741824}},
  {{6,24},{1,2,3,4,4,5,6,8,10,1073741824}},
  {{7,24},{2,3,4,5,6,8,9,12,16,1073741824}},
  {{9,57},{2,3,4,5,6,8,10,14,19,1073741824}},
  {{7,61},{2,2,3,4,5,6,7,9,12,1073741824}},
  {{6,56},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{6,47},{1,1,2,2,3,4,5,8,12,1073741824}},
  {{7,47},{1,1,2,2,3,4,6,8,12,1073741824}},
  {{6,19},{1,2,2,3,3,4,5,7,8,1073741824}},
  {{7,19},{1,2,3,3,4,5,7,8,12,1073741824}},
  {{5,19},{2,2,3,3,4,6,7,9,12,1073741824}},
  {{6,68},{1,2,2,2,3,4,4,6,7,1073741824}},
  {{7,68},{1,2,2,3,3,4,5,6,8,1073741824}},
  {{6,117},{1,2,3,4,4,5,7,8,11,1073741824}},
  {{7,117},{1,2,3,4,4,6,7,9,12,1073741824}},
  {{3,125},{1,1,1,1,2,2,3,7,10,1073741824}},
  {{3,127},{1,1,2,2,2,4,5,8,11,1073741824}},
  {{4,36},{2,3,4,5,6,7,8,9,11,1073741824}},
  {{6,12},{2,4,5,6,7,8,10,13,16,1073741824}},
  {{7,12},{3,4,5,6,8,9,12,14,17,1073741824}},
  {{9,2},{4,5,7,8,10,12,15,18,23,1073741824}},
  {{6,85},{1,2,3,3,4,4,5,6,8,1073741824}},
  {{7,85},{1,2,3,3,4,4,5,6,8,1073741824}},
  {{6,13},{2,3,4,6,7,8,10,12,16,1073741824}},
  {{7,13},{2,3,5,6,8,9,11,14,16,1073741824}},
  {{8,21},{1,1,1,2,3,4,7,8,9,1073741824}},
  {{5,81},{2,3,4,6,8,10,12,16,22,1073741824}},
  {{7,81},{2,2,4,4,6,7,8,12,16,1073741824}},
  {{6,80},{1,2,4,4,6,7,8,10,16,1073741824}},
  {{6,2},{1,2,3,4,4,6,7,8,12,1073741824}},
  {{7,2},{2,3,4,5,6,8,10,12,16,1073741824}},
  {{14,98},{1,2,3,4,5,6,8,9,15,1073741824}},
  {{6,46},{2,3,4,5,6,8,8,11,16,1073741824}},
  {{7,46},{2,3,4,6,6,8,8,12,16,1073741824}},
  {{6,10},{1,2,3,3,4,5,6,8,10,1073741824}},
  {{7,10},{1,2,3,4,4,6,7,8,12,1073741824}},
  {{6,72},{1,2,3,3,4,5,6,7,9,1073741824}},
  {{7,72},{1,2,3,4,4,5,6,8,10,1073741824}},
  {{6,60},{1,1,2,2,3,4,4,5,7,1073741824}},
  {{6,17},{1,2,3,4,4,6,7,8,12,1073741824}},
  {{7,17},{2,3,3,4,5,6,8,11,15,1073741824}},
  {{6,115},{1,2,3,4,5,6,8,8,11,1073741824}},
  {{7,115},{1,2,3,4,5,7,8,9,12,1073741824}},
  {{6,61},{1,2,2,3,4,5,6,7,10,1073741824}},
  {{14,127},{2,3,4,6,8,12,14,19,24,1073741824}},
  {{6,63},{1,2,2,3,4,5,6,7,10,1073741824}},
  {{7,63},{1,2,3,4,4,5,6,8,12,1073741824}},
  {{14,102},{2,2,3,3,4,6,7,8,12,1073741824}},
  {{5,53},{2,3,3,4,5,6,7,9,12,1073741824}},
  {{7,53},{1,2,3,3,4,4,6,7,9,1073741824}},
  {{14,101},{1,2,2,3,3,4,5,6,9,1073741824}},
  {{6,87},{2,3,4,5,6,7,8,10,14,1073741824}},
  {{7,87},{2,3,4,5,6,7,8,11,16,1073741824}},
  {{3,120},{1,1,1,1,2,2,4,8,12,1073741824}},
  {{6,53},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{6,82},{1,2,3,3,4,5,5,6,8,1073741824}},
  {{7,82},{1,2,3,4,4,5,6,7,9,1073741824}},
  {{6,118},{1,2,2,3,4,4,5,7,9,1073741824}},
  {{7,118},{1,2,2,3,4,4,6,7,10,1073741824}},
  {{5,48},{1,2,2,3,3,4,6,8,12,1073741824}},
  {{6,81},{1,2,3,4,5,6,8,10,14,1073741824}},
  {{6,94},{1,1,2,2,3,4,5,7,8,1073741824}},
  {{7,94},{1,2,2,3,3,4,5,7,9,1073741824}},
  {{7,74},{1,2,2,3,3,4,5,6,8,1073741824}},
  {{5,26},{2,3,4,5,6,6,8,10,15,1073741824}},
  {{3,102},{1,2,2,3,4,4,6,7,10,1073741824}},
  {{6,51},{1,1,2,2,2,3,4,5,7,1073741824}},
  {{7,51},{1,2,2,3,3,3,4,6,8,1073741824}},
  {{6,18},{1,2,3,3,4,5,6,7,9,1073741824}},
  {{7,18},{2,3,3,4,4,6,7,9,13,1073741824}},
  {{6,116},{1,2,2,2,4,4,5,6,9,1073741824}},
  {{7,116},{1,2,2,3,4,4,6,8,12,1073741824}},
  {{5,30},{2,3,6,8,9,12,15,17,24,1073741824}},
  {{5,58},{1,2,3,4,4,6,7,8,10,1073741824}},
  {{6,67},{1,2,2,3,3,4,4,5,7,1073741824}},
  {{7,67},{1,2,2,3,3,4,4,6,7,1073741824}},
  {{6,54},{1,2,2,3,3,4,5,6,7,1073741824}},
  {{7,54},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{5,61},{2,3,3,4,6,6,8,10,13,1073741824}},
  {{8,40},{1,2,2,4,5,8,9,13,18,1073741824}},
  {{6,42},{1,1,2,2,3,4,4,5,8,1073741824}},
  {{7,42},{1,2,2,3,3,4,4,6,8,1073741824}},
  {{6,25},{1,2,3,4,5,6,8,9,13,1073741824}},
  {{7,14},{1,1,1,2,2,3,4,5,8,1073741824}},
  {{8,7},{1,2,2,3,4,5,8,8,16,1073741824}},
  {{4,39},{2,3,4,5,6,7,8,8,10,1073741824}},
  {{3,122},{1,1,1,1,1,1,2,2,4,1073741824}},
  {{6,90},{1,2,3,4,4,6,7,8,14,1073741824}},
  {{7,90},{1,2,3,4,5,6,8,10,15,1073741824}},
  {{5,24},{2,3,5,6,6,8,9,12,16,1073741824}},
  {{9,11},{2,4,5,6,7,8,10,12,16,1073741824}},
  {{6,74},{1,2,2,3,3,4,4,5,7,1073741824}},
  {{6,62},{1,2,3,4,4,5,6,8,11,1073741824}},
  {{6,64},{1,2,3,3,4,4,5,6,7,1073741824}},
  {{7,64},{1,2,3,3,4,4,5,6,8,1073741824}},
  {{5,64},{1,2,3,4,4,5,6,7,10,1073741824}},
  {{6,9},{1,2,2,3,4,4,5,7,9,1073741824}},
  {{6,76},{1,2,3,4,4,5,6,8,10,1073741824}},
  {{7,76},{1,2,3,4,4,5,6,8,10,1073741824}},
  {{5,4},{2,3,3,4,6,6,8,12,15,1073741824}},
  {{6,23},{1,2,3,3,4,5,6,7,8,1073741824}},
  {{7,23},{2,3,3,4,5,6,8,10,14,1073741824}},
  {{5,16},{2,3,3,4,5,6,8,12,15,1073741824}},
  {{7,16},{2,2,3,4,4,6,7,9,12,1073741824}},
  {{8,17},{1,2,3,4,5,7,12,15,19,1073741824}},
  {{6,77},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{7,77},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{5,93},{2,2,2,3,3,3,4,6,10,1073741824}},
  {{7,93},{1,1,2,2,3,3,5,7,11,1073741824}},
  {{6,31},{1,1,2,2,3,4,5,7,12,1073741824}},
  {{7,31},{1,1,2,3,4,5,6,8,14,1073741824}},
  {{5,27},{3,4,6,6,7,9,12,14,18,1073741824}},
  {{5,62},{2,3,4,5,6,8,9,12,16,1073741824}},
  {{5,66},{1,2,3,4,4,5,6,8,10,1073741824}},
  {{6,41},{1,2,2,3,3,4,5,6,8,1073741824}},
  {{7,41},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{6,70},{1,2,2,2,3,4,4,6,8,1073741824}},
  {{7,70},{1,2,2,2,3,4,4,6,8,1073741824}},
  {{13,0},{2,3,4,5,6,8,9,11,16,1073741824}},
  {{6,43},{1,1,2,2,3,4,4,6,8,1073741824}},
  {{7,43},{1,1,2,2,3,4,5,6,8,1073741824}},
  {{9,26},{3,5,6,7,9,11,13,16,24,1073741824}},
  {{5,68},{1,2,3,3,4,5,6,8,10,1073741824}},
  {{5,29},{2,3,5,6,8,10,14,16,24,1073741824}},
  {{9,28},{3,5,7,8,10,13,16,18,24,1073741824}},
  {{3,121},{2,2,3,4,4,6,8,9,15,1073741824}},
  {{5,6},{1,2,2,3,3,4,5,7,11,1073741824}},
  {{7,6},{1,2,2,3,3,4,5,8,11,1073741824}},
  {{6,6},{1,1,2,2,3,4,4,6,8,1073741824}},
  {{6,93},{1,1,2,2,3,4,5,8,11,1073741824}},
  {{8,126},{1,1,2,3,4,4,6,8,15,1073741824}},
  {{5,71},{1,2,3,4,4,5,6,8,11,1073741824}},
  {{5,17},{2,3,3,5,6,8,10,12,18,1073741824}},
  {{5,49},{1,2,2,3,3,3,3,4,6,1073741824}},
  {{6,55},{1,1,2,2,3,4,5,6,9,1073741824}},
  {{7,55},{1,2,2,2,3,4,6,8,10,1073741824}},
  {{5,11},{2,2,3,4,5,6,7,8,12,1073741824}},
  {{13,40},{2,4,5,6,8,10,11,12,14,1073741824}},
  {{5,51},{2,2,3,3,3,3,3,5,6,1073741824}},
  {{5,52},{2,2,3,3,3,4,6,7,10,1073741824}},
  {{9,53},{2,3,4,5,6,8,10,12,16,1073741824}},
  {{5,40},{2,2,3,4,5,6,7,8,12,1073741824}},
  {{5,85},{2,2,3,4,4,5,6,7,10,1073741824}},
  {{5,65},{1,2,3,4,4,5,6,7,9,1073741824}},
  {{5,88},{2,2,3,4,4,6,6,8,10,1073741824}},
  {{5,57},{1,2,3,3,4,5,6,8,10,1073741824}},
  {{5,41},{1,2,3,4,4,5,6,8,12,1073741824}},
  {{5,67},{1,2,2,3,4,4,6,7,9,1073741824}},
  {{5,42},{1,2,2,3,4,4,5,7,9,1073741824}},
  {{5,91},{1,2,3,3,3,4,6,7,10,1073741824}},
  {{5,70},{1,2,3,4,4,5,6,8,11,1073741824}},
  {{15,32},{1,1,2,2,2,2,3,4,5,1073741824}},
  {{6,3},{1,2,3,4,4,5,6,8,10,1073741824}},
  {{7,3},{2,3,4,5,6,7,8,11,15,1073741824}},
  {{9,108},{5,8,9,11,12,14,15,17,25,1073741824}},
  {{5,75},{2,3,3,4,5,6,8,9,12,1073741824}},
  {{6,45},{1,2,2,3,4,4,5,7,8,1073741824}},
  {{7,45},{1,2,3,4,4,6,7,9,14,1073741824}},
  {{5,89},{2,2,3,3,3,3,3,4,6,1073741824}},
  {{7,89},{1,2,2,3,3,3,3,4,6,1073741824}},
  {{3,103},{1,2,2,3,4,4,6,7,10,1073741824}},
  {{9,85},{2,3,4,4,6,7,9,10,14,1073741824}},
  {{6,110},{1,2,3,4,5,6,7,8,9,1073741824}},
  {{7,110},{2,3,4,5,6,6,7,8,11,1073741824}},
  {{9,18},{2,3,3,4,6,7,9,12,17,1073741824}},
  {{9,6},{4,6,8,9,10,12,14,17,22,1073741824}},
  {{5,7},{1,1,2,2,3,3,5,7,12,1073741824}},
  {{7,7},{1,1,2,2,3,4,6,8,13,1073741824}},
  {{6,7},{1,1,2,2,3,4,6,8,11,1073741824}},
  {{6,44},{1,1,2,2,3,4,6,8,12,1073741824}},
  {{7,44},{1,2,2,3,4,4,6,8,12,1073741824}},
  {{5,10},{2,3,4,5,6,7,8,11,14,1073741824}},
  {{8,11},{2,3,4,5,6,6,6,7,9,1073741824}},
  {{5,44},{1,2,2,3,3,4,5,8,12,1073741824}},
  {{3,97},{1,1,1,1,1,2,2,4,6,1073741824}},
  {{5,95},{1,2,3,3,3,3,3,4,6,1073741824}},
  {{7,95},{1,1,2,2,3,3,3,4,7,1073741824}},
  {{5,1},{2,3,5,6,8,9,12,13,18,1073741824}},
  {{8,25},{2,3,4,6,8,10,14,18,25,1073741824}},
  {{9,72},{2,3,4,5,6,9,10,12,16,1073741824}},
  {{6,69},{1,2,2,3,3,4,4,5,7,1073741824}},
  {{7,69},{1,2,2,3,3,4,5,6,8,1073741824}},
  {{9,70},{2,2,3,4,5,7,10,13,17,1073741824}},
  {{6,8},{1,2,3,4,4,6,7,8,11,1073741824}},
  {{7,8},{1,2,3,4,5,6,8,9,14,1073741824}},
  {{6,14},{1,1,1,1,2,2,3,4,7,1073741824}},
  {{8,48},{1,1,2,2,3,4,6,9,16,1073741824}},
  {{9,44},{2,2,3,4,5,6,8,12,18,1073741824}},
  {{6,78},{1,1,2,3,4,4,5,6,8,1073741824}},
  {{7,78},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{6,59},{1,2,2,3,4,4,5,6,8,1073741824}},
  {{7,59},{1,2,3,3,4,5,6,7,9,1073741824}},
  {{8,116},{1,2,4,5,8,8,9,12,18,1073741824}},
  {{9,45},{2,4,5,7,8,11,13,16,21,1073741824}},
  {{9,119},{1,1,2,3,5,5,6,9,12,1073741824}},
  {{9,62},{3,4,5,6,8,9,12,15,21,1073741824}},
  {{6,89},{1,1,1,2,2,2,3,4,5,1073741824}},
  {{5,21},{2,3,4,5,6,8,9,12,16,1073741824}},
  {{6,1},{1,2,2,3,4,4,6,7,9,1073741824}},
  {{6,16},{1,2,2,3,4,5,6,8,10,1073741824}},
  {{5,116},{2,3,5,6,8,12,18,19,24,1073741824}},
  {{9,50},{2,3,3,4,4,5,6,7,10,1073741824}},
  {{9,7},{3,5,6,8,10,12,14,18,24,1073741824}},
  {{5,45},{2,3,4,6,7,9,12,15,21,1073741824}},
  {{6,95},{1,1,1,1,2,2,2,4,8,1073741824}},
  {{8,8},{1,2,3,4,6,8,10,16,22,1073741824}},
  {{9,29},{3,4,6,8,10,12,16,20,28,1073741824}},
  {{5,54},{2,2,3,3,4,5,6,8,10,1073741824}},
  {{6,20},{1,1,1,1,2,2,2,3,4,1073741824}},
  {{7,20},{1,1,1,2,2,2,3,4,7,1073741824}},
  {{5,28},{3,5,6,8,9,11,13,16,20,1073741824}},
  {{6,105},{2,3,4,6,8,8,10,14,16,1073741824}},
  {{7,105},{3,5,6,7,8,9,12,16,18,1073741824}},
  {{5,59},{2,3,3,4,5,6,7,9,12,1073741824}},
  {{9,61},{2,4,4,6,7,8,10,13,18,1073741824}},
  {{9,65},{2,3,4,5,6,8,10,12,17,1073741824}},
  {{6,108},{3,4,5,6,8,8,10,13,16,1073741824}},
  {{7,108},{3,4,6,7,8,10,12,15,18,1073741824}},
  {{6,84},{1,2,3,4,5,6,7,8,13,1073741824}},
  {{7,84},{1,2,3,4,5,6,8,10,16,1073741824}},
  {{9,95},{1,2,3,3,3,4,4,5,6,1073741824}},
  {{15,34},{2,3,5,6,7,8,9,11,14,1073741824}},
  {{3,98},{1,2,2,3,4,5,6,8,11,1073741824}},
  {{8,24},{2,2,4,5,8,9,12,16,21,1073741824}},
  {{5,18},{2,3,3,4,6,6,8,11,15,1073741824}},
  {{9,3},{4,6,7,9,11,13,16,19,24,1073741824}},
  {{9,17},{2,3,4,5,6,8,10,15,19,1073741824}},
  {{9,51},{2,3,3,3,4,4,5,6,9,1073741824}},
  {{5,23},{2,3,4,5,6,8,10,12,16,1073741824}},
  {{14,122},{1,1,1,2,3,3,4,6,9,1073741824}},
  {{6,107},{2,3,4,5,6,7,8,9,16,1073741824}},
  {{7,107},{2,3,4,5,6,7,8,10,16,1073741824}},
  {{14,99},{2,3,4,5,6,8,9,12,16,1073741824}},
  {{8,10},{1,2,2,3,4,4,6,10,15,1073741824}},
  {{14,100},{2,3,3,4,4,6,7,9,12,1073741824}},
  {{5,82},{1,2,3,4,5,6,7,10,15,1073741824}},
  {{5,12},{3,5,6,7,9,11,12,15,19,1073741824}},
  {{8,66},{2,4,4,4,5,8,10,11,17,1073741824}},
  {{5,105},{4,6,6,8,9,11,12,16,21,1073741824}},
  {{14,96},{2,3,4,6,7,8,10,12,17,1073741824}},
  {{14,103},{2,3,3,4,5,6,7,9,12,1073741824}},
  {{5,2},{3,4,5,6,8,9,12,15,20,1073741824}},
  {{5,5},{3,3,3,5,6,7,9,12,16,1073741824}},
  {{5,87},{2,4,5,6,8,12,12,16,21,1073741824}},
  {{3,123},{1,1,1,2,3,3,4,6,8,1073741824}},
  {{15,33},{2,2,4,5,6,7,8,10,12,1073741824}},
  {{15,38},{2,3,4,4,5,6,6,8,11,1073741824}},
  {{5,78},{1,2,3,4,4,6,8,10,18,1073741824}},
  {{6,86},{1,2,3,4,5,6,8,10,13,1073741824}},
  {{7,86},{1,2,3,4,5,6,7,9,13,1073741824}},
  {{9,23},{3,5,6,8,9,11,14,18,22,1073741824}},
  {{13,118},{3,4,4,4,4,4,4,7,14,1073741824}},
  {{8,118},{1,3,4,4,6,8,9,12,22,1073741824}},
  {{5,22},{2,2,3,4,5,6,6,8,11,1073741824}},
  {{5,90},{2,3,3,4,6,6,9,12,15,1073741824}},
  {{9,94},{1,2,3,3,4,5,6,7,10,1073741824}},
  {{9,21},{3,5,6,7,8,10,12,15,21,1073741824}},
  {{9,90},{2,3,4,5,6,8,10,13,21,1073741824}},
  {{5,119},{1,1,2,2,3,3,3,4,6,1073741824}},
  {{7,114},{2,4,4,5,7,8,9,12,16,1073741824}},
  {{5,74},{1,2,3,4,5,6,7,8,11,1073741824}},
  {{9,12},{3,4,6,8,9,12,14,16,22,1073741824}},
  {{5,72},{2,3,4,4,6,7,8,12,16,1073741824}},
  {{6,104},{1,2,3,4,4,6,7,8,11,1073741824}},
  {{7,104},{1,2,3,4,4,6,7,8,12,1073741824}},
  {{3,124},{1,1,1,2,3,5,7,11,20,1073741824}},
  {{6,113},{1,2,3,4,5,7,8,10,14,1073741824}},
  {{7,113},{1,2,3,4,6,7,8,11,14,1073741824}},
  {{9,64},{2,3,5,6,9,12,16,18,22,1073741824}},
  {{8,1},{1,2,3,4,5,8,9,14,20,1073741824}},
  {{5,84},{2,3,4,4,6,8,9,12,17,1073741824}},
  {{14,97},{1,2,3,3,4,6,8,12,22,1073741824}},
  {{8,114},{1,2,2,4,6,8,12,16,19,1073741824}},
  {{7,92},{1,1,2,3,3,4,4,6,8,1073741824}},
  {{6,83},{2,3,3,4,5,6,7,8,12,1073741824}},
  {{7,83},{2,3,4,4,5,6,8,10,16,1073741824}},
  {{3,101},{1,1,1,1,1,2,2,3,5,1073741824}},
  {{8,119},{1,2,4,4,4,4,4,6,8,1073741824}},
  {{9,107},{2,3,4,6,7,8,9,12,18,1073741824}},
  {{9,20},{2,3,4,5,7,8,9,12,16,1073741824}},
  {{9,54},{2,3,3,4,4,6,7,9,13,1073741824}},
  {{5,110},{2,4,5,6,6,7,8,10,15,1073741824}},
  {{9,105},{5,6,8,8,11,13,16,18,24,1073741824}},
  {{6,92},{1,1,2,2,3,3,4,5,8,1073741824}},
  {{9,116},{1,2,2,4,6,8,12,19,24,1073741824}},
  {{6,114},{2,3,4,5,6,7,8,10,16,1073741824}},
  {{5,63},{2,3,3,4,5,6,8,12,15,1073741824}},
  {{8,28},{2,4,4,6,8,8,9,12,15,1073741824}},
  {{5,55},{2,3,3,3,5,6,8,10,15,1073741824}},
  {{5,20},{2,2,3,4,5,6,7,8,12,1073741824}},
  {{9,9},{2,3,4,5,6,8,10,14,20,1073741824}},
  {{5,46},{2,3,4,6,6,8,9,12,16,1073741824}},
  {{13,16},{2,3,4,4,6,7,8,12,16,1073741824}},
  {{9,81},{2,4,5,6,8,9,12,16,25,1073741824}},
  {{5,94},{2,2,3,3,3,4,6,7,12,1073741824}},
  {{8,80},{1,2,2,3,4,6,8,11,12,1073741824}},
  {{5,106},{7,9,11,13,15,16,18,18,22,1073741824}},
  {{8,42},{1,2,4,4,5,6,8,10,16,1073741824}},
  {{6,15},{2,3,4,5,7,8,8,10,16,1073741824}},
  {{7,15},{2,3,4,5,7,8,9,13,16,1073741824}},
  {{9,71},{2,3,4,6,7,9,11,13,17,1073741824}},
  {{5,47},{2,2,3,4,6,8,11,14,27,1073741824}},
  {{9,68},{2,4,5,6,8,9,11,14,18,1073741824}},
  {{14,126},{1,1,1,2,3,4,6,10,20,1073741824}},
  {{13,8},{2,3,4,6,8,9,10,12,17,1073741824}},
  {{9,77},{2,3,4,5,6,7,8,10,14,1073741824}},
  {{9,78},{1,2,3,3,4,6,9,14,17,1073741824}},
  {{6,109},{1,2,2,3,4,4,6,7,9,1073741824}},
  {{7,109},{1,2,3,3,4,5,6,8,12,1073741824}},
  {{13,29},{1,2,2,2,2,3,8,8,8,1073741824}},
  {{8,29},{1,2,3,4,5,8,8,16,23,1073741824}},
  {{9,92},{2,3,3,4,4,5,6,8,11,1073741824}},
  {{8,45},{1,1,2,4,5,7,11,13,16,1073741824}},
  {{8,79},{3,5,5,5,5,6,7,29,29,1073741824}},
  {{5,43},{1,2,3,3,4,5,7,9,16,1073741824}},
  {{8,73},{3,7,7,7,8,8,8,8,8,1073741824}},
  {{5,92},{1,2,3,3,3,4,4,6,9,1073741824}},
  {{13,24},{2,4,4,6,8,9,12,14,17,1073741824}},
  {{14,125},{1,1,2,4,7,16,16,23,55,1073741824}},
  {{5,8},{2,3,4,6,6,8,10,14,20,1073741824}},
  {{5,108},{4,6,8,10,12,15,16,20,24,1073741824}},
  {{5,3},{3,3,5,6,8,9,12,14,18,1073741824}},
  {{8,2},{1,3,4,4,6,8,10,13,18,1073741824}},
  {{5,13},{3,5,7,9,11,12,14,16,24,1073741824}},
  {{8,12},{1,3,4,4,4,6,7,8,11,1073741824}},
  {{8,82},{2,4,5,6,6,7,9,11,12,1073741824}},
  {{9,66},{3,4,5,6,8,9,12,14,18,1073741824}},
  {{5,31},{1,2,3,3,5,6,8,11,21,1073741824}},
  {{5,112},{2,3,4,4,6,7,9,13,16,1073741824}},
  {{7,112},{1,2,3,4,4,6,8,9,13,1073741824}},
  {{6,111},{1,2,3,4,5,6,7,9,10,1073741824}},
  {{7,111},{1,2,3,4,5,6,7,9,12,1073741824}},
  {{14,124},{2,3,4,6,9,15,16,20,22,1073741824}},
  {{14,120},{2,5,7,8,12,14,16,20,32,1073741824}},
  {{9,79},{3,4,7,8,9,10,10,11,14,1073741824}},
  {{9,63},{3,3,4,5,6,8,11,14,20,1073741824}},
  {{5,104},{2,3,4,4,6,8,9,11,17,1073741824}},
  {{9,31},{3,5,6,7,8,10,12,16,22,1073741824}},
  {{8,64},{2,5,7,11,17,17,19,21,23,1073741824}},
  {{5,114},{3,5,6,8,9,10,12,13,20,1073741824}},
  {{13,32},{2,3,5,6,8,8,9,10,14,1073741824}},
  {{9,41},{2,3,3,4,5,7,8,10,14,1073741824}},
  {{5,79},{2,2,3,4,6,6,8,10,15,1073741824}},
  {{9,84},{3,4,5,6,8,12,16,18,28,1073741824}},
  {{9,14},{2,3,4,4,4,6,8,9,12,1073741824}},
  {{15,35},{1,2,2,3,4,5,7,8,10,1073741824}},
  {{9,74},{4,5,6,8,9,12,13,16,20,1073741824}},
  {{5,83},{2,3,3,5,6,9,14,18,24,1073741824}},
  {{8,124},{1,2,2,2,3,4,5,5,8,1073741824}},
  {{6,112},{1,2,3,4,4,5,7,8,11,1073741824}},
  {{9,59},{2,4,4,5,6,8,9,12,16,1073741824}},
  {{9,40},{2,3,4,6,7,9,11,15,21,1073741824}},
  {{5,111},{2,2,3,4,5,6,10,15,18,1073741824}},
  {{5,109},{2,3,5,6,8,8,10,13,16,1073741824}},
  {{8,127},{1,2,4,5,7,8,11,16,20,1073741824}},
  {{13,25},{2,4,4,4,6,8,10,13,18,1073741824}},
  {{9,115},{6,6,7,9,9,12,14,20,26,1073741824}},
  {{8,22},{1,1,3,4,7,8,9,14,16,1073741824}},
  {{5,107},{2,4,4,5,6,7,8,10,16,1073741824}},
  {{5,14},{1,2,3,3,4,4,6,8,12,1073741824}},
  {{9,91},{1,2,3,3,4,4,5,6,9,1073741824}},
  {{9,75},{2,4,5,6,7,8,11,15,21,1073741824}},
  {{8,39},{1,1,2,2,4,4,8,15,23,1073741824}},
  {{8,27},{2,4,4,5,8,10,11,16,32,1073741824}},
  {{8,99},{2,3,4,4,6,8,8,8,16,1073741824}},
  {{9,87},{3,4,6,8,10,14,16,22,32,1073741824}},
  {{5,76},{2,3,4,4,5,6,7,8,10,1073741824}},
  {{9,110},{3,5,6,6,8,10,13,17,24,1073741824}},
  {{8,67},{1,1,2,3,4,5,5,5,5,1073741824}},
  {{15,36},{1,2,3,4,5,6,8,10,13,1073741824}},
  {{13,1},{1,2,3,4,5,7,8,8,11,1073741824}},
  {{5,86},{1,2,3,3,4,5,6,8,11,1073741824}},
  {{8,13},{1,1,1,2,2,3,8,9,11,1073741824}},
  {{9,86},{2,2,3,3,5,6,6,6,12,1073741824}},
  {{9,113},{6,7,8,12,16,19,22,24,24,1073741824}},
  {{9,55},{2,3,4,5,6,8,11,14,24,1073741824}},
  {{9,10},{2,3,4,5,6,8,10,14,17,1073741824}},
  {{9,47},{1,2,3,4,5,6,8,11,16,1073741824}},
  {{9,22},{4,5,7,9,10,12,15,18,22,1073741824}},
  {{9,104},{2,3,5,7,8,9,10,14,18,1073741824}},
  {{8,56},{1,2,2,3,3,4,7,16,20,1073741824}},
  {{9,8},{3,4,5,6,8,11,15,20,30,1073741824}},
  {{9,82},{2,3,4,5,7,8,10,12,16,1073741824}},
  {{9,112},{3,4,5,6,9,13,23,36,44,1073741824}},
  {{5,117},{2,3,3,3,4,5,8,13,16,1073741824}},
  {{13,127},{2,3,4,6,8,10,12,12,16,1073741824}},
  {{9,42},{1,2,3,4,5,6,8,12,17,1073741824}},
  {{8,4},{1,3,5,6,8,12,13,19,21,1073741824}},
  {{8,34},{2,2,2,4,6,9,10,11,13,1073741824}},
  {{8,52},{2,3,3,3,4,6,10,11,11,1073741824}},
  {{8,5},{2,3,7,7,9,10,11,15,23,1073741824}},
  {{9,58},{2,3,4,6,6,8,10,12,17,1073741824}},
  {{8,30},{1,2,4,5,8,12,20,26,31,1073741824}},
  {{8,41},{1,2,3,4,6,8,8,12,17,1073741824}},
  {{9,118},{2,4,4,5,5,9,16,20,23,1073741824}},
  {{5,113},{2,5,5,6,6,6,8,14,18,1073741824}},
  {{5,15},{2,3,4,5,6,8,10,12,16,1073741824}},
  {{15,37},{2,3,4,5,6,6,8,10,12,1073741824}},
  {{8,71},{1,1,1,1,1,2,2,4,5,1073741824}},
  {{5,77},{1,2,3,3,4,5,6,7,10,1073741824}},
  {{8,26},{1,2,3,4,6,9,14,19,24,1073741824}},
  {{8,117},{1,2,3,6,8,8,8,12,13,1073741824}},
  {{9,43},{2,3,5,7,8,11,19,30,39,1073741824}},
  {{8,19},{2,2,4,4,5,6,9,11,13,1073741824}},
  {{9,15},{3,5,8,10,12,12,14,17,28,1073741824}},
  {{8,35},{1,1,2,2,4,7,8,16,17,1073741824}},
  {{14,121},{2,6,6,8,12,16,18,24,30,1073741824}},
  {{8,60},{1,1,1,1,1,1,2,3,4,1073741824}},
  {{8,89},{2,3,3,4,5,8,8,14,34,1073741824}},
  {{9,13},{2,3,3,5,7,9,12,16,23,1073741824}},
  {{8,108},{1,1,1,1,1,1,1,2,2,1073741824}},
  {{13,126},{2,4,4,6,7,8,11,15,20,1073741824}},
  {{5,69},{2,2,3,4,4,6,6,8,12,1073741824}},
  {{13,30},{4,4,4,4,4,4,4,15,17,1073741824}},
  {{13,26},{1,2,2,3,5,6,8,11,18,1073741824}},
  {{5,118},{2,3,3,5,6,6,8,9,14,1073741824}},
  {{8,43},{1,2,3,4,6,10,15,17,19,1073741824}},
  {{9,69},{2,4,5,6,7,9,11,13,17,1073741824}},
  {{9,106},{4,7,9,12,16,34,40,96,96,1073741824}},
  {{8,113},{2,3,5,7,8,10,12,14,15,1073741824}},
  {{8,123},{3,4,4,4,4,4,4,5,6,1073741824}},
  {{8,120},{1,2,2,2,2,3,4,7,11,1073741824}},
  {{8,6},{1,3,4,6,8,8,10,13,18,1073741824}},
  {{8,33},{1,1,2,4,4,6,8,12,30,1073741824}},
  {{8,68},{1,1,1,1,2,2,3,4,6,1073741824}},
  {{8,87},{1,2,2,4,8,8,11,13,14,1073741824}},
  {{9,117},{1,5,7,10,14,16,17,19,22,1073741824}},
  {{8,57},{1,1,1,2,4,5,6,12,16,1073741824}},
  {{5,115},{3,4,6,8,10,12,12,13,15,1073741824}},
  {{8,18},{1,2,3,4,6,6,8,12,20,1073741824}},
  {{13,18},{2,3,8,8,8,8,8,12,16,1073741824}},
  {{13,17},{4,6,8,8,8,9,9,12,15,1073741824}},
  {{8,50},{2,2,3,4,5,5,6,6,8,1073741824}},
  {{13,4},{2,3,3,4,10,10,10,10,12,1073741824}},
  {{8,31},{1,1,1,1,1,1,1,2,4,1073741824}},
  {{8,55},{1,1,1,1,1,3,4,4,6,1073741824}},
  {{9,67},{2,3,4,6,7,8,11,13,17,1073741824}},
  {{8,9},{1,2,2,4,5,6,8,12,20,1073741824}},
  {{8,23},{1,2,3,3,4,5,8,12,16,1073741824}},
  {{14,123},{1,1,2,3,4,6,10,16,20,1073741824}},
  {{13,42},{2,3,4,7,8,8,9,12,19,1073741824}},
  {{13,33},{4,7,8,9,9,9,10,11,16,1073741824}},
  {{9,109},{2,3,3,4,5,7,10,14,18,1073741824}},
  {{9,93},{1,2,3,3,4,5,6,9,15,1073741824}},
  {{13,23},{2,2,4,4,6,6,7,8,11,1073741824}},
  {{13,34},{7,8,10,14,15,16,16,16,16,1073741824}},
  {{8,3},{1,2,3,4,8,12,19,21,22,1073741824}},
  {{13,27},{2,2,2,4,5,6,7,9,19,1073741824}},
  {{8,81},{2,2,3,3,4,4,12,22,24,1073741824}},
  {{13,48},{3,4,5,6,7,8,10,12,16,1073741824}},
  {{8,36},{1,2,2,2,7,9,16,18,21,1073741824}},
  {{13,41},{2,4,5,6,6,7,7,8,9,1073741824}},
  {{8,58},{1,2,2,4,4,5,7,9,13,1073741824}},
  {{8,46},{1,3,4,5,6,6,11,14,17,1073741824}},
  {{8,112},{1,2,2,2,3,4,6,8,10,1073741824}},
  {{8,76},{1,2,4,4,5,5,9,30,48,1073741824}},
  {{13,10},{3,3,4,5,6,7,8,8,12,1073741824}},
  {{8,54},{2,2,4,6,7,8,8,8,12,1073741824}},
  {{8,49},{1,2,2,3,4,6,6,12,12,1073741824}},
  {{9,76},{2,3,4,5,6,9,13,16,16,1073741824}},
  {{9,114},{4,5,6,8,10,13,16,20,24,1073741824}},
  {{8,14},{2,3,4,4,4,5,8,8,16,1073741824}},
  {{13,6},{3,4,4,4,5,8,8,8,8,1073741824}},
  {{13,119},{2,4,4,5,6,8,8,8,11,1073741824}},
  {{9,111},{8,11,13,14,18,21,24,26,28,1073741824}},
  {{13,20},{2,3,3,4,4,6,7,8,9,1073741824}},
  {{8,20},{1,1,1,1,1,1,2,3,8,1073741824}},
  {{13,9},{2,4,5,5,6,6,9,11,11,1073741824}},
  {{8,37},{1,1,2,2,2,4,4,4,4,1073741824}},
  {{8,51},{1,1,2,4,9,16,16,16,16,1073741824}},
  {{8,38},{1,2,4,4,4,5,8,16,16,1073741824}},
  {{8,65},{3,3,4,5,5,5,5,9,19,1073741824}},
  {{8,96},{4,4,4,4,4,4,4,4,4,1073741824}},
  {{15,39},{2,2,3,3,4,4,6,9,10,1073741824}},
  {{8,62},{1,1,3,3,3,4,4,4,4,1073741824}},
  {{8,91},{3,4,5,5,6,6,8,8,8,1073741824}},
  {{13,2},{2,4,4,4,4,4,6,8,9,1073741824}},
  {{8,84},{1,4,4,4,4,4,4,4,7,1073741824}},
  {{8,90},{8,8,8,8,8,8,8,8,9,1073741824}},
  {{8,47},{1,1,2,3,4,5,8,8,12,1073741824}},
  {{8,97},{6,6,6,6,6,6,17,19,19,1073741824}},
  {{8,70},{12,12,12,12,12,16,16,16,16,1073741824}},
  {{13,47},{5,7,7,8,8,9,9,10,12,1073741824}},
  {{8,59},{4,4,4,6,16,16,16,16,16,1073741824}},
  {{8,83},{2,3,3,3,3,3,3,4,5,1073741824}},
  {{8,100},{2,2,2,4,4,8,19,19,20,1073741824}},
  {{13,51},{1,2,3,4,5,5,6,7,8,1073741824}},
  {{13,50},{2,2,3,3,4,4,4,5,8,1073741824}},
  {{8,93},{4,4,4,4,4,4,4,4,4,1073741824}},
  {{8,109},{4,4,4,4,5,6,7,7,7,1073741824}},
  {{13,36},{4,4,4,4,4,4,4,7,8,1073741824}},
  {{8,88},{1,1,2,4,4,8,9,10,12,1073741824}},
  {{8,15},{1,2,4,7,8,8,8,9,19,1073741824}},
  {{8,92},{2,2,2,2,2,2,2,2,2,1073741824}},
  {{8,72},{2,3,4,6,8,8,8,8,9,1073741824}},
  {{13,11},{16,16,16,16,16,16,16,17,17,1073741824}},
  {{8,44},{12,12,12,12,16,16,16,16,28,1073741824}},
  {{8,94},{31,31,31,35,35,36,36,37,37,1073741824}},
  {{13,12},{4,4,4,4,6,6,6,6,6,1073741824}},
  {{8,53},{2,2,4,6,6,7,8,8,8,1073741824}},
  {{13,114},{1,1,2,2,2,2,2,7,8,1073741824}},
  {{8,111},{1,1,1,1,1,1,1,1,1,1073741824}},
  {{8,75},{1,1,2,2,2,3,4,6,8,1073741824}},
  {{8,98},{4,7,12,14,14,14,14,14,14,1073741824}},
  {{13,117},{4,4,4,6,6,6,6,10,13,1073741824}},
  {{8,61},{1,1,1,1,4,4,5,7,33,1073741824}},
  {{8,74},{1,1,1,1,1,1,1,1,2,1073741824}},
  {{13,123},{2,2,7,8,8,8,10,14,14,1073741824}},
  {{8,104},{10,10,34,36,36,36,36,36,36,1073741824}},
  {{13,80},{2,2,3,3,6,6,6,8,11,1073741824}},
  {{13,49},{1,1,1,2,3,4,5,31,41,1073741824}},
  {{8,101},{3,3,3,3,3,3,9,9,9,1073741824}},
  {{13,3},{2,2,3,4,4,4,7,8,8,1073741824}},
  {{13,66},{2,2,2,2,3,4,4,5,8,1073741824}},
  {{13,28},{4,4,4,4,16,24,25,25,26,1073741824}},
  {{13,113},{2,2,3,3,3,3,4,4,4,1073741824}},
  {{13,88},{5,8,8,8,8,8,8,9,9,1073741824}},
  {{8,77},{1,1,3,11,16,23,24,28,29,1073741824}},
  {{13,107},{4,5,5,6,6,6,6,7,8,1073741824}},
  {{8,107},{2,2,2,2,2,2,2,2,2,1073741824}},
  {{8,69},{1,3,3,3,4,4,4,4,4,1073741824}},
  {{13,81},{16,16,16,16,16,16,17,24,24,1073741824}},
  {{13,64},{2,2,2,7,8,12,12,18,20,1073741824}},
  {{13,74},{8,8,8,8,8,8,8,8,14,1073741824}},
  {{13,38},{17,17,17,17,17,18,18,18,19,1073741824}},
  {{13,87},{4,7,12,12,12,13,39,51,54,1073741824}},
  {{13,14},{2,2,3,4,5,6,8,8,8,1073741824}},
  {{13,7},{6,8,8,8,8,10,20,20,20,1073741824}},
  {{13,116},{2,2,4,4,4,4,6,6,6,1073741824}},
  {{13,115},{3,3,3,3,3,3,3,3,3,1073741824}},
  {{8,63},{7,8,8,9,9,9,9,9,9,1073741824}},
  {{8,102},{4,4,4,4,6,8,8,8,8,1073741824}},
  {{8,121},{1,2,2,2,2,2,2,2,2,1073741824}},
  {{13,57},{3,5,8,9,9,10,10,11,11,1073741824}},
  {{13,65},{7,7,9,9,11,11,11,11,11,1073741824}},
  {{13,56},{4,4,4,4,4,4,4,4,4,1073741824}},
  {{8,105},{4,9,9,9,9,9,9,9,9,1073741824}},
  {{8,78},{4,4,4,4,4,4,4,4,4,1073741824}},
  {{0,1},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,1},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,1},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,2},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,2},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,2},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,3},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,3},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,3},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,4},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,4},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,4},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,5},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,5},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,5},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,6},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,6},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,6},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,7},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,7},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,7},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,8},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,8},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,8},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,9},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,9},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,9},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,10},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,10},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,10},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,11},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,11},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,11},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,12},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,12},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,12},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,13},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,13},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,13},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,14},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,14},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,14},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,15},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,15},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,15},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,16},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,16},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,16},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,17},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,17},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,17},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,18},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,18},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,18},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,19},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,19},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,19},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,20},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,20},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,20},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,21},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,21},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,21},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,22},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,22},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,22},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,23},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,23},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,23},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,24},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,24},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,24},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,25},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,25},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,25},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,26},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,26},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,26},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,27},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,27},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,27},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,28},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,28},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,28},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,29},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,29},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,29},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,30},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,30},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,30},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,31},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,31},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,31},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,32},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,32},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,32},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,33},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,33},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,33},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,34},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,34},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,34},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,35},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,35},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,35},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,36},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,36},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,36},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,37},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,37},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,37},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,38},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,38},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,38},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,39},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,39},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,39},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,40},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,40},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,40},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,41},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,41},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,41},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,42},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,42},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,42},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,43},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,43},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,43},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,44},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,44},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,44},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,45},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,45},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,45},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,46},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,46},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,46},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,47},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,47},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,47},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,48},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,48},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,48},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,49},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,49},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,49},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,50},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,50},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,50},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,51},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,51},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,51},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,52},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,52},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,52},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,53},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,53},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,53},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,54},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,54},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,54},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,55},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,55},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,55},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,56},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,56},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,56},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,57},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,57},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,57},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,58},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,58},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,58},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,59},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,59},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,59},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,60},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,60},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,60},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,61},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,61},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,61},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,62},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,62},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,62},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,63},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,63},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,63},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,64},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,64},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,64},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,65},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,65},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,65},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,66},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,66},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,66},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,67},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,67},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,67},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,68},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,68},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,68},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,69},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,69},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,69},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,70},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,70},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,70},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,71},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,71},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,71},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,72},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,72},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,72},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,73},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,73},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,73},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,74},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,74},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,74},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,75},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,75},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,75},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,76},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,76},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,76},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,77},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,77},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,77},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,78},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,78},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,78},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,79},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,79},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,79},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,80},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,80},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,80},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,81},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,81},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,81},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,82},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,82},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,82},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,83},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,83},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,83},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,84},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,84},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,84},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,85},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,85},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,85},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,86},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,86},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,86},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,87},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,87},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,87},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,88},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,88},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,88},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,89},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,89},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,89},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,90},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,90},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,90},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,91},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,91},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,91},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,92},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,92},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,92},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,93},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,93},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,93},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,94},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,94},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,94},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,95},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,95},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,95},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,96},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,96},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,96},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,97},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,97},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,97},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,98},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,98},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,98},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,99},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,99},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,99},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,100},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,100},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,100},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,101},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,101},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,101},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,102},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,102},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,102},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,103},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,103},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,103},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,104},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,104},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,104},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,105},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,105},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,105},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,106},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,106},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,106},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,107},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,107},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,107},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,108},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,108},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,108},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,109},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,109},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,109},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,110},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,110},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,110},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,111},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,111},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,111},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,112},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,112},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,112},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,113},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,113},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,113},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,114},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,114},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,114},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,115},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,115},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,115},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,116},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,116},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,116},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,117},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,117},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,117},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,118},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,118},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,118},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,119},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,119},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,119},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,120},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,120},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,120},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,121},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,121},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,121},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,122},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,122},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,122},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,123},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,123},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,123},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,124},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,124},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,124},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,125},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,125},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,125},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,126},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,126},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,126},{2,3,4,5,7,8,8,8,12,1073741824}},
  {{0,127},{1,2,2,3,3,4,4,4,6,1073741824}},
  {{1,127},{1,2,2,2,2,2,3,4,6,1073741824}},
  {{2,127},{2,3,4,5,7,8,8,8,12,1073741824}}};

std::map<std::tuple<int,int>,std::vector<int>> OPZ_FIX_DUPLICATE_QUANTILES = {
  {{9,0},{0,1,2,3,4,5,6,7,8,9}},
  {{5,0},{0,1,2,2,4,4,6,7,8,9}},
  {{7,0},{0,0,2,3,3,5,6,7,8,9}},
  {{9,88},{0,1,2,3,4,5,6,7,8,9}},
  {{6,66},{0,1,2,2,4,4,6,7,8,9}},
  {{7,66},{0,1,2,2,4,4,6,7,8,9}},
  {{6,49},{0,0,0,3,3,3,6,7,8,9}},
  {{7,49},{0,0,2,2,4,4,6,6,8,9}},
  {{4,33},{0,0,2,3,3,5,6,7,7,9}},
  {{9,30},{0,1,2,3,4,5,6,7,8,9}},
  {{0,0},{0,1,1,3,3,5,5,5,8,9}},
  {{2,0},{0,1,2,3,4,5,5,5,8,9}},
  {{1,0},{0,1,1,1,1,1,6,7,8,9}},
  {{6,27},{0,1,2,3,4,5,6,7,8,9}},
  {{7,27},{0,1,2,3,3,5,6,7,8,9}},
  {{5,50},{0,0,2,2,2,2,6,7,8,9}},
  {{7,50},{0,1,1,3,3,3,6,7,8,9}},
  {{8,0},{0,1,2,3,4,5,6,7,8,9}},
  {{6,75},{0,1,2,2,4,4,6,7,8,9}},
  {{7,75},{0,1,2,2,4,5,6,6,8,9}},
  {{4,32},{0,1,1,3,4,4,4,7,8,9}},
  {{9,24},{0,1,2,3,4,5,6,7,8,9}},
  {{9,25},{0,1,2,3,4,5,6,7,8,9}},
  {{6,26},{0,1,2,2,4,5,6,7,8,9}},
  {{7,26},{0,0,2,3,4,5,6,7,8,9}},
  {{6,91},{0,1,1,3,4,4,6,7,8,9}},
  {{7,91},{0,1,1,3,4,4,6,7,8,9}},
  {{6,71},{0,1,1,3,3,5,6,7,8,9}},
  {{7,71},{0,1,1,3,4,4,6,7,8,9}},
  {{6,79},{0,1,2,3,3,5,6,7,8,9}},
  {{7,79},{0,1,2,3,3,5,5,7,8,9}},
  {{6,4},{0,1,2,2,4,4,6,7,8,9}},
  {{7,4},{0,1,1,3,4,5,6,7,8,9}},
  {{6,5},{0,1,2,3,3,5,6,7,8,9}},
  {{7,5},{0,1,1,3,4,5,6,7,8,9}},
  {{6,0},{0,1,1,3,4,4,6,7,8,9}},
  {{6,28},{0,1,2,3,4,5,6,7,8,9}},
  {{7,28},{0,1,2,3,4,5,6,7,8,9}},
  {{6,11},{0,1,2,2,4,4,6,7,8,9}},
  {{7,11},{0,1,2,2,4,5,6,7,8,9}},
  {{9,4},{0,1,2,3,4,5,6,7,8,9}},
  {{6,40},{0,1,2,2,4,5,6,7,8,9}},
  {{7,40},{0,1,2,2,4,5,6,7,8,9}},
  {{9,48},{0,0,2,3,4,5,6,7,8,9}},
  {{3,100},{0,1,1,3,4,4,6,7,8,9}},
  {{4,38},{0,1,2,3,4,5,5,7,8,9}},
  {{6,88},{0,1,1,3,4,4,6,7,8,9}},
  {{7,88},{0,1,2,2,4,5,6,7,8,9}},
  {{5,56},{0,0,2,3,3,5,5,7,8,9}},
  {{7,56},{0,1,1,3,4,4,6,7,8,9}},
  {{6,57},{0,0,2,2,4,5,5,7,8,9}},
  {{7,57},{0,1,1,3,3,5,5,7,8,9}},
  {{8,115},{0,1,2,3,4,5,6,7,8,9}},
  {{6,58},{0,1,1,1,4,5,5,7,8,9}},
  {{7,58},{0,1,1,1,4,5,5,7,8,9}},
  {{9,80},{0,1,2,3,4,5,6,7,8,9}},
  {{7,80},{0,1,2,2,4,5,6,7,8,9}},
  {{5,80},{0,1,2,3,4,5,6,7,8,9}},
  {{3,126},{0,0,0,3,3,3,6,6,8,9}},
  {{9,19},{0,1,2,3,4,5,6,7,8,9}},
  {{9,56},{0,1,2,3,4,5,6,7,8,9}},
  {{5,73},{0,0,2,3,3,5,5,7,8,9}},
  {{7,73},{0,1,1,3,3,5,5,7,8,9}},
  {{6,22},{0,1,2,2,4,4,6,7,8,9}},
  {{7,22},{0,1,2,2,4,5,6,7,8,9}},
  {{9,60},{0,1,2,3,4,5,6,7,8,9}},
  {{6,73},{0,1,1,3,3,5,5,7,8,9}},
  {{3,96},{0,1,2,3,4,5,6,7,8,9}},
  {{6,106},{0,1,2,3,4,5,6,7,8,9}},
  {{7,106},{0,1,2,3,4,5,6,7,8,9}},
  {{6,30},{0,1,2,3,4,5,6,7,8,9}},
  {{7,30},{0,1,2,3,4,5,6,7,8,9}},
  {{6,29},{0,1,1,3,4,5,6,7,8,9}},
  {{7,29},{0,1,2,3,4,5,6,7,8,9}},
  {{9,83},{0,1,2,3,4,5,6,7,8,9}},
  {{4,34},{0,1,2,3,4,5,5,5,8,9}},
  {{8,32},{0,1,1,3,4,5,6,7,8,9}},
  {{3,99},{0,1,2,3,3,5,6,7,8,9}},
  {{6,48},{0,0,2,2,4,5,6,7,8,9}},
  {{7,48},{0,1,1,3,3,5,6,7,8,9}},
  {{6,50},{0,0,2,2,2,5,6,7,8,9}},
  {{7,1},{0,1,2,2,4,5,6,7,8,9}},
  {{4,35},{0,1,2,2,4,4,6,7,8,9}},
  {{9,52},{0,1,1,3,4,5,6,7,8,9}},
  {{9,1},{0,1,2,3,4,5,6,7,8,9}},
  {{6,119},{0,0,0,0,0,0,0,7,8,9}},
  {{7,119},{0,0,0,0,0,0,6,6,8,9}},
  {{9,89},{0,0,2,2,4,4,6,7,8,9}},
  {{7,52},{0,1,1,1,4,4,6,7,8,9}},
  {{6,65},{0,1,2,2,4,4,6,7,8,9}},
  {{7,65},{0,1,2,2,4,5,5,7,8,9}},
  {{9,16},{0,1,2,2,4,5,6,7,8,9}},
  {{6,21},{0,1,2,2,4,5,6,7,8,9}},
  {{7,21},{0,1,1,3,4,4,6,7,8,9}},
  {{4,37},{0,1,2,2,4,5,6,6,8,9}},
  {{8,16},{0,1,2,3,4,5,6,7,8,9}},
  {{9,5},{0,1,2,3,4,5,6,7,8,9}},
  {{5,25},{0,1,2,3,4,5,5,7,8,9}},
  {{7,25},{0,1,2,3,4,5,6,7,8,9}},
  {{7,62},{0,1,1,3,4,5,6,7,8,9}},
  {{6,52},{0,0,2,2,4,4,6,6,8,9}},
  {{9,27},{0,1,2,3,4,5,6,7,8,9}},
  {{9,46},{0,1,2,3,4,5,6,7,8,9}},
  {{9,49},{0,1,2,2,4,4,6,7,8,9}},
  {{5,60},{0,1,1,3,4,4,6,7,8,9}},
  {{7,60},{0,1,1,1,4,5,5,7,8,9}},
  {{9,73},{0,1,2,3,4,5,6,7,8,9}},
  {{5,9},{0,1,1,3,4,5,6,7,8,9}},
  {{7,9},{0,1,1,3,4,4,6,7,8,9}},
  {{6,24},{0,1,2,3,3,5,6,7,8,9}},
  {{7,24},{0,1,2,3,4,5,6,7,8,9}},
  {{9,57},{0,1,2,3,4,5,6,7,8,9}},
  {{7,61},{0,0,2,3,4,5,6,7,8,9}},
  {{6,56},{0,1,1,3,4,4,6,7,8,9}},
  {{6,47},{0,0,2,2,4,5,6,7,8,9}},
  {{7,47},{0,0,2,2,4,5,6,7,8,9}},
  {{6,19},{0,1,1,3,3,5,6,7,8,9}},
  {{7,19},{0,1,2,2,4,5,6,7,8,9}},
  {{5,19},{0,0,2,2,4,5,6,7,8,9}},
  {{6,68},{0,1,1,1,4,5,5,7,8,9}},
  {{7,68},{0,1,1,3,3,5,6,7,8,9}},
  {{6,117},{0,1,2,3,3,5,6,7,8,9}},
  {{7,117},{0,1,2,3,3,5,6,7,8,9}},
  {{3,125},{0,0,0,0,4,4,6,7,8,9}},
  {{3,127},{0,0,2,2,2,5,6,7,8,9}},
  {{4,36},{0,1,2,3,4,5,6,7,8,9}},
  {{6,12},{0,1,2,3,4,5,6,7,8,9}},
  {{7,12},{0,1,2,3,4,5,6,7,8,9}},
  {{9,2},{0,1,2,3,4,5,6,7,8,9}},
  {{6,85},{0,1,2,2,4,4,6,7,8,9}},
  {{7,85},{0,1,2,2,4,4,6,7,8,9}},
  {{6,13},{0,1,2,3,4,5,6,7,8,9}},
  {{7,13},{0,1,2,3,4,5,6,7,8,9}},
  {{8,21},{0,0,0,3,4,5,6,7,8,9}},
  {{5,81},{0,1,2,3,4,5,6,7,8,9}},
  {{7,81},{0,0,2,2,4,5,6,7,8,9}},
  {{6,80},{0,1,2,2,4,5,6,7,8,9}},
  {{6,2},{0,1,2,3,3,5,6,7,8,9}},
  {{7,2},{0,1,2,3,4,5,6,7,8,9}},
  {{14,98},{0,1,2,3,4,5,6,7,8,9}},
  {{6,46},{0,1,2,3,4,5,5,7,8,9}},
  {{7,46},{0,1,2,3,3,5,5,7,8,9}},
  {{6,10},{0,1,2,2,4,5,6,7,8,9}},
  {{7,10},{0,1,2,3,3,5,6,7,8,9}},
  {{6,72},{0,1,2,2,4,5,6,7,8,9}},
  {{7,72},{0,1,2,3,3,5,6,7,8,9}},
  {{6,60},{0,0,2,2,4,5,5,7,8,9}},
  {{6,17},{0,1,2,3,3,5,6,7,8,9}},
  {{7,17},{0,1,1,3,4,5,6,7,8,9}},
  {{6,115},{0,1,2,3,4,5,6,6,8,9}},
  {{7,115},{0,1,2,3,4,5,6,7,8,9}},
  {{6,61},{0,1,1,3,4,5,6,7,8,9}},
  {{14,127},{0,1,2,3,4,5,6,7,8,9}},
  {{6,63},{0,1,1,3,4,5,6,7,8,9}},
  {{7,63},{0,1,2,3,3,5,6,7,8,9}},
  {{14,102},{0,0,2,2,4,5,6,7,8,9}},
  {{5,53},{0,1,1,3,4,5,6,7,8,9}},
  {{7,53},{0,1,2,2,4,4,6,7,8,9}},
  {{14,101},{0,1,1,3,3,5,6,7,8,9}},
  {{6,87},{0,1,2,3,4,5,6,7,8,9}},
  {{7,87},{0,1,2,3,4,5,6,7,8,9}},
  {{3,120},{0,0,0,0,4,4,6,7,8,9}},
  {{6,53},{0,1,1,3,4,4,6,7,8,9}},
  {{6,82},{0,1,2,2,4,5,5,7,8,9}},
  {{7,82},{0,1,2,3,3,5,6,7,8,9}},
  {{6,118},{0,1,1,3,4,4,6,7,8,9}},
  {{7,118},{0,1,1,3,4,4,6,7,8,9}},
  {{5,48},{0,1,1,3,3,5,6,7,8,9}},
  {{6,81},{0,1,2,3,4,5,6,7,8,9}},
  {{6,94},{0,0,2,2,4,5,6,7,8,9}},
  {{7,94},{0,1,1,3,3,5,6,7,8,9}},
  {{7,74},{0,1,1,3,3,5,6,7,8,9}},
  {{5,26},{0,1,2,3,4,4,6,7,8,9}},
  {{3,102},{0,1,1,3,4,4,6,7,8,9}},
  {{6,51},{0,0,2,2,2,5,6,7,8,9}},
  {{7,51},{0,1,1,3,3,3,6,7,8,9}},
  {{6,18},{0,1,2,2,4,5,6,7,8,9}},
  {{7,18},{0,1,1,3,3,5,6,7,8,9}},
  {{6,116},{0,1,1,1,4,4,6,7,8,9}},
  {{7,116},{0,1,1,3,4,4,6,7,8,9}},
  {{5,30},{0,1,2,3,4,5,6,7,8,9}},
  {{5,58},{0,1,2,3,3,5,6,7,8,9}},
  {{6,67},{0,1,1,3,3,5,5,7,8,9}},
  {{7,67},{0,1,1,3,3,5,5,7,8,9}},
  {{6,54},{0,1,1,3,3,5,6,7,8,9}},
  {{7,54},{0,1,1,3,4,4,6,7,8,9}},
  {{5,61},{0,1,1,3,4,4,6,7,8,9}},
  {{8,40},{0,1,1,3,4,5,6,7,8,9}},
  {{6,42},{0,0,2,2,4,5,5,7,8,9}},
  {{7,42},{0,1,1,3,3,5,5,7,8,9}},
  {{6,25},{0,1,2,3,4,5,6,7,8,9}},
  {{7,14},{0,0,0,3,3,5,6,7,8,9}},
  {{8,7},{0,1,1,3,4,5,6,6,8,9}},
  {{4,39},{0,1,2,3,4,5,6,6,8,9}},
  {{3,122},{0,0,0,0,0,0,6,6,8,9}},
  {{6,90},{0,1,2,3,3,5,6,7,8,9}},
  {{7,90},{0,1,2,3,4,5,6,7,8,9}},
  {{5,24},{0,1,2,3,3,5,6,7,8,9}},
  {{9,11},{0,1,2,3,4,5,6,7,8,9}},
  {{6,74},{0,1,1,3,3,5,5,7,8,9}},
  {{6,62},{0,1,2,3,3,5,6,7,8,9}},
  {{6,64},{0,1,2,2,4,4,6,7,8,9}},
  {{7,64},{0,1,2,2,4,4,6,7,8,9}},
  {{5,64},{0,1,2,3,3,5,6,7,8,9}},
  {{6,9},{0,1,1,3,4,4,6,7,8,9}},
  {{6,76},{0,1,2,3,3,5,6,7,8,9}},
  {{7,76},{0,1,2,3,3,5,6,7,8,9}},
  {{5,4},{0,1,1,3,4,4,6,7,8,9}},
  {{6,23},{0,1,2,2,4,5,6,7,8,9}},
  {{7,23},{0,1,1,3,4,5,6,7,8,9}},
  {{5,16},{0,1,1,3,4,5,6,7,8,9}},
  {{7,16},{0,0,2,3,3,5,6,7,8,9}},
  {{8,17},{0,1,2,3,4,5,6,7,8,9}},
  {{6,77},{0,1,1,3,4,4,6,7,8,9}},
  {{7,77},{0,1,1,3,4,4,6,7,8,9}},
  {{5,93},{0,0,0,3,3,3,6,7,8,9}},
  {{7,93},{0,0,2,2,4,4,6,7,8,9}},
  {{6,31},{0,0,2,2,4,5,6,7,8,9}},
  {{7,31},{0,0,2,3,4,5,6,7,8,9}},
  {{5,27},{0,1,2,2,4,5,6,7,8,9}},
  {{5,62},{0,1,2,3,4,5,6,7,8,9}},
  {{5,66},{0,1,2,3,3,5,6,7,8,9}},
  {{6,41},{0,1,1,3,3,5,6,7,8,9}},
  {{7,41},{0,1,1,3,4,4,6,7,8,9}},
  {{6,70},{0,1,1,1,4,5,5,7,8,9}},
  {{7,70},{0,1,1,1,4,5,5,7,8,9}},
  {{13,0},{0,1,2,3,4,5,6,7,8,9}},
  {{6,43},{0,0,2,2,4,5,5,7,8,9}},
  {{7,43},{0,0,2,2,4,5,6,7,8,9}},
  {{9,26},{0,1,2,3,4,5,6,7,8,9}},
  {{5,68},{0,1,2,2,4,5,6,7,8,9}},
  {{5,29},{0,1,2,3,4,5,6,7,8,9}},
  {{9,28},{0,1,2,3,4,5,6,7,8,9}},
  {{3,121},{0,0,2,3,3,5,6,7,8,9}},
  {{5,6},{0,1,1,3,3,5,6,7,8,9}},
  {{7,6},{0,1,1,3,3,5,6,7,8,9}},
  {{6,6},{0,0,2,2,4,5,5,7,8,9}},
  {{6,93},{0,0,2,2,4,5,6,7,8,9}},
  {{8,126},{0,0,2,3,4,4,6,7,8,9}},
  {{5,71},{0,1,2,3,3,5,6,7,8,9}},
  {{5,17},{0,1,1,3,4,5,6,7,8,9}},
  {{5,49},{0,1,1,3,3,3,3,7,8,9}},
  {{6,55},{0,0,2,2,4,5,6,7,8,9}},
  {{7,55},{0,1,1,1,4,5,6,7,8,9}},
  {{5,11},{0,0,2,3,4,5,6,7,8,9}},
  {{13,40},{0,1,2,3,4,5,6,7,8,9}},
  {{5,51},{0,0,2,2,2,2,2,7,8,9}},
  {{5,52},{0,0,2,2,2,5,6,7,8,9}},
  {{9,53},{0,1,2,3,4,5,6,7,8,9}},
  {{5,40},{0,0,2,3,4,5,6,7,8,9}},
  {{5,85},{0,0,2,3,3,5,6,7,8,9}},
  {{5,65},{0,1,2,3,3,5,6,7,8,9}},
  {{5,88},{0,0,2,3,3,5,5,7,8,9}},
  {{5,57},{0,1,2,2,4,5,6,7,8,9}},
  {{5,41},{0,1,2,3,3,5,6,7,8,9}},
  {{5,67},{0,1,1,3,4,4,6,7,8,9}},
  {{5,42},{0,1,1,3,4,4,6,7,8,9}},
  {{5,91},{0,1,2,2,2,5,6,7,8,9}},
  {{5,70},{0,1,2,3,3,5,6,7,8,9}},
  {{15,32},{0,0,2,2,2,2,6,7,8,9}},
  {{6,3},{0,1,2,3,3,5,6,7,8,9}},
  {{7,3},{0,1,2,3,4,5,6,7,8,9}},
  {{9,108},{0,1,2,3,4,5,6,7,8,9}},
  {{5,75},{0,1,1,3,4,5,6,7,8,9}},
  {{6,45},{0,1,1,3,4,4,6,7,8,9}},
  {{7,45},{0,1,2,3,3,5,6,7,8,9}},
  {{5,89},{0,0,2,2,2,2,2,7,8,9}},
  {{7,89},{0,1,1,3,3,3,3,7,8,9}},
  {{3,103},{0,1,1,3,4,4,6,7,8,9}},
  {{9,85},{0,1,2,2,4,5,6,7,8,9}},
  {{6,110},{0,1,2,3,4,5,6,7,8,9}},
  {{7,110},{0,1,2,3,4,4,6,7,8,9}},
  {{9,18},{0,1,1,3,4,5,6,7,8,9}},
  {{9,6},{0,1,2,3,4,5,6,7,8,9}},
  {{5,7},{0,0,2,2,4,4,6,7,8,9}},
  {{7,7},{0,0,2,2,4,5,6,7,8,9}},
  {{6,7},{0,0,2,2,4,5,6,7,8,9}},
  {{6,44},{0,0,2,2,4,5,6,7,8,9}},
  {{7,44},{0,1,1,3,4,4,6,7,8,9}},
  {{5,10},{0,1,2,3,4,5,6,7,8,9}},
  {{8,11},{0,1,2,3,4,4,4,7,8,9}},
  {{5,44},{0,1,1,3,3,5,6,7,8,9}},
  {{3,97},{0,0,0,0,0,5,5,7,8,9}},
  {{5,95},{0,1,2,2,2,2,2,7,8,9}},
  {{7,95},{0,0,2,2,4,4,4,7,8,9}},
  {{5,1},{0,1,2,3,4,5,6,7,8,9}},
  {{8,25},{0,1,2,3,4,5,6,7,8,9}},
  {{9,72},{0,1,2,3,4,5,6,7,8,9}},
  {{6,69},{0,1,1,3,3,5,5,7,8,9}},
  {{7,69},{0,1,1,3,3,5,6,7,8,9}},
  {{9,70},{0,0,2,3,4,5,6,7,8,9}},
  {{6,8},{0,1,2,3,3,5,6,7,8,9}},
  {{7,8},{0,1,2,3,4,5,6,7,8,9}},
  {{6,14},{0,0,0,0,4,4,6,7,8,9}},
  {{8,48},{0,0,2,2,4,5,6,7,8,9}},
  {{9,44},{0,0,2,3,4,5,6,7,8,9}},
  {{6,78},{0,0,2,3,4,4,6,7,8,9}},
  {{7,78},{0,1,1,3,4,4,6,7,8,9}},
  {{6,59},{0,1,1,3,4,4,6,7,8,9}},
  {{7,59},{0,1,2,2,4,5,6,7,8,9}},
  {{8,116},{0,1,2,3,4,4,6,7,8,9}},
  {{9,45},{0,1,2,3,4,5,6,7,8,9}},
  {{9,119},{0,0,2,3,4,4,6,7,8,9}},
  {{9,62},{0,1,2,3,4,5,6,7,8,9}},
  {{6,89},{0,0,0,3,3,3,6,7,8,9}},
  {{5,21},{0,1,2,3,4,5,6,7,8,9}},
  {{6,1},{0,1,1,3,4,4,6,7,8,9}},
  {{6,16},{0,1,1,3,4,5,6,7,8,9}},
  {{5,116},{0,1,2,3,4,5,6,7,8,9}},
  {{9,50},{0,1,1,3,3,5,6,7,8,9}},
  {{9,7},{0,1,2,3,4,5,6,7,8,9}},
  {{5,45},{0,1,2,3,4,5,6,7,8,9}},
  {{6,95},{0,0,0,0,4,4,4,7,8,9}},
  {{8,8},{0,1,2,3,4,5,6,7,8,9}},
  {{9,29},{0,1,2,3,4,5,6,7,8,9}},
  {{5,54},{0,0,2,2,4,5,6,7,8,9}},
  {{6,20},{0,0,0,0,4,4,4,7,8,9}},
  {{7,20},{0,0,0,3,3,3,6,7,8,9}},
  {{5,28},{0,1,2,3,4,5,6,7,8,9}},
  {{6,105},{0,1,2,3,4,4,6,7,8,9}},
  {{7,105},{0,1,2,3,4,5,6,7,8,9}},
  {{5,59},{0,1,1,3,4,5,6,7,8,9}},
  {{9,61},{0,1,1,3,4,5,6,7,8,9}},
  {{9,65},{0,1,2,3,4,5,6,7,8,9}},
  {{6,108},{0,1,2,3,4,4,6,7,8,9}},
  {{7,108},{0,1,2,3,4,5,6,7,8,9}},
  {{6,84},{0,1,2,3,4,5,6,7,8,9}},
  {{7,84},{0,1,2,3,4,5,6,7,8,9}},
  {{9,95},{0,1,2,2,2,5,5,7,8,9}},
  {{15,34},{0,1,2,3,4,5,6,7,8,9}},
  {{3,98},{0,1,1,3,4,5,6,7,8,9}},
  {{8,24},{0,0,2,3,4,5,6,7,8,9}},
  {{5,18},{0,1,1,3,4,4,6,7,8,9}},
  {{9,3},{0,1,2,3,4,5,6,7,8,9}},
  {{9,17},{0,1,2,3,4,5,6,7,8,9}},
  {{9,51},{0,1,1,1,4,4,6,7,8,9}},
  {{5,23},{0,1,2,3,4,5,6,7,8,9}},
  {{14,122},{0,0,0,3,4,4,6,7,8,9}},
  {{6,107},{0,1,2,3,4,5,6,7,8,9}},
  {{7,107},{0,1,2,3,4,5,6,7,8,9}},
  {{14,99},{0,1,2,3,4,5,6,7,8,9}},
  {{8,10},{0,1,1,3,4,4,6,7,8,9}},
  {{14,100},{0,1,1,3,3,5,6,7,8,9}},
  {{5,82},{0,1,2,3,4,5,6,7,8,9}},
  {{5,12},{0,1,2,3,4,5,6,7,8,9}},
  {{8,66},{0,1,1,1,4,5,6,7,8,9}},
  {{5,105},{0,1,1,3,4,5,6,7,8,9}},
  {{14,96},{0,1,2,3,4,5,6,7,8,9}},
  {{14,103},{0,1,1,3,4,5,6,7,8,9}},
  {{5,2},{0,1,2,3,4,5,6,7,8,9}},
  {{5,5},{0,0,0,3,4,5,6,7,8,9}},
  {{5,87},{0,1,2,3,4,5,5,7,8,9}},
  {{3,123},{0,0,0,3,4,4,6,7,8,9}},
  {{15,33},{0,0,2,3,4,5,6,7,8,9}},
  {{15,38},{0,1,2,2,4,5,5,7,8,9}},
  {{5,78},{0,1,2,3,3,5,6,7,8,9}},
  {{6,86},{0,1,2,3,4,5,6,7,8,9}},
  {{7,86},{0,1,2,3,4,5,6,7,8,9}},
  {{9,23},{0,1,2,3,4,5,6,7,8,9}},
  {{13,118},{0,1,1,1,1,1,1,7,8,9}},
  {{8,118},{0,1,2,2,4,5,6,7,8,9}},
  {{5,22},{0,0,2,3,4,5,5,7,8,9}},
  {{5,90},{0,1,1,3,4,4,6,7,8,9}},
  {{9,94},{0,1,2,2,4,5,6,7,8,9}},
  {{9,21},{0,1,2,3,4,5,6,7,8,9}},
  {{9,90},{0,1,2,3,4,5,6,7,8,9}},
  {{5,119},{0,0,2,2,4,4,4,7,8,9}},
  {{7,114},{0,1,1,3,4,5,6,7,8,9}},
  {{5,74},{0,1,2,3,4,5,6,7,8,9}},
  {{9,12},{0,1,2,3,4,5,6,7,8,9}},
  {{5,72},{0,1,2,2,4,5,6,7,8,9}},
  {{6,104},{0,1,2,3,3,5,6,7,8,9}},
  {{7,104},{0,1,2,3,3,5,6,7,8,9}},
  {{3,124},{0,0,0,3,4,5,6,7,8,9}},
  {{6,113},{0,1,2,3,4,5,6,7,8,9}},
  {{7,113},{0,1,2,3,4,5,6,7,8,9}},
  {{9,64},{0,1,2,3,4,5,6,7,8,9}},
  {{8,1},{0,1,2,3,4,5,6,7,8,9}},
  {{5,84},{0,1,2,2,4,5,6,7,8,9}},
  {{14,97},{0,1,2,2,4,5,6,7,8,9}},
  {{8,114},{0,1,1,3,4,5,6,7,8,9}},
  {{7,92},{0,0,2,3,3,5,5,7,8,9}},
  {{6,83},{0,1,1,3,4,5,6,7,8,9}},
  {{7,83},{0,1,2,2,4,5,6,7,8,9}},
  {{3,101},{0,0,0,0,0,5,5,7,8,9}},
  {{8,119},{0,1,2,2,2,2,2,7,8,9}},
  {{9,107},{0,1,2,3,4,5,6,7,8,9}},
  {{9,20},{0,1,2,3,4,5,6,7,8,9}},
  {{9,54},{0,1,1,3,3,5,6,7,8,9}},
  {{5,110},{0,1,2,3,3,5,6,7,8,9}},
  {{9,105},{0,1,2,2,4,5,6,7,8,9}},
  {{6,92},{0,0,2,2,4,4,6,7,8,9}},
  {{9,116},{0,1,1,3,4,5,6,7,8,9}},
  {{6,114},{0,1,2,3,4,5,6,7,8,9}},
  {{5,63},{0,1,1,3,4,5,6,7,8,9}},
  {{8,28},{0,1,1,3,4,4,6,7,8,9}},
  {{5,55},{0,1,1,1,4,5,6,7,8,9}},
  {{5,20},{0,0,2,3,4,5,6,7,8,9}},
  {{9,9},{0,1,2,3,4,5,6,7,8,9}},
  {{5,46},{0,1,2,3,3,5,6,7,8,9}},
  {{13,16},{0,1,2,2,4,5,6,7,8,9}},
  {{9,81},{0,1,2,3,4,5,6,7,8,9}},
  {{5,94},{0,0,2,2,2,5,6,7,8,9}},
  {{8,80},{0,1,1,3,4,5,6,7,8,9}},
  {{5,106},{0,1,2,3,4,5,6,6,8,9}},
  {{8,42},{0,1,2,2,4,5,6,7,8,9}},
  {{6,15},{0,1,2,3,4,5,5,7,8,9}},
  {{7,15},{0,1,2,3,4,5,6,7,8,9}},
  {{9,71},{0,1,2,3,4,5,6,7,8,9}},
  {{5,47},{0,0,2,3,4,5,6,7,8,9}},
  {{9,68},{0,1,2,3,4,5,6,7,8,9}},
  {{14,126},{0,0,0,3,4,5,6,7,8,9}},
  {{13,8},{0,1,2,3,4,5,6,7,8,9}},
  {{9,77},{0,1,2,3,4,5,6,7,8,9}},
  {{9,78},{0,1,2,2,4,5,6,7,8,9}},
  {{6,109},{0,1,1,3,4,4,6,7,8,9}},
  {{7,109},{0,1,2,2,4,5,6,7,8,9}},
  {{13,29},{0,1,1,1,1,5,6,6,6,9}},
  {{8,29},{0,1,2,3,4,5,5,7,8,9}},
  {{9,92},{0,1,1,3,3,5,6,7,8,9}},
  {{8,45},{0,0,2,3,4,5,6,7,8,9}},
  {{8,79},{0,1,1,1,1,5,6,7,7,9}},
  {{5,43},{0,1,2,2,4,5,6,7,8,9}},
  {{8,73},{0,1,1,1,4,4,4,4,4,9}},
  {{5,92},{0,1,2,2,2,5,5,7,8,9}},
  {{13,24},{0,1,1,3,4,5,6,7,8,9}},
  {{14,125},{0,0,2,3,4,5,5,7,8,9}},
  {{5,8},{0,1,2,3,3,5,6,7,8,9}},
  {{5,108},{0,1,2,3,4,5,6,7,8,9}},
  {{5,3},{0,0,2,3,4,5,6,7,8,9}},
  {{8,2},{0,1,2,2,4,5,6,7,8,9}},
  {{5,13},{0,1,2,3,4,5,6,7,8,9}},
  {{8,12},{0,1,2,2,2,5,6,7,8,9}},
  {{8,82},{0,1,2,3,3,5,6,7,8,9}},
  {{9,66},{0,1,2,3,4,5,6,7,8,9}},
  {{5,31},{0,1,2,2,4,5,6,7,8,9}},
  {{5,112},{0,1,2,2,4,5,6,7,8,9}},
  {{7,112},{0,1,2,3,3,5,6,7,8,9}},
  {{6,111},{0,1,2,3,4,5,6,7,8,9}},
  {{7,111},{0,1,2,3,4,5,6,7,8,9}},
  {{14,124},{0,1,2,3,4,5,6,7,8,9}},
  {{14,120},{0,1,2,3,4,5,6,7,8,9}},
  {{9,79},{0,1,2,3,4,5,5,7,8,9}},
  {{9,63},{0,0,2,3,4,5,6,7,8,9}},
  {{5,104},{0,1,2,2,4,5,6,7,8,9}},
  {{9,31},{0,1,2,3,4,5,6,7,8,9}},
  {{8,64},{0,1,2,3,4,4,6,7,8,9}},
  {{5,114},{0,1,2,3,4,5,6,7,8,9}},
  {{13,32},{0,1,2,3,4,4,6,7,8,9}},
  {{9,41},{0,1,1,3,4,5,6,7,8,9}},
  {{5,79},{0,0,2,3,4,4,6,7,8,9}},
  {{9,84},{0,1,2,3,4,5,6,7,8,9}},
  {{9,14},{0,1,2,2,2,5,6,7,8,9}},
  {{15,35},{0,1,1,3,4,5,6,7,8,9}},
  {{9,74},{0,1,2,3,4,5,6,7,8,9}},
  {{5,83},{0,1,1,3,4,5,6,7,8,9}},
  {{8,124},{0,1,1,1,4,5,6,6,8,9}},
  {{6,112},{0,1,2,3,3,5,6,7,8,9}},
  {{9,59},{0,1,1,3,4,5,6,7,8,9}},
  {{9,40},{0,1,2,3,4,5,6,7,8,9}},
  {{5,111},{0,0,2,3,4,5,6,7,8,9}},
  {{5,109},{0,1,2,3,4,4,6,7,8,9}},
  {{8,127},{0,1,2,3,4,5,6,7,8,9}},
  {{13,25},{0,1,1,1,4,5,6,7,8,9}},
  {{9,115},{0,0,2,3,3,5,6,7,8,9}},
  {{8,22},{0,0,2,3,4,5,6,7,8,9}},
  {{5,107},{0,1,1,3,4,5,6,7,8,9}},
  {{5,14},{0,1,2,2,4,4,6,7,8,9}},
  {{9,91},{0,1,2,2,4,4,6,7,8,9}},
  {{9,75},{0,1,2,3,4,5,6,7,8,9}},
  {{8,39},{0,0,2,2,4,4,6,7,8,9}},
  {{8,27},{0,1,1,3,4,5,6,7,8,9}},
  {{8,99},{0,1,2,2,4,5,5,5,8,9}},
  {{9,87},{0,1,2,3,4,5,6,7,8,9}},
  {{5,76},{0,1,2,2,4,5,6,7,8,9}},
  {{9,110},{0,1,2,2,4,5,6,7,8,9}},
  {{8,67},{0,0,2,3,4,5,5,5,5,9}},
  {{15,36},{0,1,2,3,4,5,6,7,8,9}},
  {{13,1},{0,1,2,3,4,5,6,6,8,9}},
  {{5,86},{0,1,2,2,4,5,6,7,8,9}},
  {{8,13},{0,0,0,3,3,5,6,7,8,9}},
  {{9,86},{0,0,2,2,4,5,5,5,8,9}},
  {{9,113},{0,1,2,3,4,5,6,7,7,9}},
  {{9,55},{0,1,2,3,4,5,6,7,8,9}},
  {{9,10},{0,1,2,3,4,5,6,7,8,9}},
  {{9,47},{0,1,2,3,4,5,6,7,8,9}},
  {{9,22},{0,1,2,3,4,5,6,7,8,9}},
  {{9,104},{0,1,2,3,4,5,6,7,8,9}},
  {{8,56},{0,1,1,3,3,5,6,7,8,9}},
  {{9,8},{0,1,2,3,4,5,6,7,8,9}},
  {{9,82},{0,1,2,3,4,5,6,7,8,9}},
  {{9,112},{0,1,2,3,4,5,6,7,8,9}},
  {{5,117},{0,1,1,1,4,5,6,7,8,9}},
  {{13,127},{0,1,2,3,4,5,6,6,8,9}},
  {{9,42},{0,1,2,3,4,5,6,7,8,9}},
  {{8,4},{0,1,2,3,4,5,6,7,8,9}},
  {{8,34},{0,0,0,3,4,5,6,7,8,9}},
  {{8,52},{0,1,1,1,4,5,6,7,7,9}},
  {{8,5},{0,1,2,2,4,5,6,7,8,9}},
  {{9,58},{0,1,2,3,3,5,6,7,8,9}},
  {{8,30},{0,1,2,3,4,5,6,7,8,9}},
  {{8,41},{0,1,2,3,4,5,5,7,8,9}},
  {{9,118},{0,1,1,3,3,5,6,7,8,9}},
  {{5,113},{0,1,1,3,3,3,6,7,8,9}},
  {{5,15},{0,1,2,3,4,5,6,7,8,9}},
  {{15,37},{0,1,2,3,4,4,6,7,8,9}},
  {{8,71},{0,0,0,0,0,5,5,7,8,9}},
  {{5,77},{0,1,2,2,4,5,6,7,8,9}},
  {{8,26},{0,1,2,3,4,5,6,7,8,9}},
  {{8,117},{0,1,2,3,4,4,4,7,8,9}},
  {{9,43},{0,1,2,3,4,5,6,7,8,9}},
  {{8,19},{0,0,2,2,4,5,6,7,8,9}},
  {{9,15},{0,1,2,3,4,4,6,7,8,9}},
  {{8,35},{0,0,2,2,4,5,6,7,8,9}},
  {{14,121},{0,1,1,3,4,5,6,7,8,9}},
  {{8,60},{0,0,0,0,0,0,6,7,8,9}},
  {{8,89},{0,1,1,3,4,5,5,7,8,9}},
  {{9,13},{0,1,1,3,4,5,6,7,8,9}},
  {{8,108},{0,0,0,0,0,0,0,7,7,9}},
  {{13,126},{0,1,1,3,4,5,6,7,8,9}},
  {{5,69},{0,0,2,3,3,5,5,7,8,9}},
  {{13,30},{0,0,0,0,0,0,0,7,8,9}},
  {{13,26},{0,1,1,3,4,5,6,7,8,9}},
  {{5,118},{0,1,1,3,4,4,6,7,8,9}},
  {{8,43},{0,1,2,3,4,5,6,7,8,9}},
  {{9,69},{0,1,2,3,4,5,6,7,8,9}},
  {{9,106},{0,1,2,3,4,5,6,7,7,9}},
  {{8,113},{0,1,2,3,4,5,6,7,8,9}},
  {{8,123},{0,1,1,1,1,1,1,7,8,9}},
  {{8,120},{0,1,1,1,1,5,6,7,8,9}},
  {{8,6},{0,1,2,3,4,4,6,7,8,9}},
  {{8,33},{0,0,2,3,3,5,6,7,8,9}},
  {{8,68},{0,0,0,0,4,4,6,7,8,9}},
  {{8,87},{0,1,1,3,4,4,6,7,8,9}},
  {{9,117},{0,1,2,3,4,5,6,7,8,9}},
  {{8,57},{0,0,0,3,4,5,6,7,8,9}},
  {{5,115},{0,1,2,3,4,5,5,7,8,9}},
  {{8,18},{0,1,2,3,4,4,6,7,8,9}},
  {{13,18},{0,1,2,2,2,2,2,7,8,9}},
  {{13,17},{0,1,2,2,2,5,5,7,8,9}},
  {{8,50},{0,0,2,3,4,4,6,6,8,9}},
  {{13,4},{0,1,1,3,4,4,4,4,8,9}},
  {{8,31},{0,0,0,0,0,0,0,7,8,9}},
  {{8,55},{0,0,0,0,0,5,6,6,8,9}},
  {{9,67},{0,1,2,3,4,5,6,7,8,9}},
  {{8,9},{0,1,1,3,4,5,6,7,8,9}},
  {{8,23},{0,1,2,2,4,5,6,7,8,9}},
  {{14,123},{0,0,2,3,4,5,6,7,8,9}},
  {{13,42},{0,1,2,3,4,4,6,7,8,9}},
  {{13,33},{0,1,2,3,3,3,6,7,8,9}},
  {{9,109},{0,1,1,3,4,5,6,7,8,9}},
  {{9,93},{0,1,2,2,4,5,6,7,8,9}},
  {{13,23},{0,0,2,2,4,4,6,7,8,9}},
  {{13,34},{0,1,2,3,4,5,5,5,5,9}},
  {{8,3},{0,1,2,3,4,5,6,7,8,9}},
  {{13,27},{0,0,0,3,4,5,6,7,8,9}},
  {{8,81},{0,0,2,2,4,4,6,7,8,9}},
  {{13,48},{0,1,2,3,4,5,6,7,8,9}},
  {{8,36},{0,1,1,1,4,5,6,7,8,9}},
  {{13,41},{0,1,2,3,3,5,5,7,8,9}},
  {{8,58},{0,1,1,3,3,5,6,7,8,9}},
  {{8,46},{0,1,2,3,4,4,6,7,8,9}},
  {{8,112},{0,1,1,1,4,5,6,7,8,9}},
  {{8,76},{0,1,2,2,4,4,6,7,8,9}},
  {{13,10},{0,0,2,3,4,5,6,6,8,9}},
  {{8,54},{0,0,2,3,4,5,5,5,8,9}},
  {{8,49},{0,1,1,3,4,5,5,7,7,9}},
  {{9,76},{0,1,2,3,4,5,6,7,7,9}},
  {{9,114},{0,1,2,3,4,5,6,7,8,9}},
  {{8,14},{0,1,2,2,2,5,6,6,8,9}},
  {{13,6},{0,1,1,1,4,5,5,5,5,9}},
  {{13,119},{0,1,1,3,4,5,5,5,8,9}},
  {{9,111},{0,1,2,3,4,5,6,7,8,9}},
  {{13,20},{0,1,1,3,3,5,6,7,8,9}},
  {{8,20},{0,0,0,0,0,0,6,7,8,9}},
  {{13,9},{0,1,2,2,4,4,6,7,7,9}},
  {{8,37},{0,0,2,2,2,5,5,5,5,9}},
  {{8,51},{0,0,2,3,4,5,5,5,5,9}},
  {{8,38},{0,1,2,2,2,5,6,7,7,9}},
  {{8,65},{0,0,2,3,3,3,3,7,8,9}},
  {{8,96},{0,0,0,0,0,0,0,0,0,9}},
  {{15,39},{0,0,2,2,4,4,6,7,8,9}},
  {{8,62},{0,0,2,2,2,5,5,5,5,9}},
  {{8,91},{0,1,2,2,4,4,6,6,6,9}},
  {{13,2},{0,1,1,1,1,1,6,7,8,9}},
  {{8,84},{0,1,1,1,1,1,1,1,8,9}},
  {{8,90},{0,0,0,0,0,0,0,0,8,9}},
  {{8,47},{0,0,2,3,4,5,6,6,8,9}},
  {{8,97},{0,0,0,0,0,0,6,7,7,9}},
  {{8,70},{0,0,0,0,0,5,5,5,5,9}},
  {{13,47},{0,1,1,3,3,5,5,7,8,9}},
  {{8,59},{0,0,0,3,4,4,4,4,4,9}},
  {{8,83},{0,1,1,1,1,1,1,7,8,9}},
  {{8,100},{0,0,0,3,3,5,6,6,8,9}},
  {{13,51},{0,1,2,3,4,4,6,7,8,9}},
  {{13,50},{0,0,2,2,4,4,4,7,8,9}},
  {{8,93},{0,0,0,0,0,0,0,0,0,9}},
  {{8,109},{0,0,0,0,4,5,6,6,6,9}},
  {{13,36},{0,0,0,0,0,0,0,7,8,9}},
  {{8,88},{0,0,2,3,3,5,6,7,8,9}},
  {{8,15},{0,1,2,3,4,4,4,7,8,9}},
  {{8,92},{0,0,0,0,0,0,0,0,0,9}},
  {{8,72},{0,1,2,3,4,4,4,4,8,9}},
  {{13,11},{0,0,0,0,0,0,0,7,7,9}},
  {{8,44},{0,0,0,0,4,4,4,4,8,9}},
  {{8,94},{0,0,0,3,3,5,5,7,7,9}},
  {{13,12},{0,0,0,0,4,4,4,4,4,9}},
  {{8,53},{0,0,2,3,3,5,6,6,6,9}},
  {{13,114},{0,0,2,2,2,2,2,7,8,9}},
  {{8,111},{0,0,0,0,0,0,0,0,0,9}},
  {{8,75},{0,0,2,2,2,5,6,7,8,9}},
  {{8,98},{0,1,2,3,3,3,3,3,3,9}},
  {{13,117},{0,0,0,3,3,3,3,7,8,9}},
  {{8,61},{0,0,0,0,4,4,6,7,8,9}},
  {{8,74},{0,0,0,0,0,0,0,0,8,9}},
  {{13,123},{0,0,2,3,3,3,6,7,7,9}},
  {{8,104},{0,0,2,3,3,3,3,3,3,9}},
  {{13,80},{0,0,2,2,4,4,4,7,8,9}},
  {{13,49},{0,0,0,3,4,5,6,7,8,9}},
  {{8,101},{0,0,0,0,0,0,6,6,6,9}},
  {{13,3},{0,0,2,3,3,3,6,7,7,9}},
  {{13,66},{0,0,0,0,4,5,5,7,8,9}},
  {{13,28},{0,0,0,0,4,5,6,6,8,9}},
  {{13,113},{0,0,2,2,2,2,6,6,6,9}},
  {{13,88},{0,1,1,1,1,1,1,7,7,9}},
  {{8,77},{0,0,2,3,4,5,6,7,8,9}},
  {{13,107},{0,1,1,3,3,3,3,7,8,9}},
  {{8,107},{0,0,0,0,0,0,0,0,0,9}},
  {{8,69},{0,1,1,1,4,4,4,4,4,9}},
  {{13,81},{0,0,0,0,0,0,6,7,7,9}},
  {{13,64},{0,0,0,3,4,5,5,7,8,9}},
  {{13,74},{0,0,0,0,0,0,0,0,8,9}},
  {{13,38},{0,0,0,0,0,5,5,5,8,9}},
  {{13,87},{0,1,2,2,2,5,6,7,8,9}},
  {{13,14},{0,0,2,3,4,5,6,6,6,9}},
  {{13,7},{0,1,1,1,1,5,6,6,6,9}},
  {{13,116},{0,0,2,2,2,2,6,6,6,9}},
  {{13,115},{0,0,0,0,0,0,0,0,0,9}},
  {{8,63},{0,1,1,3,3,3,3,3,3,9}},
  {{8,102},{0,0,0,0,4,5,5,5,5,9}},
  {{8,121},{0,1,1,1,1,1,1,1,1,9}},
  {{13,57},{0,1,2,3,3,5,5,7,7,9}},
  {{13,65},{0,0,2,2,4,4,4,4,4,9}},
  {{13,56},{0,0,0,0,0,0,0,0,0,9}},
  {{8,105},{0,1,1,1,1,1,1,1,1,9}},
  {{8,78},{0,0,0,0,0,0,0,0,0,9}},
  {{0,1},{0,1,1,3,3,5,5,5,8,9}},
  {{1,1},{0,1,1,1,1,1,6,7,8,9}},
  {{2,1},{0,1,2,3,4,5,5,5,8,9}},
  {{0,2},{0,1,1,3,3,5,5,5,8,9}},
  {{1,2},{0,1,1,1,1,1,6,7,8,9}},
  {{2,2},{0,1,2,3,4,5,5,5,8,9}},
  {{0,3},{0,1,1,3,3,5,5,5,8,9}},
  {{1,3},{0,1,1,1,1,1,6,7,8,9}},
  {{2,3},{0,1,2,3,4,5,5,5,8,9}},
  {{0,4},{0,1,1,3,3,5,5,5,8,9}},
  {{1,4},{0,1,1,1,1,1,6,7,8,9}},
  {{2,4},{0,1,2,3,4,5,5,5,8,9}},
  {{0,5},{0,1,1,3,3,5,5,5,8,9}},
  {{1,5},{0,1,1,1,1,1,6,7,8,9}},
  {{2,5},{0,1,2,3,4,5,5,5,8,9}},
  {{0,6},{0,1,1,3,3,5,5,5,8,9}},
  {{1,6},{0,1,1,1,1,1,6,7,8,9}},
  {{2,6},{0,1,2,3,4,5,5,5,8,9}},
  {{0,7},{0,1,1,3,3,5,5,5,8,9}},
  {{1,7},{0,1,1,1,1,1,6,7,8,9}},
  {{2,7},{0,1,2,3,4,5,5,5,8,9}},
  {{0,8},{0,1,1,3,3,5,5,5,8,9}},
  {{1,8},{0,1,1,1,1,1,6,7,8,9}},
  {{2,8},{0,1,2,3,4,5,5,5,8,9}},
  {{0,9},{0,1,1,3,3,5,5,5,8,9}},
  {{1,9},{0,1,1,1,1,1,6,7,8,9}},
  {{2,9},{0,1,2,3,4,5,5,5,8,9}},
  {{0,10},{0,1,1,3,3,5,5,5,8,9}},
  {{1,10},{0,1,1,1,1,1,6,7,8,9}},
  {{2,10},{0,1,2,3,4,5,5,5,8,9}},
  {{0,11},{0,1,1,3,3,5,5,5,8,9}},
  {{1,11},{0,1,1,1,1,1,6,7,8,9}},
  {{2,11},{0,1,2,3,4,5,5,5,8,9}},
  {{0,12},{0,1,1,3,3,5,5,5,8,9}},
  {{1,12},{0,1,1,1,1,1,6,7,8,9}},
  {{2,12},{0,1,2,3,4,5,5,5,8,9}},
  {{0,13},{0,1,1,3,3,5,5,5,8,9}},
  {{1,13},{0,1,1,1,1,1,6,7,8,9}},
  {{2,13},{0,1,2,3,4,5,5,5,8,9}},
  {{0,14},{0,1,1,3,3,5,5,5,8,9}},
  {{1,14},{0,1,1,1,1,1,6,7,8,9}},
  {{2,14},{0,1,2,3,4,5,5,5,8,9}},
  {{0,15},{0,1,1,3,3,5,5,5,8,9}},
  {{1,15},{0,1,1,1,1,1,6,7,8,9}},
  {{2,15},{0,1,2,3,4,5,5,5,8,9}},
  {{0,16},{0,1,1,3,3,5,5,5,8,9}},
  {{1,16},{0,1,1,1,1,1,6,7,8,9}},
  {{2,16},{0,1,2,3,4,5,5,5,8,9}},
  {{0,17},{0,1,1,3,3,5,5,5,8,9}},
  {{1,17},{0,1,1,1,1,1,6,7,8,9}},
  {{2,17},{0,1,2,3,4,5,5,5,8,9}},
  {{0,18},{0,1,1,3,3,5,5,5,8,9}},
  {{1,18},{0,1,1,1,1,1,6,7,8,9}},
  {{2,18},{0,1,2,3,4,5,5,5,8,9}},
  {{0,19},{0,1,1,3,3,5,5,5,8,9}},
  {{1,19},{0,1,1,1,1,1,6,7,8,9}},
  {{2,19},{0,1,2,3,4,5,5,5,8,9}},
  {{0,20},{0,1,1,3,3,5,5,5,8,9}},
  {{1,20},{0,1,1,1,1,1,6,7,8,9}},
  {{2,20},{0,1,2,3,4,5,5,5,8,9}},
  {{0,21},{0,1,1,3,3,5,5,5,8,9}},
  {{1,21},{0,1,1,1,1,1,6,7,8,9}},
  {{2,21},{0,1,2,3,4,5,5,5,8,9}},
  {{0,22},{0,1,1,3,3,5,5,5,8,9}},
  {{1,22},{0,1,1,1,1,1,6,7,8,9}},
  {{2,22},{0,1,2,3,4,5,5,5,8,9}},
  {{0,23},{0,1,1,3,3,5,5,5,8,9}},
  {{1,23},{0,1,1,1,1,1,6,7,8,9}},
  {{2,23},{0,1,2,3,4,5,5,5,8,9}},
  {{0,24},{0,1,1,3,3,5,5,5,8,9}},
  {{1,24},{0,1,1,1,1,1,6,7,8,9}},
  {{2,24},{0,1,2,3,4,5,5,5,8,9}},
  {{0,25},{0,1,1,3,3,5,5,5,8,9}},
  {{1,25},{0,1,1,1,1,1,6,7,8,9}},
  {{2,25},{0,1,2,3,4,5,5,5,8,9}},
  {{0,26},{0,1,1,3,3,5,5,5,8,9}},
  {{1,26},{0,1,1,1,1,1,6,7,8,9}},
  {{2,26},{0,1,2,3,4,5,5,5,8,9}},
  {{0,27},{0,1,1,3,3,5,5,5,8,9}},
  {{1,27},{0,1,1,1,1,1,6,7,8,9}},
  {{2,27},{0,1,2,3,4,5,5,5,8,9}},
  {{0,28},{0,1,1,3,3,5,5,5,8,9}},
  {{1,28},{0,1,1,1,1,1,6,7,8,9}},
  {{2,28},{0,1,2,3,4,5,5,5,8,9}},
  {{0,29},{0,1,1,3,3,5,5,5,8,9}},
  {{1,29},{0,1,1,1,1,1,6,7,8,9}},
  {{2,29},{0,1,2,3,4,5,5,5,8,9}},
  {{0,30},{0,1,1,3,3,5,5,5,8,9}},
  {{1,30},{0,1,1,1,1,1,6,7,8,9}},
  {{2,30},{0,1,2,3,4,5,5,5,8,9}},
  {{0,31},{0,1,1,3,3,5,5,5,8,9}},
  {{1,31},{0,1,1,1,1,1,6,7,8,9}},
  {{2,31},{0,1,2,3,4,5,5,5,8,9}},
  {{0,32},{0,1,1,3,3,5,5,5,8,9}},
  {{1,32},{0,1,1,1,1,1,6,7,8,9}},
  {{2,32},{0,1,2,3,4,5,5,5,8,9}},
  {{0,33},{0,1,1,3,3,5,5,5,8,9}},
  {{1,33},{0,1,1,1,1,1,6,7,8,9}},
  {{2,33},{0,1,2,3,4,5,5,5,8,9}},
  {{0,34},{0,1,1,3,3,5,5,5,8,9}},
  {{1,34},{0,1,1,1,1,1,6,7,8,9}},
  {{2,34},{0,1,2,3,4,5,5,5,8,9}},
  {{0,35},{0,1,1,3,3,5,5,5,8,9}},
  {{1,35},{0,1,1,1,1,1,6,7,8,9}},
  {{2,35},{0,1,2,3,4,5,5,5,8,9}},
  {{0,36},{0,1,1,3,3,5,5,5,8,9}},
  {{1,36},{0,1,1,1,1,1,6,7,8,9}},
  {{2,36},{0,1,2,3,4,5,5,5,8,9}},
  {{0,37},{0,1,1,3,3,5,5,5,8,9}},
  {{1,37},{0,1,1,1,1,1,6,7,8,9}},
  {{2,37},{0,1,2,3,4,5,5,5,8,9}},
  {{0,38},{0,1,1,3,3,5,5,5,8,9}},
  {{1,38},{0,1,1,1,1,1,6,7,8,9}},
  {{2,38},{0,1,2,3,4,5,5,5,8,9}},
  {{0,39},{0,1,1,3,3,5,5,5,8,9}},
  {{1,39},{0,1,1,1,1,1,6,7,8,9}},
  {{2,39},{0,1,2,3,4,5,5,5,8,9}},
  {{0,40},{0,1,1,3,3,5,5,5,8,9}},
  {{1,40},{0,1,1,1,1,1,6,7,8,9}},
  {{2,40},{0,1,2,3,4,5,5,5,8,9}},
  {{0,41},{0,1,1,3,3,5,5,5,8,9}},
  {{1,41},{0,1,1,1,1,1,6,7,8,9}},
  {{2,41},{0,1,2,3,4,5,5,5,8,9}},
  {{0,42},{0,1,1,3,3,5,5,5,8,9}},
  {{1,42},{0,1,1,1,1,1,6,7,8,9}},
  {{2,42},{0,1,2,3,4,5,5,5,8,9}},
  {{0,43},{0,1,1,3,3,5,5,5,8,9}},
  {{1,43},{0,1,1,1,1,1,6,7,8,9}},
  {{2,43},{0,1,2,3,4,5,5,5,8,9}},
  {{0,44},{0,1,1,3,3,5,5,5,8,9}},
  {{1,44},{0,1,1,1,1,1,6,7,8,9}},
  {{2,44},{0,1,2,3,4,5,5,5,8,9}},
  {{0,45},{0,1,1,3,3,5,5,5,8,9}},
  {{1,45},{0,1,1,1,1,1,6,7,8,9}},
  {{2,45},{0,1,2,3,4,5,5,5,8,9}},
  {{0,46},{0,1,1,3,3,5,5,5,8,9}},
  {{1,46},{0,1,1,1,1,1,6,7,8,9}},
  {{2,46},{0,1,2,3,4,5,5,5,8,9}},
  {{0,47},{0,1,1,3,3,5,5,5,8,9}},
  {{1,47},{0,1,1,1,1,1,6,7,8,9}},
  {{2,47},{0,1,2,3,4,5,5,5,8,9}},
  {{0,48},{0,1,1,3,3,5,5,5,8,9}},
  {{1,48},{0,1,1,1,1,1,6,7,8,9}},
  {{2,48},{0,1,2,3,4,5,5,5,8,9}},
  {{0,49},{0,1,1,3,3,5,5,5,8,9}},
  {{1,49},{0,1,1,1,1,1,6,7,8,9}},
  {{2,49},{0,1,2,3,4,5,5,5,8,9}},
  {{0,50},{0,1,1,3,3,5,5,5,8,9}},
  {{1,50},{0,1,1,1,1,1,6,7,8,9}},
  {{2,50},{0,1,2,3,4,5,5,5,8,9}},
  {{0,51},{0,1,1,3,3,5,5,5,8,9}},
  {{1,51},{0,1,1,1,1,1,6,7,8,9}},
  {{2,51},{0,1,2,3,4,5,5,5,8,9}},
  {{0,52},{0,1,1,3,3,5,5,5,8,9}},
  {{1,52},{0,1,1,1,1,1,6,7,8,9}},
  {{2,52},{0,1,2,3,4,5,5,5,8,9}},
  {{0,53},{0,1,1,3,3,5,5,5,8,9}},
  {{1,53},{0,1,1,1,1,1,6,7,8,9}},
  {{2,53},{0,1,2,3,4,5,5,5,8,9}},
  {{0,54},{0,1,1,3,3,5,5,5,8,9}},
  {{1,54},{0,1,1,1,1,1,6,7,8,9}},
  {{2,54},{0,1,2,3,4,5,5,5,8,9}},
  {{0,55},{0,1,1,3,3,5,5,5,8,9}},
  {{1,55},{0,1,1,1,1,1,6,7,8,9}},
  {{2,55},{0,1,2,3,4,5,5,5,8,9}},
  {{0,56},{0,1,1,3,3,5,5,5,8,9}},
  {{1,56},{0,1,1,1,1,1,6,7,8,9}},
  {{2,56},{0,1,2,3,4,5,5,5,8,9}},
  {{0,57},{0,1,1,3,3,5,5,5,8,9}},
  {{1,57},{0,1,1,1,1,1,6,7,8,9}},
  {{2,57},{0,1,2,3,4,5,5,5,8,9}},
  {{0,58},{0,1,1,3,3,5,5,5,8,9}},
  {{1,58},{0,1,1,1,1,1,6,7,8,9}},
  {{2,58},{0,1,2,3,4,5,5,5,8,9}},
  {{0,59},{0,1,1,3,3,5,5,5,8,9}},
  {{1,59},{0,1,1,1,1,1,6,7,8,9}},
  {{2,59},{0,1,2,3,4,5,5,5,8,9}},
  {{0,60},{0,1,1,3,3,5,5,5,8,9}},
  {{1,60},{0,1,1,1,1,1,6,7,8,9}},
  {{2,60},{0,1,2,3,4,5,5,5,8,9}},
  {{0,61},{0,1,1,3,3,5,5,5,8,9}},
  {{1,61},{0,1,1,1,1,1,6,7,8,9}},
  {{2,61},{0,1,2,3,4,5,5,5,8,9}},
  {{0,62},{0,1,1,3,3,5,5,5,8,9}},
  {{1,62},{0,1,1,1,1,1,6,7,8,9}},
  {{2,62},{0,1,2,3,4,5,5,5,8,9}},
  {{0,63},{0,1,1,3,3,5,5,5,8,9}},
  {{1,63},{0,1,1,1,1,1,6,7,8,9}},
  {{2,63},{0,1,2,3,4,5,5,5,8,9}},
  {{0,64},{0,1,1,3,3,5,5,5,8,9}},
  {{1,64},{0,1,1,1,1,1,6,7,8,9}},
  {{2,64},{0,1,2,3,4,5,5,5,8,9}},
  {{0,65},{0,1,1,3,3,5,5,5,8,9}},
  {{1,65},{0,1,1,1,1,1,6,7,8,9}},
  {{2,65},{0,1,2,3,4,5,5,5,8,9}},
  {{0,66},{0,1,1,3,3,5,5,5,8,9}},
  {{1,66},{0,1,1,1,1,1,6,7,8,9}},
  {{2,66},{0,1,2,3,4,5,5,5,8,9}},
  {{0,67},{0,1,1,3,3,5,5,5,8,9}},
  {{1,67},{0,1,1,1,1,1,6,7,8,9}},
  {{2,67},{0,1,2,3,4,5,5,5,8,9}},
  {{0,68},{0,1,1,3,3,5,5,5,8,9}},
  {{1,68},{0,1,1,1,1,1,6,7,8,9}},
  {{2,68},{0,1,2,3,4,5,5,5,8,9}},
  {{0,69},{0,1,1,3,3,5,5,5,8,9}},
  {{1,69},{0,1,1,1,1,1,6,7,8,9}},
  {{2,69},{0,1,2,3,4,5,5,5,8,9}},
  {{0,70},{0,1,1,3,3,5,5,5,8,9}},
  {{1,70},{0,1,1,1,1,1,6,7,8,9}},
  {{2,70},{0,1,2,3,4,5,5,5,8,9}},
  {{0,71},{0,1,1,3,3,5,5,5,8,9}},
  {{1,71},{0,1,1,1,1,1,6,7,8,9}},
  {{2,71},{0,1,2,3,4,5,5,5,8,9}},
  {{0,72},{0,1,1,3,3,5,5,5,8,9}},
  {{1,72},{0,1,1,1,1,1,6,7,8,9}},
  {{2,72},{0,1,2,3,4,5,5,5,8,9}},
  {{0,73},{0,1,1,3,3,5,5,5,8,9}},
  {{1,73},{0,1,1,1,1,1,6,7,8,9}},
  {{2,73},{0,1,2,3,4,5,5,5,8,9}},
  {{0,74},{0,1,1,3,3,5,5,5,8,9}},
  {{1,74},{0,1,1,1,1,1,6,7,8,9}},
  {{2,74},{0,1,2,3,4,5,5,5,8,9}},
  {{0,75},{0,1,1,3,3,5,5,5,8,9}},
  {{1,75},{0,1,1,1,1,1,6,7,8,9}},
  {{2,75},{0,1,2,3,4,5,5,5,8,9}},
  {{0,76},{0,1,1,3,3,5,5,5,8,9}},
  {{1,76},{0,1,1,1,1,1,6,7,8,9}},
  {{2,76},{0,1,2,3,4,5,5,5,8,9}},
  {{0,77},{0,1,1,3,3,5,5,5,8,9}},
  {{1,77},{0,1,1,1,1,1,6,7,8,9}},
  {{2,77},{0,1,2,3,4,5,5,5,8,9}},
  {{0,78},{0,1,1,3,3,5,5,5,8,9}},
  {{1,78},{0,1,1,1,1,1,6,7,8,9}},
  {{2,78},{0,1,2,3,4,5,5,5,8,9}},
  {{0,79},{0,1,1,3,3,5,5,5,8,9}},
  {{1,79},{0,1,1,1,1,1,6,7,8,9}},
  {{2,79},{0,1,2,3,4,5,5,5,8,9}},
  {{0,80},{0,1,1,3,3,5,5,5,8,9}},
  {{1,80},{0,1,1,1,1,1,6,7,8,9}},
  {{2,80},{0,1,2,3,4,5,5,5,8,9}},
  {{0,81},{0,1,1,3,3,5,5,5,8,9}},
  {{1,81},{0,1,1,1,1,1,6,7,8,9}},
  {{2,81},{0,1,2,3,4,5,5,5,8,9}},
  {{0,82},{0,1,1,3,3,5,5,5,8,9}},
  {{1,82},{0,1,1,1,1,1,6,7,8,9}},
  {{2,82},{0,1,2,3,4,5,5,5,8,9}},
  {{0,83},{0,1,1,3,3,5,5,5,8,9}},
  {{1,83},{0,1,1,1,1,1,6,7,8,9}},
  {{2,83},{0,1,2,3,4,5,5,5,8,9}},
  {{0,84},{0,1,1,3,3,5,5,5,8,9}},
  {{1,84},{0,1,1,1,1,1,6,7,8,9}},
  {{2,84},{0,1,2,3,4,5,5,5,8,9}},
  {{0,85},{0,1,1,3,3,5,5,5,8,9}},
  {{1,85},{0,1,1,1,1,1,6,7,8,9}},
  {{2,85},{0,1,2,3,4,5,5,5,8,9}},
  {{0,86},{0,1,1,3,3,5,5,5,8,9}},
  {{1,86},{0,1,1,1,1,1,6,7,8,9}},
  {{2,86},{0,1,2,3,4,5,5,5,8,9}},
  {{0,87},{0,1,1,3,3,5,5,5,8,9}},
  {{1,87},{0,1,1,1,1,1,6,7,8,9}},
  {{2,87},{0,1,2,3,4,5,5,5,8,9}},
  {{0,88},{0,1,1,3,3,5,5,5,8,9}},
  {{1,88},{0,1,1,1,1,1,6,7,8,9}},
  {{2,88},{0,1,2,3,4,5,5,5,8,9}},
  {{0,89},{0,1,1,3,3,5,5,5,8,9}},
  {{1,89},{0,1,1,1,1,1,6,7,8,9}},
  {{2,89},{0,1,2,3,4,5,5,5,8,9}},
  {{0,90},{0,1,1,3,3,5,5,5,8,9}},
  {{1,90},{0,1,1,1,1,1,6,7,8,9}},
  {{2,90},{0,1,2,3,4,5,5,5,8,9}},
  {{0,91},{0,1,1,3,3,5,5,5,8,9}},
  {{1,91},{0,1,1,1,1,1,6,7,8,9}},
  {{2,91},{0,1,2,3,4,5,5,5,8,9}},
  {{0,92},{0,1,1,3,3,5,5,5,8,9}},
  {{1,92},{0,1,1,1,1,1,6,7,8,9}},
  {{2,92},{0,1,2,3,4,5,5,5,8,9}},
  {{0,93},{0,1,1,3,3,5,5,5,8,9}},
  {{1,93},{0,1,1,1,1,1,6,7,8,9}},
  {{2,93},{0,1,2,3,4,5,5,5,8,9}},
  {{0,94},{0,1,1,3,3,5,5,5,8,9}},
  {{1,94},{0,1,1,1,1,1,6,7,8,9}},
  {{2,94},{0,1,2,3,4,5,5,5,8,9}},
  {{0,95},{0,1,1,3,3,5,5,5,8,9}},
  {{1,95},{0,1,1,1,1,1,6,7,8,9}},
  {{2,95},{0,1,2,3,4,5,5,5,8,9}},
  {{0,96},{0,1,1,3,3,5,5,5,8,9}},
  {{1,96},{0,1,1,1,1,1,6,7,8,9}},
  {{2,96},{0,1,2,3,4,5,5,5,8,9}},
  {{0,97},{0,1,1,3,3,5,5,5,8,9}},
  {{1,97},{0,1,1,1,1,1,6,7,8,9}},
  {{2,97},{0,1,2,3,4,5,5,5,8,9}},
  {{0,98},{0,1,1,3,3,5,5,5,8,9}},
  {{1,98},{0,1,1,1,1,1,6,7,8,9}},
  {{2,98},{0,1,2,3,4,5,5,5,8,9}},
  {{0,99},{0,1,1,3,3,5,5,5,8,9}},
  {{1,99},{0,1,1,1,1,1,6,7,8,9}},
  {{2,99},{0,1,2,3,4,5,5,5,8,9}},
  {{0,100},{0,1,1,3,3,5,5,5,8,9}},
  {{1,100},{0,1,1,1,1,1,6,7,8,9}},
  {{2,100},{0,1,2,3,4,5,5,5,8,9}},
  {{0,101},{0,1,1,3,3,5,5,5,8,9}},
  {{1,101},{0,1,1,1,1,1,6,7,8,9}},
  {{2,101},{0,1,2,3,4,5,5,5,8,9}},
  {{0,102},{0,1,1,3,3,5,5,5,8,9}},
  {{1,102},{0,1,1,1,1,1,6,7,8,9}},
  {{2,102},{0,1,2,3,4,5,5,5,8,9}},
  {{0,103},{0,1,1,3,3,5,5,5,8,9}},
  {{1,103},{0,1,1,1,1,1,6,7,8,9}},
  {{2,103},{0,1,2,3,4,5,5,5,8,9}},
  {{0,104},{0,1,1,3,3,5,5,5,8,9}},
  {{1,104},{0,1,1,1,1,1,6,7,8,9}},
  {{2,104},{0,1,2,3,4,5,5,5,8,9}},
  {{0,105},{0,1,1,3,3,5,5,5,8,9}},
  {{1,105},{0,1,1,1,1,1,6,7,8,9}},
  {{2,105},{0,1,2,3,4,5,5,5,8,9}},
  {{0,106},{0,1,1,3,3,5,5,5,8,9}},
  {{1,106},{0,1,1,1,1,1,6,7,8,9}},
  {{2,106},{0,1,2,3,4,5,5,5,8,9}},
  {{0,107},{0,1,1,3,3,5,5,5,8,9}},
  {{1,107},{0,1,1,1,1,1,6,7,8,9}},
  {{2,107},{0,1,2,3,4,5,5,5,8,9}},
  {{0,108},{0,1,1,3,3,5,5,5,8,9}},
  {{1,108},{0,1,1,1,1,1,6,7,8,9}},
  {{2,108},{0,1,2,3,4,5,5,5,8,9}},
  {{0,109},{0,1,1,3,3,5,5,5,8,9}},
  {{1,109},{0,1,1,1,1,1,6,7,8,9}},
  {{2,109},{0,1,2,3,4,5,5,5,8,9}},
  {{0,110},{0,1,1,3,3,5,5,5,8,9}},
  {{1,110},{0,1,1,1,1,1,6,7,8,9}},
  {{2,110},{0,1,2,3,4,5,5,5,8,9}},
  {{0,111},{0,1,1,3,3,5,5,5,8,9}},
  {{1,111},{0,1,1,1,1,1,6,7,8,9}},
  {{2,111},{0,1,2,3,4,5,5,5,8,9}},
  {{0,112},{0,1,1,3,3,5,5,5,8,9}},
  {{1,112},{0,1,1,1,1,1,6,7,8,9}},
  {{2,112},{0,1,2,3,4,5,5,5,8,9}},
  {{0,113},{0,1,1,3,3,5,5,5,8,9}},
  {{1,113},{0,1,1,1,1,1,6,7,8,9}},
  {{2,113},{0,1,2,3,4,5,5,5,8,9}},
  {{0,114},{0,1,1,3,3,5,5,5,8,9}},
  {{1,114},{0,1,1,1,1,1,6,7,8,9}},
  {{2,114},{0,1,2,3,4,5,5,5,8,9}},
  {{0,115},{0,1,1,3,3,5,5,5,8,9}},
  {{1,115},{0,1,1,1,1,1,6,7,8,9}},
  {{2,115},{0,1,2,3,4,5,5,5,8,9}},
  {{0,116},{0,1,1,3,3,5,5,5,8,9}},
  {{1,116},{0,1,1,1,1,1,6,7,8,9}},
  {{2,116},{0,1,2,3,4,5,5,5,8,9}},
  {{0,117},{0,1,1,3,3,5,5,5,8,9}},
  {{1,117},{0,1,1,1,1,1,6,7,8,9}},
  {{2,117},{0,1,2,3,4,5,5,5,8,9}},
  {{0,118},{0,1,1,3,3,5,5,5,8,9}},
  {{1,118},{0,1,1,1,1,1,6,7,8,9}},
  {{2,118},{0,1,2,3,4,5,5,5,8,9}},
  {{0,119},{0,1,1,3,3,5,5,5,8,9}},
  {{1,119},{0,1,1,1,1,1,6,7,8,9}},
  {{2,119},{0,1,2,3,4,5,5,5,8,9}},
  {{0,120},{0,1,1,3,3,5,5,5,8,9}},
  {{1,120},{0,1,1,1,1,1,6,7,8,9}},
  {{2,120},{0,1,2,3,4,5,5,5,8,9}},
  {{0,121},{0,1,1,3,3,5,5,5,8,9}},
  {{1,121},{0,1,1,1,1,1,6,7,8,9}},
  {{2,121},{0,1,2,3,4,5,5,5,8,9}},
  {{0,122},{0,1,1,3,3,5,5,5,8,9}},
  {{1,122},{0,1,1,1,1,1,6,7,8,9}},
  {{2,122},{0,1,2,3,4,5,5,5,8,9}},
  {{0,123},{0,1,1,3,3,5,5,5,8,9}},
  {{1,123},{0,1,1,1,1,1,6,7,8,9}},
  {{2,123},{0,1,2,3,4,5,5,5,8,9}},
  {{0,124},{0,1,1,3,3,5,5,5,8,9}},
  {{1,124},{0,1,1,1,1,1,6,7,8,9}},
  {{2,124},{0,1,2,3,4,5,5,5,8,9}},
  {{0,125},{0,1,1,3,3,5,5,5,8,9}},
  {{1,125},{0,1,1,1,1,1,6,7,8,9}},
  {{2,125},{0,1,2,3,4,5,5,5,8,9}},
  {{0,126},{0,1,1,3,3,5,5,5,8,9}},
  {{1,126},{0,1,1,1,1,1,6,7,8,9}},
  {{2,126},{0,1,2,3,4,5,5,5,8,9}},
  {{0,127},{0,1,1,3,3,5,5,5,8,9}},
  {{1,127},{0,1,1,1,1,1,6,7,8,9}},
  {{2,127},{0,1,2,3,4,5,5,5,8,9}}};

}
// END OF NAMESPACE
