#pragma once

#include "../protobuf/midi.pb.h"

// START OF NAMESPACE
namespace mmm {

std::map<midi::TRACK_TYPE,bool> TRACK_TYPE_IS_DRUM = {
  {midi::OPZ_KICK_TRACK, true},
  {midi::OPZ_SNARE_TRACK, true},
  {midi::OPZ_HIHAT_TRACK, true},
  {midi::OPZ_SAMPLE_TRACK, false},
  {midi::OPZ_BASS_TRACK, false},
  {midi::OPZ_LEAD_TRACK, false},
  {midi::OPZ_ARP_TRACK, false},
  {midi::OPZ_CHORD_TRACK, false},
  {midi::AUX_DRUM_TRACK, true},
  {midi::AUX_INST_TRACK, false},
  {midi::STANDARD_TRACK, false},
  {midi::STANDARD_DRUM_TRACK, true}
};

bool is_drum_track(int tt) {
  return TRACK_TYPE_IS_DRUM[static_cast<midi::TRACK_TYPE>(tt)];
}

bool is_opz_track(int tt) {
  return tt <= static_cast<midi::TRACK_TYPE>(midi::OPZ_CHORD_TRACK);
}

// drums are on channel 10
// 0 is all other channels
// more to be filled in later ...
// for i in range(128):
//   print("NONE, //{}".format(i))
static const midi::TRACK_TYPE TE_DRUM_MAP[128] = {
  midi::AUX_DRUM_TRACK, //0
  midi::AUX_DRUM_TRACK, //1
  midi::AUX_DRUM_TRACK, //2
  midi::AUX_DRUM_TRACK, //3
  midi::AUX_DRUM_TRACK, //4
  midi::AUX_DRUM_TRACK, //5
  midi::AUX_DRUM_TRACK, //6
  midi::AUX_DRUM_TRACK, //7
  midi::AUX_DRUM_TRACK, //8
  midi::AUX_DRUM_TRACK, //9
  midi::AUX_DRUM_TRACK, //10
  midi::AUX_DRUM_TRACK, //11
  midi::AUX_DRUM_TRACK, //12
  midi::AUX_DRUM_TRACK, //13
  midi::AUX_DRUM_TRACK, //14
  midi::AUX_DRUM_TRACK, //15
  midi::AUX_DRUM_TRACK, //16
  midi::AUX_DRUM_TRACK, //17
  midi::AUX_DRUM_TRACK, //18
  midi::AUX_DRUM_TRACK, //19
  midi::AUX_DRUM_TRACK, //20
  midi::AUX_DRUM_TRACK, //21
  midi::AUX_DRUM_TRACK, //22
  midi::AUX_DRUM_TRACK, //23
  midi::AUX_DRUM_TRACK, //24
  midi::AUX_DRUM_TRACK, //25
  midi::AUX_DRUM_TRACK, //26
  midi::AUX_DRUM_TRACK, //27
  midi::AUX_DRUM_TRACK, //28
  midi::AUX_DRUM_TRACK, //29
  midi::AUX_DRUM_TRACK, //30
  midi::AUX_DRUM_TRACK, //31
  midi::AUX_DRUM_TRACK, //32
  midi::AUX_DRUM_TRACK, //33
  midi::AUX_DRUM_TRACK, //34
  midi::OPZ_KICK_TRACK, //35
  midi::OPZ_KICK_TRACK, //36
  midi::OPZ_SNARE_TRACK, //37
  midi::OPZ_SNARE_TRACK, //38
  midi::OPZ_SNARE_TRACK, //39
  midi::OPZ_SNARE_TRACK, //40
  midi::AUX_DRUM_TRACK, //41
  midi::OPZ_HIHAT_TRACK, //42
  midi::AUX_DRUM_TRACK, //43
  midi::OPZ_HIHAT_TRACK, //44
  midi::AUX_DRUM_TRACK, //45
  midi::AUX_DRUM_TRACK, //46
  midi::AUX_DRUM_TRACK, //47
  midi::AUX_DRUM_TRACK, //48
  midi::OPZ_HIHAT_TRACK, //49
  midi::AUX_DRUM_TRACK, //50
  midi::OPZ_HIHAT_TRACK, //51
  midi::AUX_DRUM_TRACK, //52
  midi::AUX_DRUM_TRACK, //53
  midi::AUX_DRUM_TRACK, //54
  midi::AUX_DRUM_TRACK, //55
  midi::AUX_DRUM_TRACK, //56
  midi::AUX_DRUM_TRACK, //57
  midi::AUX_DRUM_TRACK, //58
  midi::AUX_DRUM_TRACK, //59
  midi::AUX_DRUM_TRACK, //60
  midi::AUX_DRUM_TRACK, //61
  midi::AUX_DRUM_TRACK, //62
  midi::AUX_DRUM_TRACK, //63
  midi::AUX_DRUM_TRACK, //64
  midi::AUX_DRUM_TRACK, //65
  midi::AUX_DRUM_TRACK, //66
  midi::AUX_DRUM_TRACK, //67
  midi::AUX_DRUM_TRACK, //68
  midi::AUX_DRUM_TRACK, //69
  midi::AUX_DRUM_TRACK, //70
  midi::AUX_DRUM_TRACK, //71
  midi::AUX_DRUM_TRACK, //72
  midi::AUX_DRUM_TRACK, //73
  midi::AUX_DRUM_TRACK, //74
  midi::AUX_DRUM_TRACK, //75
  midi::AUX_DRUM_TRACK, //76
  midi::AUX_DRUM_TRACK, //77
  midi::AUX_DRUM_TRACK, //78
  midi::AUX_DRUM_TRACK, //79
  midi::AUX_DRUM_TRACK, //80
  midi::AUX_DRUM_TRACK, //81
  midi::AUX_DRUM_TRACK, //82
  midi::AUX_DRUM_TRACK, //83
  midi::AUX_DRUM_TRACK, //84
  midi::AUX_DRUM_TRACK, //85
  midi::AUX_DRUM_TRACK, //86
  midi::AUX_DRUM_TRACK, //87
  midi::AUX_DRUM_TRACK, //88
  midi::AUX_DRUM_TRACK, //89
  midi::AUX_DRUM_TRACK, //90
  midi::AUX_DRUM_TRACK, //91
  midi::AUX_DRUM_TRACK, //92
  midi::AUX_DRUM_TRACK, //93
  midi::AUX_DRUM_TRACK, //94
  midi::AUX_DRUM_TRACK, //95
  midi::AUX_DRUM_TRACK, //96
  midi::AUX_DRUM_TRACK, //97
  midi::AUX_DRUM_TRACK, //98
  midi::AUX_DRUM_TRACK, //99
  midi::AUX_DRUM_TRACK, //100
  midi::AUX_DRUM_TRACK, //101
  midi::AUX_DRUM_TRACK, //102
  midi::AUX_DRUM_TRACK, //103
  midi::AUX_DRUM_TRACK, //104
  midi::AUX_DRUM_TRACK, //105
  midi::AUX_DRUM_TRACK, //106
  midi::AUX_DRUM_TRACK, //107
  midi::AUX_DRUM_TRACK, //108
  midi::AUX_DRUM_TRACK, //109
  midi::AUX_DRUM_TRACK, //110
  midi::AUX_DRUM_TRACK, //111
  midi::AUX_DRUM_TRACK, //112
  midi::AUX_DRUM_TRACK, //113
  midi::AUX_DRUM_TRACK, //114
  midi::AUX_DRUM_TRACK, //115
  midi::AUX_DRUM_TRACK, //116
  midi::AUX_DRUM_TRACK, //117
  midi::AUX_DRUM_TRACK, //118
  midi::AUX_DRUM_TRACK, //119
  midi::AUX_DRUM_TRACK, //120
  midi::AUX_DRUM_TRACK, //121
  midi::AUX_DRUM_TRACK, //122
  midi::AUX_DRUM_TRACK, //123
  midi::AUX_DRUM_TRACK, //124
  midi::AUX_DRUM_TRACK, //125
  midi::AUX_DRUM_TRACK, //126
  midi::AUX_DRUM_TRACK, //127
};

static const midi::TRACK_TYPE TE_INST_MAP[128] = {
  midi::AUX_INST_TRACK, //0
  midi::AUX_INST_TRACK, //1
  midi::AUX_INST_TRACK, //2
  midi::AUX_INST_TRACK, //3
  midi::AUX_INST_TRACK, //4
  midi::AUX_INST_TRACK, //5
  midi::AUX_INST_TRACK, //6
  midi::AUX_INST_TRACK, //7
  midi::AUX_INST_TRACK, //8
  midi::AUX_INST_TRACK, //9
  midi::AUX_INST_TRACK, //10
  midi::AUX_INST_TRACK, //11
  midi::AUX_INST_TRACK, //12
  midi::AUX_INST_TRACK, //13
  midi::AUX_INST_TRACK, //14
  midi::AUX_INST_TRACK, //15
  midi::AUX_INST_TRACK, //16
  midi::AUX_INST_TRACK, //17
  midi::AUX_INST_TRACK, //18
  midi::AUX_INST_TRACK, //19
  midi::AUX_INST_TRACK, //20
  midi::AUX_INST_TRACK, //21
  midi::AUX_INST_TRACK, //22
  midi::AUX_INST_TRACK, //23
  midi::AUX_INST_TRACK, //24
  midi::AUX_INST_TRACK, //25
  midi::AUX_INST_TRACK, //26
  midi::AUX_INST_TRACK, //27
  midi::AUX_INST_TRACK, //28
  midi::AUX_INST_TRACK, //29
  midi::AUX_INST_TRACK, //30
  midi::AUX_INST_TRACK, //31
  midi::OPZ_BASS_TRACK, //32
  midi::OPZ_BASS_TRACK, //33
  midi::OPZ_BASS_TRACK, //34
  midi::OPZ_BASS_TRACK, //35
  midi::OPZ_BASS_TRACK, //36
  midi::OPZ_BASS_TRACK, //37
  midi::OPZ_BASS_TRACK, //38
  midi::OPZ_BASS_TRACK, //39
  midi::AUX_INST_TRACK, //40
  midi::AUX_INST_TRACK, //41
  midi::AUX_INST_TRACK, //42
  midi::AUX_INST_TRACK, //43
  midi::AUX_INST_TRACK, //44
  midi::AUX_INST_TRACK, //45
  midi::AUX_INST_TRACK, //46
  midi::AUX_INST_TRACK, //47
  midi::AUX_INST_TRACK, //48
  midi::AUX_INST_TRACK, //49
  midi::AUX_INST_TRACK, //50
  midi::AUX_INST_TRACK, //51
  midi::AUX_INST_TRACK, //52
  midi::AUX_INST_TRACK, //53
  midi::AUX_INST_TRACK, //54
  midi::AUX_INST_TRACK, //55
  midi::AUX_INST_TRACK, //56
  midi::AUX_INST_TRACK, //57
  midi::AUX_INST_TRACK, //58
  midi::AUX_INST_TRACK, //59
  midi::AUX_INST_TRACK, //60
  midi::AUX_INST_TRACK, //61
  midi::AUX_INST_TRACK, //62
  midi::AUX_INST_TRACK, //63
  midi::AUX_INST_TRACK, //64
  midi::AUX_INST_TRACK, //65
  midi::AUX_INST_TRACK, //66
  midi::AUX_INST_TRACK, //67
  midi::AUX_INST_TRACK, //68
  midi::AUX_INST_TRACK, //69
  midi::AUX_INST_TRACK, //70
  midi::AUX_INST_TRACK, //71
  midi::AUX_INST_TRACK, //72
  midi::AUX_INST_TRACK, //73
  midi::AUX_INST_TRACK, //74
  midi::AUX_INST_TRACK, //75
  midi::AUX_INST_TRACK, //76
  midi::AUX_INST_TRACK, //77
  midi::AUX_INST_TRACK, //78
  midi::AUX_INST_TRACK, //79
  midi::AUX_INST_TRACK, //80
  midi::AUX_INST_TRACK, //81
  midi::AUX_INST_TRACK, //82
  midi::AUX_INST_TRACK, //83
  midi::AUX_INST_TRACK, //84
  midi::AUX_INST_TRACK, //85
  midi::AUX_INST_TRACK, //86
  midi::AUX_INST_TRACK, //87
  midi::AUX_INST_TRACK, //88
  midi::AUX_INST_TRACK, //89
  midi::AUX_INST_TRACK, //90
  midi::AUX_INST_TRACK, //91
  midi::AUX_INST_TRACK, //92
  midi::AUX_INST_TRACK, //93
  midi::AUX_INST_TRACK, //94
  midi::AUX_INST_TRACK, //95
  midi::OPZ_SAMPLE_TRACK, //96
  midi::OPZ_SAMPLE_TRACK, //97
  midi::OPZ_SAMPLE_TRACK, //98
  midi::OPZ_SAMPLE_TRACK, //99
  midi::OPZ_SAMPLE_TRACK, //100
  midi::OPZ_SAMPLE_TRACK, //101
  midi::OPZ_SAMPLE_TRACK, //102
  midi::OPZ_SAMPLE_TRACK, //103
  midi::AUX_INST_TRACK, //104
  midi::AUX_INST_TRACK, //105
  midi::AUX_INST_TRACK, //106
  midi::AUX_INST_TRACK, //107
  midi::AUX_INST_TRACK, //108
  midi::AUX_INST_TRACK, //109
  midi::AUX_INST_TRACK, //110
  midi::AUX_INST_TRACK, //111
  midi::AUX_INST_TRACK, //112
  midi::AUX_INST_TRACK, //113
  midi::AUX_INST_TRACK, //114
  midi::AUX_INST_TRACK, //115
  midi::AUX_INST_TRACK, //116
  midi::AUX_INST_TRACK, //117
  midi::AUX_INST_TRACK, //118
  midi::AUX_INST_TRACK, //119
  midi::OPZ_SAMPLE_TRACK, //120
  midi::OPZ_SAMPLE_TRACK, //121
  midi::OPZ_SAMPLE_TRACK, //122
  midi::OPZ_SAMPLE_TRACK, //123
  midi::OPZ_SAMPLE_TRACK, //124
  midi::OPZ_SAMPLE_TRACK, //125
  midi::OPZ_SAMPLE_TRACK, //126
  midi::OPZ_SAMPLE_TRACK, //127
};

}
// END OF NAMESPACE