#pragma once

#include "encoder.h"
#include <string>

enum ENCODER_TYPE {
  TRACK_ENCODER,
  TRACK_BAR_MAJOR_ENCODER,
  TRACK_GENRE_ENCODER,
  TRACK_VELOCITY_ENCODER,
  TRACK_VELOCITY_LEVEL_ENCODER,
  TRACK_ONE_BAR_FILL_ENCODER,
  TRACK_MONO_POLY_ENCODER,
  TRACK_INST_HEADER_ENCODER,
  TRACK_ONE_TWO_THREE_BAR_FILL_ENCODER,
  TRACK_BAR_FILL_ENCODER,
  TRACK_MONO_POLY_DENSITY_ENCODER,
  SEGMENT_ENCODER,
  TRACK_BAR_FILL_SIXTEEN_ENCODER,
  TRACK_DENSITY_ENCODER,
  TRACK_DENSITY_VELOCITY_ENCODER,
  TRACK_BAR_FILL_DENSITY_ENCODER,
  TRACK_BAR_FILL_DENSITY_VELOCITY_ENCODER,
  NO_ENCODER
};

ENCODER* getEncoder(ENCODER_TYPE et) {
  switch (et) {
    case TRACK_ENCODER: return new TrackEncoder();
    case TRACK_BAR_MAJOR_ENCODER: return new TrackBarMajorEncoder();
    case TRACK_GENRE_ENCODER: return new TrackGenreEncoder();
    case TRACK_VELOCITY_ENCODER: return new TrackVelocityEncoder();
    case TRACK_VELOCITY_LEVEL_ENCODER: return new TrackVelocityLevelEncoder();
    case TRACK_ONE_BAR_FILL_ENCODER: return new TrackOneBarFillEncoder();
    case TRACK_MONO_POLY_ENCODER: return new TrackMonoPolyEncoder();
    case TRACK_INST_HEADER_ENCODER: return new TrackInstHeaderEncoder();
    case TRACK_ONE_TWO_THREE_BAR_FILL_ENCODER: return new TrackOneTwoThreeBarFillEncoder();
    case TRACK_BAR_FILL_ENCODER: return new TrackBarFillEncoder();
    case TRACK_MONO_POLY_DENSITY_ENCODER: return new TrackMonoPolyDensityEncoder();
    case SEGMENT_ENCODER: return new SegmentEncoder();
    case TRACK_BAR_FILL_SIXTEEN_ENCODER: return new TrackBarFillSixteenEncoder();
    case TRACK_DENSITY_ENCODER: return new TrackDensityEncoder();
    case TRACK_DENSITY_VELOCITY_ENCODER: return new TrackDensityVelocityEncoder();
    case TRACK_BAR_FILL_DENSITY_ENCODER: return new TrackBarFillDensityEncoder();
    case TRACK_BAR_FILL_DENSITY_VELOCITY_ENCODER: return new TrackBarFillDensityVelocityEncoder();
    case NO_ENCODER: return NULL;
  }
}

ENCODER_TYPE getEncoderType(string &s) {
  if (s == "TRACK_ENCODER") return TRACK_ENCODER;
  if (s == "TRACK_BAR_MAJOR_ENCODER") return TRACK_BAR_MAJOR_ENCODER;
  if (s == "TRACK_GENRE_ENCODER") return TRACK_GENRE_ENCODER;
  if (s == "TRACK_VELOCITY_ENCODER") return TRACK_VELOCITY_ENCODER;
  if (s == "TRACK_VELOCITY_LEVEL_ENCODER") return TRACK_VELOCITY_LEVEL_ENCODER;
  if (s == "TRACK_ONE_BAR_FILL_ENCODER") return TRACK_ONE_BAR_FILL_ENCODER;
  if (s == "TRACK_MONO_POLY_ENCODER") return TRACK_MONO_POLY_ENCODER;
  if (s == "TRACK_INST_HEADER_ENCODER") return TRACK_INST_HEADER_ENCODER;
  if (s == "TRACK_ONE_TWO_THREE_BAR_FILL_ENCODER") return TRACK_ONE_TWO_THREE_BAR_FILL_ENCODER;
  if (s == "TRACK_BAR_FILL_ENCODER") return TRACK_BAR_FILL_ENCODER;
  if (s == "TRACK_MONO_POLY_DENSITY_ENCODER") return TRACK_MONO_POLY_DENSITY_ENCODER;
  if (s == "SEGMENT_ENCODER") return SEGMENT_ENCODER;
  if (s == "TRACK_BAR_FILL_SIXTEEN_ENCODER") return TRACK_BAR_FILL_SIXTEEN_ENCODER;
  if (s == "TRACK_DENSITY_ENCODER") return TRACK_DENSITY_ENCODER;
  if (s == "TRACK_DENSITY_VELOCITY_ENCODER") return TRACK_DENSITY_VELOCITY_ENCODER;
  if (s == "TRACK_BAR_FILL_DENSITY_ENCODER") return TRACK_BAR_FILL_DENSITY_ENCODER;
  if (s == "TRACK_BAR_FILL_DENSITY_VELOCITY_ENCODER") return TRACK_BAR_FILL_DENSITY_VELOCITY_ENCODER;
  return NO_ENCODER;
}

int getEncoderSize(ENCODER_TYPE et) {
  ENCODER *encoder = getEncoder(et);
  if (!encoder) {
    return 0;
  }
  int size = encoder->rep->max_token();
  delete encoder;
  return size;
}