function bin263_foreman_c4_fwd()
%binDCT compatibility studies in H.263
%
%Sequence: foreman.qcif
%
%Encoder command:
% ./tmn -i ../foreman.qcif -o foreman_rec_c4.qcif -B foreman_c4.cmp -b 100 -k 0 -X c4
%
%Decoder command:
% ./tmndec -dc4 -o5 ../foreman_c4.cmp -s foreman_c4_c4.qcif
%
% Jie Liang, 10/16/2000

fm_c4_c4 = [ 29.184520  30.272805  30.544900  30.650530  30.636160  ...
30.642465  30.659647  30.689498  30.780058  30.742783  ...
30.882736  30.704005  30.749282  30.683001  30.684889  ...
30.710916  30.810139  30.816136  30.743671  30.665709  ...
30.560271  30.357641  30.290018  30.366303  30.319080  ...
30.328654  30.375195  30.450180  30.485025  30.505817  ...
30.536999  30.565674  30.488613  30.617960  30.563066  ...
30.519936  30.530830  30.545883  30.594211  30.786803  ...
30.734445  30.771287  30.786721  30.666634  30.679592  ...
30.662817  30.673786  30.811937  30.762876  30.819406  ...
30.790032  30.657325  30.622605  30.674236  30.794315  ...
30.691469  30.686306  30.727762  30.732929  30.805295  ...
30.765003  30.771189  30.713564  30.486543  30.452697  ...
30.354349  30.483847  30.324927  30.355945  30.457945  ...
30.506530  30.514103  30.554992  30.556768  30.639884  ...
30.578511  30.604233  30.720561  30.700548  30.647400  ...
30.579746  30.632598  30.584239  30.695046  30.589171  ...
30.709593  30.809685  30.783529  30.942411  30.903615  ...
30.945240  30.959699  30.968616  30.948636  30.990985  ...
31.025544  31.208172  31.131104  31.143346  31.039161  ...
]; 

fm_c4_flt = [ 29.201739  30.266048  30.534873  30.635480  30.610201  ...
30.611147  30.630297  30.658549  30.746290  30.713983  ...
30.848980  30.664355  30.708163  30.658432  30.667897  ...
30.684602  30.789906  30.785249  30.712769  30.635663  ...
30.529916  30.341595  30.263356  30.333956  30.282028  ...
30.302636  30.340857  30.412368  30.443570  30.468006  ...
30.503842  30.537757  30.459386  30.586042  30.526158  ...
30.491563  30.504961  30.520518  30.549716  30.748302  ...
30.691027  30.738604  30.756309  30.644278  30.653865  ...
30.637161  30.644681  30.786102  30.728813  30.793802  ...
30.777334  30.640333  30.602665  30.650769  30.761459  ...
30.664818  30.666013  30.709587  30.720038  30.783958  ...
30.734979  30.745373  30.690165  30.452343  30.436559  ...
30.338458  30.458015  30.284202  30.306554  30.401107  ...
30.454730  30.465022  30.537417  30.524968  30.630727  ...
30.561774  30.574939  30.686355  30.676412  30.604748  ...
30.556076  30.617534  30.565083  30.677352  30.555471  ...
30.700090  30.792862  30.769440  30.900258  30.854629  ...
30.893004  30.885979  30.887628  30.867884  30.918651  ...
30.970632  31.137674  31.058433  31.087505  30.992154  ...
]; 

fm_c4_l3 = [ 29.159016  30.256345  30.531453  30.640287  30.617352  ...
30.624746  30.649064  30.670808  30.761214  30.727949  ...
30.871239  30.690252  30.731223  30.667129  30.675553  ...
30.700102  30.806216  30.807567  30.735625  30.659288  ...
30.544792  30.355902  30.276429  30.341470  30.293285  ...
30.321727  30.359342  30.431637  30.461044  30.485774  ...
30.515848  30.551977  30.462023  30.591387  30.534244  ...
30.498950  30.513780  30.541794  30.577085  30.770069  ...
30.714856  30.750194  30.782342  30.644972  30.663827  ...
30.648850  30.664367  30.798633  30.752105  30.805984  ...
30.789296  30.638205  30.611460  30.668708  30.781752  ...
30.690156  30.686417  30.732982  30.735619  30.805584  ...
30.764315  30.769981  30.701369  30.461906  30.427279  ...
30.345517  30.488492  30.313088  30.346624  30.442665  ...
30.493718  30.487489  30.554677  30.549509  30.627979  ...
30.576681  30.586889  30.696490  30.672014  30.622665  ...
30.553989  30.600567  30.549692  30.678097  30.559882  ...
30.684112  30.780985  30.772417  30.905543  30.846753  ...
30.895135  30.892739  30.899600  30.876015  30.937424  ...
30.971990  31.140816  31.075383  31.092928  31.002409  ...
]; 

fm_c4_c1 = [ 28.566214  29.742519  29.972586  30.123188  30.143909  ...
30.179759  30.160520  30.193797  30.297146  30.265983  ...
30.453361  30.290937  30.324029  30.290957  30.298264  ...
30.285736  30.386769  30.360991  30.319528  30.217832  ...
30.140838  29.994579  29.901394  29.914800  29.895913  ...
29.976752  29.985198  30.074225  30.094922  30.151617  ...
30.184865  30.191720  30.126681  30.291295  30.213760  ...
30.192891  30.205729  30.205989  30.192310  30.396956  ...
30.352248  30.373546  30.448558  30.301319  30.330081  ...
30.340036  30.346085  30.445876  30.414063  30.471827  ...
30.486295  30.304394  30.292673  30.370520  30.435801  ...
30.356466  30.331560  30.400740  30.442753  30.496884  ...
30.427820  30.414617  30.330545  30.042963  30.058994  ...
29.973288  30.109710  29.971306  29.939944  29.984935  ...
29.999174  30.014935  30.128630  30.126309  30.228646  ...
30.166915  30.140492  30.207428  30.172173  30.129316  ...
30.073043  30.112481  30.057725  30.141962  30.005589  ...
30.132766  30.259986  30.232720  30.325262  30.255529  ...
30.298617  30.287030  30.308562  30.276028  30.413924  ...
30.460897  30.571766  30.478898  30.524016  30.426945  ...
]; 

%%%%%%%%%%%%%

close all;
figure;
plot(fm_c4_c4,'k');
hold on;
plot(fm_c4_flt, 'r');
hold on;
plot(fm_c4_l3, 'b');
hold on;
plot(fm_c4_c1, 'm');
legend('C4~C4', 'C4~FLT', 'C4~L3', 'C4~C1');
ylabel('PSNR (dB)');
xlabel('Frame');
title('Compatibility');

figure;
plot(fm_c4_c4 - fm_c4_flt, 'r');
hold on;
plot(fm_c4_c4 - fm_c4_l3, 'b');
hold on;
plot(fm_c4_c4 - fm_c4_c1, 'm');
ylabel('PSNR (dB)');
xlabel('Frame');
title('PSNR Difference');
legend('C4~C4 - C4~FLT', 'C4~C4 - C4~L3', 'C4~C4 - C4~C1');

