function bin263_foreman_flt_fwd()
%binDCT compatibility studies in H.263
%
%Sequence: foreman.qcif
%
%Encoder command:
% ./tmn -i ../foreman.qcif -o foreman_rec.qcif -B foreman_flt.cmp -b 99 -k 0
%
%Decoder command:
% ./tmndec -dc4 -o5 ../foreman_flt.cmp -s foreman_flt_c4.qcif
% seqpsnr 0 ../../foreman.qcif foreman_flt_c4.qcif mfile/y.m u.m v.m
%
% Jie Liang, 10/16/2000

fm_flt_flt = [ 29.229463  30.367657  30.622751  30.719441  30.725884  ...
30.794678  30.707078  30.698174  30.838927  30.805295  ...
30.896550  30.788468  30.751976  30.776014  30.716500  ...
30.738785  30.832072  30.827054  30.823625  30.725604  ...
30.656988  30.521487  30.435347  30.587701  30.534542  ...
30.492445  30.492165  30.608391  30.586582  30.532927  ...
30.570252  30.587251  30.602144  30.600773  30.667239  ...
30.676126  30.598068  30.630319  30.730231  30.794622  ...
30.834671  30.799124  30.793878  30.734770  30.686090  ...
30.671685  30.747560  30.839048  30.830952  30.816454  ...
30.842640  30.798139  30.711263  30.688989  30.884328  ...
30.798611  30.810488  30.824571  30.821902  30.846827  ...
30.772996  30.735185  30.644372  30.521704  30.468218  ...
30.522976  30.540116  30.513447  30.493925  30.579945  ...
30.609218  30.559252  30.585991  30.736606  30.779279  ...
30.722758  30.679545  30.705651  30.784747  30.755493  ...
30.640617  30.726831  30.652015  30.705239  30.690107  ...
30.700641  30.754086  30.806434  30.911029  30.975469  ...
30.949855  30.977557  31.011687  31.056093  31.120207  ...
31.267013  31.212274  31.203646  31.152837  31.183097  ...
]; 

fm_flt_c4 = [ 29.187570  30.335120  30.591809  30.695510  30.702825  ...
30.771177  30.683967  30.668349  30.802188  30.768854  ...
30.851749  30.745029  30.700784  30.728697  30.663001  ...
30.703008  30.782121  30.778308  30.788275  30.692542  ...
30.619470  30.463415  30.377181  30.526152  30.471039  ...
30.423995  30.416125  30.543117  30.528737  30.484633  ...
30.515313  30.541334  30.551612  30.550882  30.609873  ...
30.635569  30.555447  30.591021  30.685306  30.739520  ...
30.787861  30.752424  30.738154  30.689023  30.635535  ...
30.626521  30.702153  30.793236  30.797344  30.780153  ...
30.794628  30.745151  30.661896  30.636420  30.823937  ...
30.735903  30.739882  30.770440  30.758706  30.784776  ...
30.714720  30.665881  30.591000  30.500159  30.425514  ...
30.473372  30.506036  30.477009  30.463313  30.552675  ...
30.561468  30.515554  30.519428  30.648828  30.692022  ...
30.641919  30.594981  30.629307  30.692532  30.653534  ...
30.526476  30.614309  30.529702  30.584206  30.557855  ...
30.580692  30.624110  30.672411  30.786219  30.872531  ...
30.841379  30.877266  30.938235  30.973948  31.030075  ...
31.155872  31.102864  31.079263  31.025921  31.077605  ...
]; 

fm_flt_l3 = [ 29.179741  30.345012  30.606766  30.709386  30.722531  ...
30.789587  30.708728  30.687815  30.829816  30.793397  ...
30.888960  30.774187  30.732539  30.757435  30.695995  ...
30.726956  30.813548  30.808920  30.810866  30.708281  ...
30.641201  30.501085  30.404883  30.548744  30.500653  ...
30.453545  30.444475  30.566905  30.551858  30.503167  ...
30.549422  30.567899  30.574479  30.574798  30.642117  ...
30.655624  30.574680  30.611642  30.708430  30.772253  ...
30.809116  30.778611  30.770141  30.713390  30.659420  ...
30.640416  30.723047  30.814311  30.809069  30.790434  ...
30.801240  30.760238  30.686096  30.657399  30.866584  ...
30.772442  30.785802  30.807980  30.788825  30.822711  ...
30.739567  30.697443  30.604412  30.501898  30.434820  ...
30.481414  30.513151  30.488716  30.469274  30.553147  ...
30.560736  30.510411  30.516759  30.651458  30.716547  ...
30.665642  30.614273  30.652937  30.713437  30.685293  ...
30.559249  30.639210  30.556843  30.601950  30.598507  ...
30.606202  30.663621  30.714300  30.823988  30.886422  ...
30.868476  30.891370  30.946564  30.994817  31.062860  ...
31.189008  31.126245  31.111205  31.053597  31.096875  ...
]; 

fm_flt_c1 = [ 28.644201  29.885023  30.108497  30.274938  30.312092  ...
30.385144  30.284497  30.270825  30.385501  30.415632  ...
30.542316  30.390703  30.403119  30.464368  30.393120  ...
30.393013  30.445026  30.422920  30.471897  30.341838  ...
30.230668  30.135247  30.032381  30.139958  30.117644  ...
30.112330  30.080087  30.226069  30.261181  30.143825  ...
30.242796  30.210487  30.213176  30.203262  30.288306  ...
30.283288  30.229526  30.274806  30.375046  30.483169  ...
30.494311  30.505224  30.519449  30.471706  30.375336  ...
30.364881  30.433250  30.519339  30.513934  30.487802  ...
30.487369  30.434910  30.373779  30.341746  30.593280  ...
30.489005  30.527883  30.546041  30.536927  30.572882  ...
30.429007  30.414115  30.297745  30.124267  30.125276  ...
30.140750  30.173092  30.147561  30.056916  30.086547  ...
30.076851  30.025812  30.063227  30.211134  30.345140  ...
30.264924  30.222167  30.238518  30.291284  30.272774  ...
30.197400  30.202312  30.157696  30.199348  30.148395  ...
30.158877  30.250313  30.305095  30.432606  30.437841  ...
30.426497  30.420802  30.518632  30.584498  30.628220  ...
30.735619  30.647742  30.620829  30.569404  30.571691  ...
]; 

%%%%%%%%%%%%%

close all;
figure;
plot(fm_flt_flt,'k');
hold on;
plot(fm_flt_c4, 'r');
hold on;
plot(fm_flt_l3, 'b');
hold on;
plot(fm_flt_c1, 'm');
legend('FLT~FLT', 'FLT~C4', 'FLT~L3', 'FLT~C1');
ylabel('PSNR (dB)');
xlabel('Frame');
title('Compatibility');

figure;
plot(fm_flt_flt - fm_flt_c4, 'r');
hold on;
plot(fm_flt_flt - fm_flt_l3, 'b');
hold on;
plot(fm_flt_flt - fm_flt_c1, 'm');
ylabel('PSNR (dB)');
xlabel('Frame');
title('PSNR Difference');
legend('FLT~FLT - FLT~C4', 'FLT~FLT - FLT~L3', 'FLT~FLT - FLT~C1');

