function bin263_c4_fwd()
%binDCT compatibility studies in H.263
%
%Sequence: glasgow.qcif
%
%Encoder command:
% ./tmn -i ../glasgow.qcif -o glasgow_rec_c4.qcif -B glasgow_c4.cmp -b 100 -k 0 -X c4
%
%Decoder command:
% ./tmndec -dc4 -o5 ../glasgow_c4.cmp -s glasgow_c4_c4.qcif
%
% Jie Liang, 10/16/2000


g_c4_c4 = [ 27.287304  28.398125  28.563259  28.682100  28.749407  ...
28.744387  28.768000  28.756714  28.693143  28.668273  ...
28.623850  28.550244  28.390838  28.385891  28.366755  ...
28.392651  28.331741  28.393082  28.364438  28.298650  ...
28.328716  28.383265  28.350387  28.309321  24.719731  ...
25.456961  25.580484  25.664650  25.742620  25.818386  ...
25.952565  25.983790  26.110078  26.243469  26.312288  ...
26.285043  26.302009  26.311395  26.463746  26.505800  ...
26.590188  26.460901  26.567458  26.635099  26.691763  ...
26.875064  27.129428  27.135579  27.187149  27.181970  ...
27.186552  27.134593  27.292398  27.320180  27.371882  ...
27.449597  27.359428  27.323455  27.373507  27.447144  ...
27.454084  27.540976  27.496993  27.426547  27.447795  ...
27.622042  27.529062  27.468499  27.497048  27.458838  ...
27.364846  27.436480  27.534047  25.247020  25.990576  ...
26.107847  26.243660  26.252153  26.196636  26.245278  ...
26.298682  26.299162  26.282659  26.330442  26.299325  ...
26.321310  26.222174  26.157214  26.055124  26.034348  ...
25.931584  25.930321  25.936521  25.927299  25.824721  ...
25.869976  25.888324  25.989621  25.973503  24.385125  ...
]; 


g_c4_flt = [ 27.297423  28.405488  28.570704  28.686844  28.755366  ...
28.748391  28.769116  28.759210  28.690015  28.668491  ...
28.621579  28.547029  28.382623  28.375987  28.361004  ...
28.373948  28.320502  28.377886  28.348122  28.281221  ...
28.308950  28.355720  28.319487  28.282238  24.704502  ...
25.435471  25.560405  25.647087  25.725063  25.803957  ...
25.934371  25.962175  26.087655  26.218551  26.285586  ...
26.258013  26.281471  26.292856  26.442824  26.486065  ...
26.563414  26.437718  26.552050  26.613610  26.677276  ...
26.860128  27.101516  27.103929  27.166034  27.163996  ...
27.167602  27.109590  27.254238  27.292213  27.340647  ...
27.420893  27.330201  27.301960  27.339345  27.404021  ...
27.419803  27.499163  27.451862  27.395567  27.401477  ...
27.580215  27.478071  27.426692  27.451113  27.428563  ...
27.316308  27.382367  27.482444  25.223983  25.964773  ...
26.079221  26.211072  26.215805  26.159258  26.205764  ...
26.263341  26.262010  26.242648  26.285039  26.259528  ...
26.281405  26.179369  26.106962  26.010703  25.996304  ...
25.888651  25.881769  25.890512  25.878366  25.778155  ...
25.823605  25.834746  25.936360  25.916623  24.374925  ...
]; 

g_c4_l3 = [ 27.274307  28.373268  28.540727  28.654559  28.723845  ...
28.717381  28.740641  28.728326  28.665199  28.644247  ...
28.594674  28.524601  28.358959  28.352559  28.336061  ...
28.353777  28.301549  28.357274  28.330725  28.270861  ...
28.299256  28.348042  28.314620  28.271461  24.728089  ...
25.460439  25.581693  25.671180  25.746233  25.822438  ...
25.952721  25.982855  26.106975  26.234577  26.298330  ...
26.269402  26.294848  26.307435  26.454579  26.501719  ...
26.583053  26.458395  26.562137  26.622559  26.687391  ...
26.861861  27.109948  27.104706  27.165979  27.168216  ...
27.162004  27.105846  27.257103  27.294927  27.341858  ...
27.418097  27.320421  27.303397  27.341574  27.412264  ...
27.428140  27.511850  27.470971  27.402546  27.415355  ...
27.594812  27.507578  27.454216  27.481431  27.451940  ...
27.355648  27.420087  27.514930  25.234175  25.976935  ...
26.094945  26.226818  26.232446  26.176409  26.224504  ...
26.280205  26.278980  26.259929  26.306634  26.276695  ...
26.295135  26.194436  26.128589  26.027478  26.006004  ...
25.898597  25.895620  25.904178  25.895394  25.791799  ...
25.839335  25.850331  25.949610  25.939046  24.380263  ...
]; 


g_c4_c1 = [ 26.715482  27.565167  27.698038  27.762788  27.806241  ...
27.817363  27.833017  27.800425  27.755933  27.731139  ...
27.664014  27.589872  27.454241  27.435436  27.434480  ...
27.434459  27.397386  27.428785  27.407068  27.371649  ...
27.403212  27.429133  27.402037  27.387246  24.640113  ...
25.310738  25.408237  25.481734  25.504327  25.583601  ...
25.712967  25.693942  25.781637  25.893797  25.937284  ...
25.910737  25.921758  25.946405  26.079277  26.064212  ...
26.151768  26.074180  26.203790  26.241812  26.314384  ...
26.482330  26.756421  26.790292  26.843880  26.819798  ...
26.823360  26.783252  26.944106  27.024006  27.040594  ...
27.100011  27.028544  27.018532  26.954674  27.001641  ...
27.064912  27.117363  27.154378  27.052308  27.023237  ...
27.170467  27.100133  27.084121  27.113572  27.122304  ...
27.011459  27.040962  27.115396  24.958540  25.592740  ...
25.671575  25.766462  25.756169  25.695917  25.717702  ...
25.765945  25.776962  25.736673  25.761852  25.749782  ...
25.743585  25.665081  25.591389  25.492650  25.459543  ...
25.366138  25.369948  25.375682  25.398076  25.366493  ...
25.395008  25.420456  25.489543  25.491154  24.090239  ...
]; 

%%%%%%%%%%%%%

%close all;
figure;
plot(g_c4_c4,'k');
hold on;
plot(g_c4_flt, 'r');
hold on;
plot(g_c4_l3, 'b');
hold on;
plot(g_c4_c1, 'm');
legend('C4~C4', 'C4~FLT', 'C4~L3', 'C4~C1');
ylabel('PSNR (dB)');
xlabel('Frame');
title('Compatibility');

figure;
plot(g_c4_c4 - g_c4_flt, 'r');
hold on;
plot(g_c4_c4 - g_c4_l3, 'b');
hold on;
plot(g_c4_c4 - g_c4_c1, 'm');
ylabel('PSNR (dB)');
xlabel('Frame');
title('PSNR Difference');
legend('C4~C4 - C4~FLT', 'C4~C4 - C4~L3', 'C4~C4 - C4~C1');

