function bin263_flt_c4_fwd()
%binDCT compatibility studies in H.263
%
%Sequence: glasgow.qcif
%
%Encoder command:
% ./tmn -i ../glasgow.qcif -o glasgow_rec.qcif -B glasgow_flt.cmp -b 99 -k 0
%
%Decoder command:
% ./tmndec -dc4 -o5 ../glasgow_flt.cmp -s glasgow_flt_c4.qcif
% seqpsnr 0 ../../glasgow.qcif glasgow_flt_c4.qcif mfile/y.m u.m v.m
%
% Jie Liang, 10/16/2000

g_flt_flt = [ 27.297388  28.513500  28.660308  28.771407  28.845156  ...
28.796105  28.840037  28.847777  28.834375  28.789367  ...
28.710159  28.616872  28.451507  28.437341  28.431677  ...
28.427730  28.386843  28.438836  28.432564  28.373199  ...
28.389507  28.431655  28.388441  28.334184  28.100452  ...
27.335836  27.148568  27.090898  27.109841  27.158450  ...
27.095539  27.094652  27.159612  27.207425  27.244522  ...
27.193885  27.250226  27.218264  27.302787  27.345995  ...
27.308308  27.368711  27.388810  27.427407  27.466088  ...
27.598168  27.703157  27.784186  27.705922  27.676418  ...
27.814697  27.769859  27.752993  27.782572  27.804712  ...
27.916571  27.935135  27.889165  27.887096  27.874775  ...
27.848456  27.863025  27.863236  27.868350  27.891201  ...
28.019124  27.844867  27.815897  27.838739  27.809840  ...
27.754040  27.766645  27.946205  27.635829  27.572504  ...
27.610439  27.659172  27.634216  27.578518  27.636095  ...
27.679328  27.771179  27.610318  27.698060  27.610331  ...
27.618208  27.510774  27.424311  27.318479  27.294088  ...
27.143475  27.128237  27.087401  27.000699  27.070651  ...
26.990917  27.120745  27.199169  27.111795  27.341405  ...
]; 

g_flt_c4 = [ 27.262783  28.459995  28.599468  28.706745  28.775629  ...
28.731105  28.773419  28.776806  28.771778  28.722762  ...
28.641130  28.550213  28.394160  28.380424  28.362538  ...
28.364172  28.318283  28.368954  28.366117  28.311968  ...
28.325363  28.372357  28.333389  28.280416  28.081097  ...
27.318371  27.121471  27.061208  27.092517  27.133371  ...
27.070896  27.073479  27.130391  27.183187  27.217443  ...
27.179626  27.227762  27.200008  27.272021  27.316724  ...
27.277548  27.324837  27.350158  27.372746  27.408549  ...
27.541924  27.645433  27.728370  27.659721  27.629186  ...
27.789589  27.732549  27.726380  27.750066  27.764085  ...
27.878532  27.890013  27.833687  27.829909  27.822963  ...
27.784564  27.798969  27.819348  27.820851  27.857317  ...
27.970923  27.798620  27.762572  27.800841  27.741292  ...
27.700035  27.705372  27.874736  27.615130  27.552431  ...
27.588248  27.642588  27.617503  27.564394  27.618808  ...
27.654420  27.749713  27.587868  27.675171  27.587071  ...
27.592061  27.485990  27.402314  27.298708  27.263603  ...
27.115189  27.082104  27.039013  26.954531  27.029425  ...
26.944235  27.083097  27.162319  27.065443  27.305027  ...
]; 

g_flt_l3 = [ 27.262921  28.457548  28.604048  28.709027  28.780602  ...
28.737516  28.783779  28.783363  28.775049  28.730509  ...
28.644463  28.551642  28.392611  28.381023  28.368816  ...
28.366430  28.327240  28.375068  28.373437  28.321405  ...
28.335959  28.380551  28.342046  28.287737  28.083630  ...
27.323915  27.140501  27.085205  27.097879  27.144153  ...
27.080521  27.081831  27.142147  27.189678  27.230124  ...
27.185333  27.230889  27.204582  27.280037  27.327319  ...
27.290058  27.340961  27.364027  27.395344  27.425088  ...
27.552899  27.655798  27.742698  27.657038  27.623184  ...
27.770607  27.725068  27.716922  27.732108  27.760507  ...
27.873641  27.885860  27.839822  27.833431  27.823207  ...
27.777925  27.807941  27.809738  27.825355  27.843259  ...
27.951794  27.783258  27.768396  27.794675  27.749880  ...
27.699487  27.705990  27.882835  27.614588  27.553530  ...
27.590247  27.642585  27.613467  27.563455  27.614801  ...
27.653106  27.747574  27.587404  27.674338  27.584322  ...
27.589437  27.484152  27.400328  27.293767  27.259379  ...
27.112195  27.082774  27.038263  26.958025  27.022608  ...
26.948331  27.081397  27.164784  27.070312  27.317460  ...
]; 

g_flt_c1 = [ 26.763728  27.712926  27.845900  27.913123  27.959081  ...
27.942542  27.979063  27.957329  27.950674  27.904412  ...
27.814246  27.709555  27.559608  27.556222  27.579693  ...
27.557521  27.539111  27.571288  27.558488  27.522855  ...
27.514830  27.546260  27.531670  27.494036  27.191292  ...
26.684775  26.634646  26.634030  26.611457  26.661061  ...
26.652383  26.633676  26.684667  26.712315  26.802618  ...
26.751714  26.757124  26.747507  26.876679  26.886407  ...
26.824583  26.917981  26.939511  27.007263  27.054144  ...
27.175852  27.319645  27.414226  27.308579  27.245391  ...
27.386983  27.322427  27.357974  27.395218  27.433690  ...
27.499354  27.544940  27.490325  27.442946  27.409928  ...
27.399012  27.433439  27.465996  27.431952  27.381442  ...
27.461490  27.352640  27.397287  27.394100  27.366135  ...
27.294609  27.279935  27.470581  26.786175  26.723396  ...
26.737484  26.761157  26.740587  26.701037  26.726618  ...
26.762247  26.848763  26.703445  26.759585  26.706671  ...
26.694869  26.619460  26.529050  26.419837  26.379684  ...
26.282165  26.280468  26.239286  26.207533  26.354033  ...
26.289661  26.439120  26.524490  26.442109  26.381997  ...
]; 

%%%%%%%%%%%%%

%close all;
figure;
plot(g_flt_flt,'k');
hold on;
plot(g_flt_c4, 'r');
hold on;
plot(g_flt_l3, 'b');
hold on;
plot(g_flt_c1, 'm');
legend('FLT~FLT', 'FLT~C4', 'FLT~L3', 'FLT~C1');
ylabel('PSNR (dB)');
xlabel('Frame');
title('Compatibility');

figure;
plot(g_flt_flt - g_flt_c4, 'r');
hold on;
plot(g_flt_flt - g_flt_l3, 'b');
hold on;
plot(g_flt_flt - g_flt_c1, 'm');
ylabel('PSNR (dB)');
xlabel('Frame');
title('PSNR Difference');
legend('FLT~FLT - FLT~C4', 'FLT~FLT - FLT~L3', 'FLT~FLT - FLT~C1');

