function bin263_c4_fwd()
%binDCT compatibility studies in H.263
%
%Sequence: suzie.qcif
%
%Encoder command:
% ./tmn -i ../suzie.qcif -o suzie_rec_c4.qcif -B suzie_c4.cmp -b 100 -k 0 -X c4
%
%Decoder command:
% ./tmndec -dc4 -o5 ../suzie_c4.cmp -s suzie_c4_c4.qcif
%
% Jie Liang, 10/16/2000

s_c4_c4 = [ 31.237241  32.090725  32.406853  32.572413  32.578459  ...
32.620047  32.660661  32.651762  32.578330  32.581662  ...
32.615670  32.684071  32.610327  32.699023  32.665240  ...
32.653873  32.769084  32.844792  32.839914  32.953247  ...
32.952462  32.855500  32.910404  32.927140  32.937499  ...
32.947181  32.949171  33.029886  33.006553  33.074011  ...
33.030882  33.025743  32.997468  33.091772  33.087054  ...
33.196810  33.165147  33.253835  33.070969  33.036822  ...
32.991392  32.970238  32.905143  32.989734  33.031920  ...
33.250441  33.306758  33.315869  33.530881  33.664245  ...
34.099911  34.514121  34.781813  34.670206  34.560914  ...
34.258335  34.160303  34.211575  34.153570  34.128175  ...
33.867494  33.814184  33.653322  33.412398  33.221844  ...
33.064709  33.018254  32.766054  32.726565  32.789304  ...
32.742299  32.761732  32.916089  32.808305  32.673353  ...
32.733072  32.750497  32.773948  32.861684  32.851820  ...
32.676929  32.545677  32.614121  32.557106  32.565404  ...
32.589094  32.479760  32.519449  32.454468  32.428083  ...
32.536405  32.704006  32.632553  32.500904  32.437833  ...
32.477885  32.527718  32.631659  32.562831  32.590558  ...
]; 
s_c4_flt = [ 31.260340  32.107934  32.398367  32.554006  32.558293  ...
32.605167  32.646902  32.640938  32.565751  32.571298  ...
32.594014  32.667304  32.596821  32.687744  32.651063  ...
32.644401  32.760537  32.837715  32.829042  32.942238  ...
32.937949  32.843372  32.893393  32.925584  32.925413  ...
32.925108  32.932500  33.016248  32.979790  33.055747  ...
33.005753  33.005289  32.966474  33.082213  33.077360  ...
33.188609  33.156362  33.241716  33.054485  33.023554  ...
32.986520  32.957853  32.880197  32.971345  33.018935  ...
33.230246  33.303616  33.306171  33.522754  33.662315  ...
34.113921  34.517267  34.778391  34.666948  34.571752  ...
34.276816  34.173007  34.222452  34.144041  34.133264  ...
33.857425  33.801531  33.650658  33.401432  33.227159  ...
33.067347  33.021635  32.765566  32.723347  32.792245  ...
32.740129  32.779033  32.932153  32.810167  32.678335  ...
32.755534  32.762010  32.772656  32.856223  32.870566  ...
32.672840  32.532626  32.626990  32.570702  32.571007  ...
32.584356  32.474404  32.529756  32.475196  32.430951  ...
32.554376  32.726239  32.659538  32.530884  32.466779  ...
32.501031  32.572832  32.662928  32.589122  32.630147  ...
]; 

s_c4_c1 = [ 30.956321  31.702559  32.116926  32.465291  32.451223  ...
32.500740  32.539085  32.531026  32.437080  32.426373  ...
32.558312  32.637846  32.521808  32.619146  32.571760  ...
32.537416  32.635361  32.773619  32.731248  32.861068  ...
32.877911  32.764629  32.856874  32.882791  32.880366  ...
32.873323  32.896314  32.990521  32.962511  33.034203  ...
33.004937  32.982496  32.919974  33.040467  33.040111  ...
33.155811  33.132124  33.218038  33.017087  33.003121  ...
32.936742  32.912748  32.782127  32.883241  32.925206  ...
33.122097  33.187307  33.189037  33.431840  33.567487  ...
33.941045  34.373497  34.651377  34.543512  34.469649  ...
34.187878  34.088844  34.074827  33.915606  33.988722  ...
33.704495  33.605142  33.448255  33.179562  32.990731  ...
32.851230  32.835295  32.530723  32.514203  32.620519  ...
32.525017  32.639651  32.784233  32.637677  32.461783  ...
32.534770  32.494314  32.582378  32.661298  32.703706  ...
32.541512  32.370017  32.456890  32.381320  32.371687  ...
32.381256  32.328992  32.344726  32.307079  32.224448  ...
32.388485  32.562156  32.525380  32.412940  32.320103  ...
32.369835  32.401325  32.523904  32.474427  32.501124  ...
];

s_c4_l3 = [ 31.237044  32.083886  32.396843  32.575668  32.582030  ...
32.622746  32.662276  32.658313  32.579657  32.577605  ...
32.612120  32.686917  32.605441  32.703142  32.664889  ...
32.658362  32.769349  32.844919  32.837021  32.953970  ...
32.959942  32.863243  32.912913  32.938349  32.941517  ...
32.943868  32.946869  33.036764  33.005216  33.072722  ...
33.027060  33.020467  32.980533  33.094555  33.085488  ...
33.198246  33.160703  33.252057  33.066519  33.043212  ...
33.000244  32.977283  32.898948  32.983575  33.027642  ...
33.243223  33.315587  33.306859  33.517982  33.663258  ...
34.102215  34.516313  34.786872  34.675145  34.571767  ...
34.273029  34.181813  34.222946  34.146594  34.127322  ...
33.852911  33.795862  33.635774  33.394281  33.220599  ...
33.058208  33.010404  32.746483  32.715327  32.783217  ...
32.722607  32.751778  32.914372  32.795640  32.667991  ...
32.738104  32.741570  32.775466  32.864563  32.870285  ...
32.683504  32.542302  32.620221  32.562912  32.565033  ...
32.574729  32.470376  32.513216  32.456718  32.405877  ...
32.531870  32.693081  32.643059  32.509223  32.431864  ...
32.477447  32.529166  32.640367  32.569778  32.612702  ...
];

%%%%%%%%%%%%%

close all;
figure;
plot(s_c4_c4,'k');
hold on;
plot(s_c4_flt, 'r');
hold on;
plot(s_c4_l3, 'b');
hold on;
plot(s_c4_c1, 'm');
legend('C4~C4', 'C4~FLT', 'C4~L3', 'C4~C1');
ylabel('PSNR (dB)');
xlabel('Frame');
title('Compatibility');

figure;
plot(s_c4_c4 - s_c4_flt, 'r');
hold on;
plot(s_c4_c4 - s_c4_l3, 'b');
hold on;
plot(s_c4_c4 - s_c4_c1, 'm');
ylabel('PSNR (dB)');
xlabel('Frame');
title('PSNR Difference');
legend('C4~C4 - C4~FLT', 'C4~C4 - C4~L3', 'C4~C4 - C4~C1');

