function bin263_flt_c4_fwd()
%binDCT compatibility studies in H.263
%
%Sequence: suzie.qcif
%
%Encoder command:
% ./tmn -i ../suzie.qcif -o suzie_rec.qcif -B suzie_flt.cmp -b 99 -k 0
%
%Decoder command:
% ./tmndec -dc4 -o5 ../suzie_flt.cmp -s suzie_flt_c4.qcif
% seqpsnr 0 ../../suzie.qcif suzie_flt_c4.qcif mfile/y.m u.m v.m
%
% Jie Liang, 10/16/2000

s_flt_flt = [ 31.290613  32.158118  32.491311  32.634529  32.630814  ...
32.644076  32.633732  32.692606  32.576851  32.629230  ...
32.680562  32.700839  32.654917  32.744633  32.637788  ...
32.730674  32.829320  32.947986  32.866877  32.869356  ...
32.918942  32.872307  32.890793  32.954678  32.908282  ...
32.958103  33.000186  33.009561  33.047510  33.022301  ...
33.074032  33.091042  33.155806  33.192262  33.228007  ...
33.208875  33.320639  33.354288  33.242016  33.154536  ...
32.989525  33.052728  32.915093  32.942996  33.098060  ...
33.230546  33.298364  33.400060  33.705448  33.814622  ...
34.338370  34.849665  34.999744  34.864413  34.605088  ...
34.464548  34.420388  34.178122  34.295531  34.240941  ...
34.003855  33.913924  33.946782  33.644859  33.404052  ...
33.121372  33.085590  32.985619  32.875489  33.023226  ...
32.992038  33.179853  33.199303  33.197602  32.854163  ...
32.768092  32.829851  32.820780  32.932660  33.057052  ...
32.896252  32.746136  32.799098  32.747460  32.603333  ...
32.728140  32.707908  32.652475  32.625630  32.554718  ...
32.630239  32.690324  32.667752  32.617909  32.542813  ...
32.603012  32.723041  32.747083  32.717165  32.827000  ...
]; 

s_flt_c4 = [ 31.259294  32.117042  32.465566  32.623966  32.621965  ...
32.630693  32.619214  32.676460  32.564981  32.625297  ...
32.670042  32.694404  32.637421  32.727103  32.621339  ...
32.712329  32.798179  32.938499  32.859337  32.856329  ...
32.912465  32.862637  32.881742  32.955979  32.897156  ...
32.956984  32.996113  33.012434  33.042017  33.020309  ...
33.074113  33.090167  33.157850  33.173878  33.212115  ...
33.190273  33.306752  33.332782  33.229542  33.138639  ...
32.988224  33.042585  32.912691  32.943707  33.090961  ...
33.206653  33.268739  33.366211  33.661678  33.771125  ...
34.278093  34.820149  34.965225  34.831574  34.580308  ...
34.446316  34.387420  34.157810  34.268457  34.200760  ...
33.964926  33.890444  33.903223  33.601493  33.365753  ...
33.083665  33.042606  32.959900  32.830898  32.986504  ...
32.966511  33.126312  33.146768  33.155849  32.814105  ...
32.715977  32.790692  32.791068  32.886498  33.012845  ...
32.859434  32.720264  32.770705  32.710415  32.551615  ...
32.662709  32.641069  32.582837  32.557666  32.482368  ...
32.541242  32.603650  32.585570  32.532838  32.442737  ...
32.494567  32.626353  32.641268  32.607285  32.711626  ...
]; 

s_flt_c1 = [ 30.973575  31.746002  32.238417  32.507204  32.504022  ...
32.541223  32.517722  32.568759  32.437611  32.457878  ...
32.576284  32.589429  32.550439  32.637227  32.544186  ...
32.621690  32.705774  32.868765  32.766238  32.806142  ...
32.843022  32.779377  32.804941  32.889670  32.839347  ...
32.900084  32.962042  32.962370  33.005958  32.969867  ...
33.049541  33.046022  33.103280  33.148084  33.213032  ...
33.178795  33.288036  33.302663  33.185935  33.100093  ...
32.920464  32.963345  32.791704  32.832618  32.986798  ...
33.108037  33.163836  33.263825  33.534031  33.669652  ...
34.149101  34.655055  34.876077  34.745132  34.486009  ...
34.386552  34.329969  34.052358  34.110654  34.074726  ...
33.792661  33.746596  33.806916  33.422465  33.191295  ...
32.918849  32.870928  32.788873  32.663828  32.842302  ...
32.762244  32.989299  32.991083  32.996922  32.704924  ...
32.588108  32.638853  32.675338  32.733878  32.887226  ...
32.761433  32.614409  32.699769  32.585269  32.420590  ...
32.492157  32.562722  32.449194  32.450153  32.335056  ...
32.428461  32.500421  32.479592  32.447462  32.389609  ...
32.444185  32.558630  32.582641  32.586038  32.694096  ...
]; 

s_flt_l3 = [ 31.262599  32.121077  32.472941  32.640609  32.637735  ...
32.650811  32.637338  32.694610  32.575883  32.624168  ...
32.677031  32.702174  32.647847  32.747108  32.636671  ...
32.728614  32.819256  32.948630  32.869290  32.870117  ...
32.925072  32.875933  32.888819  32.958577  32.902566  ...
32.953642  32.996270  33.003574  33.046266  33.011564  ...
33.068436  33.074187  33.150577  33.169611  33.219752  ...
33.185891  33.307350  33.336042  33.239187  33.151954  ...
32.989435  33.052792  32.916656  32.932790  33.081189  ...
33.206741  33.275053  33.370881  33.672542  33.794864  ...
34.313161  34.829779  34.980388  34.841630  34.582782  ...
34.447762  34.406278  34.172408  34.281305  34.210491  ...
33.969269  33.898338  33.919821  33.619564  33.370950  ...
33.090091  33.050297  32.971606  32.840163  32.996712  ...
32.969554  33.147818  33.163923  33.176484  32.838845  ...
32.747753  32.810388  32.805066  32.909837  33.033144  ...
32.887057  32.732375  32.779018  32.733636  32.578683  ...
32.695399  32.682722  32.624646  32.602321  32.527067  ...
32.598829  32.660496  32.626247  32.581824  32.500337  ...
32.551468  32.671197  32.699347  32.667928  32.773359  ...
]; 

%%%%%%%%%%%%%

close all;
figure;
plot(s_flt_flt,'k');
hold on;
plot(s_flt_c4, 'r');
hold on;
plot(s_flt_l3, 'b');
hold on;
plot(s_flt_c1, 'm');
legend('FLT~FLT', 'FLT~C4', 'FLT~L3', 'FLT~C1');
ylabel('PSNR (dB)');
xlabel('Frame');
title('Compatibility');

figure;
plot(s_flt_flt - s_flt_c4, 'r');
hold on;
plot(s_flt_flt - s_flt_l3, 'b');
hold on;
plot(s_flt_flt - s_flt_c1, 'm');
ylabel('PSNR (dB)');
xlabel('Frame');
title('PSNR Difference');
legend('FLT~FLT - FLT~C4', 'FLT~FLT - FLT~L3', 'FLT~FLT - FLT~C1');

