/**********************************************************************
 *
 *          Multiplierless Approximation of the DCT
 *
 *	    Trac D. Tran
 *	    The Johns Hopkins University, ECE Department
 *	    105 Barton Hall
 *	    3400 N. Charles Street
 *	    Baltimore MD 21218-2686
 *	    410-516-7416 Office; 410-516-5566 Fax
 *	    ttran@ece.jhu.edu
 *	    
 *	    Copyright (c) 1998 Trac D. Tran
 *
 *   This program is Copyright (c) by Trac D. Tran.
 *   It may not be redistributed without the consent of the copyright
 *   holders. In no circumstances may the copyright notice be removed.
 *   The program may not be sold for profit nor may they be incorporated
 *   in commercial programs without the written permission of the copyright
 *   holders. This program is provided as is, without any express or
 *   implied warranty, without even the warranty of fitness for a
 *   particular purpose.
 *
 **********************************************************************/

/**********************************************************************
 *
 *	Name:        Multiplierless Approximation of the FDCT
 *	Description:	Does dct on an 8x8 block + zigzag-scanning of
 *        coefficients
 *
 *	Input:        64 int pixels in a 2D array
 *	Returns:	64 int coefficients in a 1D array
 *	Side effects:	mapping integers to integers with 
 *                      perfect reconstruction for unifying
 *                      lossless + lossy coding. DC coefficient
 *                      has no bit expansion. 
 *
 *	Date: 981225	Author: Trac D. Tran
 *
 **********************************************************************/

/**********************************************************************
 *
 *  Name:        Multiplierless Approximation of the FDCT
 *  Description:    Does dct on an 8x8 block + zigzag-scanning of
 *        coefficients
 *
 *  Input:        64 int pixels in a 2D array
 *  Returns:    64 int coefficients in a 1D array
 *  Side effects:   mapping integers to integers with
 *                      perfect reconstruction for unifying
 *                      lossless + lossy coding. DC coefficient
 *                      has no bit expansion.
 *
 *  Date: 981225    Author: Trac D. Tran
 *
 **********************************************************************/
/*
 * Var. 1 of binDCT from Chen's factorization:
 * 9 shifts, 28 adds, Coding gain: 8.7686dB.
 */

/***************************************
 *
 * Modification required to port the function from JPEG code to H.263 code:
 *
 * Jie Liang, 10/04/2000
 *
 * 0. Include "sim.h", extern lossless_codec.
 * 1: function name and parameters;
 * 2: define outptr;
 * 3: before the column transform, let outptr = coeff;
 *    then change all dataptr to outptr;
 *    update outptr++;
 * 4: add "return 0";
 * 5: delete z1, z2, z3, z4, z5: no longer used.
 *
 ***************************************
 */

#include "sim.h"

extern int lossless_codec;

int fdct_bin_c1( int *data, int *coeff)
{
  INT32 tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7;
  INT32 tmp10, tmp11, tmp12, tmp13;
  DCTELEM *dataptr;
  int i, ctr;
  DCTELEM *outptr;   //H.263

  //fprintf(stderr, "jpeg_fdct_bin_a1 ...\n");

  /* Pass 1: process rows. */
  /* Note results are scaled up by sqrt(8) compared to a true DCT; */
  /* furthermore, we scale the results by 2**PASS1_BITS. */

  //fprintf(stderr, "\nOriginal image:\n");

//Case 1: lossless binDCT not required. Use original butterflies.

if (!lossless_codec){

  dataptr = data;

  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {
    tmp0 = dataptr[0] + dataptr[7];
    tmp7 = dataptr[0] - dataptr[7];
    tmp1 = dataptr[1] + dataptr[6];
    tmp6 = dataptr[1] - dataptr[6];
    tmp2 = dataptr[2] + dataptr[5];
    tmp5 = dataptr[2] - dataptr[5];
    tmp3 = dataptr[3] + dataptr[4];
    tmp4 = dataptr[3] - dataptr[4];
    
    /* Even part */
    tmp10 = (tmp0 + tmp3) ;	/* phase 2 */
    tmp13 = tmp0 - tmp3;
    tmp11 = (tmp1 + tmp2) ;
    tmp12 = tmp1 - tmp2;
    
    dataptr[0] = (tmp10 + tmp11);             /* phase 3 */
	dataptr[4] = ((dataptr[0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
	//dataptr[4] = tmp10 - tmp11;

	/*1/2, -1/2: alter the sign to get positive scaling factor */   
    dataptr[6] = (( tmp13 ) >> 1) - tmp12;
    dataptr[2] = tmp13 - ((dataptr[6] ) >> 1);
    
    /* Odd part */

/* pi/4 = -1/2u 3/4d -1/2u*/
	tmp10 = tmp5 - (( tmp6 ) >> 1);
	tmp6 = tmp6 + tmp10 - ((tmp10 ) >> 2);
	tmp5 = ((tmp6 ) >> 1) - tmp10;

    tmp10 = tmp4 + tmp5;
    tmp11 = tmp4 - tmp5;
    tmp12 = tmp7 - tmp6;
    tmp13 = tmp7 + tmp6;

    /* 7pi/16 = 1/4u -1/4d: alter the sign to get positive scaling factor */
    dataptr[7] = ((tmp13 ) >> 2) - tmp10;
	dataptr[1] = tmp13 - ((dataptr[7] ) >> 2);

    /* 3pi/16 = */
	/* new version: 1, -1/2 */
    dataptr[5] = tmp11 + tmp12;
    dataptr[3] = tmp12 - ((dataptr[5] ) >> 1);
    
    dataptr += DCTSIZE;		/* advance pointer to next row */
  }

  /* Pass 2: process columns.
   * We remove the PASS1_BITS scaling, but leave the results scaled up
   * by an overall factor of 8.
   */

  dataptr = data;

  //for H.263
  outptr = coeff;

  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {
    tmp0 = (dataptr[DCTSIZE*0] + dataptr[DCTSIZE*7]);
    tmp7 = (dataptr[DCTSIZE*0] - dataptr[DCTSIZE*7]);
    tmp1 = (dataptr[DCTSIZE*1] + dataptr[DCTSIZE*6]);
    tmp6 = (dataptr[DCTSIZE*1] - dataptr[DCTSIZE*6]);
    tmp2 = (dataptr[DCTSIZE*2] + dataptr[DCTSIZE*5]);
    tmp5 = (dataptr[DCTSIZE*2] - dataptr[DCTSIZE*5]);
    tmp3 = (dataptr[DCTSIZE*3] + dataptr[DCTSIZE*4]);
    tmp4 = (dataptr[DCTSIZE*3] - dataptr[DCTSIZE*4]);

    /* Even part */
    
    tmp10 = (tmp0 + tmp3);	/* phase 2 */
    tmp13 = tmp0 - tmp3;
    tmp11 = (tmp1 + tmp2);
    tmp12 = tmp1 - tmp2;
    
    //for H.263: change dataptr in the following to outptr.

    outptr[DCTSIZE*0] = (tmp10 + tmp11); /* phase 3 */
	outptr[DCTSIZE*4] = ((outptr[DCTSIZE*0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
    //outptr[DCTSIZE*4] = (tmp10 - tmp11); /* phase 3 */

	// 1/2, 1/2
    outptr[DCTSIZE*6] = ((tmp13 ) >> 1) - tmp12;
    outptr[DCTSIZE*2] = tmp13 - ((outptr[DCTSIZE*6] ) >> 1);
 
    /* Odd part */

/* pi/4 = -1/2u 3/4d -1/2u*/
	tmp10 = tmp5 - ((tmp6 ) >> 1);
	tmp6 = tmp6 + tmp10 - ((tmp10 ) >> 2);
	tmp5 = ((tmp6 ) >> 1) - tmp10;

    tmp10 = tmp4 + tmp5;
    tmp11 = tmp4 - tmp5;
    tmp12 = tmp7 - tmp6;
    tmp13 = tmp7 + tmp6;

    /* 7pi/16 = 1/4u -1/4d: alter sign to get positive scaling factor */
    outptr[DCTSIZE*7] = ((tmp13 ) >> 2) - tmp10;
	outptr[DCTSIZE*1] = tmp13 - ((outptr[DCTSIZE*7] ) >> 2);

    /* 3pi/16 = */
	/* new : 1 and -1/2 */
    outptr[DCTSIZE*5] = tmp11 + tmp12 ;
    outptr[DCTSIZE*3] = tmp12 - ((outptr[DCTSIZE*5] ) >> 1);

    dataptr++;			/* advance pointer to next column */
    
    //for H.263
    outptr++;
  }

/****************************************************************************/
   
} else {

/****************************************************************************/
  //Case 2: lossless binDCT: Use new butterflies.

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {


/*******************/
/* Jie: test code */
	//	for (tmp0 = 0; tmp0 < 8; tmp0 ++) {
	//	  fprintf(stderr, "%10d", dataptr[tmp0]+128);
	//	}
	//	fprintf(stderr, "\n");

    tmp7 = dataptr[0] - dataptr[7];
    tmp0 = dataptr[0] - ((tmp7 ) >> 1);

    tmp6 = dataptr[1] - dataptr[6];
    tmp1 = dataptr[1] - ((tmp6 ) >> 1);

    tmp5 = dataptr[2] - dataptr[5];
    tmp2 = dataptr[2] - ((tmp5 ) >> 1);

    tmp4 = dataptr[3] - dataptr[4];
    tmp3 = dataptr[3] - ((tmp4 ) >> 1);
    
    /* Even part */
	//old method: larger dynamic range.
	//    tmp10 = (tmp0 + tmp3) ;	/* phase 2 */
	//    tmp13 = ((tmp10 ) >> 1) - tmp3;
	tmp13 = tmp0 - tmp3;
 	tmp10 = tmp0 - ((tmp13 ) >> 1);	

	//    tmp11 = (tmp1 + tmp2) ;
	//    tmp12 = ((tmp11 ) >> 1) - tmp2;
	tmp12 = tmp1 - tmp2;
	tmp11 = tmp1 - ((tmp12 ) >> 1);   

    //    dataptr[0] = (tmp10 + tmp11);             /* phase 3 */
	//    dataptr[4] = ((dataptr[0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
	dataptr[4] = tmp10 - tmp11;
    dataptr[0] = tmp10 - ((dataptr[4] ) >> 1);

	/*1/2, -1/2: alter the sign to get positive scaling factor */   
	/* new version: 7/16 and -3/8 */
    dataptr[6] = ( (tmp13 ) >> 1) - tmp12;  
    dataptr[2] = tmp13 - ((dataptr[6] ) >> 1);
    
    /* Odd part */

/* pi/4 = -1/2u 3/4d -1/2u*/
	tmp10 = tmp5 - (( tmp6 ) >> 1);
	tmp6 = tmp6 + tmp10 - (( tmp10 ) >> 2);
	tmp5 = ((tmp6 ) >> 1) - tmp10;

	//butterflies:
    tmp10 = tmp4 + tmp5;
    tmp11 = ((tmp10 ) >> 1) - tmp5;

    tmp13 = tmp6 + tmp7;
    tmp12 = ((tmp13 ) >> 1) - tmp6;

    /* 7pi/16 = 1/4u -1/4d: alter the sign to get positive scaling factor */
    dataptr[7] = (( tmp13 ) >> 2) - tmp10;
	dataptr[1] = tmp13 - (( dataptr[7] ) >> 2);

    /* 3pi/16 = */
	/* new version: 1, -1/2 */
    dataptr[5] = tmp11 + tmp12 ;
    dataptr[3] = tmp12 - ((dataptr[5] ) >> 1);
    
    dataptr += DCTSIZE;		/* advance pointer to next row */
  }

  /* Pass 2: process columns.
   * We remove the PASS1_BITS scaling, but leave the results scaled up
   * by an overall factor of 8.
   */

  dataptr = data;

  //H.263
  outptr = coeff;

  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {

    tmp7 = dataptr[DCTSIZE*0] - dataptr[DCTSIZE*7];
    tmp0 = dataptr[DCTSIZE*0] - ((tmp7 ) >> 1);

    tmp6 = dataptr[DCTSIZE*1] - dataptr[DCTSIZE*6];
    tmp1 = dataptr[DCTSIZE*1] - ((tmp6 ) >> 1);

    tmp5 = dataptr[DCTSIZE*2] - dataptr[DCTSIZE*5];
    tmp2 = dataptr[DCTSIZE*2] - ((tmp5 ) >> 1);

    tmp4 = dataptr[DCTSIZE*3] - dataptr[DCTSIZE*4];
    tmp3 = dataptr[DCTSIZE*3] - ((tmp4 ) >> 1);

   /* Even part */
    
    //tmp10 = (tmp0 + tmp3); 
    //tmp13 = ((tmp10 ) >> 1) - tmp3;
	tmp13 = tmp0 - tmp3;
 	tmp10 = tmp0 - ((tmp13 ) >> 1);

    //tmp11 = (tmp1 + tmp2);
    //tmp12 = ((tmp11 ) >> 1) - tmp2;
	tmp12 = tmp1 - tmp2;
	tmp11 = tmp1 - ((tmp12 ) >> 1);

	//old method: larger dynamic range
    //dataptr[DCTSIZE*0] = (tmp10 + tmp11); /* phase 3 */
	//outptr[DCTSIZE*4] = ((outptr[DCTSIZE*0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
	outptr[DCTSIZE*4] = tmp10 - tmp11;
    outptr[DCTSIZE*0] = tmp10 - ((outptr[DCTSIZE*4] ) >> 1);

	// 1/2, 1/2
    outptr[DCTSIZE*6] = (( tmp13 ) >> 1) - tmp12;
    outptr[DCTSIZE*2] = tmp13 - (( outptr[DCTSIZE*6] ) >> 1);
 
    /* Odd part */

/* pi/4 = -1/2u 3/4d -1/2u*/
	tmp10 = tmp5 - (( tmp6 ) >> 1);
	tmp6 = tmp6 + tmp10 - (( tmp10 ) >> 2);
	tmp5 = ((tmp6 ) >> 1) - tmp10;

	//butterflies
    tmp10 = tmp4 + tmp5;
    tmp11 = ((tmp10 ) >> 1) - tmp5;

    tmp13 = tmp7 + tmp6;
    tmp12 = ((tmp13 ) >> 1) - tmp6;

    /* 7pi/16 = 1/4u -1/4d: alter sign to get positive scaling factor */
    outptr[DCTSIZE*7] = (( tmp13 ) >> 2) - tmp10;
	outptr[DCTSIZE*1] = tmp13 - (( outptr[DCTSIZE*7] ) >> 2);

    /* 3pi/16 = */
	/* new : 1 and -1/2 */
    outptr[DCTSIZE*5] = tmp11 + tmp12;
    outptr[DCTSIZE*3] = tmp12 - (( outptr[DCTSIZE*5] ) >> 1);

    dataptr++;			/* advance pointer to next column */

    //H.263
    outptr++;
  }

} // lossless ot not.

return (0);
 
}


