/* 
 **********************************************************************
 *
 * Course: 		520.643 Digital Multimedia Coding and Processing 
 * 
 * Homework Assignment: 1
 *
 * File Name:		imgpara.h
 * 
 * Designed by:		Jie Liang
 *
 * Created Date:	Sept. 26, 1999
 *
 * Contents:
 *			The following functions are provided:
 *			1: Calculate the entropies of two grayscale images,
 *			2: Calculate the MSE,
 *			3: Calculate the PSNR,
 *			4: Calculate the Mean Absolute Difference,
 *			5: Calculate the maximum Pixel Error.
 *
 * Limitations:
 *
 * Copyright (C) 1999 Department of Electrical and Computer Engineering 
 * The Johns Hopkins University. All right reserved. 
 *
 *********************************************************************
 */

/*
 *********************************************************************
 *
 *   Modification History:
 *
 *   Date	Programmer	Description
 *-------------------------------------------------------------------
 *
 * 09/26/99	Jie Liang	Created.
 * 
 * $Log: imgpara.h,v $
 * Revision 1.3  1999/09/30 02:15:53  jliang
 * *** empty log message ***
 *
 * Revision 1.2  1999/09/26 17:31:39  jliang
 * Modified getmse.
 *
 * Revision 1.1  1999/09/26 16:14:25  jliang
 * Initial revision
 *
 *
 ********************************************************************
 */
#ifndef	_IMGPARA_H
#define _IMGPARA_H

/*
 ********************************************************************
 *
 *	Include Files
 *
 ********************************************************************
 */
#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/*
 *******************************************************************
 *
 * 	Constants
 *
 *******************************************************************
 */

/*
 *******************************************************************
 *
 *	Macros
 *
 *******************************************************************
 */

/*
 *******************************************************************
 *
 *	Enumerated Types
 *
 *******************************************************************
 */

/*
 *******************************************************************
 *
 *	Data Types
 *
 *******************************************************************
 */

/*
 *******************************************************************
 *
 *	Variables
 *
 *******************************************************************
 */

/*
 *******************************************************************
 *
 *	Function Prototypes
 *
 *******************************************************************
 */

double getentropy(unsigned char *imgptr, 
		unsigned int hsize, unsigned int vsize);
double getmse(  unsigned char *imgptr1, unsigned char *imgptr2, 
		unsigned int hsize, unsigned int vsize);
double getpsnr( unsigned char *imgptr1, unsigned char *imgptr2,
		unsigned int hsize, unsigned int vsize, unsigned int maxval);
double getmad(	unsigned char *imgptr1, unsigned char *imgptr2, 
		unsigned int hsize, unsigned int vsize);
double getmpe(	unsigned char *imgptr1, unsigned char *imgptr2,
		unsigned int hsize, unsigned int vsize);
		
/*
 *******************************************************************
 * 
 * Function Name:	getentropy
 *
 * Descriptions:	Calculate the entropy of a grayscale image.
 *
 * Input Parameters:	
 *			imgptr:		Pointer to the image data,
 *			hsize:		Horizontal size of the image,
 *			vsize:		Vertical size fo the image.
 * Output Parameters:
 *			entropy:	Entropy of the image.
 * Limitations:
 *			1 byte per pixel.
 *			
 ********************************************************************
 */
double getentropy(unsigned char *imgptr, unsigned int hsize, unsigned int vsize) {
	
	double 			entropy = 0;
	const unsigned int 	ARRAYSIZE = 256; 
	double	 		histogram[ARRAYSIZE];
	unsigned int 		i;
	
	for (i = 0; i < ARRAYSIZE; i++){
		histogram[i] = 0;
	}
	
	/* get the frequency of each pixel value */

	for (i = 0; i < hsize * vsize; i++) {
		histogram[*(imgptr + i)] += 1;
	}
	
	/* calculate the entropy */

	for (i = 0; i < ARRAYSIZE; i++){
		if (histogram[i] != 0) {
			histogram[i] /= (hsize * vsize);	/* probability */
			entropy += - histogram[i] * log(histogram[i]) / log(2);	
		}
	}

	return (entropy);
}

/*
 ******************************************************************************
 *
 * Function Name:	getmse
 *
 * Descriptions:	Calculate the mean square error between two images.
 *
 * Input Parameters:	
 *			imgptr1: pointer to the first image,
 *			imgptr2: pointer to the second image,
 *			hsize:   Horizontal size,
 *			vsize:   Vertical size.
 * Output Parameters:
 *			mse:     Meean Square Error.
 *
 * Limitations:
 *
 ******************************************************************************
 */		

double getmse(unsigned char *imgptr1, unsigned char * imgptr2, unsigned int hsize, unsigned int vsize) {
	double  	err, mse = 0;
	unsigned int 	i, pixels;

	pixels = hsize * vsize;
	
	for (i =0; i < pixels; i++) {
		err = *(imgptr1 + i) - *(imgptr2 + i);
		mse = mse + err * err; 
	}
	mse /=  pixels;

	return(mse);
	
}

/*
 *******************************************************************************
 *
 * Function Name:	getpsnr
 *
 * Descriptions:
 *			Calculate the Peak SNR between two images.
 * Input Parameters:
 *			imgptr1:	pointer to the first image,
 *			imgptr2:	pointer to the second image,
 *			hsize:		Horizontal size,
 *			vsize:		Vertical size,
 *			maxval:		Maximum pixel value, such as 255.
 * Output Parameters:
 *			psnr:		Peak SNR.
 * Limitations:
 *
 ********************************************************************************
 */
double getpsnr( unsigned char *imgptr1, unsigned char *imgptr2, 
		unsigned int hsize, unsigned int vsize, unsigned int maxval) {
	double 		mse, psnr;

	mse = getmse(imgptr1, imgptr2, hsize, vsize);
	psnr = 10 * log10( maxval * maxval / mse);

	return (psnr);

}


/*
 *****************************************************************************
 *
 * Function Name:	getmad
 * 
 * Descriptions:
 *			Calculate the Maximum Absolute Difference between two images.
 *
 * Input Parameters:
 *			imgptr1:	pointer to the first image,
 *			imgptr2:	pointer to the second image,
 *			hsize:		Horizontal size,
 *			vsize:		Vertical size.
 * Output Parameters:
 *			mad:		maximum absolute difference.
 *
 * Limitations:
 *
 *******************************************************************************
 */
double getmad(unsigned char * imgptr1, unsigned char * imgptr2, unsigned int hsize, unsigned int vsize) {
	double mad = 0;
	unsigned int 	i, pixels;

	pixels = hsize * vsize;
	for (i = 0; i < pixels; i++){
		mad += abs(*(imgptr1 + i) - *(imgptr2 + i));
	}
	mad = mad / pixels;
	
	return (mad);
}

/*
 ******************************************************************************
 *
 * Function Name:	getmpe
 *
 * Descriptions:
 *			Calculate the Maximum Pixel Error between two images.
 *
 * Input Parameters:
 *			imgptr1:	pointer to the first image,
 *			imgptr2: 	pointer to the second image,
 *			hsize:		Horizontal size,
 *			vsize:		Vertical size.
 * Output Parameters:
 *			mpe:		maximum pixel error.
 * Limitations:
 *
 *******************************************************************************
 */
double getmpe(unsigned char *imgptr1, unsigned char *imgptr2, unsigned int hsize, unsigned int vsize) {
	double mpe = 0;
	double tmp;
	unsigned int	i, pixels;

	pixels =  hsize * vsize;

	for (i = 0; i < pixels; i++) {
		tmp = abs(*(imgptr1 + i) - *(imgptr2 + i));
		mpe = tmp > mpe ? tmp : mpe;
	}
	return (mpe);
} 

#endif

/*
 *************************************************************************
 *
 * End of $Source: /home/jliang/course/520.643/hw1/RCS/imgpara.h,v $
 *
 **************************************************************************
 */
