/*
 * jfdct_bin_c1.c
 *
 * Variation 6 of the binDCt from Chen's factorization:
 * Complexity: 23 shifts, 42 Adds.
 * 
 * Use floor operation.
 *
 */

/*
 ************************************************
 *
 * $Log: jfdct_bin_c1.c,v $
 * Revision 1.1  2000/07/23 15:37:16  jliang
 * Initial revision
 *
 *
 ************************************************
 */

/*
**********************************************************************
*
* Modification History:
* Date       Programmer   Description
* --------   ----------   --------------------------------------------

*
***********************************************************************
*/

#define JPEG_INTERNALS
#include "jinclude.h"
#include "jpeglib.h"
#include "jdct.h"		/* Private declarations for DCT subsystem */

#ifdef DCT_BIN_C1_SUPPORTED

/*
 * This module is specialized to the case DCTSIZE = 8.
 */

#if DCTSIZE != 8
  Sorry, this code only copes with 8x8 DCTs. /* deliberate syntax err */
#endif


/*
 * The poop on this scaling stuff is as follows:
 *
 * Each 1-D DCT step produces outputs which are a factor of sqrt(N)
 * larger than the true DCT outputs.  The final outputs are therefore
 * a factor of N larger than desired; since N=8 this can be cured by
 * a simple right shift at the end of the algorithm.  The advantage of
 * this arrangement is that we save two multiplications per 1-D DCT,
 * because the y0 and y4 outputs need not be divided by sqrt(N).
 * In the IJG code, this factor of 8 is removed by the quantization step
 * (in jcdctmgr.c), NOT in this module.
 *
 * We have to do addition and subtraction of the integer inputs, which
 * is no problem, and multiplication by fractional constants, which is
 * a problem to do in integer arithmetic.  We multiply all the constants
 * by CONST_SCALE and convert them to integer constants (thus retaining
 * CONST_BITS bits of precision in the constants).  After doing a
 * multiplication we have to divide the product by CONST_SCALE, with proper
 * rounding, to produce the correct output.  This division can be done
 * cheaply as a right shift of CONST_BITS bits.  We postpone shifting
 * as long as possible so that partial sums can be added together with
 * full fractional precision.
 *
 * The outputs of the first pass are scaled up by PASS1_BITS bits so that
 * they are represented to better-than-integral precision.  These outputs
 * require BITS_IN_JSAMPLE + PASS1_BITS + 3 bits; this fits in a 16-bit word
 * with the recommended scaling.  (For 12-bit sample data, the intermediate
 * array is INT32 anyway.)
 *
 * To avoid overflow of the 32-bit intermediate results in pass 2, we must
 * have BITS_IN_JSAMPLE + CONST_BITS + PASS1_BITS <= 26.  Error analysis
 * shows that the values given below are the most effective.
 */

#if BITS_IN_JSAMPLE == 8
#define CONST_BITS  13
#define PASS1_BITS  2
#else
#define CONST_BITS  13
#define PASS1_BITS  1		/* lose a little precision to avoid overflow */
#endif

/* Some C compilers fail to reduce "FIX(constant)" at compile time, thus
 * causing a lot of useless floating-point operations at run time.
 * To get around this we use the following pre-calculated constants.
 * If you change CONST_BITS you may want to add appropriate values.
 * (With a reasonable C compiler, you can just rely on the FIX() macro...)
 */

#if CONST_BITS == 13
#define FIX_0_298631336  ((INT32)  2446)	/* FIX(0.298631336) */
#define FIX_0_390180644  ((INT32)  3196)	/* FIX(0.390180644) */
#define FIX_0_541196100  ((INT32)  4433)	/* FIX(0.541196100) */
#define FIX_0_765366865  ((INT32)  6270)	/* FIX(0.765366865) */
#define FIX_0_899976223  ((INT32)  7373)	/* FIX(0.899976223) */
#define FIX_1_175875602  ((INT32)  9633)	/* FIX(1.175875602) */
#define FIX_1_501321110  ((INT32)  12299)	/* FIX(1.501321110) */
#define FIX_1_847759065  ((INT32)  15137)	/* FIX(1.847759065) */
#define FIX_1_961570560  ((INT32)  16069)	/* FIX(1.961570560) */
#define FIX_2_053119869  ((INT32)  16819)	/* FIX(2.053119869) */
#define FIX_2_562915447  ((INT32)  20995)	/* FIX(2.562915447) */
#define FIX_3_072711026  ((INT32)  25172)	/* FIX(3.072711026) */
#else
#define FIX_0_298631336  FIX(0.298631336)
#define FIX_0_390180644  FIX(0.390180644)
#define FIX_0_541196100  FIX(0.541196100)
#define FIX_0_765366865  FIX(0.765366865)
#define FIX_0_899976223  FIX(0.899976223)
#define FIX_1_175875602  FIX(1.175875602)
#define FIX_1_501321110  FIX(1.501321110)
#define FIX_1_847759065  FIX(1.847759065)
#define FIX_1_961570560  FIX(1.961570560)
#define FIX_2_053119869  FIX(2.053119869)
#define FIX_2_562915447  FIX(2.562915447)
#define FIX_3_072711026  FIX(3.072711026)
#endif


/* Multiply an INT32 variable by an INT32 constant to yield an INT32 result.
 * For 8-bit samples with the recommended scaling, all the variable
 * and constant values involved are no more than 16 bits wide, so a
 * 16x16->32 bit multiply can be used instead of a full 32x32 multiply.
 * For 12-bit samples, a full 32-bit multiplication will be needed.
 */

#if BITS_IN_JSAMPLE == 8
#define MULTIPLY(var,const)  MULTIPLY16C16(var,const)
#else
#define MULTIPLY(var,const)  ((var) * (const))
#endif


//Jie 07/09/00: lossless binDCT flag, defined in cjpeg.
extern boolean lossless_codec;


/*
 * Perform the forward binDCT-A on one block of samples.
 * Cost: 17 shifts.
 */

GLOBAL(void)
jpeg_fdct_bin_c1 (DCTELEM * data)
{
  INT32 tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7;
  INT32 tmp10, tmp11, tmp12, tmp13;
  INT32 z1, z2, z3, z4, z5;
  DCTELEM *dataptr;
  int ctr;
  SHIFT_TEMPS

	/*	fprintf(stderr, "jpeg_fdct_bin_a1 ...\n"); */

  /* Pass 1: process rows. */
  /* Note results are scaled up by sqrt(8) compared to a true DCT; */
  /* furthermore, we scale the results by 2**PASS1_BITS. */

	//fprintf(stderr, "\nOriginal image:\n");

//Case 1: lossless binDCT not required. Use original butterflies.
if (!lossless_codec){

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {


/*******************/
/* Jie: test code */
	//	for (tmp0 = 0; tmp0 < 8; tmp0 ++) {
	//	  fprintf(stderr, "%10d", dataptr[tmp0]+128);
	//	}
	//	fprintf(stderr, "\n");

    tmp0 = dataptr[0] + dataptr[7];
    tmp7 = dataptr[0] - dataptr[7];
    tmp1 = dataptr[1] + dataptr[6];
    tmp6 = dataptr[1] - dataptr[6];
    tmp2 = dataptr[2] + dataptr[5];
    tmp5 = dataptr[2] - dataptr[5];
    tmp3 = dataptr[3] + dataptr[4];
    tmp4 = dataptr[3] - dataptr[4];
    
    /* Even part */
    tmp10 = (tmp0 + tmp3) ;	/* phase 2 */
    tmp13 = tmp0 - tmp3;
    tmp11 = (tmp1 + tmp2) ;
    tmp12 = tmp1 - tmp2;
    
    dataptr[0] = (tmp10 + tmp11);             /* phase 3 */
	dataptr[4] = ((dataptr[0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
	//dataptr[4] = tmp10 - tmp11;

	//3pi/8: 13/32, 11/32
    dataptr[6] = ( ( (tmp13 << 3) + (tmp13 << 2) + tmp13 ) >> 5) - tmp12;
    dataptr[2] = tmp13 - (( (dataptr[6] << 3) + (dataptr[6] << 1) + dataptr[6] ) >> 5);
    
    /* Odd part */

/* pi/4 = 13/32, 11/16, 13/32*/
	tmp10 = tmp5 - (( (tmp6 << 3) + (tmp6 << 2) + tmp6 ) >> 5);
	tmp6 = tmp6 + tmp10 - (((tmp10 << 2) + tmp10) >> 4);
	tmp5 = (((tmp6 << 3) + (tmp6 << 2) + tmp6 ) >> 5) - tmp10;

    tmp10 = tmp4 + tmp5;
    tmp11 = tmp4 - tmp5;
    tmp12 = tmp7 - tmp6;
    tmp13 = tmp7 + tmp6;

    /* 7pi/16 = 3/16u -3/16d: alter the sign to get positive scaling factor */
    dataptr[7] = (((tmp13 << 1) + tmp13 ) >> 4) - tmp10;
	dataptr[1] = tmp13 - (((dataptr[7] << 1) + dataptr[7] ) >> 4);

    /* 3pi/16 = */
	/* new version: 11/16, 15/32 */
    dataptr[5] = tmp11 + (((tmp12 << 3) + (tmp12 << 1) + tmp12 ) >> 4);
    dataptr[3] = tmp12 - (((dataptr[5] << 4) - dataptr[5] ) >> 5);
   
    dataptr += DCTSIZE;		/* advance pointer to next row */
  }

  /* Pass 2: process columns.
   * We remove the PASS1_BITS scaling, but leave the results scaled up
   * by an overall factor of 8.
   */

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {
    tmp0 = (dataptr[DCTSIZE*0] + dataptr[DCTSIZE*7]);
    tmp7 = (dataptr[DCTSIZE*0] - dataptr[DCTSIZE*7]);
    tmp1 = (dataptr[DCTSIZE*1] + dataptr[DCTSIZE*6]);
    tmp6 = (dataptr[DCTSIZE*1] - dataptr[DCTSIZE*6]);
    tmp2 = (dataptr[DCTSIZE*2] + dataptr[DCTSIZE*5]);
    tmp5 = (dataptr[DCTSIZE*2] - dataptr[DCTSIZE*5]);
    tmp3 = (dataptr[DCTSIZE*3] + dataptr[DCTSIZE*4]);
    tmp4 = (dataptr[DCTSIZE*3] - dataptr[DCTSIZE*4]);

    /* Even part */
    
    tmp10 = (tmp0 + tmp3);	/* phase 2 */
    tmp13 = tmp0 - tmp3;
    tmp11 = (tmp1 + tmp2);
    tmp12 = tmp1 - tmp2;
    
    dataptr[DCTSIZE*0] = (tmp10 + tmp11); /* phase 3 */
	dataptr[DCTSIZE*4] = ((dataptr[DCTSIZE*0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
    //dataptr[DCTSIZE*4] = (tmp10 - tmp11); /* phase 3 */

	// 3pi/8: 13/32, 11/32
    dataptr[DCTSIZE*6] = (((tmp13 << 3) + (tmp13 << 2) + tmp13 ) >> 5) - tmp12;
    dataptr[DCTSIZE*2] = tmp13 - (( (dataptr[DCTSIZE*6] << 3) + (dataptr[DCTSIZE*6] << 1) + dataptr[DCTSIZE*6] ) >> 5);
 
    /* Odd part */

/* pi/4 = 13/32, 11/16, 13/32*/
	tmp10 = tmp5 - (((tmp6 << 3) + (tmp6 << 2) + tmp6 ) >> 5);
	tmp6 = tmp6 + tmp10 - (((tmp10 << 2) + tmp10 ) >> 4);
	tmp5 = (((tmp6 << 3) + (tmp6 << 2) + tmp6 ) >> 5) - tmp10;

    tmp10 = tmp4 + tmp5;
    tmp11 = tmp4 - tmp5;
    tmp12 = tmp7 - tmp6;
    tmp13 = tmp7 + tmp6;

    /* 7pi/16 = 3/16u -3/16d: alter sign to get positive scaling factor */
    dataptr[DCTSIZE*7] = (((tmp13 << 1) + tmp13 ) >> 4) - tmp10;
	dataptr[DCTSIZE*1] = tmp13 - (((dataptr[DCTSIZE*7] << 1) + dataptr[DCTSIZE*7] ) >> 4);

    /* 3pi/16 = */
	/* 11/16, 15/32 */
    dataptr[DCTSIZE*5] = tmp11 + (((tmp12 << 3) + (tmp12 << 1) + tmp12 ) >> 4);
    dataptr[DCTSIZE*3] = tmp12 - (((dataptr[DCTSIZE*5] << 4) - dataptr[DCTSIZE*5] ) >> 5);

     dataptr++;			/* advance pointer to next column */

  }

/****************************************************************************/
   
} else {

/****************************************************************************/
  //Case 2: lossless binDCT: Use new butterflies.

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {


/*******************/
/* Jie: test code */
	//	for (tmp0 = 0; tmp0 < 8; tmp0 ++) {
	//	  fprintf(stderr, "%10d", dataptr[tmp0]+128);
	//	}
	//	fprintf(stderr, "\n");

    tmp7 = dataptr[0] - dataptr[7];
    tmp0 = dataptr[0] - ((tmp7 ) >> 1);

    tmp6 = dataptr[1] - dataptr[6];
    tmp1 = dataptr[1] - ((tmp6 ) >> 1);

    tmp5 = dataptr[2] - dataptr[5];
    tmp2 = dataptr[2] - ((tmp5 ) >> 1);

    tmp4 = dataptr[3] - dataptr[4];
    tmp3 = dataptr[3] - ((tmp4 ) >> 1);
    
    /* Even part */
	//old method: larger dynamic range.
	//    tmp10 = (tmp0 + tmp3) ;	/* phase 2 */
	//    tmp13 = ((tmp10 ) >> 1) - tmp3;
	tmp13 = tmp0 - tmp3;
 	tmp10 = tmp0 - ((tmp13 ) >> 1);	

	//    tmp11 = (tmp1 + tmp2) ;
	//    tmp12 = ((tmp11 ) >> 1) - tmp2;
	tmp12 = tmp1 - tmp2;
	tmp11 = tmp1 - ((tmp12 ) >> 1);   

    //    dataptr[0] = (tmp10 + tmp11);             /* phase 3 */
	//    dataptr[4] = ((dataptr[0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
	dataptr[4] = tmp10 - tmp11;
    dataptr[0] = tmp10 - ((dataptr[4] ) >> 1);

	//3pi/8: 13/32, 11/32.
    dataptr[6] = ( ((tmp13 << 3) + (tmp13 << 2) + tmp13 ) >> 5) - tmp12;     
    dataptr[2] = tmp13 - (((dataptr[6] << 3) + (dataptr[6] << 1) + dataptr[6] ) >> 5);
    
    /* Odd part */

	/* pi/4 = 13/32, 11/16, 13/32 */
	tmp10 = tmp5 - (( (tmp6 << 3) + (tmp6 << 2) + tmp6 ) >> 5);
	tmp6 = tmp6 + tmp10 - (((tmp10 << 2) + tmp10 ) >> 4);
	tmp5 = (((tmp6 << 3) + (tmp6 << 2) + tmp6 ) >> 5) - tmp10;

	//butterflies:
    //tmp10 = tmp4 + tmp5;
    //tmp11 = ((tmp10 ) >> 1) - tmp5;
	tmp11 = tmp4 - tmp5;
	tmp10 = tmp4 - ((tmp11 ) >> 1);

    //tmp13 = tmp6 + tmp7;
    //tmp12 = ((tmp13 ) >> 1) - tmp6;
	tmp12 = tmp7 - tmp6;
	tmp13 = tmp7 - (( tmp12 ) >> 1);

    /* 7pi/16 = 3/16u -3/16d: alter the sign to get positive scaling factor */
    dataptr[7] = (((tmp13 << 1) + tmp13) >> 4) - tmp10;
	dataptr[1] = tmp13 - (((dataptr[7] << 1) + dataptr[7] ) >> 4);

    /* 3pi/16 = */
	/* new version: 11/16, 15/32 */
    dataptr[5] = tmp11 + (((tmp12 << 3) + (tmp12 << 1) + tmp12 ) >> 4);
    dataptr[3] = tmp12 - (((dataptr[5] << 4) - dataptr[5] ) >> 5);
    
    dataptr += DCTSIZE;		/* advance pointer to next row */
  }

  /* Pass 2: process columns.
   * We remove the PASS1_BITS scaling, but leave the results scaled up
   * by an overall factor of 8.
   */

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {

    tmp7 = dataptr[DCTSIZE*0] - dataptr[DCTSIZE*7];
    tmp0 = dataptr[DCTSIZE*0] - ((tmp7 ) >> 1);

    tmp6 = dataptr[DCTSIZE*1] - dataptr[DCTSIZE*6];
    tmp1 = dataptr[DCTSIZE*1] - ((tmp6 ) >> 1);

    tmp5 = dataptr[DCTSIZE*2] - dataptr[DCTSIZE*5];
    tmp2 = dataptr[DCTSIZE*2] - ((tmp5 ) >> 1);

    tmp4 = dataptr[DCTSIZE*3] - dataptr[DCTSIZE*4];
    tmp3 = dataptr[DCTSIZE*3] - ((tmp4 ) >> 1);

    /* Even part */
    
    //tmp10 = (tmp0 + tmp3); 
    //tmp13 = ((tmp10 ) >> 1) - tmp3;
	tmp13 = tmp0 - tmp3;
 	tmp10 = tmp0 - ((tmp13 ) >> 1);

    //tmp11 = (tmp1 + tmp2);
    //tmp12 = ((tmp11 ) >> 1) - tmp2;
	tmp12 = tmp1 - tmp2;
	tmp11 = tmp1 - ((tmp12 ) >> 1);

	//old method: larger dynamic range
    //dataptr[DCTSIZE*0] = (tmp10 + tmp11); /* phase 3 */
	//dataptr[DCTSIZE*4] = ((dataptr[DCTSIZE*0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
	dataptr[DCTSIZE*4] = tmp10 - tmp11;
    dataptr[DCTSIZE*0] = tmp10 - ((dataptr[DCTSIZE*4] ) >> 1);

	// 3pi/8: 13/32, 11/32
    dataptr[DCTSIZE*6] = (((tmp13 << 3) + (tmp13 << 2) + tmp13 ) >> 5) - tmp12;
    dataptr[DCTSIZE*2] = tmp13 - (((dataptr[DCTSIZE*6] << 3) + (dataptr[DCTSIZE*6] << 1) + dataptr[DCTSIZE*6] ) >> 5);
 
    /* Odd part */

	/* pi/4 = 13/32, 11/16, 13/32 */
	tmp10 = tmp5 - (((tmp6 << 3) + (tmp6 << 2) + tmp6 ) >> 5);
	tmp6 = tmp6 + tmp10 - (((tmp10 << 2) + tmp10 ) >> 4);
	tmp5 = (((tmp6 << 3) + (tmp6 << 2) + tmp6 ) >> 5) - tmp10;

	//butterflies
	//old
    //tmp10 = tmp4 + tmp5;
    //tmp11 = ((tmp10 ) >> 1) - tmp5;
	tmp11 = tmp4 - tmp5;
	tmp10 = tmp4 - ((tmp11 ) >> 1);

	//old
    //tmp13 = tmp7 + tmp6;
    //tmp12 = ((tmp13 ) >> 1) - tmp6;
	tmp12 = tmp7 - tmp6;
	tmp13 = tmp7 - (( tmp12 ) >> 1);

    /* 7pi/16 = 3/16u -3/16d: alter sign to get positive scaling factor */
    dataptr[DCTSIZE*7] = (((tmp13 << 1) + tmp13 ) >> 4) - tmp10;
	dataptr[DCTSIZE*1] = tmp13 - (((dataptr[DCTSIZE*7] << 1) + dataptr[DCTSIZE*7] ) >> 4);

    /* 3pi/16 = */
	/* new : 11/16 and 15/32 */
    dataptr[DCTSIZE*5] = tmp11 + (((tmp12 << 3) + (tmp12 << 1) + tmp12 ) >> 4);
    dataptr[DCTSIZE*3] = tmp12 - (((dataptr[DCTSIZE*5] << 4) - dataptr[DCTSIZE*5] ) >> 5);

    dataptr++;			/* advance pointer to next column */
  }

} // lossless ot not.
 
}

/**************************************
 * problem with Sachin's code:
 * 1: it's verison binDCT-C.
 * 2: X[0] and X[4]: butterfly, not lifting.
 * 3: Neg scaling required.
 **************************************
 */

#endif /* DCT_BIN_C1_SUPPORTED */
