/*
 * jfdct_bin_l1.c
 *
 * binDCT from Loeffler's fact: Var. 3: 16 shifts, 34 adds.
 * Use floor operation for all right-shifting.
 */

/*
 ************************************************
 *
 * $Log: jfdct_bin_l1.c,v $
 * Revision 1.1  2000/07/23 15:37:19  jliang
 * Initial revision
 *
 *
 ************************************************
 */

/*
**********************************************************************
*
* Modification History:
* Date       Programmer   Description
* --------   ----------   --------------------------------------------

*
***********************************************************************
*/

#define JPEG_INTERNALS
#include "jinclude.h"
#include "jpeglib.h"
#include "jdct.h"		/* Private declarations for DCT subsystem */

#ifdef DCT_BIN_L1_SUPPORTED

/*
 * This module is specialized to the case DCTSIZE = 8.
 */

#if DCTSIZE != 8
  Sorry, this code only copes with 8x8 DCTs. /* deliberate syntax err */
#endif

#if BITS_IN_JSAMPLE == 8
#define CONST_BITS  13
#define PASS1_BITS  2
#else
#define CONST_BITS  13
#define PASS1_BITS  1		/* lose a little precision to avoid overflow */
#endif

/* Multiply an INT32 variable by an INT32 constant to yield an INT32 result.
 * For 8-bit samples with the recommended scaling, all the variable
 * and constant values involved are no more than 16 bits wide, so a
 * 16x16->32 bit multiply can be used instead of a full 32x32 multiply.
 * For 12-bit samples, a full 32-bit multiplication will be needed.
 */

#if BITS_IN_JSAMPLE == 8
#define MULTIPLY(var,const)  MULTIPLY16C16(var,const)
#else
#define MULTIPLY(var,const)  ((var) * (const))
#endif


//Jie 07/09/00: lossless binDCT flag, defined in cjpeg.
extern boolean lossless_codec;


/*
 * Perform the forward binDCT-A on one block of samples.
 * Cost: 17 shifts.
 */

GLOBAL(void)
jpeg_fdct_bin_l1 (DCTELEM * data)
{
  INT32 tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7;
  INT32 tmp10, tmp11, tmp12, tmp13;
  INT32 z1;
  DCTELEM *dataptr;
  int ctr;
  SHIFT_TEMPS

	/*	fprintf(stderr, "jpeg_fdct_bin_a1 ...\n"); */

  /* Pass 1: process rows. */
  /* Note results are scaled up by sqrt(8) compared to a true DCT; */
  /* furthermore, we scale the results by 2**PASS1_BITS. */

	//fprintf(stderr, "\nOriginal image:\n");

//Case 1: lossless binDCT not required. Use original butterflies.
if (!lossless_codec){

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {


/*******************/
/* Jie: test code */
	//	for (tmp0 = 0; tmp0 < 8; tmp0 ++) {
	//	  fprintf(stderr, "%10d", dataptr[tmp0]+128);
	//	}
	//	fprintf(stderr, "\n");

    tmp0 = dataptr[0] + dataptr[7];
    tmp7 = dataptr[0] - dataptr[7];
    tmp1 = dataptr[1] + dataptr[6];
    tmp6 = dataptr[1] - dataptr[6];
    tmp2 = dataptr[2] + dataptr[5];
    tmp5 = dataptr[2] - dataptr[5];
    tmp3 = dataptr[3] + dataptr[4];
    tmp4 = dataptr[3] - dataptr[4];
    
    /* Even part */
    tmp10 = (tmp0 + tmp3) ;
    tmp13 = tmp0 - tmp3;
    tmp11 = (tmp1 + tmp2) ;
    tmp12 = tmp1 - tmp2;
    
    dataptr[0] = (tmp10 + tmp11);         
	dataptr[4] = ((dataptr[0] ) >> 1) - tmp11;

	//3pi/8: 7/16, 3/8
    dataptr[6] = ( ((tmp13 << 3) - tmp13 ) >> 4) - tmp12;    
    dataptr[2] = tmp13 - (((dataptr[6] << 1) + dataptr[6] ) >> 3);
    
    /* Odd part */

	// 3pi/16 = -1/4, 9/16, -5/16
	tmp7 = tmp7 - (( tmp4 ) >> 2);
	tmp4 = tmp4 + (((tmp7 << 3) + tmp7 ) >> 4);
	tmp7 = tmp7 - (((tmp4 << 2) + tmp4 ) >> 4);

	// pi/16 = -1/8, 3/16, -3/32
	tmp6 = tmp6 - (( tmp5 ) >> 3);
	tmp5 = tmp5 + (((tmp6 << 1) + tmp6 ) >> 4);
	tmp6 = tmp6 - (((tmp5 << 1) + tmp5 ) >> 5);

	//last group of butterflies.
    dataptr[3] = tmp7 - tmp5;
    dataptr[5] = tmp4 - tmp6;

    tmp4 = tmp4 + tmp6;
    tmp7 = tmp7 + tmp5;
	dataptr[1] = tmp4 + tmp7;
	dataptr[7] = ((dataptr[1] ) >> 1) - tmp4;

    dataptr += DCTSIZE;		/* advance pointer to next row */

  }

  /* Pass 2: process columns.
   * We remove the PASS1_BITS scaling, but leave the results scaled up
   * by an overall factor of 8.
   */

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {
    tmp0 = (dataptr[DCTSIZE*0] + dataptr[DCTSIZE*7]);
    tmp7 = (dataptr[DCTSIZE*0] - dataptr[DCTSIZE*7]);
    tmp1 = (dataptr[DCTSIZE*1] + dataptr[DCTSIZE*6]);
    tmp6 = (dataptr[DCTSIZE*1] - dataptr[DCTSIZE*6]);
    tmp2 = (dataptr[DCTSIZE*2] + dataptr[DCTSIZE*5]);
    tmp5 = (dataptr[DCTSIZE*2] - dataptr[DCTSIZE*5]);
    tmp3 = (dataptr[DCTSIZE*3] + dataptr[DCTSIZE*4]);
    tmp4 = (dataptr[DCTSIZE*3] - dataptr[DCTSIZE*4]);

    /* Even part */
    
    tmp10 = (tmp0 + tmp3);	
    tmp13 = tmp0 - tmp3;
    tmp11 = (tmp1 + tmp2);
    tmp12 = tmp1 - tmp2;
    
    dataptr[DCTSIZE*0] = (tmp10 + tmp11); 
	dataptr[DCTSIZE*4] = ((dataptr[DCTSIZE*0] ) >> 1) - tmp11;  

	// 3pi/8: 7/16, 3/8
    dataptr[DCTSIZE*6] = (((tmp13 << 3) - tmp13 ) >> 4) - tmp12;
    dataptr[DCTSIZE*2] = tmp13 - (((dataptr[DCTSIZE*6] << 1) + dataptr[DCTSIZE*6] ) >> 3);
 
    /* Odd part */

	// 3pi/16 = -1/4, 9/16, -5/16
	tmp7 = tmp7 - (( tmp4 ) >> 2);
	tmp4 = tmp4 + (((tmp7 << 3) + tmp7 ) >> 4);
	tmp7 = tmp7 - (((tmp4 << 2) + tmp4 ) >> 4);

	// pi/16 = -1/8, 3/16, -3/32
	tmp6 = tmp6 - (( tmp5 ) >> 3);
	tmp5 = tmp5 + (((tmp6 << 1) + tmp6 ) >> 4);
	tmp6 = tmp6 - (((tmp5 << 1) + tmp5 ) >> 5);
 
	//last group of butterflies.
    dataptr[DCTSIZE*3] = tmp7 - tmp5;
    dataptr[DCTSIZE*5] = tmp4 - tmp6;

    tmp4 = tmp4 + tmp6;
    tmp7 = tmp7 + tmp5;
	dataptr[DCTSIZE*1] = tmp4 + tmp7;
	dataptr[DCTSIZE*7] = ((dataptr[DCTSIZE*1] ) >> 1) - tmp4;

    dataptr++;			/* advance pointer to next column */
  }

/****************************************************************************/
   
} else {

/****************************************************************************/
  //Case 2: lossless binDCT: Use new butterflies.

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {


/*******************/
/* Jie: test code */
	//	for (tmp0 = 0; tmp0 < 8; tmp0 ++) {
	//	  fprintf(stderr, "%10d", dataptr[tmp0]+128);
	//	}
	//	fprintf(stderr, "\n");

	/*	for (z1 = 0; z1 < 8; z1 ++) {
	  fprintf(stderr, "%6d", dataptr[z1]);
	}
	fprintf(stderr, "\n");*/

    tmp7 = dataptr[0] - dataptr[7];
    tmp0 = dataptr[0] - ((tmp7 ) >> 1);

    tmp6 = dataptr[1] - dataptr[6];
    tmp1 = dataptr[1] - ((tmp6 ) >> 1);

    tmp5 = dataptr[2] - dataptr[5];
    tmp2 = dataptr[2] - ((tmp5 ) >> 1);

    tmp4 = dataptr[3] - dataptr[4];
    tmp3 = dataptr[3] - ((tmp4 ) >> 1);
    
   /* Even part */
	//old method: larger dynamic range.
	//    tmp10 = (tmp0 + tmp3) ;	/* phase 2 */
	//    tmp13 = ((tmp10 ) >> 1) - tmp3;
	tmp13 = tmp0 - tmp3;
 	tmp10 = tmp0 - ((tmp13 ) >> 1);	

	//    tmp11 = (tmp1 + tmp2) ;
	//    tmp12 = ((tmp11 ) >> 1) - tmp2;
	tmp12 = tmp1 - tmp2;
	tmp11 = tmp1 - ((tmp12 ) >> 1);   

    //    dataptr[0] = (tmp10 + tmp11);             /* phase 3 */
	//    dataptr[4] = ((dataptr[0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
	dataptr[4] = tmp10 - tmp11;
    dataptr[0] = tmp10 - ((dataptr[4] ) >> 1);

	// 3pi/8: 7/16 and -3/8 
    dataptr[6] = ( ((tmp13 << 3) - tmp13 ) >> 4) - tmp12;
    dataptr[2] = tmp13 - (((dataptr[6] << 1) + dataptr[6] ) >> 3);
    
    /* Odd part */

	// 3pi/16 = -1/4, 9/16, -5/16
	tmp7 = tmp7 - (( tmp4 ) >> 2);
	tmp4 = tmp4 + (((tmp7 << 3) + tmp7 ) >> 4);
	tmp7 = tmp7 - (((tmp4 << 2) + tmp4 ) >> 4);

	// pi/16 = -1/8, 3/16, -3/32
	tmp6 = tmp6 - (( tmp5 ) >> 3);
	tmp5 = tmp5 + (((tmp6 << 1) + tmp6 ) >> 4);
	tmp6 = tmp6 - (((tmp5 << 1) + tmp5 ) >> 5);

	//butterflies:
	tmp6 = tmp4 - tmp6;
	tmp4 = tmp4 - ((tmp6 ) >> 1);

	tmp5 = tmp7 - tmp5;
	tmp7 = tmp7 - ((tmp5 ) >> 1);

	//last butterfly
	dataptr[7] = tmp7 - tmp4;
	dataptr[1] = tmp7 - ((dataptr[7] ) >> 1);

    dataptr[3] = tmp5;
	dataptr[5] = tmp6;

    dataptr += DCTSIZE;		/* advance pointer to next row */
  }

  /* Pass 2: process columns.
   * We remove the PASS1_BITS scaling, but leave the results scaled up
   * by an overall factor of 8.
   */

  dataptr = data;
  for (ctr = DCTSIZE-1; ctr >= 0; ctr--) {

    tmp7 = dataptr[DCTSIZE*0] - dataptr[DCTSIZE*7];
    tmp0 = dataptr[DCTSIZE*0] - ((tmp7 ) >> 1);

    tmp6 = dataptr[DCTSIZE*1] - dataptr[DCTSIZE*6];
    tmp1 = dataptr[DCTSIZE*1] - ((tmp6 ) >> 1);

    tmp5 = dataptr[DCTSIZE*2] - dataptr[DCTSIZE*5];
    tmp2 = dataptr[DCTSIZE*2] - ((tmp5 ) >> 1);

    tmp4 = dataptr[DCTSIZE*3] - dataptr[DCTSIZE*4];
    tmp3 = dataptr[DCTSIZE*3] - ((tmp4 ) >> 1);
    
    //tmp10 = (tmp0 + tmp3); 
    //tmp13 = ((tmp10 ) >> 1) - tmp3;
	tmp13 = tmp0 - tmp3;
 	tmp10 = tmp0 - ((tmp13 ) >> 1);

    //tmp11 = (tmp1 + tmp2);
    //tmp12 = ((tmp11 ) >> 1) - tmp2;
	tmp12 = tmp1 - tmp2;
	tmp11 = tmp1 - ((tmp12 ) >> 1);

	//old method: larger dynamic range
    //dataptr[DCTSIZE*0] = (tmp10 + tmp11); /* phase 3 */
	//dataptr[DCTSIZE*4] = ((dataptr[DCTSIZE*0] ) >> 1) - tmp11;   /* Jie 05/18/00 */
	dataptr[DCTSIZE*4] = tmp10 - tmp11;
    dataptr[DCTSIZE*0] = tmp10 - ((dataptr[DCTSIZE*4] ) >> 1);

	// 7/16, 3/8
    dataptr[DCTSIZE*6] = (((tmp13 << 3) - tmp13 ) >> 4) - tmp12;
    dataptr[DCTSIZE*2] = tmp13 - (((dataptr[DCTSIZE*6] << 1) + dataptr[DCTSIZE*6] ) >> 3);
 
    /* Odd part */

	// 3pi/16 = -1/4, 9/16, -5/16
	tmp7 = tmp7 - (( tmp4 ) >> 2);
	tmp4 = tmp4 + (((tmp7 << 3) + tmp7 ) >> 4);
	tmp7 = tmp7 - (((tmp4 << 2) + tmp4 ) >> 4);

	// pi/16 = -1/8, 3/16, -3/32
	tmp6 = tmp6 - (( tmp5 ) >> 3);
	tmp5 = tmp5 + (((tmp6 << 1) + tmp6 ) >> 4);
	tmp6 = tmp6 - (((tmp5 << 1) + tmp5 ) >> 5);

	//butterflies:
	tmp6 = tmp4 - tmp6;
	tmp4 = tmp4 - ((tmp6 ) >> 1);

	tmp5 = tmp7 - tmp5;
	tmp7 = tmp7 - ((tmp5 ) >> 1);

	//last butterfly
	dataptr[DCTSIZE*7] = tmp7 - tmp4;
	dataptr[DCTSIZE*1] = tmp7 - ((dataptr[DCTSIZE*7] ) >> 1);

    dataptr[DCTSIZE*3] = tmp5;
	dataptr[DCTSIZE*5] = tmp6;

    dataptr++;			/* advance pointer to next column */
  }

} // lossless ot not.
 
}

/**************************************
 * problem with Sachin's code:
 * 1: it's verison binDCT-C.
 * 2: X[0] and X[4]: butterfly, not lifting.
 * 3: Neg scaling required.
 **************************************
 */

#endif /* DCT_BIN_L1_SUPPORTED */
