function bin263_all(colorplot)
% Comparision of Floating DCt and binDCT-C4 for all sequence,
% with the default quantization steps.
%
%Encoder command:
% ./tmn -i ../***.qcif -o ***_rec_flt.qcif -B ***_flt.cmp -b 99 -k 0
% ./tmn -i ../***.qcif -o ***_rec_c4.qcif  -B ***_c4.cmp  -b 99 -k 0 -X c4

%Decoder command:
% ./tmndec -o5 ../***_flt.cmp -s ***_rec_flt.qcif
% ./tmndec -dc4 -o5 ../***_c4.cmp  -s ***_rec_c4.qcif
%
% Possible Problems:
% 
% Bug in decoder caused the decoder result drops a lot when the scene changes.
% check for it!
%
%
% Jie Liang, 10/16/2000

if nargin == 0
   colorplot = 1;
end

%%%%%%%%%%%%%%%%%%%%%%%
%
% Miss America
%
%%%%%%%%%%%%%%%%%%%%%%%

close all;

t1 = 'Miss America ';

f_f = [ 34.263854  35.412826  35.628262  35.813853  36.106505  ...
36.102421  36.128483  36.090579  36.131802  36.201243  ...
36.248532  36.267637  36.225254  36.212587  36.170866  ...
36.085771  36.112724  35.923538  35.906809  35.793677  ...
35.806030  35.945601  36.108591  36.067128  36.125901  ...
36.020984  36.042172  35.989168  36.125275  36.125923  ...
36.114953  36.069889  36.038815  36.241938  36.225508  ...
36.225132  36.266499  36.402676  36.436649  36.443220  ...
36.318966  36.197937  36.079559  36.153507  36.243758  ...
36.247821  36.318198  36.133186  35.991691  35.927518  ...
35.975794  35.985622  35.924733  35.966549  36.107806  ...
36.101250  36.243070  36.179047  36.146860  36.086713  ...
36.147327  36.148923  36.216170  36.154550  36.191748  ...
36.020003  35.895354  36.031021  36.094426  36.074241  ...
36.145048  36.115718  36.098491  36.149694  36.122911  ...
36.347387  36.226834  36.410026  36.297723  36.197805  ...
36.381456  36.226215  36.256449  36.156073  36.136671  ...
36.044387  35.857726  35.866345  35.643041  35.619526  ...
35.604453  35.588668  35.772748  35.773704  35.851770  ...
35.938252  35.995253  36.159391  36.138285  35.958052  ...
]; 

%encoder
f_f = [ 34.271880  35.412881  35.680337  35.930284  36.061038  ...
36.069078  36.008604  36.066649  36.184692  36.048735  ...
36.166776  36.260001  36.168794  36.209911  36.193821  ...
36.124811  36.059878  35.962845  35.957398  35.836820  ...
35.949053  35.990644  36.103055  36.082509  35.969851  ...
35.999919  36.052662  35.965134  36.006397  36.037355  ...
36.056774  36.022818  35.924754  36.033399  35.963875  ...
35.948296  36.102088  36.120332  36.217184  36.217239  ...
36.253022  36.140256  36.074870  36.141167  36.208403  ...
36.274706  36.275813  36.273656  35.896511  35.806502  ...
35.866945  35.925765  35.905392  35.937000  36.052524  ...
36.086296  36.072192  36.100069  36.128181  36.053862  ...
35.944628  36.015263  36.272862  36.195686  36.088105  ...
35.969278  36.068268  36.062081  36.078266  36.177823  ...
35.994991  36.006996  35.964790  35.987683  36.107967  ...
36.242249  36.103302  36.241029  36.335448  36.315083  ...
36.281036  36.273477  36.170463  36.090032  36.143042  ...
35.970955  35.947249  35.700893  35.582917  35.528478  ...
35.555688  35.661450  35.743001  35.876754  35.932587  ...
36.151073  35.924373  36.183729  36.087259  36.087334  ...
]; 


%decoder: mean: 0.044, mad: 0.280
c4_c4 = [ 34.268668  35.410517  35.676479  35.931028  36.058762  ...
36.066095  36.004811  36.062719  36.179867  36.047006  ...
36.163594  36.256026  36.168564  36.204189  36.183937  ...
36.112745  36.052779  35.952497  35.947467  35.833366  ...
35.941397  35.989985  36.103141  36.081867  35.963802  ...
35.998188  36.056890  35.967132  36.009918  36.033039  ...
36.054043  36.021416  35.931627  36.032363  35.975522  ...
35.949831  36.103614  36.122414  36.217647  36.220980  ...
36.247155  36.137343  36.073931  36.142186  36.205872  ...
36.272583  36.277501  36.276081  35.892364  35.805007  ...
35.859625  35.928375  35.906531  35.938396  36.045404  ...
36.074881  36.058187  36.087098  36.120160  36.043444  ...
35.936256  35.989022  36.255848  36.190345  36.075159  ...
35.947311  36.047143  36.046009  36.073131  36.179452  ...
36.003907  36.012716  35.958769  35.979906  36.102067  ...
36.246644  36.106612  36.251810  36.342389  36.330350  ...
36.295196  36.268675  36.170484  36.090268  36.141557  ...
35.968288  35.927250  35.678876  35.571401  35.521923  ...
35.548941  35.657153  35.730678  35.868553  35.934282  ...
36.151888  35.925703  36.179124  36.086981  36.090161  ...
]; 

%new decoder:0.042, 0.281
c4_c4 = [ 34.272211  35.414090  35.680084  35.930563  36.060740  ...
36.069420  36.007605  36.068769  36.184616  36.050029  ...
36.169263  36.263600  36.170157  36.211409  36.193020  ...
36.118132  36.054956  35.956785  35.954708  35.838215  ...
35.947705  35.990979  36.105451  36.082199  35.965925  ...
35.999489  36.053055  35.966164  36.006029  36.030577  ...
36.051621  36.020393  35.927766  36.036868  35.971966  ...
35.947995  36.102367  36.120753  36.218276  36.216721  ...
36.243391  36.134323  36.070827  36.136401  36.199540  ...
36.269869  36.268217  36.272348  35.888620  35.802550  ...
35.855564  35.919385  35.903329  35.932784  36.043814  ...
36.077219  36.060081  36.091736  36.123904  36.047366  ...
35.944317  36.005819  36.265663  36.188383  36.080392  ...
35.957907  36.054499  36.052609  36.077881  36.181781  ...
36.003561  36.016337  35.962418  35.991566  36.109678  ...
36.248154  36.113338  36.254446  36.341164  36.331415  ...
36.293725  36.271958  36.172285  36.084905  36.139736  ...
35.972988  35.940435  35.697937  35.579764  35.527584  ...
35.557422  35.656009  35.744673  35.873839  35.935015  ...
36.150986  35.918098  36.179846  36.087088  36.094297  ...
]; 


err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end
legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

%break;

%%%%%%%%%%%%%%%%%%%%%%%
%
% Car Phone
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Car Phone ';

f_f = [ 29.812920  31.092034  31.314602  31.498088  31.521592  ...
31.738390  31.692851  31.846676  31.912856  31.817985  ...
31.816703  31.743332  31.714049  31.733147  31.733265  ...
31.737576  31.677325  31.675076  31.626543  31.548468  ...
31.576246  31.572827  31.467381  31.571608  31.707586  ...
31.713955  31.859084  31.773146  31.646168  31.629050  ...
31.843049  31.734145  31.766448  31.860677  31.697064  ...
31.866688  31.606095  31.712954  31.717750  31.720702  ...
31.718881  31.761377  31.883643  31.880774  32.092210  ...
31.987670  31.900817  31.889682  31.921580  32.023627  ...
32.047723  31.932180  31.917447  31.898988  31.858975  ...
31.945709  31.796310  31.812737  31.801877  31.847805  ...
32.075399  32.042465  32.147800  32.011604  32.118875  ...
32.041588  31.929393  32.077920  32.146918  32.101247  ...
32.155161  32.137355  32.236710  32.102662  32.030036  ...
32.028859  31.981789  32.071818  31.961618  32.088521  ...
32.056283  32.141297  32.299909  32.012031  31.979473  ...
31.906070  31.987237  31.928797  32.013334  32.032573  ...
32.059309  31.976622  31.890407  31.915927  31.986625  ...
32.105828  32.145510  32.149662  32.227070  32.273825  ...
]; 

%encoder side
f_f = [ 29.764774  30.969979  31.234540  31.374740  31.437131  ...
31.623490  31.661166  31.732648  31.818125  31.734698  ...
31.721552  31.710480  31.647962  31.657239  31.681813  ...
31.768792  31.749399  31.608621  31.622054  31.536608  ...
31.492666  31.507213  31.381682  31.505737  31.545763  ...
31.583003  31.609743  31.613230  31.501907  31.551797  ...
31.650108  31.622720  31.665893  31.642927  31.663813  ...
31.698341  31.545085  31.608789  31.650058  31.632284  ...
31.766978  31.715754  31.843907  31.761614  31.994827  ...
31.876249  31.942600  31.839385  31.812645  31.912205  ...
31.890896  31.834517  31.832118  31.801642  31.760049  ...
31.839305  31.694606  31.775775  31.839240  31.800712  ...
31.899282  31.794223  32.023548  31.959855  31.936129  ...
31.956103  31.981652  32.006118  32.053749  32.000817  ...
32.120570  32.066182  32.104997  32.040740  31.971682  ...
31.982663  31.984581  31.890940  31.804775  32.022053  ...
31.866939  31.965429  32.111052  32.120648  31.985879  ...
31.902470  31.915419  31.882009  32.004746  31.990653  ...
31.935113  31.845016  31.869305  31.907897  31.942085  ...
32.109475  32.161147  32.050727  32.138713  32.155373  ...
]; 

%decoder side: 0.012298, mad: 0.035859
c4_c4 = [ 29.763920  30.969989  31.231995  31.370868  31.435862  ...
31.619765  31.656046  31.726667  31.808934  31.729244  ...
31.718329  31.701865  31.648929  31.652070  31.677317  ...
31.767861  31.750495  31.602111  31.613945  31.529066  ...
31.486539  31.500991  31.372173  31.497526  31.538320  ...
31.573724  31.597932  31.603361  31.491562  31.538027  ...
31.630615  31.608640  31.652887  31.630132  31.656791  ...
31.687853  31.532372  31.592445  31.646029  31.626133  ...
31.750976  31.704412  31.833408  31.762318  31.988307  ...
31.868742  31.928218  31.823383  31.795525  31.901286  ...
31.882952  31.813417  31.812397  31.790348  31.733685  ...
31.821607  31.689191  31.762496  31.833589  31.801347  ...
31.891213  31.784903  32.021616  31.948093  31.926049  ...
31.937381  31.958179  31.991241  32.030659  31.975854  ...
32.096269  32.051395  32.086705  32.027421  31.961610  ...
31.962467  31.972985  31.883501  31.784311  31.996170  ...
31.853302  31.946167  32.089177  32.099426  31.967206  ...
31.890553  31.898392  31.865623  31.981556  31.980379  ...
31.917873  31.828057  31.840194  31.894286  31.915694  ...
32.080246  32.125288  32.026102  32.120858  32.149234  ...
]; 

%new decoder: 0.0006, mad: 0.011276
c4_c4 = [ 29.764480  30.970319  31.232320  31.373876  31.437807  ...
31.624041  31.659995  31.731662  31.815882  31.732946  ...
31.721395  31.708984  31.651441  31.659787  31.683316  ...
31.768633  31.750806  31.608365  31.621411  31.533535  ...
31.490998  31.505454  31.379871  31.505972  31.545687  ...
31.582764  31.610007  31.609400  31.497053  31.548374  ...
31.646399  31.621307  31.663214  31.643639  31.665421  ...
31.697356  31.546643  31.610446  31.652081  31.633869  ...
31.764766  31.712813  31.847624  31.766483  31.996905  ...
31.877630  31.947404  31.842510  31.811453  31.914305  ...
31.890224  31.831877  31.835217  31.808487  31.759547  ...
31.842703  31.699320  31.781562  31.841406  31.803470  ...
31.899127  31.796127  32.027320  31.959408  31.939312  ...
31.959023  31.979984  32.004633  32.049248  31.995686  ...
32.116888  32.069334  32.107938  32.042845  31.982958  ...
31.986870  31.987316  31.898576  31.804707  32.016633  ...
31.872151  31.966879  32.103214  32.118274  31.983424  ...
31.903250  31.919197  31.885868  32.007360  31.993968  ...
31.938789  31.847309  31.867048  31.910744  31.942629  ...
32.112891  32.159123  32.047981  32.138592  32.159305  ...
]; 

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);


figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end
legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

%break;

%%%%%%%%%%%%%%%%%%%%%%%
%
% Foreman
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Foreman ';

%at decoder side: flt~flt
f_f = [ 29.229463  30.367657  30.622751  30.719441  30.725884  ...
30.794678  30.707078  30.698174  30.838927  30.805295  ...
30.896550  30.788468  30.751976  30.776014  30.716500  ...
30.738785  30.832072  30.827054  30.823625  30.725604  ...
30.656988  30.521487  30.435347  30.587701  30.534542  ...
30.492445  30.492165  30.608391  30.586582  30.532927  ...
30.570252  30.587251  30.602144  30.600773  30.667239  ...
30.676126  30.598068  30.630319  30.730231  30.794622  ...
30.834671  30.799124  30.793878  30.734770  30.686090  ...
30.671685  30.747560  30.839048  30.830952  30.816454  ...
30.842640  30.798139  30.711263  30.688989  30.884328  ...
30.798611  30.810488  30.824571  30.821902  30.846827  ...
30.772996  30.735185  30.644372  30.521704  30.468218  ...
30.522976  30.540116  30.513447  30.493925  30.579945  ...
30.609218  30.559252  30.585991  30.736606  30.779279  ...
30.722758  30.679545  30.705651  30.784747  30.755493  ...
30.640617  30.726831  30.652015  30.705239  30.690107  ...
30.700641  30.754086  30.806434  30.911029  30.975469  ...
30.949855  30.977557  31.011687  31.056093  31.120207  ...
31.267013  31.212274  31.203646  31.152837  31.183097  ...
31.210257  31.222319  31.250541  31.189299  31.166022  ...
31.136685  31.107276  31.112049  31.093589  31.001835  ...
30.894270  30.870798  30.765512  30.626134  30.667153  ...
30.629883  30.653975  30.576802  30.614045  30.661248  ...
30.626320  30.752876  30.731781  30.850037  30.858822  ...
30.906942  30.759779  30.721644  30.874960  30.919654  ...
30.900524  30.968461  30.867762  30.859560  30.820348  ...
30.823937  30.814552  30.903177  30.892616  30.825036  ...
31.010572  31.060498  30.942581  31.006374  30.973117  ...
31.062998  30.970671  30.893351  30.774977  30.690487  ...
30.731694  30.697635  30.755628  30.691475  30.575881  ...
30.548035  30.500340  30.524644  30.683769  30.906367  ...
30.918892  30.868756  30.798072  30.791743  30.849316  ...
30.847218  30.788620  30.870257  30.772423  30.639167  ...
30.735388  30.766596  30.794523  30.883182  30.903242  ...
30.913562  30.972313  30.914619  30.842093  30.778349  ...
30.665264  30.589152  30.578096  30.521436  30.309858  ...
30.352117  30.364638  30.268892  30.336899  30.762998  ...
30.873597  30.761110  30.831973  30.966538  30.971983  ...
30.812251  30.861767  30.992117  30.981186  30.909732  ...
31.031615  30.990601  31.072417  31.059321  31.071081  ...
31.135634  31.001151  31.158583  31.227822  31.113248  ...
30.965313  31.031575  31.003113  30.952477  30.994459  ...
31.029527  31.016723  31.035473  31.163207  31.168956  ...
31.145174  31.076693  31.017719  31.009751  30.926121  ...
30.830221  30.706014  30.665525  30.520744  30.436503  ...
30.325131  30.301627  30.243680  30.256496  30.212180  ...
30.157305  30.303989  30.483110  30.504396  30.509777  ...
30.484330  30.643590  30.647651  30.737118  30.947983  ...
31.021324  31.141169  31.296651  31.159980  31.200688  ...
31.189947  31.255950  31.529013  31.669166  31.171907  ...
30.942060  30.986061  31.079186  30.611083  30.472391  ...
30.489958  30.578391  30.670479  30.681977  30.725118  ...
30.670525  30.811435  30.926395  30.952637  31.022118  ...
31.011477  30.987305  30.834683  30.786582  30.703615  ...
30.623332  30.761424  30.813494  30.755145  30.800473  ...
31.083885  31.308083  31.437469  31.368686  31.626156  ...
31.873400  32.296191  32.611350  33.144267  33.005990  ...
32.863722  32.366630  32.190574  32.054511  31.974923  ...
31.577861  31.312120  31.427496  31.781641  32.161238  ...
32.737673  33.072032  33.231178  33.073337  33.202249  ...
33.200134  33.128288  33.259508  33.270580  32.873021  ...
32.263836  31.663929  31.272973  31.072316  30.915429  ...
30.691868  30.390706  30.038390  29.609025  29.408457  ...
29.214768  29.207046  29.223753  29.173473  29.388262  ...
29.573595  29.576596  29.493424  29.349142  29.251266  ...
29.129558  29.053012  28.973528  29.019633  28.951890  ...
28.983488  29.127309  29.128833  29.276681  29.164768  ...
29.098912  29.063631  29.106530  29.102989  29.059270  ...
28.970040  28.930812  28.941737  28.877507  28.819231  ...
28.893457  28.984783  28.921255  28.981435  29.027294  ...
28.988817  28.920192  28.784460  28.807454  28.839635  ...
28.817151  28.797887  28.782035  28.812307  28.796347  ...
28.915899  28.854361  28.847931  28.828017  28.816563  ...
28.777279  28.825355  28.934089  28.879372  28.818783  ...
28.866457  28.859974  28.812520  28.774182  28.763048  ...
28.847104  28.913256  28.964374  28.908590  28.936613  ...
28.893347  28.822551  28.858179  28.807572  28.850385  ...
28.938809  28.974578  28.971360  29.051949  28.982020  ...
28.878832  28.854432  28.845950  28.821689  28.776741  ...
]; 


%encoder side result after modifying the quant:
%0.0848, 0.29756
e_c4_c4 = [ 29.174622  30.264994  30.562508  30.678695  30.610174  ...
30.631108  30.650616  30.645094  30.761004  30.723293  ...
30.827111  30.758185  30.724040  30.687361  30.668343  ...
30.606990  30.698567  30.814015  30.789403  30.669717  ...
30.472494  30.482409  30.385116  30.441375  30.406585  ...
30.313202  30.338634  30.470596  30.404796  30.457292  ...
30.469398  30.498569  30.610177  30.604800  30.621209  ...
30.606078  30.552731  30.636456  30.634413  30.672380  ...
30.758147  30.720791  30.718067  30.583027  30.638251  ...
30.586205  30.608345  30.731273  30.747560  30.802625  ...
30.731790  30.726311  30.543057  30.608854  30.678008  ...
30.627937  30.600461  30.684868  30.671227  30.784567  ...
30.732686  30.681854  30.578656  30.415321  30.339099  ...
30.411832  30.370279  30.298442  30.443850  30.400202  ...
30.412759  30.382568  30.434642  30.503200  30.689418  ...
30.668964  30.642747  30.608448  30.763871  30.728931  ...
30.618415  30.628823  30.624190  30.624074  30.613098  ...
30.573558  30.794349  30.738042  30.879950  30.924748  ...
30.907445  30.936116  30.960589  31.039235  31.023982  ...
31.066187  31.076771  31.081031  31.065372  31.071553  ...
31.187785  31.185794  31.213723  31.126808  31.077895  ...
30.970642  30.909099  31.087624  31.041368  30.959406  ...
30.796473  30.758414  30.702546  30.591682  30.556064  ...
30.566887  30.466049  30.464459  30.502235  30.610313  ...
30.599826  30.648578  30.752261  30.789685  30.752127  ...
30.735500  30.726878  30.698319  30.874751  30.936937  ...
30.948177  30.988685  30.837172  30.778415  30.789909  ...
30.814492  30.778822  30.762097  30.712185  30.707819  ...
30.869558  30.898144  30.874551  30.847003  30.912976  ...
30.981130  30.902285  30.799368  30.719905  30.649517  ...
30.605266  30.619926  30.601160  30.495159  30.480752  ...
30.442980  30.368159  30.436906  30.624454  30.731082  ...
30.812321  30.775406  30.685074  30.683615  30.794052  ...
30.706733  30.744087  30.778932  30.754186  30.642050  ...
30.740207  30.645739  30.674633  30.773846  30.870679  ...
30.781853  30.787849  30.737061  30.762109  30.689233  ...
30.609331  30.534903  30.461724  30.446142  30.239055  ...
30.206486  30.196289  30.203513  30.253690  30.647176  ...
30.806901  30.752603  30.738448  30.763633  30.795055  ...
30.743002  30.748277  30.694554  30.829771  30.826311  ...
30.859364  30.916002  30.956823  30.938605  30.972754  ...
30.972405  30.974924  31.013893  31.159161  31.023209  ...
30.850169  30.920908  30.923434  30.926502  31.013101  ...
30.962428  30.938055  30.944601  31.007497  31.046093  ...
31.027764  31.003086  31.005002  30.942456  30.945984  ...
30.750056  30.703875  30.511535  30.508938  30.404186  ...
30.244890  30.212891  30.197701  30.305830  30.233498  ...
30.212648  30.203292  30.405343  30.476782  30.496583  ...
30.515349  30.517156  30.593187  30.625693  30.792546  ...
30.834553  30.906478  31.062914  31.116436  31.128322  ...
31.052522  31.085245  31.396058  31.565425  31.157121  ...
30.791613  30.905708  31.001619  30.481876  30.379343  ...
30.385951  30.483107  30.581668  30.609561  30.622045  ...
30.536021  30.715403  30.818136  30.849175  31.009791  ...
30.932646  30.833109  30.809545  30.760153  30.675787  ...
30.489306  30.564780  30.702143  30.683890  30.686920  ...
30.868547  31.249964  31.369990  31.353328  31.714960  ...
31.982113  32.137053  32.497142  33.073417  32.983130  ...
32.787807  32.315555  32.098097  31.920518  31.825393  ...
31.482707  31.308827  31.303256  31.617756  32.044427  ...
32.493299  32.945098  33.149700  33.032693  33.079341  ...
32.999781  33.027483  33.131159  33.220682  32.798897  ...
32.173240  31.565266  31.197440  31.020161  30.956311  ...
30.650227  30.333816  29.941116  29.526244  29.231841  ...
29.198861  29.072383  29.115167  29.180894  29.238304  ...
29.517423  29.525252  29.416684  29.285408  29.190248  ...
29.083143  29.018935  28.897523  28.915809  28.891466  ...
28.909820  29.051288  29.110973  29.170864  29.059325  ...
29.002316  28.992272  28.990532  29.063100  28.969826  ...
28.925198  28.829317  28.838161  28.825301  28.770805  ...
28.773360  28.854778  28.824055  28.856566  28.898082  ...
28.828176  28.738188  28.737301  28.709740  28.766901  ...
28.779084  28.705689  28.734945  28.716771  28.765322  ...
28.810810  28.818434  28.830454  28.748468  28.745088  ...
28.746839  28.796572  28.816403  28.853780  28.842008  ...
28.849271  28.839296  28.781794  28.700614  28.760704  ...
28.766818  28.789046  28.834023  28.841244  28.906637  ...
28.839284  28.849973  28.772474  28.786142  28.765878  ...
28.850820  28.902861  28.852961  28.948341  28.881451  ...
28.881017  28.831545  28.770090  28.765880  28.757155  ...
];

%after changing the quant at the encoder
%this is msred at the decoder
%mean: 0.096, mad: 0.329
f_f = [ 29.175500  30.263980  30.563892  30.680519  30.611357  ...
30.636185  30.652530  30.643336  30.758671  30.719164  ...
30.828562  30.756064  30.721361  30.681965  30.663317  ...
30.603089  30.695649  30.812032  30.782421  30.662623  ...
30.465368  30.473299  30.374686  30.437512  30.404183  ...
30.310520  30.337748  30.471918  30.407881  30.456205  ...
30.473216  30.496048  30.606530  30.604321  30.627946  ...
30.607321  30.546558  30.630581  30.631958  30.665921  ...
30.752948  30.718714  30.718107  30.584980  30.639219  ...
30.580653  30.603827  30.725068  30.743480  30.799672  ...
30.734605  30.730474  30.548376  30.621087  30.680932  ...
30.626344  30.599130  30.692208  30.678023  30.789878  ...
30.738770  30.682733  30.573766  30.418538  30.339056  ...
30.413104  30.367221  30.297683  30.439235  30.407103  ...
30.416345  30.385435  30.432822  30.493331  30.679952  ...
30.658769  30.635953  30.609139  30.761622  30.715583  ...
30.596299  30.603849  30.602277  30.595683  30.589174  ...
30.562245  30.774558  30.723776  30.874316  30.916096  ...
30.886597  30.921856  30.938559  31.013553  30.997476  ...
31.039948  31.054689  31.047572  31.043056  31.054685  ...
31.149227  31.162484  31.182471  31.094579  31.049511  ...
30.943786  30.878627  31.049642  31.009605  30.932695  ...
30.769930  30.746897  30.696896  30.584685  30.542409  ...
30.558533  30.458284  30.452065  30.494397  30.603201  ...
30.590538  30.640755  30.746230  30.785426  30.738623  ...
30.714707  30.713095  30.672645  30.850486  30.905429  ...
30.922515  30.953267  30.801389  30.740895  30.760812  ...
30.787343  30.749082  30.729922  30.689155  30.684837  ...
30.833176  30.873162  30.852968  30.815716  30.891804  ...
30.959077  30.885359  30.767096  30.691942  30.638004  ...
30.589201  30.603004  30.590529  30.495803  30.474557  ...
30.437908  30.357018  30.411768  30.597013  30.698805  ...
30.776909  30.746944  30.652943  30.653657  30.770242  ...
30.673122  30.713126  30.750143  30.721105  30.612628  ...
30.718322  30.630700  30.655930  30.765282  30.852974  ...
30.758063  30.778223  30.743105  30.748002  30.669520  ...
30.595900  30.528231  30.457371  30.436439  30.230657  ...
30.194023  30.190999  30.199406  30.248469  30.632714  ...
30.791073  30.731731  30.718505  30.740363  30.779267  ...
30.721112  30.719093  30.662626  30.803640  30.806910  ...
30.835163  30.895031  30.932182  30.913341  30.947836  ...
30.949137  30.952066  30.991833  31.120289  30.990988  ...
30.822708  30.888061  30.899152  30.904449  30.991859  ...
30.943472  30.917317  30.921853  30.987047  31.030960  ...
31.009601  30.992293  30.990859  30.925746  30.933080  ...
30.735778  30.690542  30.506572  30.501659  30.401341  ...
30.246454  30.226460  30.212072  30.316744  30.234733  ...
30.211007  30.200620  30.399515  30.466765  30.491640  ...
30.513569  30.516328  30.580656  30.617413  30.781866  ...
30.820199  30.893836  31.054238  31.102500  31.113248  ...
31.039295  31.074208  31.387322  31.560919  31.144440  ...
30.784867  30.894798  30.996889  30.479383  30.380982  ...
30.379619  30.480587  30.578295  30.611435  30.609567  ...
30.520408  30.705890  30.803948  30.823335  30.989790  ...
30.914447  30.804078  30.781736  30.738251  30.654806  ...
30.474269  30.546917  30.689047  30.664530  30.667534  ...
30.847666  31.232002  31.355772  31.330514  31.689871  ...
31.976552  32.117849  32.478603  33.052984  32.977184  ...
32.780217  32.310532  32.089463  31.916456  31.811465  ...
31.472097  31.299622  31.290812  31.609362  32.032918  ...
32.479564  32.933877  33.137353  33.032201  33.075830  ...
32.996081  33.022385  33.123249  33.213772  32.790471  ...
32.170328  31.562097  31.198725  31.026001  30.954718  ...
30.646962  30.328407  29.932642  29.518654  29.225402  ...
29.191145  29.069470  29.105395  29.169599  29.231384  ...
29.512862  29.524895  29.417398  29.284213  29.193620  ...
29.080472  29.010051  28.891509  28.905836  28.886306  ...
28.902558  29.048326  29.109714  29.171881  29.062085  ...
29.000433  28.992258  28.991409  29.061554  28.968618  ...
28.922121  28.825056  28.830373  28.819739  28.771214  ...
28.772398  28.852252  28.818733  28.849578  28.888496  ...
28.817065  28.728434  28.727730  28.699561  28.758050  ...
28.770412  28.698125  28.727171  28.710141  28.751850  ...
28.798724  28.812508  28.820098  28.738139  28.739138  ...
28.745182  28.794545  28.812702  28.843395  28.834415  ...
28.841647  28.828930  28.770043  28.689729  28.744095  ...
28.753430  28.781173  28.826182  28.835576  28.902251  ...
28.834754  28.843666  28.763653  28.777868  28.764692  ...
28.848230  28.900160  28.844114  28.940126  28.872331  ...
28.866930  28.817824  28.754223  28.748745  28.737114  ...
];

%encoder and decoder both use the scaled Quant.
%0.08867, 0.306, slightly better as they are better matched.
c4_c4 = [ 29.173951  30.263292  30.561939  30.677601  30.609361  ...
30.631626  30.650907  30.644012  30.759161  30.720213  ...
30.823810  30.754829  30.720197  30.684207  30.665107  ...
30.602392  30.697576  30.812143  30.788857  30.669105  ...
30.473548  30.480346  30.381641  30.439608  30.404441  ...
30.309637  30.335911  30.467769  30.405083  30.455951  ...
30.467011  30.495510  30.606321  30.602698  30.623721  ...
30.605490  30.550149  30.634248  30.631120  30.666004  ...
30.753277  30.720489  30.714474  30.580496  30.635334  ...
30.582596  30.602423  30.724894  30.744447  30.799684  ...
30.730674  30.724012  30.536933  30.603840  30.673023  ...
30.620567  30.592724  30.679755  30.666907  30.780623  ...
30.729801  30.678701  30.573724  30.412881  30.339087  ...
30.411113  30.369866  30.294853  30.436180  30.394923  ...
30.409746  30.382133  30.433649  30.501168  30.691818  ...
30.667918  30.641952  30.610177  30.768983  30.729099  ...
30.615830  30.628558  30.623730  30.621312  30.611074  ...
30.573586  30.791866  30.733806  30.877850  30.922147  ...
30.904695  30.933779  30.955135  31.029871  31.021468  ...
31.066750  31.073780  31.081048  31.066679  31.067606  ...
31.177986  31.181682  31.206919  31.125517  31.077622  ...
30.969199  30.907926  31.087096  31.035310  30.958226  ...
30.793932  30.757746  30.701075  30.588178  30.552175  ...
30.564567  30.465911  30.465389  30.504304  30.609073  ...
30.598973  30.648418  30.752174  30.788664  30.748524  ...
30.736390  30.725454  30.698904  30.876221  30.937568  ...
30.949350  30.986461  30.832493  30.769207  30.785139  ...
30.806987  30.769002  30.756739  30.708377  30.701979  ...
30.863712  30.896595  30.874896  30.844743  30.914469  ...
30.982412  30.902570  30.795793  30.716105  30.647323  ...
30.605696  30.613739  30.595825  30.491129  30.475706  ...
30.438861  30.362016  30.427195  30.617607  30.725115  ...
30.805191  30.765056  30.681037  30.678362  30.788680  ...
30.707288  30.737608  30.769962  30.744772  30.635380  ...
30.736328  30.648645  30.671627  30.773657  30.869300  ...
30.780307  30.789305  30.741173  30.753145  30.673636  ...
30.596998  30.530547  30.457423  30.435956  30.234063  ...
30.201316  30.195344  30.205071  30.253377  30.644110  ...
30.804176  30.746602  30.723262  30.757432  30.784147  ...
30.731332  30.737901  30.686049  30.821482  30.822007  ...
30.855207  30.910987  30.948108  30.933573  30.968915  ...
30.964175  30.967545  31.009615  31.148956  31.013776  ...
30.842704  30.911812  30.913526  30.916910  31.007181  ...
30.956879  30.934930  30.936607  30.999900  31.040048  ...
31.015401  30.996604  31.001606  30.934488  30.938598  ...
30.741479  30.699486  30.509332  30.504345  30.399624  ...
30.241253  30.213046  30.196248  30.303184  30.224401  ...
30.203745  30.193971  30.397340  30.472649  30.494113  ...
30.511031  30.517341  30.591154  30.630565  30.800423  ...
30.834038  30.908696  31.059095  31.106565  31.119555  ...
31.040042  31.080558  31.389688  31.553764  31.142831  ...
30.777671  30.890590  30.981130  30.463638  30.365750  ...
30.372420  30.471985  30.562059  30.597394  30.610859  ...
30.528931  30.708765  30.813999  30.844464  31.005543  ...
30.924216  30.824291  30.808313  30.763777  30.673033  ...
30.481700  30.563703  30.698168  30.683677  30.681247  ...
30.858581  31.240855  31.359833  31.344552  31.717605  ...
31.987208  32.134984  32.497385  33.071028  32.982376  ...
32.783357  32.320171  32.095769  31.920448  31.818229  ...
31.481825  31.307427  31.300219  31.615565  32.045781  ...
32.493617  32.944070  33.148275  33.033345  33.079411  ...
32.999760  33.026124  33.128857  33.220062  32.798661  ...
32.174313  31.565410  31.200313  31.022495  30.955969  ...
30.649147  30.329027  29.933955  29.523362  29.229068  ...
29.198275  29.071329  29.112523  29.180162  29.235302  ...
29.514094  29.526055  29.417043  29.283985  29.191051  ...
29.083542  29.016470  28.894472  28.914741  28.888005  ...
28.907793  29.050771  29.109311  29.168150  29.056886  ...
28.997083  28.990125  28.986279  29.056994  28.970626  ...
28.924831  28.830802  28.835657  28.820309  28.764987  ...
28.765227  28.848652  28.821499  28.855333  28.892025  ...
28.822250  28.734873  28.729956  28.702437  28.761455  ...
28.774651  28.702678  28.728676  28.713807  28.763070  ...
28.806998  28.816453  28.825211  28.744217  28.741356  ...
28.743568  28.795013  28.812688  28.852024  28.838548  ...
28.845716  28.834698  28.777307  28.696755  28.752255  ...
28.764412  28.786967  28.831541  28.837330  28.904063  ...
28.836435  28.843410  28.765314  28.781493  28.759557  ...
28.844132  28.894746  28.844781  28.942898  28.876154  ...
28.869423  28.821963  28.756368  28.754148  28.743836  ...
];

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end
legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

break;

%%%%%%%%%%%%%%%%%%%%%%%
%
% Glasgow
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Glasgow ';

f_f = [ 27.297388  28.513500  28.660308  28.771407  28.845156  ...
28.796105  28.840037  28.847777  28.834375  28.789367  ...
28.710159  28.616872  28.451507  28.437341  28.431677  ...
28.427730  28.386843  28.438836  28.432564  28.373199  ...
28.389507  28.431655  28.388441  28.334184  28.100452  ...
27.335836  27.148568  27.090898  27.109841  27.158450  ...
27.095539  27.094652  27.159612  27.207425  27.244522  ...
27.193885  27.250226  27.218264  27.302787  27.345995  ...
27.308308  27.368711  27.388810  27.427407  27.466088  ...
27.598168  27.703157  27.784186  27.705922  27.676418  ...
27.814697  27.769859  27.752993  27.782572  27.804712  ...
27.916571  27.935135  27.889165  27.887096  27.874775  ...
27.848456  27.863025  27.863236  27.868350  27.891201  ...
28.019124  27.844867  27.815897  27.838739  27.809840  ...
27.754040  27.766645  27.946205  27.635829  27.572504  ...
27.610439  27.659172  27.634216  27.578518  27.636095  ...
27.679328  27.771179  27.610318  27.698060  27.610331  ...
27.618208  27.510774  27.424311  27.318479  27.294088  ...
27.143475  27.128237  27.087401  27.000699  27.070651  ...
26.990917  27.120745  27.199169  27.111795  27.341405  ...
]; 

% after changing quant of the encoder
% at the decoder:
c4_c4 = [ 27.277855  28.397930  28.576770  28.674861  28.739148  ...
28.744515  28.765592  28.754876  28.723909  28.668142  ...
28.592470  28.555208  28.416494  28.359748  28.374819  ...
28.396937  28.341177  28.397223  28.365160  28.271845  ...
28.343946  28.386061  28.347779  28.312469  28.067536  ...
27.254199  27.070575  27.040471  27.066549  27.081311  ...
27.129826  27.032746  27.096953  27.167090  27.177911  ...
27.115254  27.146247  27.180959  27.291834  27.278785  ...
27.296432  27.308994  27.307355  27.312046  27.462797  ...
27.458236  27.657618  27.645618  27.671089  27.634404  ...
27.759382  27.648080  27.721189  27.739800  27.747706  ...
27.818883  27.833308  27.784141  27.784367  27.775281  ...
27.815893  27.792211  27.770756  27.711056  27.750743  ...
27.892121  27.725886  27.690683  27.726413  27.696778  ...
27.682534  27.699326  27.805728  27.628902  27.539537  ...
27.568418  27.658920  27.650976  27.549663  27.605735  ...
27.659866  27.739579  27.584119  27.676771  27.597989  ...
27.574738  27.469504  27.342008  27.177770  27.133541  ...
27.019001  26.987931  26.960102  26.896172  26.954291  ...
26.909157  27.020176  27.107802  26.996097  27.300880  ...
]; 

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;

if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end

legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

break;

%%%%%%%%%%%%%%%%%%%%%%%
%
% News
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'News ';

f_f = [ 29.182181  30.244700  30.271327  30.310090  30.301551  ...
30.285975  30.279121  30.273950  30.275685  30.273468  ...
30.360369  30.325245  30.332505  30.343238  30.337218  ...
30.418971  30.431791  30.451191  30.453232  30.447719  ...
30.425918  30.404964  30.412634  30.416296  30.392675  ...
30.308698  30.369783  30.347498  30.379087  30.363446  ...
30.368956  30.360739  30.361243  30.397883  30.448306  ...
30.495770  30.419699  30.454976  30.470000  30.512338  ...
30.499875  30.484775  30.518151  30.544464  30.518032  ...
30.537760  30.499124  30.493381  30.497664  30.523704  ...
30.533493  30.589225  30.645935  30.645458  30.544780  ...
30.517614  30.456647  30.516112  30.525509  30.541618  ...
30.513516  30.492531  30.488374  30.521196  30.528806  ...
30.547877  30.546206  30.538475  30.545898  30.520931  ...
30.556501  30.521659  30.510625  30.505929  30.516658  ...
30.551852  30.517308  30.529508  30.571586  30.512694  ...
30.442221  30.490371  30.474798  30.471177  30.438914  ...
30.422371  30.396046  30.428070  30.426000  30.418460  ...
30.481667  30.315154  30.359639  30.351011  30.313808  ...
30.261296  30.295561  30.368890  30.398931  30.550918  ...
30.600455  30.630794  30.554049  30.612333  30.551708  ...
30.569500  30.547144  30.474263  30.511707  30.484583  ...
30.442977  30.509110  30.495162  30.527431  30.520233  ...
30.569320  30.615739  30.599230  30.652934  30.617206  ...
30.639261  30.681074  30.633550  30.656182  30.664370  ...
30.637216  30.676566  30.644776  30.681604  30.566458  ...
30.488993  30.487416  30.520471  30.557238  30.574334  ...
30.484669  30.537795  30.458363  30.464345  30.451557  ...
30.434409  30.499858  30.535046  30.523627  30.563829  ...
30.604981  30.616596  30.616817  30.598700  30.651387  ...
30.456042  30.436530  30.499719  30.520839  30.523853  ...
30.482601  30.438999  30.468687  30.494695  30.549542  ...
30.492189  30.420190  30.424910  30.452112  30.493786  ...
30.528475  30.594870  30.589140  30.565500  30.574139  ...
30.557166  30.527767  30.526407  30.554219  30.572828  ...
30.517584  30.460848  30.414080  30.405031  30.367264  ...
30.359591  30.266165  30.354015  30.359768  30.308056  ...
30.382896  30.344139  30.396000  30.403223  30.419264  ...
30.482421  30.482118  30.480375  30.521029  30.505677  ...
30.471010  30.487342  30.494344  30.554055  30.576543  ...
30.559306  30.605360  30.603797  30.607181  30.549596  ...
30.529741  30.574073  30.578385  30.602041  30.570657  ...
30.581216  30.583045  30.532689  30.555833  30.617583  ...
30.646494  30.635303  30.587662  30.573760  30.554824  ...
30.527645  30.462964  30.471906  30.444761  30.423977  ...
30.524114  30.466985  30.460557  30.510562  30.487749  ...
30.492419  30.487186  30.555150  30.593362  30.559189  ...
30.506323  30.471075  30.440646  30.439404  30.456208  ...
30.547407  30.413365  30.461284  30.448111  30.311200  ...
30.390717  30.393333  30.473590  30.512813  30.542084  ...
30.621209  30.616921  30.537255  30.547960  30.544999  ...
30.489784  30.501227  30.435545  30.422809  30.353777  ...
30.381581  30.483293  30.490524  30.499923  30.498702  ...
30.636493  30.653311  30.580936  30.616899  30.629971  ...
30.641964  30.672377  30.594256  30.603313  30.604436  ...
30.567287  30.540546  30.479577  30.506107  30.405780  ...
30.353772  30.355330  30.363228  30.366983  30.402385  ...
30.362967  30.401303  30.438016  30.452931  30.385669  ...
30.451352  30.452724  30.465803  30.497995  30.487200  ...
30.549832  30.639897  30.678710  30.635535  30.690762  ...
];

%encoder side
f_f = [ 29.141369  30.176582  30.212346  30.220049  30.245397  ...
30.196967  30.168857  30.147073  30.176667  30.199974  ...
30.240264  30.206696  30.214854  30.242732  30.260680  ...
30.291523  30.333222  30.360616  30.380125  30.348857  ...
30.300675  30.287087  30.281682  30.282815  30.312700  ...
30.257309  30.255037  30.213868  30.229599  30.267488  ...
30.275264  30.247941  30.283082  30.349560  30.365836  ...
30.383929  30.392699  30.386017  30.407039  30.434607  ...
30.434977  30.421020  30.446457  30.472179  30.417694  ...
30.405612  30.384632  30.416209  30.433139  30.438754  ...
30.407129  30.473228  30.517035  30.538490  30.446373  ...
30.375422  30.388143  30.379021  30.389466  30.386443  ...
30.425799  30.347469  30.438602  30.481308  30.419104  ...
30.457549  30.499976  30.502641  30.494347  30.464638  ...
30.486599  30.465492  30.457333  30.432170  30.460100  ...
30.497561  30.449241  30.539475  30.537581  30.453607  ...
30.353443  30.342531  30.333825  30.317977  30.314029  ...
30.350822  30.353151  30.269021  30.296537  30.242139  ...
30.183006  30.253673  30.304249  30.274486  30.187693  ...
30.188862  30.201652  30.255925  30.278104  30.373440  ...
30.441098  30.509288  30.467833  30.491879  30.456173  ...
30.461029  30.491274  30.463876  30.448043  30.389031  ...
30.383224  30.411180  30.403515  30.450557  30.481314  ...
30.497797  30.491840  30.458683  30.487380  30.460555  ...
30.500618  30.500011  30.552217  30.583425  30.574731  ...
30.581653  30.619032  30.563883  30.607939  30.425994  ...
30.398801  30.369263  30.351405  30.352397  30.367869  ...
30.373090  30.369177  30.418123  30.445038  30.392976  ...
30.384030  30.340729  30.404397  30.469803  30.504221  ...
30.577566  30.571249  30.534414  30.536268  30.593706  ...
30.177175  30.307518  30.347703  30.347718  30.318862  ...
30.328273  30.306978  30.338879  30.371272  30.399448  ...
30.359273  30.363463  30.373882  30.386507  30.360186  ...
30.410563  30.432408  30.481821  30.491539  30.482722  ...
30.410015  30.354092  30.347786  30.399188  30.374319  ...
30.379694  30.353989  30.301203  30.270132  30.254486  ...
30.249702  30.221141  30.200758  30.220656  30.238757  ...
30.263415  30.290706  30.280068  30.318779  30.347812  ...
30.373986  30.347518  30.390178  30.420924  30.390181  ...
30.338321  30.308746  30.292882  30.312961  30.345323  ...
30.362827  30.422740  30.432403  30.437538  30.367734  ...
30.395642  30.426779  30.436195  30.453996  30.420219  ...
30.446428  30.453671  30.521588  30.531393  30.493656  ...
30.522913  30.578364  30.485544  30.505364  30.461100  ...
30.451542  30.402908  30.415606  30.399234  30.374078  ...
30.418533  30.377971  30.445812  30.446121  30.441956  ...
30.403949  30.404730  30.403269  30.418684  30.390094  ...
30.365767  30.342109  30.349294  30.353240  30.302184  ...
30.218292  30.290565  30.332030  30.344710  30.243541  ...
30.267934  30.272006  30.364939  30.396216  30.503934  ...
30.550478  30.567299  30.500751  30.511538  30.473266  ...
30.450542  30.435067  30.335934  30.341356  30.377848  ...
30.363595  30.426773  30.429478  30.474480  30.510992  ...
30.550200  30.588105  30.541776  30.577855  30.586621  ...
30.594921  30.598885  30.491950  30.500390  30.517807  ...
30.502179  30.482928  30.409482  30.450259  30.327259  ...
30.264087  30.301816  30.409662  30.405728  30.376735  ...
30.323745  30.394557  30.414028  30.428425  30.423838  ...
30.442259  30.422609  30.502268  30.502484  30.463184  ...
30.502957  30.538350  30.549040  30.543221  30.615700  ...
];

%decoder side: 0.1857, mad: 0.741224
c4_c4 = [ 29.137286  30.170956  30.209168  30.217100  30.241738  ...
30.191927  30.162973  30.142912  30.173067  30.195685  ...
30.237307  30.205270  30.215557  30.243934  30.257298  ...
30.288576  30.333543  30.362070  30.381310  30.345991  ...
30.298431  30.283524  30.277559  30.278342  30.307080  ...
30.255615  30.248829  30.206961  30.222647  30.261609  ...
30.273187  30.242367  30.279464  30.344139  30.357936  ...
30.376994  30.384842  30.384537  30.404270  30.428975  ...
30.429033  30.414686  30.443873  30.469210  30.410745  ...
30.395036  30.372685  30.403836  30.422147  30.434065  ...
30.399260  30.463535  30.511149  30.532549  30.438325  ...
30.367599  30.381518  30.376577  30.386403  30.382179  ...
30.415840  30.337808  30.424640  30.467909  30.411768  ...
30.453361  30.497525  30.502750  30.494037  30.456527  ...
30.473601  30.451215  30.441011  30.416276  30.441871  ...
30.483511  30.434482  30.525423  30.522536  30.438144  ...
30.339392  30.324858  30.315746  30.296416  30.301215  ...
30.334855  30.333964  30.252070  30.275792  30.225616  ...
29.779668  29.887909  29.972846  29.950329  29.881439  ...
29.909008  29.984830  30.061885  30.081279  30.215970  ...
30.242044  30.312182  30.305852  30.324745  30.330733  ...
30.313213  30.327540  30.340840  30.348583  30.267244  ...
30.263684  30.297694  30.274270  30.323311  30.327185  ...
30.335442  30.351917  30.307442  30.350425  30.305428  ...
30.371131  30.371594  30.425230  30.456466  30.449446  ...
30.464430  30.497253  30.462325  30.499500  30.304162  ...
30.320887  30.290838  30.267185  30.266362  30.291067  ...
30.283082  30.261035  30.317169  30.344533  30.291326  ...
30.291616  30.259041  30.325858  30.388146  30.412823  ...
30.475903  30.488303  30.438121  30.437987  30.487398  ...
30.010046  30.136612  30.152144  30.150790  30.140454  ...
30.163660  30.150643  30.179445  30.206174  30.228868  ...
30.197547  30.209118  30.218125  30.234956  30.205044  ...
30.257223  30.280855  30.317946  30.324549  30.307722  ...
30.248404  30.204121  30.211253  30.256879  30.222708  ...
30.243674  30.207370  30.161687  30.127794  30.112944  ...
30.117929  30.114918  30.085956  30.116115  30.119781  ...
30.141088  30.177474  30.159617  30.189204  30.222891  ...
30.262303  30.236147  30.269035  30.299080  30.271571  ...
30.213669  30.185030  30.171006  30.188862  30.221094  ...
30.262639  30.322570  30.336227  30.346011  30.288714  ...
30.319089  30.354509  30.357616  30.370738  30.326631  ...
30.356188  30.369788  30.450498  30.462671  30.415313  ...
30.447915  30.504606  30.406946  30.421828  30.369011  ...
30.366369  30.328535  30.328211  30.309634  30.298679  ...
30.345628  30.306647  30.375942  30.375356  30.372478  ...
30.343466  30.355193  30.350768  30.364394  30.340606  ...
30.332846  30.304331  30.308121  30.311953  30.265773  ...
29.806183  29.931360  29.986044  29.996164  29.927414  ...
30.009364  30.059084  30.149064  30.162289  30.306384  ...
30.361495  30.405870  30.360873  30.366759  30.355742  ...
30.309201  30.265933  30.221968  30.225000  30.258982  ...
30.235596  30.331387  30.325157  30.374916  30.398007  ...
30.420202  30.465272  30.405878  30.443505  30.432967  ...
30.477550  30.513892  30.406318  30.415629  30.441556  ...
30.442189  30.434956  30.343281  30.388820  30.244402  ...
30.211925  30.259785  30.360014  30.355619  30.316449  ...
30.240523  30.320098  30.318964  30.331068  30.336524  ...
30.370167  30.361360  30.442356  30.438570  30.411574  ...
30.448873  30.496574  30.508553  30.506421  30.569699  ...
];

%new decoder: 0.176312, 0.722923
c4_c4 = [ 29.141745  30.175989  30.211557  30.219303  30.244940  ...
30.195220  30.167841  30.146168  30.175940  30.198901  ...
30.239075  30.206340  30.214588  30.243306  30.260579  ...
30.289951  30.332840  30.360919  30.379323  30.346251  ...
30.300150  30.287602  30.283560  30.284101  30.315207  ...
30.259110  30.256216  30.214187  30.229910  30.269734  ...
30.278129  30.248965  30.284478  30.351465  30.367333  ...
30.385720  30.393281  30.388169  30.408732  30.435323  ...
30.436521  30.422246  30.448990  30.475239  30.420585  ...
30.406402  30.387333  30.418286  30.435417  30.441793  ...
30.409074  30.472573  30.516174  30.537667  30.442642  ...
30.372208  30.382977  30.375255  30.384399  30.382942  ...
30.423512  30.343295  30.437086  30.480039  30.418521  ...
30.454063  30.497112  30.503531  30.495484  30.462841  ...
30.483941  30.462547  30.456592  30.431486  30.455597  ...
30.492971  30.444323  30.533863  30.531176  30.448265  ...
30.348466  30.335849  30.329828  30.313321  30.312111  ...
30.347815  30.349520  30.268949  30.293857  30.239426  ...
29.797676  29.898410  29.980680  29.957604  29.892009  ...
29.920911  29.996835  30.074880  30.093877  30.226252  ...
30.246039  30.316477  30.305982  30.326145  30.336512  ...
30.319191  30.334033  30.345243  30.352340  30.273047  ...
30.271077  30.302740  30.286867  30.334719  30.340264  ...
30.348680  30.362864  30.319505  30.362053  30.315701  ...
30.383794  30.382597  30.432327  30.465011  30.458082  ...
30.472073  30.505985  30.469897  30.506915  30.306059  ...
30.322073  30.295597  30.270768  30.268940  30.298027  ...
30.288064  30.258909  30.314015  30.344216  30.294018  ...
30.295832  30.264776  30.326185  30.390835  30.413020  ...
30.474410  30.487988  30.435321  30.435055  30.487088  ...
30.009000  30.135829  30.155355  30.154194  30.146909  ...
30.169983  30.151216  30.183622  30.210750  30.233902  ...
30.201746  30.213854  30.226019  30.242757  30.213176  ...
30.266118  30.288213  30.325159  30.331327  30.318297  ...
30.258120  30.217779  30.223005  30.274691  30.243791  ...
30.265462  30.229074  30.179522  30.144272  30.127207  ...
30.137243  30.134638  30.102999  30.128586  30.133084  ...
30.153459  30.190120  30.172459  30.205370  30.238237  ...
30.276876  30.244976  30.287433  30.316987  30.282137  ...
30.228393  30.201832  30.184384  30.205994  30.243677  ...
30.283293  30.345549  30.357759  30.369200  30.311211  ...
30.336677  30.372989  30.375184  30.388950  30.347606  ...
30.376643  30.389780  30.470261  30.482259  30.434709  ...
30.466260  30.516616  30.414985  30.432446  30.378860  ...
30.377310  30.336734  30.341133  30.319503  30.306913  ...
30.350139  30.310883  30.383521  30.381909  30.373397  ...
30.351911  30.357187  30.356111  30.370354  30.349125  ...
30.337483  30.306404  30.314037  30.319968  30.273454  ...
29.824484  29.933358  29.985006  29.996672  29.929700  ...
30.008659  30.064096  30.153083  30.168320  30.313369  ...
30.368796  30.411643  30.366349  30.373210  30.368136  ...
30.316375  30.274832  30.227907  30.230118  30.277205  ...
30.242259  30.346739  30.333207  30.383883  30.405175  ...
30.439797  30.488766  30.426692  30.464049  30.454142  ...
30.499559  30.531459  30.420469  30.434374  30.456378  ...
30.457848  30.451516  30.361498  30.404626  30.256915  ...
30.217308  30.263317  30.365486  30.362028  30.329123  ...
30.264392  30.333851  30.347584  30.359135  30.369926  ...
30.396266  30.380151  30.459016  30.456525  30.427096  ...
30.463949  30.510586  30.524611  30.521344  30.581583  ...
];

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end

legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

%break;

%%%%%%%%%%%%%%%%%%%%%%%
%
% Suzie
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Suzie ';

f_f = [ 31.290613  32.158118  32.491311  32.634529  32.630814  ...
32.644076  32.633732  32.692606  32.576851  32.629230  ...
32.680562  32.700839  32.654917  32.744633  32.637788  ...
32.730674  32.829320  32.947986  32.866877  32.869356  ...
32.918942  32.872307  32.890793  32.954678  32.908282  ...
32.958103  33.000186  33.009561  33.047510  33.022301  ...
33.074032  33.091042  33.155806  33.192262  33.228007  ...
33.208875  33.320639  33.354288  33.242016  33.154536  ...
32.989525  33.052728  32.915093  32.942996  33.098060  ...
33.230546  33.298364  33.400060  33.705448  33.814622  ...
34.338370  34.849665  34.999744  34.864413  34.605088  ...
34.464548  34.420388  34.178122  34.295531  34.240941  ...
34.003855  33.913924  33.946782  33.644859  33.404052  ...
33.121372  33.085590  32.985619  32.875489  33.023226  ...
32.992038  33.179853  33.199303  33.197602  32.854163  ...
32.768092  32.829851  32.820780  32.932660  33.057052  ...
32.896252  32.746136  32.799098  32.747460  32.603333  ...
32.728140  32.707908  32.652475  32.625630  32.554718  ...
32.630239  32.690324  32.667752  32.617909  32.542813  ...
32.603012  32.723041  32.747083  32.717165  32.827000  ...
]; 

%encoder
f_f = [ 31.237752  32.091229  32.404781  32.568921  32.576517  ...
32.618443  32.659363  32.652155  32.578468  32.583219  ...
32.614703  32.686203  32.611533  32.697586  32.663921  ...
32.650772  32.766961  32.846375  32.841658  32.950709  ...
32.952914  32.855378  32.907278  32.925821  32.937099  ...
32.947882  32.952196  33.034574  33.010204  33.079786  ...
33.033568  33.028918  33.002669  33.095630  33.094807  ...
33.207557  33.177020  33.264171  33.083703  33.046272  ...
32.998656  32.980172  32.915423  32.996512  33.038541  ...
33.258637  33.316209  33.330092  33.558102  33.701219  ...
34.111999  34.564878  34.789348  34.710824  34.558730  ...
34.246220  34.164364  34.219039  34.148991  34.122424  ...
33.872363  33.833514  33.672377  33.491853  33.298978  ...
33.147976  33.100847  32.828218  32.791539  32.873818  ...
32.868188  32.913351  33.060191  32.945103  32.825106  ...
32.858400  32.871245  32.891162  32.985954  32.988628  ...
32.777304  32.676880  32.732385  32.666218  32.663945  ...
32.688743  32.604980  32.637159  32.594967  32.554779  ...
32.656389  32.824419  32.737713  32.615776  32.544266  ...
32.574872  32.615795  32.712083  32.669185  32.690368  ...
]; 

%decoder: 0.104223, mad: 0.418
c4_c4 = [ 31.237241  32.090725  32.406853  32.572413  32.578459  ...
32.620047  32.660661  32.651762  32.578330  32.581662  ...
32.615670  32.684071  32.610327  32.699023  32.665240  ...
32.653873  32.769084  32.844792  32.839914  32.953247  ...
32.952462  32.855500  32.910404  32.927140  32.937499  ...
32.947181  32.949171  33.029886  33.006553  33.074011  ...
33.030882  33.025743  32.997468  33.091772  33.087054  ...
33.196810  33.165147  33.253835  33.070969  33.036822  ...
32.991392  32.970238  32.905143  32.989734  33.031920  ...
33.250441  33.306758  33.315869  33.530881  33.664245  ...
34.099911  34.514121  34.781813  34.670206  34.560914  ...
34.258335  34.160303  34.211575  34.153570  34.128175  ...
33.867494  33.814184  33.653322  33.412398  33.221844  ...
33.064709  33.018254  32.766054  32.726565  32.789304  ...
32.742299  32.761732  32.916089  32.808305  32.673353  ...
32.733072  32.750497  32.773948  32.861684  32.851820  ...
32.676929  32.545677  32.614121  32.557106  32.565404  ...
32.589094  32.479760  32.519449  32.454468  32.428083  ...
32.536405  32.704006  32.632553  32.500904  32.437833  ...
32.477885  32.527718  32.631659  32.562831  32.590558  ...
]; 

%new decoder: 0.1007, 0.4110
c4_c4 = [ 31.237563  32.092316  32.405258  32.570940  32.577724  ...
32.619850  32.659679  32.652053  32.578960  32.583940  ...
32.615150  32.686223  32.612461  32.698062  32.663074  ...
32.651082  32.767086  32.844346  32.840811  32.949233  ...
32.952087  32.855658  32.906831  32.927016  32.938789  ...
32.949914  32.953070  33.035274  33.011485  33.080996  ...
33.034977  33.031258  33.004558  33.096425  33.093523  ...
33.205225  33.176237  33.264216  33.084839  33.046644  ...
33.000454  32.980240  32.916218  32.995876  33.033721  ...
33.246622  33.302477  33.317759  33.537368  33.680229  ...
34.111510  34.521064  34.777963  34.673475  34.554810  ...
34.257984  34.166104  34.217055  34.147430  34.122615  ...
33.868399  33.815745  33.648679  33.405529  33.221960  ...
33.062047  33.016955  32.757662  32.723949  32.790231  ...
32.753681  32.768830  32.926793  32.811763  32.679888  ...
32.738094  32.755902  32.785489  32.873098  32.866995  ...
32.687945  32.550179  32.626233  32.571217  32.574429  ...
32.600647  32.492293  32.522373  32.466775  32.434559  ...
32.537388  32.709029  32.637474  32.504899  32.438720  ...
32.482471  32.526954  32.637648  32.561010  32.594713  ...
]; 

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);


figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end

legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);
