function bin263_all_small(colorplot)
% Comparision of Floating DCt and binDCT-C4 for all sequence,
  % with smaller quantization steps: A4 q 2
%
%Encoder command:
% ./tmn -i ../***.qcif -o ***_rec_flt.qcif -B ***_flt.cmp -b 99 -k 0 -A 4 -q 2
% ./tmn -i ../***.qcif -o ***_rec_c4.qcif  -B ***_c4.cmp  -b 99 -k 0 -X c4 -A 4 -q 2

%Decoder command:
% ./tmndec -o5 ../***_flt.cmp -s ***_rec_flt.qcif
% ./tmndec -dc4 -o5 ../***_c4.cmp  -s ***_rec_c4.qcif
%
% Possible Problems:
% 
% Bug in decoder caused the decoder result drops a lot when the scene changes.
% check for it!
%
%
% Jie Liang, 10/16/2000

if nargin == 0
   colorplot = 1;
end

%%%%%%%%%%%%%%%%%%%%%%%
%
% Miss America
%
%%%%%%%%%%%%%%%%%%%%%%%

close all;

t1 = 'Miss America ';

f_f = [ 42.648899  44.609740  44.819638  44.726469  44.659768  ...
44.736496  44.730226  44.821557  44.763402  44.874991  ...
44.919592  44.780403  44.889184  44.948072  44.771459  ...
44.794210  44.782939  44.796754  44.754100  44.675671  ...
44.740341  44.807663  44.871835  44.962258  44.817320  ...
44.680546  44.735006  44.743089  44.756699  44.779690  ...
44.699323  44.713343  44.681707  44.744425  44.636790  ...
44.705471  44.917710  44.884151  44.952850  44.968045  ...
44.764270  44.645844  44.588919  44.752683  44.715762  ...
44.682172  44.711861  44.630126  44.617288  44.567970  ...
44.526598  44.487986  44.477333  44.519728  44.636100  ...
44.709132  44.621716  44.621945  44.573254  44.595595  ...
44.654686  44.750243  44.713499  44.665397  44.883502  ...
44.744425  44.736888  44.854554  44.783890  44.844572  ...
44.703680  44.714904  44.747726  44.844009  44.838145  ...
45.093683  44.927124  44.958955  44.845618  44.835095  ...
44.855038  44.827880  44.922619  44.982961  44.867548  ...
44.741911  44.740733  44.686279  44.658382  44.696991  ...
44.667790  44.665937  44.816122  44.847548  44.759852  ...
44.786269  44.684496  44.831005  44.769878  44.722480  ...
]; 

%10/20: 1228-scaled encoder side
%-0.0277, 0.218
e_c4_c4 = [ 42.632200  44.812528  44.966308  44.873291  44.877988  ...
44.866821  44.864801  44.929337  44.872806  44.909786  ...
44.945437  44.939681  44.973260  44.990189  44.789285  ...
44.833009  44.907501  44.882447  44.877016  44.773515  ...
44.765534  44.743561  44.849802  44.920082  44.860522  ...
44.810454  44.849802  44.761745  44.833731  44.850204  ...
44.762298  44.695359  44.704614  44.662158  44.614923  ...
44.640931  44.786904  44.809736  44.818039  44.820757  ...
44.682017  44.614160  44.649839  44.685969  44.728426  ...
44.731950  44.621334  44.627984  44.530411  44.543220  ...
44.501636  44.410903  44.446338  44.454415  44.638399  ...
44.704069  44.646381  44.615228  44.518087  44.528990  ...
44.554787  44.720995  44.770194  44.711549  44.800573  ...
44.763008  44.742461  44.759852  44.781036  44.882934  ...
44.787459  44.880906  44.882528  44.916975  44.937955  ...
45.045921  45.000845  44.983708  44.846985  44.911010  ...
44.930650  44.882447  44.970445  44.975331  44.899269  ...
44.796595  44.836780  44.750479  44.817480  44.715294  ...
44.753313  44.793256  44.905299  44.828120  44.749850  ...
44.825638  44.781512  44.813486  44.759616  44.764744  ...
]; 

%10/20: both side use the 128-scaled q table
%0.1223, 0.3168
d_c4_c4 = [ 42.632490  44.810693  44.960771  44.861732  44.861571  ...
44.849721  44.832608  44.895770  44.846824  44.873210  ...
44.915585  44.903832  44.931470  44.956066  44.761430  ...
44.787856  44.861894  44.834373  44.812768  44.703291  ...
44.724044  44.697380  44.792700  44.833250  44.791429  ...
44.691787  44.746154  44.627525  44.734458  44.724748  ...
44.650531  44.560658  44.579831  44.494954  44.498071  ...
44.493322  44.670879  44.663314  44.694660  44.701657  ...
44.556367  44.448540  44.524133  44.523087  44.594304  ...
44.519206  44.421832  44.398696  44.361487  44.345259  ...
44.319106  44.223560  44.250334  44.277769  44.474453  ...
44.489097  44.506840  44.387608  44.333020  44.325879  ...
44.338670  44.502527  44.566537  44.485838  44.605020  ...
44.542920  44.558249  44.537672  44.604411  44.730461  ...
44.657765  44.694583  44.753470  44.792700  44.771459  ...
44.817799  44.887641  44.781670  44.665166  44.725452  ...
44.741676  44.644845  44.767745  44.687675  44.638783  ...
44.536024  44.654840  44.523610  44.607836  44.490876  ...
44.505501  44.481399  44.624237  44.533254  44.521519  ...
44.571517  44.518311  44.526748  44.559227  44.484358  ...
]; 

f_f = f_f;
c4_c4 = d_c4_c4;

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end
legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

%break;

%%%%%%%%%%%%%%%%%%%%%%%
%
% Car Phone
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Car Phone ';

f_f = [ 39.831399  42.174639  42.502273  42.603597  42.560093  ...
42.724235  42.689193  42.773564  42.755286  42.675655  ...
42.696395  42.699337  42.739262  42.782957  42.718662  ...
42.731841  42.604605  42.656520  42.735352  42.663424  ...
42.603213  42.706310  42.689193  42.629061  42.706507  ...
42.830888  42.729123  42.560806  42.671363  42.666199  ...
42.678242  42.662889  42.664690  42.716298  42.761752  ...
42.815490  42.623416  42.776360  42.777409  42.660700  ...
42.645990  42.740005  42.738866  42.652344  42.947544  ...
42.791669  42.676826  42.652829  42.789865  42.694875  ...
42.706359  42.801905  42.702430  42.794025  42.737084  ...
42.792772  42.673362  42.777159  42.778808  42.687774  ...
42.788312  42.702037  42.842586  42.729864  42.868423  ...
42.881297  42.877308  42.903147  42.850961  42.797386  ...
42.849945  42.747787  42.754342  42.795379  42.708965  ...
42.770970  42.751312  42.759910  42.739361  42.770870  ...
42.719352  42.761403  42.817507  42.795179  42.809598  ...
42.754192  42.731100  42.669803  42.784758  42.774213  ...
42.682150  42.686502  42.709506  42.729172  42.824369  ...
42.901194  42.838126  42.909786  42.888722  42.778358  ...
]; 

%encoder
%10/20 128-scaled encoder
%-0.36, 0.6048, consisitent better than H.263
new_e_c4_c4 = [ 39.824610  42.779507  42.921234  43.021048  43.024801  ...
42.998020  43.132796  43.238710  43.157916  43.124672  ...
43.110733  43.200437  43.081757  43.124293  43.125051  ...
43.150942  43.054570  43.037830  43.131279  43.091788  ...
42.912774  43.040801  43.096194  43.060644  43.152956  ...
43.160315  43.123211  43.068436  43.050366  43.105935  ...
43.122129  43.103135  42.981339  43.108738  43.028505  ...
43.178247  43.035073  43.037459  43.068062  42.947596  ...
43.132905  43.073941  43.085724  42.900783  43.109709  ...
43.003384  43.050844  43.029828  43.100981  43.021313  ...
42.923765  43.123427  43.064538  43.049142  43.131604  ...
43.063471  43.103942  43.163918  43.215440  43.044253  ...
43.123427  43.064965  43.160152  43.141642  43.165775  ...
43.181042  43.194384  43.155081  43.057553  43.073407  ...
43.180823  43.144468  43.131170  43.180111  43.065339  ...
43.169983  43.135888  43.158570  43.109709  43.090392  ...
43.194879  43.155953  43.285064  43.159661  43.191031  ...
43.207270  43.161243  43.036133  43.112514  43.117535  ...
43.047228  43.082507  43.092594  43.127812  43.144794  ...
43.143490  43.054357  43.155735  43.170639  43.057500  ...
]; 

new_e_c4_c4_64 = [ 39.821195  42.806177  42.922680  43.040695  43.064538  ...
43.021630  43.128191  43.177645  43.201979  43.168288  ...
43.090231  43.149417  43.124942  43.134965  43.078115  ...
43.186583  43.006279  43.032900  43.135345  43.115753  ...
43.049408  43.152630  43.155680  43.152194  43.167414  ...
43.097485  43.151595  43.048451  43.106151  43.168890  ...
43.144794  43.141316  43.018883  43.060058  43.063258  ...
43.235600  43.090553  43.086099  43.157697  42.984691  ...
43.093722  43.070840  43.166594  42.971977  43.199501  ...
43.037459  43.040960  43.072391  43.208153  43.079614  ...
43.048451  43.168343  43.133664  43.063791  43.144957  ...
43.036133  43.091251  43.220250  43.180330  43.151159  ...
43.148112  43.119102  43.142946  43.182139  43.173374  ...
43.163863  43.199391  43.201759  43.114187  43.107768  ...
43.159715  43.125051  43.103242  43.160097  43.087762  ...
43.105289  43.180330  43.125700  43.162171  43.208539  ...
43.202695  43.268252  43.344538  43.209201  43.157534  ...
43.194879  43.180933  43.109062  43.158079  43.097538  ...
43.112729  43.092003  43.139796  43.120561  43.215551  ...
43.207325  43.124942  43.095710  43.156989  43.139904  ...
]; 

%-0.449, 0.689, 10/19 version, better?
e_c4_c4 = [ 39.927800  42.864293  43.045793  43.142240  43.126837  ...
43.124834  43.206774  43.259648  43.240265  43.197354  ...
43.219974  43.309784  43.254292  43.215606  43.213231  ...
43.284166  43.088621  43.103673  43.250781  43.221689  ...
43.105450  43.196089  43.227226  43.193119  43.219476  ...
43.189767  43.197850  43.118940  43.156662  43.245937  ...
43.178138  43.265289  43.061551  43.185156  43.185320  ...
43.281641  43.118237  43.163153  43.171514  43.045315  ...
43.224567  43.106151  43.274017  43.088782  43.250948  ...
43.178795  43.124239  43.099044  43.155081  43.146915  ...
43.074744  43.218757  43.174469  43.100712  43.235267  ...
43.167250  43.133122  43.241321  43.252174  43.209532  ...
43.186418  43.193614  43.227336  43.192020  43.165119  ...
43.203136  43.297040  43.241321  43.155571  43.133935  ...
43.205230  43.187186  43.207546  43.221301  43.184936  ...
43.235933  43.156662  43.191361  43.223183  43.175181  ...
43.230828  43.290627  43.296759  43.258978  43.277939  ...
43.214446  43.187900  43.116671  43.172827  43.154918  ...
43.110895  43.126729  43.178960  43.186967  43.309501  ...
43.225121  43.182303  43.208373  43.231494  43.194989  ...
]; 

%decoder: encoder 1s 128-scaled, decoder round off.
%0.275, 1.043, bad
d_c4_c4 = [ 39.913232  42.863376  42.981496  43.032370  42.974224  ...
42.927745  43.007912  43.036822  43.013552  42.936234  ...
42.982858  43.037193  42.912877  42.879660  42.881348  ...
42.945830  42.685181  42.680440  42.887236  42.863987  ...
42.735649  42.753497  42.807234  42.792070  42.779757  ...
42.702135  42.722854  42.662451  42.671802  42.800398  ...
42.732830  42.756578  42.544110  42.586306  42.550316  ...
42.646087  42.504946  42.479779  42.464738  42.292535  ...
42.511943  42.351913  42.529742  42.331985  42.362796  ...
42.370613  42.430614  42.375938  42.418961  42.359483  ...
42.207679  42.481831  42.504383  42.350328  42.529600  ...
42.395246  42.369249  42.485146  42.476841  42.402251  ...
42.367430  42.381361  42.370249  42.283564  42.256364  ...
42.325948  42.353000  42.279643  42.205533  42.211449  ...
42.255256  42.222821  42.215309  42.173379  42.142151  ...
42.142151  42.096004  42.135553  42.134390  42.131892  ...
42.204263  42.257516  42.323247  42.252644  42.201988  ...
42.144007  42.196609  42.066556  42.088453  42.125224  ...
42.010763  42.059479  42.039160  42.031917  42.129396  ...
41.918013  41.868053  41.866635  41.936413  41.894632  ...
]; 

%10/20: 128-scaled encoder and decoder
%-0.155, 0.606, error accumulated.
new_c4_c4 = [ 39.826483  42.780907  42.914526  43.011021  43.022264  ...
42.982439  43.124618  43.224733  43.140610  43.090499  ...
43.062138  43.165065  43.044412  43.093829  43.069505  ...
43.105127  43.006964  42.971716  43.058832  43.009176  ...
42.840152  42.961177  42.996759  42.963835  43.054890  ...
43.054943  43.008860  42.968426  42.951806  43.018091  ...
43.013816  42.990511  42.868015  42.987626  42.914372  ...
43.050366  42.913701  42.910970  42.945778  42.796734  ...
42.998756  42.919685  42.954043  42.769473  42.951130  ...
42.843803  42.895749  42.863427  42.922938  42.851621  ...
42.759711  42.913856  42.873936  42.863885  42.943079  ...
42.872455  42.920408  42.944429  42.961124  42.808391  ...
42.878024  42.814281  42.912001  42.865975  42.902119  ...
42.906285  42.931211  42.882371  42.755832  42.784608  ...
42.880888  42.868627  42.800398  42.878484  42.788363  ...
42.842484  42.782607  42.810605  42.721078  42.753149  ...
42.829977  42.804166  42.908344  42.801654  42.846137  ...
42.819524  42.794627  42.656423  42.722262  42.738024  ...
42.640082  42.677656  42.668244  42.703068  42.735253  ...
42.657152  42.538669  42.616286  42.661041  42.632200  ...
]; 

%new decoder with +64 before /128.
new_c4_c4_64 = [ 39.820360  42.805323  42.921957  43.034437  43.050259  ...
43.009387  43.113431  43.148928  43.174524  43.124455  ...
43.040324  43.110733  43.075332  43.077205  43.029881  ...
43.141968  42.959509  43.001806  43.084330  43.071108  ...
42.990039  43.087065  43.093615  43.078490  43.071322  ...
43.018196  43.061978  42.951078  43.012708  43.080793  ...
43.041704  43.012603  42.904587  42.944273  42.966913  ...
43.131387  42.973284  42.964617  43.020309  42.865159  ...
42.957686  42.921905  43.031999  42.835189  43.034490  ...
42.855536  42.882678  42.908087  43.051749  42.950714  ...
42.878944  42.983591  42.953887  42.894107  42.987941  ...
42.881348  42.933385  43.028240  43.013974  42.965974  ...
42.907057  42.913031  42.933282  42.924746  42.905410  ...
42.919169  42.919737  42.922318  42.823510  42.836961  ...
42.862153  42.873169  42.834530  42.915558  42.844158  ...
42.817809  42.880376  42.832355  42.853299  42.908395  ...
42.895698  42.923145  43.013763  42.910249  42.843803  ...
42.848421  42.849488  42.755385  42.836657  42.804016  ...
42.761602  42.734313  42.754491  42.752801  42.838683  ...
42.806580  42.715805  42.670973  42.764042  42.795781  ...
]; 

%I option: first frame improved by 0.8 dB. Good.
%-0.1192, 0.7857, show error accum.
c4_c4_i = [ 40.617197  42.704934  42.891234  42.905925  42.980763  ...
42.984115  43.044199  43.111596  43.162225  42.960082  ...
42.994605  42.965139  42.971351  43.013869  42.999650  ...
43.092701  42.966287  42.929814  43.040536  43.007649  ...
42.981444  43.000228  43.023004  42.977885  43.021260  ...
43.001280  42.984324  42.941159  42.931056  43.036398  ...
43.006964  42.966756  42.866944  42.995656  42.938877  ...
42.976943  42.885699  42.899344  42.915661  42.775012  ...
42.824672  42.857520  42.938670  42.742779  42.911125  ...
42.798792  42.787261  42.803915  42.865669  42.849792  ...
42.730803  42.928365  42.889439  42.878944  42.862917  ...
42.827804  42.849894  42.877410  42.884419  42.765935  ...
42.859098  42.789164  42.893183  42.785859  42.837872  ...
42.812115  42.834277  42.724334  42.679805  42.715756  ...
42.804920  42.714968  42.713196  42.733473  42.733423  ...
42.768327  42.746398  42.781107  42.735154  42.703903  ...
42.759960  42.785209  42.896570  42.837113  42.759413  ...
42.759264  42.744316  42.600143  42.695806  42.661527  ...
42.628288  42.616479  42.615709  42.622838  42.661381  ...
42.584824  42.603645  42.583439  42.645312  42.635196  ...
]; 


f_f = new_c4_c4;
c4_c4 = new_c4_c4_64;

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end
legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

%%%%%%%%%%%%%%%%%%%%%%%
%
% Foreman
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Foreman ';

f_f = [ 38.872140  41.312405  41.435231  41.450625  41.441764  ...
41.492599  41.391626  41.419892  41.417591  41.436845  ...
41.378105  41.444336  41.399548  41.331520  41.345651  ...
41.335927  41.381834  41.354642  41.532132  41.367477  ...
41.373113  41.304604  41.356983  41.441654  41.329766  ...
41.358604  41.433655  41.440699  41.321827  41.292415  ...
41.242559  41.385640  41.304284  41.329981  41.332487  ...
41.229144  41.249546  41.209707  41.168194  41.247228  ...
41.243647  41.222120  41.266304  41.242770  41.278137  ...
41.258974  41.318220  41.496019  41.488476  41.391662  ...
41.397839  41.332165  41.307025  41.257178  41.411896  ...
41.304854  41.325973  41.407376  41.453275  41.521944  ...
41.393950  41.323614  41.386002  41.281393  41.192125  ...
41.318434  41.313617  41.127451  41.145424  41.148856  ...
41.190114  41.144669  41.144395  41.170989  41.164368  ...
41.224110  41.200629  41.200247  41.290819  41.339369  ...
41.288407  41.260876  41.329945  41.345508  41.334887  ...
41.320112  41.336464  41.379987  41.418869  41.336464  ...
41.449999  41.423256  41.369752  41.416897  41.460721  ...
41.411313  41.469287  41.343389  41.399476  41.590955  ...
41.624995  41.652282  41.571271  41.581121  41.580514  ...
41.491076  41.505066  41.687352  41.413210  41.370294  ...
41.378213  41.288549  41.294012  41.327833  41.357991  ...
41.233482  41.243577  41.168746  41.114453  41.192090  ...
41.185610  41.174164  41.364986  41.411422  41.293019  ...
41.201428  41.182461  41.262215  41.666995  41.540653  ...
41.395622  41.281180  41.232222  41.178172  41.320648  ...
41.348095  41.298772  41.243050  41.240174  41.340840  ...
41.261439  41.396967  41.311086  41.404207  41.454012  ...
41.434645  41.364012  41.370113  41.351008  41.204313  ...
41.243156  41.290996  41.273471  41.290712  41.590993  ...
41.242314  41.228829  41.186822  41.179555  41.258833  ...
41.420075  41.187515  41.178933  41.281180  41.274390  ...
41.201845  41.276122  41.255524  41.326438  41.310373  ...
41.398675  41.433655  41.450993  41.527784  41.519176  ...
41.533257  41.546895  41.501415  41.512675  41.443638  ...
41.465297  41.244384  41.213085  41.307737  41.264717  ...
41.198058  41.210333  41.204070  41.102956  41.222853  ...
41.254961  41.322684  41.416860  41.475390  41.468400  ...
41.487845  41.480464  41.470692  41.759736  41.655869  ...
41.644963  41.695521  41.586624  41.554352  41.506072  ...
41.555068  41.574943  41.657567  41.844294  41.741517  ...
41.548626  41.544299  41.567224  41.538249  41.482318  ...
41.505550  41.482837  41.490221  41.726392  41.752155  ...
41.617913  41.498996  41.551639  41.460057  41.445880  ...
41.408761  41.445916  41.305992  41.334350  41.260171  ...
41.302043  41.253589  41.364806  41.314366  41.220444  ...
41.235864  41.230508  41.250073  41.212458  41.210473  ...
41.225962  41.213782  41.281818  41.376657  41.686070  ...
41.623310  41.635044  41.780811  41.602336  41.692135  ...
41.783592  41.723726  41.907942  42.007456  41.993797  ...
41.659961  41.867729  41.949646  41.573618  41.409563  ...
41.425926  41.445916  41.536935  41.496726  41.557896  ...
41.516111  41.593465  41.631551  41.648467  41.762622  ...
41.796526  41.772480  41.743603  41.806700  41.769984  ...
41.763888  41.854905  42.026534  41.919079  41.901078  ...
42.032085  42.136846  42.156546  42.255522  42.427571  ...
42.554063  42.675509  42.894774  43.087655  43.047228  ...
42.984691  42.844615  42.821794  42.784508  42.696198  ...
42.589510  42.397076  42.505087  42.546288  42.637953  ...
42.705917  42.966234  43.074155  43.060644  42.882269  ...
42.781557  42.610754  42.568988  42.550363  42.390948  ...
42.203607  42.062867  41.881566  41.875880  41.862830  ...
41.727765  41.566242  41.242559  41.097320  40.949265  ...
40.983337  40.821539  40.853497  40.870273  40.935547  ...
41.185749  40.962697  40.932247  40.853529  40.867215  ...
40.735066  40.769537  40.713024  40.707034  40.718368  ...
40.724062  40.673393  40.789214  40.813491  40.747538  ...
40.756720  40.760486  40.819024  40.803903  40.765543  ...
40.713272  40.707313  40.786749  40.838991  40.764192  ...
40.814953  40.763029  40.657635  40.722101  40.739376  ...
40.605275  40.649119  40.600643  40.678997  40.656654  ...
40.704895  40.646580  40.576832  40.593144  40.584784  ...
40.639796  40.675209  40.613584  40.574846  40.563399  ...
40.484138  40.683652  40.695729  40.618078  40.511535  ...
40.674931  40.543911  40.495141  40.516726  40.460311  ...
40.459081  40.461601  40.619324  40.548274  40.637293  ...
40.630523  40.643523  40.516578  40.602519  40.644195  ...
40.759324  40.813268  40.663526  40.805870  40.748227  ...
40.690011  40.569645  40.540925  40.560820  40.477074  ...
];

%10/19 encoder
%-0.5332, 0.8905
e_c4_c4 = [ 38.973977  41.901159  41.971831  42.042490  42.028930  ...
41.977478  41.944199  41.992087  41.934150  41.948036  ...
41.925437  41.868337  41.949357  41.845705  41.846269  ...
41.817900  41.849617  41.900874  42.001060  42.019019  ...
41.966067  41.925684  41.844738  41.863639  41.903406  ...
41.887178  41.838898  41.906184  41.751209  41.835921  ...
41.808299  41.912893  41.853249  41.845665  41.914653  ...
41.814938  41.819463  41.877829  41.712219  41.692563  ...
41.727883  41.668466  41.837610  41.759262  41.793458  ...
41.774066  41.908760  41.901364  41.986212  41.846874  ...
41.854703  41.852401  41.793617  41.801111  41.829973  ...
41.773273  41.702692  41.770736  41.832865  41.782519  ...
41.769627  41.756537  41.903160  41.863841  41.778667  ...
41.912442  41.869471  41.724667  41.718478  41.805902  ...
41.772797  41.741202  41.803825  41.779064  41.848487  ...
41.816579  41.811537  41.865258  41.900588  41.877544  ...
41.812897  41.773590  41.882216  41.841877  41.854622  ...
41.826400  41.946261  41.973284  41.970379  41.916660  ...
41.967973  41.914858  41.852724  41.900792  41.962835  ...
41.910151  41.983091  41.920883  41.908801  41.938348  ...
42.017886  42.170467  42.090755  42.049075  42.035958  ...
42.065580  41.955925  42.059606  42.015874  41.937566  ...
41.929175  41.874500  41.947128  42.002898  41.954561  ...
41.882379  41.822389  41.718752  41.651202  41.707648  ...
41.710304  41.795091  41.895447  41.898221  41.883192  ...
41.759815  41.704057  41.664443  41.900996  41.853855  ...
41.769350  41.775731  41.751130  41.700508  41.874500  ...
41.895651  41.904345  41.819944  41.786295  41.857531  ...
41.841354  41.867405  41.858097  41.814978  41.906552  ...
41.931806  41.918874  41.987420  41.947375  41.833669  ...
41.888237  41.855188  41.741911  41.800393  41.941108  ...
41.736325  41.757208  41.741635  41.714761  41.798798  ...
41.866109  41.720749  41.772797  41.780533  41.732868  ...
41.781010  41.884005  41.853451  41.875352  41.866190  ...
41.919652  41.944777  42.082702  42.027165  42.057955  ...
42.106136  42.149321  42.140900  42.100020  42.056600  ...
41.973450  41.839462  41.861332  41.893369  41.844536  ...
41.792184  41.832865  41.792223  41.698170  41.694665  ...
41.827483  41.882948  41.933821  42.098994  42.132323  ...
42.063885  41.934561  41.903038  42.104039  42.025358  ...
42.044557  42.094126  42.050511  42.080829  42.086322  ...
42.096645  42.026198  42.053174  42.242297  42.147290  ...
42.129654  42.108790  42.032674  42.066640  42.077682  ...
41.992796  41.985463  41.970918  42.023972  42.118394  ...
42.023090  41.870566  41.952619  41.958241  42.001728  ...
41.904468  41.841072  41.786374  41.829129  41.757603  ...
41.765391  41.808059  41.870120  41.728040  41.713705  ...
41.749789  41.819543  41.777993  41.850706  41.865542  ...
41.887382  41.873891  41.842320  41.893409  42.156676  ...
42.146987  42.221370  42.327569  42.262083  42.166994  ...
42.319200  42.304525  42.131720  42.272477  42.396252  ...
42.321718  42.421032  42.020487  42.024014  42.039792  ...
42.022334  42.005616  42.118265  42.002815  42.068592  ...
42.067107  42.173248  42.208643  42.219437  42.266522  ...
42.402434  42.503211  42.499601  42.474185  42.378535  ...
42.369840  42.174466  42.143316  42.142237  42.331444  ...
42.417122  42.459860  42.752652  42.936908  42.999807  ...
43.222131  43.307017  43.284110  43.472897  43.432398  ...
43.383878  43.273569  43.115375  43.143163  43.020097  ...
43.276706  43.141805  42.985844  43.243601  43.243323  ...
43.349607  43.289053  43.113431  42.842839  42.717431  ...
42.648366  42.802508  42.794226  42.738420  42.622741  ...
42.282762  42.248042  42.128234  41.920473  41.842240  ...
42.079978  42.134218  41.867810  41.727883  41.722668  ...
41.716482  41.643077  41.697196  41.760764  41.578012  ...
41.656100  41.540803  41.550998  41.678771  41.501229  ...
41.526511  41.484172  41.501899  41.406683  41.493677  ...
41.522730  41.488179  41.456444  41.488847  41.584460  ...
41.620821  41.622812  41.500038  41.482688  41.366646  ...
41.491224  41.476649  41.499665  41.517569  41.458692  ...
41.386836  41.305921  41.308343  41.244419  41.196947  ...
41.235443  41.435781  41.477056  41.413064  41.395077  ...
41.263060  41.383646  41.361920  41.263589  41.201498  ...
41.229808  41.301830  41.109857  41.211239  41.179970  ...
41.004839  41.205983  41.292131  41.163162  41.034333  ...
41.074276  40.975512  41.086510  41.086104  41.101563  ...
41.113125  40.988231  41.083567  41.236880  41.233237  ...
41.227710  41.382197  41.319148  41.353346  41.275344  ...
41.396421  41.374523  41.293161  41.457660  41.470396  ...
41.281499  41.223971  41.166229  41.195698  41.089896  ...
];

%10/20 encoder side
%-0.4508, 0.7398, worse than 10/19 version, why?
new_e_c4_c4 = [ 38.876187  41.749986  41.845584  41.870444  41.919283  ...
41.915145  41.843690  41.809937  41.882135  41.805502  ...
41.803665  41.838576  41.805183  41.805662  41.675437  ...
41.706867  41.707258  41.765470  41.861332  41.835157  ...
41.835358  41.838375  41.812617  41.722551  41.720671  ...
41.788920  41.680905  41.772440  41.678500  41.719417  ...
41.762148  41.780970  41.800672  41.765985  41.754010  ...
41.673615  41.660270  41.720710  41.632165  41.651935  ...
41.697469  41.630055  41.684166  41.645348  41.671756  ...
41.695755  41.776049  41.860200  41.786096  41.783632  ...
41.848487  41.813017  41.713392  41.606454  41.806261  ...
41.689490  41.675553  41.786653  41.811497  41.743721  ...
41.751327  41.640578  41.787766  41.793259  41.689957  ...
41.779977  41.702107  41.604509  41.615504  41.676561  ...
41.624804  41.616766  41.623271  41.649006  41.652706  ...
41.688401  41.699378  41.685331  41.779580  41.736443  ...
41.628061  41.638732  41.685293  41.726157  41.731886  ...
41.706243  41.789278  41.795689  41.868053  41.818942  ...
41.834996  41.812897  41.722551  41.746478  41.848810  ...
41.798280  41.841475  41.853734  41.827363  41.876976  ...
41.975692  42.041605  42.026030  41.991753  42.076279  ...
42.038232  41.871620  42.062571  41.832584  41.807220  ...
41.768756  41.731062  41.741596  41.818661  41.823672  ...
41.762108  41.703238  41.628751  41.598336  41.542344  ...
41.532207  41.607064  41.778271  41.759855  41.734911  ...
41.639770  41.554880  41.589929  41.883761  41.805302  ...
41.691240  41.689451  41.618411  41.646426  41.758274  ...
41.688596  41.738684  41.702029  41.749040  41.748961  ...
41.798798  41.746557  41.747188  41.762780  41.855471  ...
41.860523  41.840025  41.869350  41.817860  41.730002  ...
41.776564  41.791148  41.702887  41.720475  41.948655  ...
41.650817  41.650701  41.641577  41.624229  41.667498  ...
41.743052  41.602679  41.643424  41.709171  41.615810  ...
41.632050  41.771648  41.783830  41.758788  41.755826  ...
41.809658  41.898915  41.865461  41.948944  41.967973  ...
42.033600  42.082745  42.013443  42.015622  41.965611  ...
41.952867  41.700703  41.675940  41.752905  41.712806  ...
41.709796  41.726039  41.662510  41.649738  41.697702  ...
41.667808  41.874581  41.885917  41.873607  41.989669  ...
41.946055  41.851876  41.839864  42.057150  41.943375  ...
41.958779  41.969176  41.951710  42.005490  41.976896  ...
41.982841  41.990128  41.950017  42.118651  42.066556  ...
41.917111  41.973740  41.963125  41.929093  42.022418  ...
41.901649  41.863194  41.786136  41.944076  42.035368  ...
41.925437  41.810497  41.874622  41.845584  41.891372  ...
41.819503  41.792223  41.766895  41.779144  41.678189  ...
41.678965  41.668272  41.714096  41.721963  41.629595  ...
41.654981  41.682264  41.717538  41.729570  41.766776  ...
41.744706  41.691046  41.711711  41.798957  42.009800  ...
42.038190  42.115262  42.196653  42.249988  42.066853  ...
42.225196  42.159058  42.275502  42.413675  42.452437  ...
42.180949  42.382137  42.393462  42.095065  41.896956  ...
41.931395  41.862587  41.994464  41.855551  41.977894  ...
41.950678  42.036589  41.985005  42.144698  42.165518  ...
42.297050  42.209301  42.308155  42.305107  42.389668  ...
42.266433  42.341915  42.549510  42.376394  42.437168  ...
42.533566  42.551976  42.634519  42.749078  42.874140  ...
43.040907  43.163972  43.254236  43.493643  43.382097  ...
43.419348  43.325567  43.303182  43.298336  43.244769  ...
43.137950  42.992033  43.014765  43.038732  43.089855  ...
43.165119  43.396763  43.448984  43.437280  43.356451  ...
43.150887  43.052015  42.898060  42.908807  42.731989  ...
42.536069  42.459024  42.320009  42.340830  42.256896  ...
42.159795  42.060283  41.838053  41.710187  41.611378  ...
41.607636  41.538549  41.593313  41.537348  41.540014  ...
41.638233  41.481280  41.530707  41.518765  41.422561  ...
41.338795  41.404352  41.370402  41.316864  41.387163  ...
41.353310  41.347376  41.356622  41.411058  41.420514  ...
41.487363  41.478056  41.381472  41.359649  41.278916  ...
41.415035  41.359649  41.336787  41.460573  41.374957  ...
41.303537  41.222678  41.232467  41.194414  41.096438  ...
41.179590  41.267998  41.253448  41.265740  41.291102  ...
41.114556  41.233167  41.173439  41.156966  41.085089  ...
41.148959  41.134699  41.048468  41.120043  41.031558  ...
40.909866  41.039955  41.142783  41.045349  40.825712  ...
41.036909  40.948937  40.908956  41.012618  40.927970  ...
40.938458  40.879169  40.939962  41.113295  41.176928  ...
41.169539  41.274107  41.203687  41.170022  41.204313  ...
41.278951  41.252042  41.218490  41.320327  41.295291  ...
41.158514  41.056325  41.086747  41.081977  40.977689  ...
];

%10/20: both side use the same scaled(by128) dequantization
%-0.1391(bindct better), 0.6541
new_c4_c4 = [ 38.877224  41.745966  41.838496  41.861737  41.903937  ...
41.888359  41.823110  41.796565  41.867648  41.778469  ...
41.787766  41.807539  41.768637  41.762820  41.635620  ...
41.663554  41.650933  41.712884  41.808019  41.777715  ...
41.763255  41.775731  41.746518  41.656293  41.662356  ...
41.721258  41.596204  41.667692  41.583245  41.622659  ...
41.668775  41.672608  41.688324  41.650971  41.633893  ...
41.570552  41.552279  41.608591  41.518466  41.543510  ...
41.581083  41.513049  41.570817  41.523403  41.546669  ...
41.580363  41.659188  41.735854  41.658107  41.641154  ...
41.695521  41.643578  41.559859  41.446468  41.639424  ...
41.532807  41.505140  41.585978  41.616728  41.541029  ...
41.573542  41.455780  41.606873  41.580856  41.505774  ...
41.573656  41.490259  41.392243  41.398675  41.469694  ...
41.410328  41.405408  41.414524  41.436258  41.462012  ...
41.505178  41.497730  41.486509  41.590461  41.527335  ...
41.450110  41.430613  41.478871  41.520111  41.499442  ...
41.519438  41.578998  41.581121  41.653901  41.599135  ...
41.603479  41.551450  41.457291  41.507675  41.623731  ...
41.570136  41.603022  41.631513  41.582942  41.637464  ...
41.713627  41.777715  41.755944  41.678073  41.757168  ...
41.736483  41.577709  41.739510  41.523441  41.508272  ...
41.466516  41.446725  41.444079  41.493491  41.496131  ...
41.427390  41.372824  41.294758  41.266516  41.271422  ...
41.253800  41.298950  41.446578  41.435011  41.428855  ...
41.313724  41.236354  41.274390  41.527185  41.471691  ...
41.329658  41.357847  41.295362  41.302790  41.417043  ...
41.333096  41.397985  41.359685  41.424938  41.390755  ...
41.448049  41.431272  41.434755  41.408250  41.474132  ...
41.468548  41.424463  41.446431  41.456296  41.341055  ...
41.369969  41.379335  41.331448  41.305708  41.456665  ...
41.178310  41.202158  41.210299  41.214549  41.297635  ...
41.343532  41.183568  41.274354  41.309625  41.231278  ...
41.226207  41.368993  41.360261  41.361884  41.361992  ...
41.405445  41.490593  41.462012  41.558689  41.508794  ...
41.580059  41.576307  41.541330  41.520896  41.478316  ...
41.502905  41.237686  41.185576  41.252604  41.182426  ...
41.175097  41.193061  41.147586  41.161819  41.238527  ...
41.222469  41.366574  41.368307  41.384951  41.474983  ...
41.406720  41.335604  41.330518  41.504432  41.474761  ...
41.464337  41.449300  41.448491  41.503687  41.478686  ...
41.443454  41.445549  41.428086  41.556954  41.495387  ...
41.369716  41.428342  41.393515  41.359829  41.467698  ...
41.352734  41.298203  41.277112  41.405299  41.447056  ...
41.338831  41.256791  41.284792  41.297244  41.295504  ...
41.196496  41.172300  41.145870  41.182115  41.071138  ...
41.063793  41.052227  41.032494  41.063086  40.977755  ...
40.975248  41.044142  41.075356  41.102616  41.115032  ...
41.138054  41.064399  41.103465  41.227325  41.379010  ...
41.419563  41.487251  41.512302  41.475724  41.378467  ...
41.465630  41.387054  41.536635  41.688712  41.728942  ...
41.494532  41.614893  41.621740  41.430576  41.260488  ...
41.276192  41.215316  41.328406  41.180696  41.264188  ...
41.245612  41.312227  41.218978  41.504172  41.461053  ...
41.579074  41.472948  41.541781  41.604432  41.718987  ...
41.679974  41.786533  41.973906  41.835800  41.896059  ...
41.959234  42.029225  42.112346  42.199844  42.365612  ...
42.558288  42.661722  42.831950  43.156880  43.125105  ...
43.176330  43.112999  43.114835  43.116941  43.078543  ...
42.993135  42.863070  42.901811  42.943909  43.026282  ...
43.100874  43.321545  43.389165  43.385889  43.308485  ...
43.102596  43.006490  42.847609  42.838430  42.682541  ...
42.493514  42.393416  42.250519  42.253883  42.176727  ...
42.077171  41.974280  41.749789  41.642000  41.531457  ...
41.516672  41.463451  41.507601  41.447792  41.446284  ...
41.541781  41.411276  41.444079  41.437652  41.337719  ...
41.247614  41.318755  41.283269  41.220967  41.290570  ...
41.246455  41.239648  41.225158  41.266728  41.316400  ...
41.379444  41.363218  41.263272  41.243682  41.165643  ...
41.293515  41.221770  41.222923  41.345077  41.263977  ...
41.170057  41.088541  41.092132  41.052092  40.934240  ...
41.009492  41.116293  41.096981  41.111423  41.139938  ...
40.946315  41.047159  40.991806  40.975149  40.882139  ...
40.957799  40.939504  40.872721  40.934926  40.850451  ...
40.722693  40.839790  40.933064  40.828645  40.610944  ...
40.798896  40.704833  40.674870  40.743721  40.658432  ...
40.660242  40.592903  40.623277  40.809964  40.952152  ...
40.921156  41.000225  40.929472  40.935809  40.964507  ...
41.013051  40.973632  40.929276  41.057703  41.075626  ...
40.930745  40.803935  40.818420  40.821634  40.711347  ...
];

%128-scaled decoder with +64 before >> 7
%-0.2158, 0.7802, better than without 64.
new_c4_c4_64 = [ 38.875902  41.816499  41.848527  41.937319  41.954107  ...
41.924575  41.898670  41.841193  41.802508  41.905244  ...
41.832464  41.809098  41.792064  41.720788  41.696962  ...
41.706165  41.740140  41.781685  41.841636  41.841595  ...
41.871579  41.845624  41.760962  41.765154  41.804464  ...
41.744509  41.688518  41.757089  41.715895  41.671214  ...
41.639117  41.812217  41.741399  41.709953  41.753339  ...
41.635198  41.665603  41.620630  41.554013  41.522505  ...
41.576951  41.534458  41.584194  41.632280  41.639962  ...
41.581614  41.646849  41.676328  41.728824  41.689412  ...
41.670982  41.749434  41.692913  41.550321  41.658648  ...
41.585219  41.519251  41.566922  41.696534  41.615237  ...
41.591411  41.562124  41.674506  41.632549  41.590613  ...
41.631014  41.542232  41.458360  41.488773  41.571498  ...
41.572937  41.530145  41.498475  41.531532  41.569039  ...
41.579642  41.526623  41.581652  41.645155  41.593921  ...
41.554917  41.542532  41.569607  41.548099  41.548062  ...
41.560727  41.677995  41.727098  41.703004  41.615390  ...
41.630324  41.637925  41.564390  41.575209  41.664018  ...
41.625723  41.608705  41.608667  41.571007  41.666609  ...
41.758314  41.864287  41.754010  41.699573  41.770142  ...
41.709757  41.617760  41.760329  41.579642  41.590157  ...
41.573126  41.554465  41.554276  41.543735  41.564730  ...
41.447130  41.481762  41.441617  41.396639  41.408906  ...
41.296782  41.345077  41.508421  41.537460  41.525911  ...
41.531007  41.335317  41.379806  41.550961  41.532357  ...
41.413173  41.368343  41.363615  41.399294  41.475316  ...
41.515588  41.481650  41.449705  41.463636  41.482725  ...
41.467994  41.565183  41.423073  41.444630  41.531270  ...
41.482021  41.497024  41.530220  41.541442  41.419892  ...
41.401622  41.502421  41.421756  41.350072  41.576686  ...
41.281605  41.269163  41.314437  41.284792  41.307061  ...
41.475724  41.274354  41.348095  41.370185  41.299767  ...
41.366971  41.435598  41.352159  41.466221  41.426256  ...
41.425231  41.502383  41.527971  41.643885  41.608438  ...
41.636850  41.597156  41.618793  41.600469  41.513497  ...
41.495870  41.426182  41.322363  41.353094  41.328549  ...
41.277890  41.338580  41.289684  41.230088  41.300976  ...
41.309625  41.441434  41.468068  41.544224  41.554691  ...
41.589853  41.458692  41.371631  41.512638  41.505066  ...
41.480538  41.503166  41.465814  41.603327  41.504507  ...
41.598374  41.455559  41.469620  41.590309  41.539676  ...
41.471025  41.492005  41.467661  41.451876  41.422561  ...
41.371992  41.348167  41.354210  41.428415  41.506967  ...
41.420075  41.262109  41.325616  41.274001  41.376006  ...
41.211796  41.273436  41.223656  41.151363  41.153493  ...
41.126323  41.108292  41.148684  41.094742  40.983271  ...
41.028886  41.101054  41.140692  41.212005  41.220967  ...
41.194310  41.248527  41.275344  41.321613  41.481910  ...
41.496317  41.596508  41.692018  41.601116  41.541480  ...
41.508571  41.583321  41.634699  41.869107  41.867324  ...
41.650432  41.696495  41.757998  41.486806  41.343496  ...
41.367440  41.348167  41.464300  41.395149  41.391771  ...
41.344574  41.487548  41.368813  41.602488  41.612600  ...
41.741399  41.756458  41.774462  41.783910  41.899894  ...
41.861009  42.010428  42.159188  41.994380  41.961800  ...
42.136717  42.180731  42.267499  42.476095  42.560711  ...
42.770870  42.865771  43.082507  43.300251  43.326247  ...
43.300194  43.200106  43.221467  43.158515  43.147513  ...
43.140339  42.925057  43.005542  43.019780  43.075921  ...
43.150179  43.383935  43.522428  43.416569  43.307808  ...
43.141153  42.983329  42.874038  42.867454  42.724136  ...
42.481645  42.486080  42.286062  42.326038  42.266522  ...
42.187834  42.060961  41.840025  41.672492  41.601688  ...
41.576800  41.601726  41.584536  41.579263  41.578922  ...
41.571347  41.503501  41.500782  41.501229  41.400203  ...
41.364445  41.334887  41.363290  41.311763  41.282703  ...
41.345184  41.269410  41.270822  41.320791  41.411641  ...
41.439928  41.397839  41.273259  41.240490  41.206713  ...
41.336680  41.348562  41.328907  41.361307  41.312405  ...
41.250565  41.130663  41.114283  41.021044  41.028585  ...
41.071678  41.242770  41.233202  41.197121  41.155040  ...
41.014981  41.190460  41.078057  41.020211  40.965560  ...
41.050984  41.074951  40.904312  40.971126  40.932280  ...
40.807647  40.979406  41.053704  40.896239  40.713893  ...
40.877685  40.742345  40.736065  40.847791  40.800258  ...
40.818801  40.636042  40.690783  40.857123  41.040959  ...
40.993860  41.035470  41.030188  41.008295  40.992104  ...
41.035637  41.053436  40.974852  41.187376  41.127929  ...
40.959607  40.871464  40.877717  40.924089  40.770198  ...
];

%10/20 night: 
%no 128-scaled quant table: round(QP * sclae + 0.5)
%-0.2568, 0.8277
d_noscale = [ 38.973436  41.897691  41.964658  42.032043  42.013653  ...
41.959027  41.926135  41.974654  41.912934  41.920104  ...
41.892798  41.822429  41.912115  41.801750  41.792303  ...
41.766737  41.785023  41.838777  41.940861  41.954107  ...
41.889377  41.858825  41.791109  41.797961  41.824795  ...
41.798240  41.754010  41.826400  41.658957  41.746478  ...
41.701522  41.819703  41.755194  41.736679  41.812977  ...
41.700508  41.721650  41.760290  41.597232  41.584422  ...
41.589511  41.540616  41.718400  41.648390  41.660154  ...
41.629518  41.772361  41.761080  41.829491  41.702614  ...
41.710656  41.697196  41.645155  41.665796  41.678034  ...
41.628099  41.525986  41.582031  41.645117  41.594682  ...
41.591906  41.578050  41.714174  41.674661  41.589549  ...
41.720318  41.668311  41.514393  41.521270  41.593274  ...
41.564994  41.542795  41.598298  41.598450  41.653940  ...
41.618870  41.624076  41.676871  41.709015  41.684943  ...
41.607865  41.577974  41.676018  41.636850  41.635928  ...
41.638463  41.740455  41.780533  41.792422  41.709054  ...
41.718674  41.655444  41.584270  41.627869  41.711203  ...
41.692485  41.735422  41.669356  41.658686  41.667150  ...
41.763769  41.887545  41.841475  41.780692  41.749907  ...
41.805742  41.672066  41.777279  41.704877  41.679896  ...
41.661390  41.596547  41.665371  41.704135  41.639693  ...
41.574830  41.530070  41.424975  41.345975  41.419819  ...
41.434425  41.509130  41.615084  41.609430  41.545954  ...
41.433068  41.370294  41.327261  41.522580  41.504880  ...
41.412480  41.414779  41.400858  41.332451  41.511145  ...
41.532695  41.528983  41.472319  41.414633  41.481836  ...
41.512414  41.547158  41.528571  41.484431  41.546895  ...
41.584232  41.543021  41.599821  41.571763  41.449153  ...
41.502719  41.465999  41.363831  41.404461  41.481206  ...
41.289542  41.333203  41.352051  41.328621  41.405955  ...
41.465334  41.308699  41.386111  41.375644  41.315365  ...
41.367621  41.437983  41.423256  41.456849  41.431602  ...
41.489107  41.504656  41.580097  41.557293  41.582980  ...
41.598412  41.633624  41.602831  41.566242  41.536184  ...
41.506631  41.343999  41.364517  41.369535  41.312940  ...
41.284332  41.317220  41.296924  41.274072  41.358387  ...
41.359360  41.413210  41.423182  41.575815  41.594225  ...
41.535096  41.377815  41.342563  41.503091  41.475316  ...
41.502681  41.515177  41.422890  41.529508  41.566015  ...
41.577027  41.500298  41.518578  41.664830  41.563445  ...
41.543134  41.535846  41.486027  41.448527  41.491856  ...
41.405336  41.425963  41.430063  41.474798  41.525986  ...
41.445843  41.287592  41.407084  41.358964  41.419052  ...
41.329122  41.238071  41.194830  41.219257  41.173923  ...
41.151466  41.212284  41.200768  41.096370  41.071476  ...
41.129843  41.190426  41.156485  41.267469  41.238386  ...
41.293373  41.289506  41.233447  41.310195  41.495945  ...
41.510063  41.616842  41.657451  41.585295  41.562388  ...
41.558387  41.632779  41.703862  41.937813  41.979515  ...
41.795370  41.971499  41.981302  41.670285  41.519887  ...
41.454491  41.495982  41.546782  41.491299  41.542871  ...
41.580590  41.622927  41.581956  41.694821  41.684865  ...
41.833991  41.913998  41.956132  41.923837  41.968347  ...
42.015455  42.110032  42.221898  42.120712  42.129482  ...
42.189186  42.273900  42.368385  42.455869  42.591807  ...
42.774912  42.873118  43.099797  43.376130  43.323584  ...
43.335496  43.210084  43.239210  43.221357  43.202585  ...
43.150724  42.954147  43.018302  43.115105  43.048770  ...
43.151704  43.383878  43.443157  43.407550  43.368511  ...
43.216822  43.075011  42.928262  42.906028  42.830888  ...
42.523471  42.554348  42.330362  42.444703  42.316818  ...
42.241017  42.058971  41.849213  41.778032  41.691396  ...
41.618640  41.533370  41.681177  41.615810  41.625302  ...
41.659768  41.571309  41.572710  41.532245  41.381255  ...
41.378358  41.433691  41.435855  41.331842  41.433435  ...
41.339369  41.335568  41.290464  41.298346  41.491707  ...
41.492376  41.501788  41.342527  41.372354  41.242594  ...
41.423694  41.360478  41.343137  41.424389  41.334529  ...
41.195316  41.146316  41.217304  41.148650  41.024780  ...
41.135760  41.242664  41.290712  41.220793  41.170471  ...
41.003777  41.162301  41.102004  41.038649  40.974456  ...
41.066554  41.027617  40.987735  41.003378  40.959114  ...
40.739251  40.957766  41.034266  40.860399  40.712589  ...
40.831516  40.724124  40.747820  40.795001  40.807678  ...
40.822908  40.625620  40.743440  40.772527  40.990780  ...
40.956518  41.054141  41.009159  40.955336  40.971225  ...
41.021645  41.033129  40.991376  41.165505  41.142475  ...
41.046086  40.868792  40.886920  40.901685  40.799117  ...
];

%noscale, eocoder side
e_c4_c4_noscale = [ 38.973977  41.901159  41.971831  42.042490  42.028930  ...
41.977478  41.944199  41.992087  41.934150  41.948036  ...
41.925437  41.868337  41.949357  41.845705  41.846269  ...
41.817900  41.849617  41.900874  42.001060  42.019019  ...
41.966067  41.925684  41.844738  41.863639  41.903406  ...
41.887178  41.838898  41.906184  41.751209  41.835921  ...
41.808299  41.912893  41.853249  41.845665  41.914653  ...
41.814938  41.819463  41.877829  41.712219  41.692563  ...
41.727883  41.668466  41.837610  41.759262  41.793458  ...
41.774066  41.908760  41.901364  41.986212  41.846874  ...
41.854703  41.852401  41.793617  41.801111  41.829973  ...
41.773273  41.702692  41.770736  41.832865  41.782519  ...
41.769627  41.756537  41.903160  41.863841  41.778667  ...
41.912442  41.869471  41.724667  41.718478  41.805902  ...
41.772797  41.741202  41.803825  41.779064  41.848487  ...
41.816579  41.811537  41.865258  41.900588  41.877544  ...
41.812897  41.773590  41.882216  41.841877  41.854622  ...
41.826400  41.946261  41.973284  41.970379  41.916660  ...
41.967973  41.914858  41.852724  41.900792  41.962835  ...
41.910151  41.983091  41.920883  41.908801  41.938348  ...
42.017886  42.170467  42.090755  42.049075  42.035958  ...
42.065580  41.955925  42.059606  42.015874  41.937566  ...
41.929175  41.874500  41.947128  42.002898  41.954561  ...
41.882379  41.822389  41.718752  41.651202  41.707648  ...
41.710304  41.795091  41.895447  41.898221  41.883192  ...
41.759815  41.704057  41.664443  41.900996  41.853855  ...
41.769350  41.775731  41.751130  41.700508  41.874500  ...
41.895651  41.904345  41.819944  41.786295  41.857531  ...
41.841354  41.867405  41.858097  41.814978  41.906552  ...
41.931806  41.918874  41.987420  41.947375  41.833669  ...
41.888237  41.855188  41.741911  41.800393  41.941108  ...
41.736325  41.757208  41.741635  41.714761  41.798798  ...
41.866109  41.720749  41.772797  41.780533  41.732868  ...
41.781010  41.884005  41.853451  41.875352  41.866190  ...
41.919652  41.944777  42.082702  42.027165  42.057955  ...
42.106136  42.149321  42.140900  42.100020  42.056600  ...
41.973450  41.839462  41.861332  41.893369  41.844536  ...
41.792184  41.832865  41.792223  41.698170  41.833830  ...
41.829491  41.959565  41.933985  42.098439  42.130988  ...
42.058166  41.920883  41.884371  42.104253  42.025526  ...
42.060961  42.109261  42.025652  42.075939  42.080276  ...
42.093315  42.034021  42.040761  42.240928  42.145000  ...
42.109990  42.095705  42.035579  42.053343  42.072073  ...
41.989003  41.986421  41.976149  42.059309  42.101772  ...
42.050596  41.868539  41.950100  41.943375  41.985630  ...
41.900629  41.828848  41.787448  41.815298  41.768796  ...
41.784506  41.836564  41.868094  41.739707  41.712610  ...
41.738213  41.802668  41.762780  41.867243  41.867567  ...
41.889295  41.869107  41.843247  41.919160  42.146728  ...
42.130687  42.258314  42.365840  42.321403  42.227264  ...
42.284858  42.301883  42.390308  42.541838  42.553921  ...
42.291820  42.553161  42.558953  42.192634  42.048019  ...
41.983715  42.058632  42.077299  42.041436  42.053766  ...
42.087174  42.154165  42.147246  42.247777  42.274568  ...
42.387567  42.445444  42.495292  42.446416  42.452808  ...
42.458839  42.536967  42.635438  42.563326  42.567988  ...
42.639162  42.699092  42.754093  42.876950  43.019411  ...
43.134911  43.241655  43.468561  43.657461  43.558634  ...
43.550807  43.398146  43.431701  43.401952  43.387325  ...
43.303407  43.100228  43.108199  43.223570  43.167250  ...
43.260262  43.474481  43.519227  43.476827  43.429088  ...
43.280182  43.129870  42.993030  42.967748  42.895698  ...
42.588649  42.622307  42.400602  42.512084  42.371614  ...
42.315201  42.119896  41.936207  41.845584  41.764758  ...
41.688907  41.609430  41.748882  41.705852  41.713783  ...
41.748843  41.662704  41.660501  41.625378  41.470249  ...
41.456222  41.509876  41.542044  41.412334  41.536109  ...
41.452613  41.467624  41.424097  41.423329  41.605004  ...
41.614128  41.643539  41.476686  41.510249  41.376006  ...
41.547497  41.501862  41.476279  41.564239  41.466701  ...
41.354426  41.321112  41.370872  41.279446  41.189733  ...
41.322291  41.441507  41.461126  41.402022  41.351727  ...
41.187134  41.349533  41.322899  41.234148  41.180281  ...
41.281216  41.249933  41.219536  41.245402  41.197017  ...
40.956091  41.195004  41.275132  41.109415  40.965198  ...
41.091861  41.002548  41.036674  41.091556  41.096743  ...
41.150367  40.956452  41.093250  41.124923  41.309554  ...
41.240174  41.376476  41.348742  41.270116  41.296463  ...
41.342384  41.367765  41.341702  41.453681  41.420112  ...
41.321255  41.168918  41.197399  41.208001  41.109721  ...
];

f_f = f_f;
c4_c4 = e_c4_c4;

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end
legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

break;

%%%%%%%%%%%%%%%%%%%%%%%
%
% Glasgow
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Glasgow ';

f_f = [ 38.751690  41.278491  41.392316  41.538362  41.495461  ...
41.470249  41.507601  41.506408  41.516746  41.378539  ...
41.371016  41.255629  41.190772  41.185853  41.158583  ...
41.163024  41.133297  41.240069  41.208767  41.184260  ...
41.083262  41.155590  41.126801  41.116498  43.024960  ...
40.408179  40.366662  40.458319  40.379613  40.404880  ...
40.358612  40.353034  40.378923  40.363938  40.402249  ...
40.419078  40.432245  40.357839  40.379354  40.402682  ...
40.410959  40.397712  40.445540  40.459784  40.450712  ...
40.397683  40.388855  40.414930  40.403145  40.434866  ...
40.525491  40.574365  40.514827  40.529389  40.515480  ...
40.526562  40.515925  40.531235  40.505195  40.489828  ...
40.593235  40.611247  40.553629  40.516162  40.509164  ...
40.501111  40.554528  40.528973  40.561810  40.548185  ...
40.524510  40.460604  40.561780  36.388024  40.725121  ...
40.860624  40.931790  40.898280  40.853465  40.891836  ...
40.921286  40.904799  40.869983  40.897535  40.874783  ...
40.952545  40.878556  40.763909  40.704368  40.747632  ...
40.710478  40.707499  40.703655  40.696132  40.720577  ...
40.646978  40.698019  40.647008  40.561480  42.648511  ...
]; 

%new encoder
e_c4_c4 = [ 38.839337  41.760645  41.841918  41.897609  41.925027  ...
41.837570  41.814898  41.855067  41.911337  41.760369  ...
41.769350  41.643501  41.613020  41.550358  41.532357  ...
41.481650  41.501006  41.515663  41.494643  41.516597  ...
41.398639  41.452244  41.464928  41.393878  43.697161  ...
41.397112  41.387271  41.431822  41.363940  41.385350  ...
41.413794  41.333884  41.362280  41.351367  41.362100  ...
41.404826  41.366971  41.324472  41.319969  41.238176  ...
41.348958  41.359072  41.320827  41.326903  41.334959  ...
41.324186  41.329945  41.357739  41.418723  41.460610  ...
41.629250  41.654403  41.532620  41.508682  41.498475  ...
41.425890  41.383175  41.343353  41.308058  41.275556  ...
41.286528  41.473799  41.425085  41.443491  41.324257  ...
41.126631  41.345364  41.396530  41.464743  41.421903  ...
41.257319  41.047931  41.038850  36.653067  41.152256  ...
41.197676  41.313653  41.217583  41.245261  41.318684  ...
41.205844  41.277607  41.245191  41.251550  41.247719  ...
41.353814  41.301367  41.302683  41.298737  41.240700  ...
41.313617  41.286564  41.249019  41.356082  41.724706  ...
41.471765  41.589891  41.490073  41.512750  43.634946  ...
]; 


%latest as of 10/18/00
c4_c4 = [ 38.754992  41.556652  41.483245  41.439047  41.409380  ...
41.260911  41.168953  41.058779  41.062615  40.870369  ...
40.835188  40.632534  40.540299  40.409801  40.375301  ...
40.236639  40.221499  40.112668  40.122686  40.047333  ...
39.929148  39.914602  39.888350  39.788893  42.419927  ...
40.556504  40.433992  40.285052  40.202931  40.166660  ...
40.122008  39.973369  39.945851  39.953301  39.937660  ...
39.993795  39.931041  39.803805  39.808064  39.749113  ...
39.768058  39.791605  39.736967  39.736619  39.775234  ...
39.708954  39.890637  39.958518  40.022097  40.106560  ...
40.341701  40.410988  40.412524  40.374583  40.393411  ...
40.343355  40.281985  40.231216  40.101189  39.936361  ...
39.877525  40.109964  40.102591  40.025515  39.863763  ...
39.586799  39.665526  39.894956  39.898919  39.842058  ...
39.555975  39.378067  39.192410  36.229112  40.060808  ...
39.981523  39.991427  39.780567  39.748715  39.732628  ...
39.608610  39.585553  39.519041  39.456135  39.365297  ...
39.394288  39.326827  39.281587  39.194686  39.059438  ...
39.063705  38.951376  38.851963  38.846403  39.093803  ...
38.868138  38.936931  38.827250  38.678354  41.942550  ...
]; 


err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;

if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end

legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

break;

%%%%%%%%%%%%%%%%%%%%%%%
%
% News
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'News ';

f_f = [ 39.977536  42.340243  42.508607  42.633166  42.644779  ...
42.596644  42.655743  42.703952  42.740203  42.711326  ...
42.729074  42.696051  42.642841  42.706458  42.645748  ...
42.735303  42.652781  42.709751  42.729963  42.715263  ...
42.706310  42.637904  42.763743  42.785709  42.721719  ...
42.732533  42.718515  42.644246  42.737331  42.664641  ...
42.675021  42.658415  42.570702  42.555249  42.593530  ...
42.622886  42.703363  42.726703  42.817809  42.788863  ...
42.774912  42.826440  42.747539  42.785559  42.740847  ...
42.674045  42.676387  42.717086  42.752950  42.776660  ...
42.748432  42.726703  42.757622  42.782357  42.787061  ...
42.702086  42.639985  42.683763  42.730210  42.637808  ...
42.726752  42.706064  42.728827  42.808139  42.753646  ...
42.788913  42.843144  42.823460  42.863783  42.813677  ...
42.762797  42.741788  42.763594  42.770970  42.745605  ...
42.659728  42.643810  42.580096  42.647105  42.602110  ...
42.533377  42.536353  42.596021  42.630702  42.630751  ...
42.645409  42.575802  42.554680  42.584585  42.535219  ...
40.384649  42.642212  42.608832  42.625393  42.679219  ...
42.660749  42.746597  42.701497  42.758617  42.795530  ...
42.708227  42.741243  42.763793  42.748184  42.723396  ...
42.614939  42.651859  42.557291  42.603741  42.600719  ...
42.592716  42.608880  42.638872  42.722558  42.737777  ...
42.755832  42.778408  42.729568  42.897289  43.005174  ...
43.043562  43.061978  43.085295  43.125105  43.023532  ...
42.918756  42.923145  42.873680  42.883907  42.713048  ...
42.674191  42.635486  42.584872  42.608111  42.526110  ...
42.465529  42.475676  42.439571  42.456240  42.426143  ...
42.484586  42.496041  42.608399  42.606046  42.602110  ...
42.608928  42.557861  42.590084  42.643568  42.656617  ...
42.655209  42.586019  42.540324  42.566275  42.558098  ...
42.614169  42.575230  42.636695  42.724186  42.707293  ...
42.664057  42.620380  42.609745  42.630751  42.579905  ...
42.623754  42.636453  42.569512  42.567512  42.517021  ...
42.463390  42.411103  42.462043  42.494824  42.424761  ...
42.463065  42.404359  42.448453  42.486407  42.443131  ...
42.421630  42.430660  42.410277  42.433474  42.414686  ...
42.449194  42.463855  42.500539  42.521445  42.515704  ...
42.522623  42.566608  42.561424  42.589223  42.611043  ...
42.510392  42.484679  42.512459  42.539426  42.565513  ...
42.602925  42.688459  42.783107  42.830534  42.804820  ...
42.842282  42.811410  42.776410  42.814734  42.763046  ...
42.802960  42.740797  42.712408  42.740302  42.657978  ...
42.678047  42.740203  42.711522  42.756031  42.692523  ...
42.686942  42.684203  42.718367  42.688067  42.652926  ...
42.628095  42.572560  42.547567  42.639937  42.684056  ...
42.687872  42.603741  42.635003  42.597794  42.507105  ...
42.530827  42.471996  42.493795  42.550790  42.544205  ...
40.259435  42.574371  42.562993  42.592381  42.587549  ...
42.581098  42.651373  42.685670  42.757274  42.734511  ...
42.755832  42.790216  42.760458  42.782307  42.823763  ...
42.769473  42.766782  42.724284  42.742284  42.693111  ...
42.685230  42.662403  42.651082  42.686844  42.618116  ...
42.616046  42.595877  42.609312  42.671704  42.629930  ...
42.584633  42.552735  42.593051  42.627178  42.496088  ...
42.486174  42.547330  42.492999  42.566275  42.519421  ...
42.515609  42.522717  42.608592  42.608111  42.511849  ...
42.491128  42.520598  42.530875  42.599136  42.607727  ...
42.611620  42.556009  42.576422  42.589606  42.593434  ...
42.604029  42.635825  42.643568  42.682639  42.677852  ...
];

c4_c4 = [ 40.128030  42.754242  42.925573  43.064325  43.018460  ...
42.977833  43.038573  43.060058  43.125863  43.061338  ...
43.092809  43.141153  43.107552  43.171186  43.088191  ...
43.043881  43.030305  43.103458  43.117265  43.049621  ...
43.009967  43.021313  43.038042  43.098560  43.006648  ...
43.022369  43.035815  42.979559  43.087870  43.017932  ...
43.018988  42.968635  42.990039  43.044518  42.970254  ...
42.998125  43.015399  43.055209  43.123752  43.132579  ...
43.097431  43.105289  43.067955  43.122562  43.081007  ...
43.022422  43.049568  43.075332  43.115807  43.138167  ...
43.091896  43.072070  43.099044  43.155626  43.196749  ...
43.120886  43.041279  43.067849  43.155789  43.085670  ...
43.122995  43.127595  43.078436  43.160315  43.130086  ...
43.130466  43.146208  43.187022  43.245548  43.174852  ...
43.090553  43.086367  43.056487  43.054996  43.081382  ...
43.039793  43.031787  43.009440  43.114619  43.044146  ...
42.989619  43.056328  43.056221  43.089157  43.052654  ...
43.057873  42.996864  43.072444  43.142185  43.108199  ...
40.424887  43.070359  43.062831  43.174579  43.179289  ...
43.190262  43.118724  43.194274  43.211905  43.274185  ...
43.119588  43.174250  43.182578  43.224345  43.148982  ...
43.066140  43.071268  43.022052  43.085348  43.075493  ...
43.060164  43.062298  43.083258  43.208760  43.187955  ...
43.223903  43.242544  43.236821  43.343115  43.366451  ...
43.383705  43.406280  43.352172  43.363305  43.270099  ...
43.199886  43.183016  43.135074  43.170256  43.071322  ...
43.051643  43.009176  43.018407  43.005542  42.942612  ...
42.893645  42.907520  42.922422  43.010757  42.881092  ...
42.964148  43.020414  42.973127  43.000754  42.998125  ...
42.950351  42.982020  43.026864  43.098775  43.088567  ...
42.557243  42.937011  42.950922  43.001911  42.974643  ...
42.922008  42.960187  42.944584  43.017510  42.956385  ...
43.016243  43.025648  42.982386  43.050472  42.967174  ...
42.946921  42.922163  42.894107  42.942145  42.881860  ...
42.850097  42.819171  42.875315  42.994605  42.905668  ...
42.888466  42.901297  42.906542  42.956541  42.859709  ...
42.883753  42.856808  42.820079  42.826490  42.844716  ...
42.860676  42.830230  42.868321  42.868678  42.849894  ...
42.896211  42.977414  42.968792  42.973284  42.907417  ...
42.859709  42.860880  42.825732  42.910095  42.926814  ...
42.931107  42.946038  43.039315  43.071696  43.049515  ...
43.021735  42.985739  42.926607  43.001017  42.924333  ...
42.892619  42.900680  42.949259  42.976630  42.961020  ...
42.935302  42.912928  42.945778  42.989514  42.924126  ...
42.934576  42.957322  42.939500  42.946298  42.904227  ...
42.903610  42.837518  42.927486  43.019041  43.007807  ...
42.898111  42.888158  42.902890  42.953887  42.876592  ...
42.837518  42.883497  42.884112  42.964774  42.939655  ...
40.215651  43.019675  43.038042  43.044518  42.983381  ...
43.043243  43.066086  43.084866  43.140393  43.075707  ...
43.075600  43.071161  43.130249  43.117967  43.137841  ...
43.104481  43.175400  43.144848  43.144903  43.135074  ...
43.095173  43.109870  43.053505  43.068650  43.043084  ...
43.036504  43.070039  43.078008  43.056434  43.032317  ...
43.023321  42.983119  43.019992  43.040324  42.971089  ...
42.963470  42.869851  42.927073  42.967800  42.955968  ...
42.973806  42.968009  43.029458  43.034490  42.985477  ...
42.948532  43.010178  43.068222  43.093024  43.065713  ...
43.064485  43.035815  43.052494  43.084491  43.058672  ...
43.072979  43.061498  43.088352  43.103404  43.123698  ...
];

%decoder
d_c4_c4 = [ 40.118405  42.722755  42.853044  42.968218  42.901040  ...
42.834632  42.890875  42.898625  42.947233  42.869494  ...
42.841521  42.870719  42.816952  42.862051  42.767529  ...
42.690417  42.697424  42.748234  42.727147  42.657395  ...
42.572227  42.581003  42.551169  42.583056  42.466970  ...
42.491876  42.480105  42.376485  42.435182  42.360209  ...
42.392868  42.308649  42.279331  42.306004  42.303450  ...
42.288829  42.280177  42.291642  42.329190  42.292446  ...
42.261728  42.258801  42.152867  42.231447  42.171771  ...
42.082659  42.106735  42.106350  42.131935  42.160618  ...
42.124880  42.121485  42.130213  42.126298  42.135682  ...
42.109475  42.025190  42.015119  42.086876  41.992462  ...
42.066853  42.085683  42.073262  42.124622  42.038612  ...
42.018096  42.014407  42.000851  42.051103  41.983757  ...
41.918956  41.951875  41.939831  41.905326  41.956835  ...
41.900955  41.909823  41.902548  41.964409  41.904427  ...
41.843166  41.888603  41.847922  41.841475  41.830816  ...
41.786136  41.708781  41.772084  41.766222  41.781566  ...
34.678286  35.513220  35.713761  35.722236  35.900344  ...
36.162984  36.423248  36.588592  36.517395  36.502294  ...
36.420149  36.146079  36.383897  36.382922  36.551055  ...
36.728304  36.957285  37.118612  37.118273  37.140207  ...
37.021316  37.001664  36.946117  36.955964  37.008037  ...
37.001743  37.206723  37.398415  37.440251  37.471379  ...
37.530789  37.516827  37.579643  37.587272  37.623545  ...
37.603754  37.602920  37.724454  37.709903  37.720586  ...
38.418408  38.449683  38.292045  38.308652  38.083493  ...
37.827396  37.801872  37.967934  38.001071  38.058933  ...
38.259939  38.427903  38.456124  38.460540  38.426765  ...
38.034093  38.073267  38.044127  38.048631  38.080307  ...
36.692817  36.816614  36.896995  36.912798  36.921558  ...
36.967760  36.980233  37.065473  37.022803  36.994957  ...
36.971485  36.978064  36.937047  36.942023  36.974084  ...
36.971905  36.903100  36.944383  36.938232  36.946613  ...
36.962768  36.953376  36.963475  36.985627  37.016845  ...
36.951639  36.993757  37.021661  37.012989  37.113145  ...
37.233497  37.294509  37.360952  37.374493  37.332770  ...
37.352679  37.309588  37.374004  37.361167  37.332228  ...
37.400775  37.465391  37.436131  37.453309  37.441669  ...
37.381409  37.440353  37.430512  37.433138  37.509425  ...
37.483498  37.575480  37.615487  37.623058  37.677503  ...
37.739837  37.772093  37.782155  37.783056  37.768134  ...
37.780779  37.799188  37.831329  37.802349  37.771130  ...
37.796553  37.769017  37.789419  37.801205  37.823403  ...
37.846614  37.845106  37.845780  37.837459  37.798950  ...
37.799236  37.817947  37.853843  37.914637  37.954799  ...
37.902930  37.884482  37.874859  37.932265  37.881584  ...
37.869789  37.902345  37.890979  37.905321  37.929695  ...
34.025294  34.849021  35.054317  35.049822  35.196834  ...
35.461532  35.755895  35.884287  35.882724  35.898786  ...
35.850919  35.624411  35.886003  35.874634  36.045076  ...
36.257284  36.445277  36.595903  36.622108  36.700379  ...
36.598997  36.647620  36.598985  36.606808  36.578704  ...
36.590467  36.775507  37.014937  37.015719  37.003131  ...
37.079359  37.106359  37.136239  37.175104  37.187732  ...
37.174636  37.213543  37.286615  37.301101  37.320083  ...
37.916447  37.942311  37.817931  37.830210  37.602510  ...
37.424668  37.483911  37.588074  37.607854  37.699743  ...
37.815619  37.897974  37.979933  37.939785  37.957581  ...
37.701637  37.783103  37.763266  37.776086  37.764620  ...
];

err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end

legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);


%%%%%%%%%%%%%%%%%%%%%%%
%
% Suzie
%
%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Suzie ';

f_f = [ 39.798292  42.164087  42.458421  42.369112  42.409175  ...
42.463576  42.501101  42.450954  42.337895  42.228540  ...
42.258048  42.280935  42.320279  42.371159  42.380039  ...
42.507293  42.564372  42.550221  42.458467  42.451603  ...
42.476142  42.469715  42.521351  42.479452  42.455776  ...
42.389440  42.415283  42.377988  42.374572  42.379447  ...
42.330452  42.307528  42.417398  42.429415  42.485286  ...
42.483932  42.438138  42.559903  42.498898  42.557386  ...
42.518291  42.587645  42.580287  42.617153  42.672192  ...
42.827854  42.954928  43.104481  43.145120  43.312890  ...
43.593336  43.851305  43.852969  43.916528  43.801948  ...
43.655382  43.653120  43.564378  43.573789  43.512535  ...
43.441643  43.242266  43.315943  43.145012  43.087655  ...
42.931573  42.831141  42.714328  42.691837  42.701153  ...
42.658367  42.704492  42.756330  42.779857  42.689976  ...
42.736391  42.736787  42.819372  42.803513  42.781357  ...
42.731297  42.678682  42.685621  42.685768  42.693013  ...
42.646427  42.641873  42.544157  42.484866  42.459071  ...
42.592573  42.529081  42.542311  42.535030  42.493514  ...
42.414778  42.458282  42.464366  42.415697  42.477960  ...
]; 

c4_c4 = [ 39.856338  42.461253  42.756827  42.701988  42.721374  ...
42.691396  42.774612  42.748085  42.636647  42.649966  ...
42.617057  42.646863  42.705180  42.747738  42.783457  ...
42.876643  42.967591  42.866281  42.821189  42.820533  ...
42.783808  42.717086  42.803764  42.801654  42.719698  ...
42.684643  42.740253  42.672826  42.763494  42.723594  ...
42.701497  42.755137  42.796383  42.816650  42.852384  ...
42.869698  42.786610  42.921234  42.925418  42.917053  ...
42.992610  42.984743  42.989094  43.035656  43.084651  ...
43.248275  43.409399  43.590504  43.663032  43.834068  ...
44.024948  44.201246  44.311916  44.268957  44.292330  ...
44.055012  43.946370  43.955796  43.928688  43.905114  ...
43.842423  43.732806  43.685262  43.592733  43.541863  ...
43.436931  43.324660  43.197850  43.065286  43.034119  ...
43.081596  43.002542  43.098184  43.115375  43.055049  ...
43.091036  43.119859  43.114727  43.173539  43.107660  ...
43.116617  43.115753  43.107013  43.088889  43.032847  ...
42.956957  43.007807  42.915145  42.967174  42.809498  ...
43.034490  42.950039  42.983748  42.974747  42.898830  ...
42.854621  42.803764  42.858792  42.785409  42.797035  ...
]; 


err = mean(f_f - c4_c4);
mad = max(abs(f_f-c4_c4));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);


figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end

legend('H.263+', 'BINDCT-C4');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c4_c4, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);
