function clipAC_scale()
%generate threshold for clipAC() in intra_pred.c
%For floating DCT, the threshold for AC coefficient is 2047 or -2048.
%For binDCT, this should be scaled accordingly.
%
%Jie Liang, 10/10/2000

bin_c =[  0.353553391, 0.509795579, 0.541196100, 0.601344887, ...
  0.707106781, 0.415734806, 0.461939766, 0.49039264]';
1 ./ (bin_c * bin_c') * 2048 - 1

%Result is:
%    16383    11362    10702    09632    08191    13932    12539   11811
%    11362    07879    07422    06680    05680    09662    08696   8191
%    10702    07422    06991    06292    05351    09101    08191   7716
%    09632    06680    06292    05662    04815    08191    07372   6944
%    08191    05680    05351    04815    04095    06966    06269   5905
%    13932    09662    09101    08191    06966    11848    10663   10044
%    12539    08696    08191    07372    06269    10663    09597   9040
%    11811    08191    07716    06944    05905    10044    09040   8515

bin_l = [ 0.353553391, 0.353553391, 0.541196100, 0.5, ...
          0.707106781, 0.5,         0.461939766, 0.70710678 ]';
1 ./ (bin_l * bin_l') * 2048 - 1


%Result is:
%    16383    16383    10702   11584   8191    11584   12539  8191
%    16383    16383    10702   11584   8191    11584   12539  8191
%    10702    10702    6991    7567    5351    7567    8191   5351
%    11584    11584    7567    8191    5792    8191    8866   5792
%    8191     8191     5351    5792    4095    5792    6269   4095
%    11584    11584    7567    8191    5792    8191    8866   5792
%    12539    12539    8191    8866    6269    8866    9597   6269
%    8191     8191     5351    5792    4095    5792    6269   4095
