function glas_adv_intra()
%This file shows the performance of the advanced intra mode:
%Sequence: glasgow
%Comparison:
%  1: floating DCT, 1 I frame,    w/o  -I option.
%  2: floating DCT, all I frames, w/o  -I option.
%  3: floating DCT, all I frames, with -I option.
%  4: binDCT-C1,    1 I frame,    w/o  -I option.
%  5: binDCT-C1,    all I frames  w/o -I options.
%  6: binDCT-C1,    all I frame,s with -I option.
%  7: binDCT-C4,    1 I frame,    w/o  -I option.
%  8: binDCT-C4,    all I frames  w/o -I options.
%  9: binDCT-C4,    all I frame,s with -I option.
% 10: binDCT-L3,    1 I frame,    w/o  -I option.
% 11: binDCT-L3,    all I frames  w/o -I options.
% 12: binDCT-L3,    all I frame,s with -I option.

% Command:
% ./tmn -i ../glasgo.qcif -o glas_rec_flt.qcif -B glas_flt.cmp -b 99 -k 0
% Notes: One I frame, all the rest are P frames.
%

g_f_p_noi = [ 27.298449  28.514110  28.661303  28.772593  28.846819  ...
28.797711  28.841464  28.848208  28.835453  28.789138  ...
28.710044  28.616674  28.451301  28.437324  28.431973  ...
28.428252  28.388137  28.440404  28.434372  28.374798  ...
28.390862  28.433132  28.389407  28.334428  28.099831  ...
27.336125  27.148671  27.090905  27.109086  27.159420  ...
27.095078  27.093909  27.160748  27.208513  27.246126  ...
27.195660  27.251624  27.219764  27.303641  27.346187  ...
27.307561  27.369205  27.389025  27.430355  27.469332  ...
27.601199  27.703371  27.786306  27.706741  27.680388  ...
27.818594  27.772050  27.753403  27.783969  27.807590  ...
27.919474  27.939408  27.895046  27.888298  27.877402  ...
27.852994  27.867316  27.869607  27.874497  27.896366  ...
28.026403  27.846992  27.820770  27.842575  27.818101  ...
27.761952  27.772659  27.952371  27.636043  27.573277  ...
27.610903  27.659385  27.634048  27.579779  27.636626  ...
27.679726  27.772490  27.610771  27.697806  27.609776  ...
27.618197  27.509568  27.423385  27.319982  27.295113  ...
27.143985  27.128728  27.089299  27.001492  27.072151  ...
26.992164  27.122564  27.200967  27.114223  27.340914  ...
]; 


%
%./tmn -i ../glasgo.qcif -o glas_rec_flt.qcif -B glas_flt.cmp -b 99 -k 0 -f 1
%
g_f_i_noi = [ 27.298449  27.387131  27.324625  27.354017  27.381497  ...
27.333711  27.246487  27.298292  27.210194  27.182035  ...
27.087630  26.989856  26.828751  26.900757  26.874504  ...
26.855580  26.850243  26.847527  26.874423  26.894552  ...
26.885512  26.859716  26.879417  26.883928  25.739233  ...
25.756540  25.680326  25.712422  25.695610  25.673215  ...
25.713816  25.746197  25.726106  25.787808  25.865997  ...
25.710944  25.787257  25.845850  25.835391  25.852873  ...
25.825103  25.863213  25.915440  25.961254  26.075214  ...
26.180486  26.353720  26.537459  26.585801  26.567326  ...
26.835006  26.768594  26.833568  26.915216  26.839921  ...
26.817474  26.789865  26.645110  26.565419  26.543051  ...
26.492983  26.483008  26.443834  26.415117  26.405695  ...
26.420861  26.347635  26.410651  26.408816  26.403430  ...
26.359437  26.338628  26.370076  25.670414  25.695909  ...
25.684229  25.705841  25.709895  25.704696  25.708255  ...
25.714178  25.703959  25.710622  25.733345  25.725700  ...
25.686531  25.689431  25.737337  25.695726  25.703477  ...
25.713859  25.671025  25.638517  25.618957  25.634033  ...
25.555252  25.621539  25.614701  25.561504  24.984410  ...
]; 


%
%./tmn -i ../glasgo.qcif -o glas_rec_flt.qcif -B glas_flt.cmp -b 99 -k 0 -f 1 -I
%
g_f_i_i = [ 28.561795  28.606971  28.521858  28.551844  28.581018  ...
28.509899  28.538148  28.546048  28.497549  28.470557  ...
28.369506  28.295034  28.189743  28.147117  28.171832  ...
28.163685  28.166281  28.105778  28.119317  28.109573  ...
28.145643  28.125443  28.134074  28.108297  26.934731  ...
27.014987  26.987942  26.971694  26.946490  26.878228  ...
26.941606  26.921431  26.965583  27.018026  27.084102  ...
27.022293  27.003510  27.089899  27.076303  27.081404  ...
27.017528  27.049659  27.122591  27.166312  27.212123  ...
27.347510  27.397269  27.649860  27.649367  27.700262  ...
27.872108  27.866914  27.918126  27.960373  27.966670  ...
27.999666  27.875263  27.893018  27.730924  27.692269  ...
27.745393  27.710921  27.688905  27.622933  27.657116  ...
27.617268  27.597122  27.551915  27.563138  27.621623  ...
27.665343  27.648063  27.645489  27.000015  27.043354  ...
27.010229  27.097806  27.034544  27.044412  27.033367  ...
27.069785  27.045265  27.075297  27.059541  27.023196  ...
27.032473  27.054098  27.042143  27.023861  26.960837  ...
26.996283  26.953268  26.983288  26.904880  26.939365  ...
26.898565  26.941573  27.007083  26.896386  26.430278  ...
]; 

%%%%%%%%%%%%%
%
% binDCT-C4:
%
%%%%%%%%%%%%%

%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_c4.qcif -B glas_c4.cmp -b 99 -k 0 -X c4
%binDCT-C4: 1 I frame, all the rest are P frames, no -I option.
%

g_c4_p_noi = [ 27.288870  28.400989  28.563930  28.681876  28.751156  ...
28.744679  28.767865  28.756092  28.700420  28.681995  ...
28.625831  28.548155  28.392854  28.379212  28.361951  ...
28.392017  28.335693  28.391264  28.364581  28.295794  ...
28.329916  28.385538  28.347646  28.308648  25.791547  ...
26.824946  26.905654  26.923476  26.961345  27.021106  ...
27.064277  27.030989  27.107006  27.186076  27.240512  ...
27.142070  27.186695  27.165010  27.285470  27.309449  ...
27.335146  27.242880  27.296961  27.343885  27.341324  ...
27.508253  27.652939  27.623847  27.695103  27.586866  ...
27.652626  27.510420  27.667500  27.662745  27.740481  ...
27.831203  27.793147  27.733448  27.777860  27.809935  ...
27.803709  27.846077  27.849925  27.784485  27.779634  ...
27.928573  27.837193  27.762344  27.772738  27.701579  ...
27.611344  27.682639  27.779582  26.030059  26.877411  ...
27.052672  27.209745  27.260239  27.229626  27.285695  ...
27.348194  27.375232  27.330772  27.427897  27.376395  ...
27.376895  27.285164  27.227991  27.114953  27.122949  ...
26.993881  26.941906  26.931513  26.901064  26.903275  ...
26.877824  26.979891  27.036476  26.984096  25.251170  ...
]; 


%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_c4.qcif -B glas_c4.cmp -b 99 -k 0 -X c4 -f 1
%binDCT-C4: all I frames, no -I option.

g_c4_i_noi = [ 27.288870  27.350018  27.297152  27.347895  27.375347  ...
27.323603  27.221566  27.270897  27.198080  27.158053  ...
27.086563  26.999754  26.828099  26.888142  26.871947  ...
26.856810  26.847611  26.834394  26.880210  26.885279  ...
26.860220  26.862853  26.893348  26.845762  25.728091  ...
25.733414  25.705280  25.709665  25.665752  25.660608  ...
25.692441  25.728495  25.713982  25.792887  25.847286  ...
25.703102  25.760275  25.827108  25.811096  25.843938  ...
25.807976  25.850517  25.908265  25.954264  26.067842  ...
26.185619  26.333170  26.516002  26.558959  26.533311  ...
26.821182  26.730569  26.817399  26.898324  26.824057  ...
26.827736  26.750868  26.621556  26.550836  26.520351  ...
26.469123  26.455515  26.427073  26.395741  26.363467  ...
26.403884  26.345380  26.392563  26.411928  26.405193  ...
26.338934  26.334235  26.351828  25.643347  25.683964  ...
25.673346  25.711058  25.701438  25.697342  25.690372  ...
25.687278  25.696541  25.695487  25.718391  25.706820  ...
25.681127  25.689497  25.728776  25.672758  25.691506  ...
25.715085  25.667246  25.638967  25.618956  25.630895  ...
25.550061  25.604313  25.607326  25.567264  24.965604  ...
]; 


%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_c4.qcif -B glas_c4.cmp -b 99 -k 0 -X c4 -f 1 -I
%binDCT-C4: all I frames, with -I option.

g_c4_i_i = [ 28.500544  28.539136  28.524235  28.532099  28.569009  ...
28.483330  28.530658  28.560065  28.457847  28.456161  ...
28.345118  28.277006  28.192723  28.134076  28.174441  ...
28.124855  28.152034  28.081700  28.081715  28.083772  ...
28.119438  28.078511  28.105320  28.112698  26.930196  ...
27.031579  26.971933  26.957995  26.947216  26.897134  ...
26.956825  26.967121  26.982690  27.032148  27.075410  ...
27.021927  27.013479  27.098617  27.076616  27.072790  ...
27.018416  27.026088  27.087362  27.139110  27.207897  ...
27.323679  27.364098  27.625906  27.620307  27.697441  ...
27.849869  27.867313  27.896975  27.945671  27.982708  ...
27.966078  27.862100  27.899975  27.739952  27.689048  ...
27.741983  27.739983  27.730743  27.628467  27.656930  ...
27.607932  27.582411  27.569149  27.556035  27.629763  ...
27.645836  27.641351  27.621064  27.005005  27.039611  ...
27.052924  27.122714  27.057141  27.049315  27.016575  ...
27.075522  27.030037  27.085012  27.071419  27.018319  ...
27.047962  27.043824  27.042186  27.053471  26.969317  ...
26.989264  26.953214  26.987852  26.921059  26.913976  ...
26.889617  26.957354  26.997110  26.908698  26.412847  ...
]; 


%%%%%%%%%%%%%
%
% binDCT-C1:
%
%%%%%%%%%%%%%

%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_c1.qcif -B glas_c1.cmp -b 99 -k 0 -X c1

g_c1_p_noi = [ 27.036147  28.169986  28.381284  28.513820  28.559702  ...
28.500586  28.515879  28.514580  28.450070  28.443075  ...
28.430142  28.347461  28.169551  28.177340  28.191637  ...
28.233526  28.188679  28.226308  28.211778  28.159246  ...
28.186849  28.218284  28.218373  28.177913  25.522761  ...
26.591562  26.761191  26.838439  26.856300  26.885423  ...
26.955585  26.835738  26.951410  27.030919  27.015732  ...
26.957828  27.003390  27.024814  27.125688  27.130063  ...
27.102641  27.106734  27.135969  27.165546  27.253168  ...
27.327119  27.465361  27.559785  27.440138  27.456971  ...
27.440192  27.339387  27.438968  27.460419  27.566526  ...
27.622571  27.643208  27.597860  27.542291  27.592677  ...
27.657914  27.674870  27.665406  27.641061  27.611485  ...
27.716274  27.557490  27.518129  27.586278  27.608903  ...
27.531098  27.537466  27.689425  25.775408  26.571232  ...
26.778362  26.928816  26.938588  26.979945  27.032418  ...
27.103619  27.134818  27.088937  27.145804  27.163644  ...
27.169834  27.097127  27.031303  26.875406  26.863105  ...
26.803696  26.798659  26.732913  26.662040  26.757879  ...
26.760822  26.843351  26.904862  26.859002  25.026430  ...
]; 

%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_c1.qcif -B glas_c1.cmp -b 99 -k 0 -X c1 -f 1

g_c1_i_noi = [ 27.036147  27.081560  27.017817  27.070410  27.139055  ...
27.095224  26.968177  27.029383  26.938387  26.913298  ...
26.843810  26.737015  26.608172  26.690200  26.639076  ...
26.634113  26.625589  26.623015  26.653253  26.635796  ...
26.642198  26.649286  26.705187  26.684619  25.468098  ...
25.492138  25.455626  25.466228  25.357704  25.408647  ...
25.459235  25.442007  25.480389  25.504304  25.561859  ...
25.463233  25.523389  25.553935  25.580212  25.581979  ...
25.561194  25.614712  25.674347  25.694980  25.886724  ...
25.958794  26.104892  26.329357  26.359098  26.399449  ...
26.587745  26.519863  26.580704  26.683873  26.568896  ...
26.553399  26.513797  26.328291  26.235677  26.254822  ...
26.199011  26.226145  26.177623  26.145473  26.154354  ...
26.210182  26.120755  26.113295  26.159689  26.132612  ...
26.039888  26.024389  26.052028  25.386767  25.414418  ...
25.434169  25.424785  25.460740  25.411818  25.401318  ...
25.428689  25.424976  25.432960  25.469142  25.460521  ...
25.436138  25.403437  25.454337  25.399328  25.421153  ...
25.466434  25.453328  25.418493  25.436362  25.451182  ...
25.407355  25.398944  25.391122  25.344651  24.756961  ...
]; 


%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_c1.qcif -B glas_c1.cmp -b 99 -k 0 -X c1 -f 1 -I

g_c1_i_i = [ 28.344297  28.374033  28.347491  28.361499  28.372128  ...
28.277177  28.324602  28.318959  28.281136  28.223580  ...
28.165921  28.094832  27.980584  27.976608  27.978608  ...
27.918162  27.928473  27.926009  27.903929  27.919306  ...
27.903625  27.879181  27.914826  27.882339  26.711947  ...
26.769781  26.715595  26.727614  26.676899  26.657676  ...
26.707660  26.722811  26.708393  26.748875  26.833853  ...
26.744084  26.803287  26.890248  26.869071  26.894755  ...
26.786625  26.800097  26.890020  26.937270  27.001924  ...
27.178370  27.169281  27.443708  27.412746  27.425061  ...
27.641769  27.643787  27.668621  27.700755  27.694835  ...
27.720435  27.700155  27.603284  27.492468  27.534288  ...
27.462680  27.467934  27.435440  27.357807  27.391878  ...
27.392514  27.352001  27.346872  27.312220  27.351928  ...
27.372228  27.416752  27.379596  26.740576  26.801876  ...
26.773551  26.848816  26.745764  26.796440  26.792988  ...
26.819607  26.795449  26.787860  26.796907  26.794611  ...
26.767833  26.793826  26.744216  26.786114  26.730077  ...
26.752207  26.734281  26.776029  26.677263  26.738813  ...
26.733801  26.774279  26.750930  26.702018  26.236662  ...
]; 

%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% binDCT-L3
%
%%%%%%%%%%%%%%%%%%%%%%%%%%


%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_l3.qcif -B glas_l3.cmp -b 99 -k 0 -X l3

g_l3_p_noi = [ 27.252131  28.370904  28.531122  28.660790  28.703114  ...
28.695420  28.716865  28.749778  28.669817  28.635200  ...
28.546589  28.505918  28.331035  28.310868  28.317916  ...
28.357354  28.310623  28.384493  28.366902  28.265297  ...
28.338663  28.339508  28.296332  28.276554  25.765875  ...
26.803083  26.895493  26.889106  26.965050  27.011317  ...
27.090216  26.991066  27.061173  27.130350  27.164404  ...
27.158286  27.099268  27.105518  27.226687  27.250856  ...
27.215723  27.247843  27.269518  27.219899  27.311401  ...
27.492418  27.542428  27.623041  27.574364  27.497014  ...
27.579397  27.492032  27.670128  27.618675  27.690248  ...
27.730771  27.721844  27.702711  27.765761  27.762484  ...
27.763748  27.811156  27.805845  27.847003  27.795884  ...
27.860276  27.741966  27.645499  27.747079  27.629493  ...
27.625586  27.671344  27.815140  25.998315  26.799749  ...
26.984559  27.137261  27.185964  27.201439  27.267809  ...
27.318016  27.361144  27.325204  27.397662  27.361304  ...
27.344101  27.264821  27.203419  27.114275  27.111587  ...
26.999352  26.924783  26.874643  26.811684  26.867798  ...
26.883090  26.940426  27.030956  27.016298  25.200843  ...
]; 

%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_l3.qcif -B glas_l3.cmp -b 99 -k 0 -X l3 -f 1
g_l3_i_noi = [ 27.252131  27.326399  27.260202  27.317941  27.344774  ...
27.281709  27.205835  27.255056  27.169905  27.144907  ...
27.052189  26.984528  26.794437  26.843150  26.835307  ...
26.833698  26.826600  26.808198  26.835577  26.875342  ...
26.864241  26.830743  26.870585  26.844155  25.705238  ...
25.721088  25.670509  25.680169  25.625121  25.626448  ...
25.684469  25.701123  25.683468  25.746675  25.833292  ...
25.672066  25.748874  25.817421  25.794601  25.808350  ...
25.780845  25.825129  25.882868  25.924022  26.052298  ...
26.144501  26.315963  26.505908  26.539281  26.535227  ...
26.798656  26.702312  26.781594  26.880342  26.813474  ...
26.796250  26.750471  26.588473  26.503307  26.496353  ...
26.431761  26.450532  26.411473  26.361165  26.341985  ...
26.370131  26.309354  26.359502  26.393091  26.370000  ...
26.309333  26.304051  26.324545  25.606011  25.660481  ...
25.640733  25.667728  25.669336  25.675670  25.663621  ...
25.653116  25.675435  25.664970  25.689608  25.674950  ...
25.642504  25.662029  25.697359  25.653824  25.664697  ...
25.686043  25.641536  25.603881  25.595067  25.596813  ...
25.526122  25.591270  25.576171  25.518287  24.947890  ...
]; 

%Command:
%./tmn -i ../glasgo.qcif -o glas_rec_l3.qcif -B glas_l3.cmp -b 99 -k 0 -X l3 -f 1 -I
g_l3_i_i = [ 28.499740  28.559174  28.494239  28.515027  28.562620  ...
28.480226  28.526310  28.538769  28.458880  28.449814  ...
28.348597  28.275426  28.171386  28.127013  28.168379  ...
28.132056  28.163671  28.067960  28.082456  28.057031  ...
28.092834  28.046440  28.087441  28.101651  26.907319  ...
26.986880  26.948315  26.970008  26.904459  26.842048  ...
26.936286  26.916874  26.941236  27.003756  27.045220  ...
26.987582  26.980878  27.060396  27.048199  27.052173  ...
26.993292  27.023027  27.073255  27.128892  27.176746  ...
27.322620  27.328964  27.639024  27.610989  27.687362  ...
27.834873  27.836160  27.894772  27.900295  27.934419  ...
27.961556  27.867538  27.869137  27.688313  27.662463  ...
27.708762  27.676584  27.673326  27.611231  27.623797  ...
27.593016  27.582299  27.548135  27.525424  27.625084  ...
27.640509  27.615754  27.608064  26.951580  27.009825  ...
27.002836  27.105495  27.034907  27.015139  27.016742  ...
27.048846  26.994779  27.056055  27.031141  26.994586  ...
27.018613  27.015260  27.026691  26.989432  26.939308  ...
26.964332  26.934917  26.965459  26.888937  26.928411  ...
26.869452  26.935803  26.981053  26.892822  26.384883  ...
]; 
%%%%%%%%%%%%%%%%%%%%%%%%
%
% Effect of advanced_intra_coding for 
% each method:
%
%%%%%%%%%%%%%%%%%%%%%%%%

%close all;
figure;
plot(g_f_p_noi,'r');
hold on;
plot(g_f_i_noi, 'g');
hold on;
plot(g_f_i_i,'b');
legend('FLT-P-noI', 'FLT-I-noI', 'FLT-I- I');
ylabel('PSNR (dB)');
xlabel('Frame');
title('FLT DCT: Performance of advanced Intra Prediction');


figure;
plot(g_c1_p_noi,'r');
hold on;
plot(g_c1_i_noi, 'g');
hold on;
plot(g_c1_i_i, 'b');
legend('C1-P-noI', 'C1-I-noI', 'C1-I- I');
ylabel('PSNR (dB)');
xlabel('Frame');
title('binDCT-C1: Performance of advanced Intra Prediction');

figure;
plot(g_c4_p_noi,'r');
hold on;
plot(g_c4_i_noi, 'g');
hold on;
plot(g_c4_i_i, 'b');
legend('C4-P-noI', 'C4-I-noI', 'C4-I- I');
ylabel('PSNR (dB)');
xlabel('Frame');
title('binDCT-C4: Performance of advanced Intra Prediction');


figure;
plot(g_l3_p_noi,'r');
hold on;
plot(g_l3_i_noi, 'g');
hold on;
plot(g_l3_i_i,'b');
legend('L3-P-noI', 'L3-I-noI', 'L3-I- I');
ylabel('PSNR (dB)');
xlabel('Frame');
title('binDCT-L3: Performance of advanced Intra Prediction');

%%%%%%%%%%%%%%%%%%%%%%%
%
% Difference between FLT and binDCT
%
%%%%%%%%%%%%%%%%%%%%%%%

figure;
plot(g_f_p_noi,'r');
hold on;
plot(g_c1_p_noi, 'g');
hold on;
plot(g_c4_p_noi, 'b');
hold on;
plot(g_l3_p_noi, 'm');
legend('FLT-P-noI', 'C1-P-noI', 'C4-P-noI', 'L3-P-noI');
ylabel('PSNR (dB)');
title('Flt DCT vs binDCT-C1, C4 & L3: all(except 1) P frames, no -I option');

flt_c1 = sum(g_f_p_noi - g_c1_p_noi) / length(g_f_p_noi);
flt_c4 = sum(g_f_p_noi - g_c4_p_noi) / length(g_f_p_noi);
flt_l3 = sum(g_f_p_noi - g_l3_p_noi) / length(g_f_p_noi);
s=sprintf('Frame  (Average degradation: C1: %fdB, C4: %fdB, L3: %fdB)', flt_c1, flt_c4, flt_l3);
xlabel(s);

figure;
plot(g_f_i_noi,'r');
hold on;
plot(g_c1_i_noi, 'g');
hold on;
plot(g_c4_i_noi, 'b');
hold on;
plot(g_l3_i_noi, 'm');
legend('FLT-I-noI', 'C1-I-noI', 'C4-I-noI', 'L3-I-noI');
ylabel('PSNR (dB)');
title('Flt DCT vs binDCT-C1, C4 & L3: all I frames, no -I option');

flt_c1 = sum(g_f_i_noi - g_c1_i_noi) / length(g_f_p_noi);
flt_c4 = sum(g_f_i_noi - g_c4_i_noi) / length(g_f_p_noi);
flt_l3 = sum(g_f_i_noi - g_l3_i_noi) / length(g_f_p_noi);
s=sprintf('Frame  (Average degradation: C1: %fdB, C4: %fdB, L3: %fdB)', flt_c1, flt_c4, flt_l3);
xlabel(s);

figure;
plot(g_f_i_i,'r');
hold on;
plot(g_c1_i_i, 'g');
hold on;
plot(g_c4_i_i, 'b');
hold on;
plot(g_l3_i_i, 'm');
legend('FLT-I-I', 'C1-I-I', 'C4-I-I', 'L3-I-I');
ylabel('PSNR (dB)');
title('Flt DCT vs binDCT-C1, C4 & L3: all I frames, with -I option');

flt_c1 = sum(g_f_i_i - g_c1_i_i) / length(g_f_p_noi);
flt_c4 = sum(g_f_i_i - g_c4_i_i) / length(g_f_p_noi);
flt_l3 = sum(g_f_i_i - g_l3_i_i) / length(g_f_p_noi);

s=sprintf('Frame  (Average degradation: C1: %fdB, C4: %fdB, L3: %fdB)', flt_c1, flt_c4, flt_l3);
xlabel(s);

%%%%%%%%%%%%%%%%%%%%%%
%
%  End of file
%
%%%%%%%%%%%%%%%%%%%%%%
