function h263_q()
%generate the quantization matrix for H.263.
%The method here is different from the JPEG.
%In JPEG, the input quality factor is used through all the image.
%In H.263, there are too many cases for the quantization steps.
%So it's not efficient to create multiple matrices.
%
%Therefore, we only provide the basic matrix, which will be
%scaled to QP in various place, not matter what value the QP is.


%c_scale = [ ...
%  0.353553391, 0.509795579, 0.541196100, 0.601344887, ...
%  0.707106781, 0.415734806, 0.461939766, 0.49039264 ...
%]';

c_scale = [sin(pi/4)/2, 1/2/sin(7*pi/16), 1/2/sin(3*pi/8), 1/2/cos(3*pi/16), ...
	      sin(pi/4), cos(3*pi/16)/2, sin(3*pi/8)/2, sin(7*pi/16)/2]'

c_matrix_f =  1 ./ (c_scale * c_scale')
c_matrix = round( 1 ./ (c_scale * c_scale') * 128)

(c_matrix_f - c_matrix/128) ./ c_matrix_f * 100

%l_scale = [ ...
% 0.353553391, 0.353553391, 0.541196100, 0.5,  ...
% 0.707106781, 0.5,         0.461939766, 0.70710678  ...
%]';

l_scale = [sin(pi/4)/2, 1/sqrt(8), 1/2/sin(3*pi/8), 1/2, ...
	      sin(pi/4), 1/2,   sin(3*pi/8)/2, 1/sqrt(2)]'

l_matrix_f =  1 ./ (l_scale * l_scale')
l_matrix = round( 1 ./ (l_scale * l_scale') * 128)

(l_matrix_f - l_matrix/128) ./ l_matrix_f * 100
