function psnr263(colorplot)
%test which way is better for gettingquantization matrix:
%1: round(QP * (flt)scale);
%2: QP * round(scale x 128);
%
% summary:
% binDCt is better for A=2 -- 8, a littler bit worse than H.263 after that.
% but when A=1, the binDCt is quite bad, why? matrix error?
%

if nargin == 0
  colorplot = 1;
end

close all;




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% forman:  default quant step
% compatibility of the C4--> F or F --> C4.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Foreman (Default Quant. steps): ';

f_f = [ 29.229463  30.367657  30.622751  30.719441  30.725884  ...
30.794678  30.707078  30.698174  30.838927  30.805295  ...
30.896550  30.788468  30.751976  30.776014  30.716500  ...
30.738785  30.832072  30.827054  30.823625  30.725604  ...
30.656988  30.521487  30.435347  30.587701  30.534542  ...
30.492445  30.492165  30.608391  30.586582  30.532927  ...
30.570252  30.587251  30.602144  30.600773  30.667239  ...
30.676126  30.598068  30.630319  30.730231  30.794622  ...
30.834671  30.799124  30.793878  30.734770  30.686090  ...
30.671685  30.747560  30.839048  30.830952  30.816454  ...
30.842640  30.798139  30.711263  30.688989  30.884328  ...
30.798611  30.810488  30.824571  30.821902  30.846827  ...
30.772996  30.735185  30.644372  30.521704  30.468218  ...
30.522976  30.540116  30.513447  30.493925  30.579945  ...
30.609218  30.559252  30.585991  30.736606  30.779279  ...
30.722758  30.679545  30.705651  30.784747  30.755493  ...
30.640617  30.726831  30.652015  30.705239  30.690107  ...
30.700641  30.754086  30.806434  30.911029  30.975469  ...
30.949855  30.977557  31.011687  31.056093  31.120207  ...
31.267013  31.212274  31.203646  31.152837  31.183097  ...
31.210257  31.222319  31.250541  31.189299  31.166022  ...
31.136685  31.107276  31.112049  31.093589  31.001835  ...
30.894270  30.870798  30.765512  30.626134  30.667153  ...
30.629883  30.653975  30.576802  30.614045  30.661248  ...
30.626320  30.752876  30.731781  30.850037  30.858822  ...
30.906942  30.759779  30.721644  30.874960  30.919654  ...
30.900524  30.968461  30.867762  30.859560  30.820348  ...
30.823937  30.814552  30.903177  30.892616  30.825036  ...
31.010572  31.060498  30.942581  31.006374  30.973117  ...
31.062998  30.970671  30.893351  30.774977  30.690487  ...
30.731694  30.697635  30.755628  30.691475  30.575881  ...
30.548035  30.500340  30.524644  30.683769  30.906367  ...
30.918892  30.868756  30.798072  30.791743  30.849316  ...
30.847218  30.788620  30.870257  30.772423  30.639167  ...
30.735388  30.766596  30.794523  30.883182  30.903242  ...
30.913562  30.972313  30.914619  30.842093  30.778349  ...
30.665264  30.589152  30.578096  30.521436  30.309858  ...
30.352117  30.364638  30.268892  30.336899  30.762998  ...
30.873597  30.761110  30.831973  30.966538  30.971983  ...
30.812251  30.861767  30.992117  30.981186  30.909732  ...
31.031615  30.990601  31.072417  31.059321  31.071081  ...
31.135634  31.001151  31.158583  31.227822  31.113248  ...
30.965313  31.031575  31.003113  30.952477  30.994459  ...
31.029527  31.016723  31.035473  31.163207  31.168956  ...
31.145174  31.076693  31.017719  31.009751  30.926121  ...
30.830221  30.706014  30.665525  30.520744  30.436503  ...
30.325131  30.301627  30.243680  30.256496  30.212180  ...
30.157305  30.303989  30.483110  30.504396  30.509777  ...
30.484330  30.643590  30.647651  30.737118  30.947983  ...
31.021324  31.141169  31.296651  31.159980  31.200688  ...
31.189947  31.255950  31.529013  31.669166  31.171907  ...
30.942060  30.986061  31.079186  30.611083  30.472391  ...
30.489958  30.578391  30.670479  30.681977  30.725118  ...
30.670525  30.811435  30.926395  30.952637  31.022118  ...
31.011477  30.987305  30.834683  30.786582  30.703615  ...
30.623332  30.761424  30.813494  30.755145  30.800473  ...
31.083885  31.308083  31.437469  31.368686  31.626156  ...
31.873400  32.296191  32.611350  33.144267  33.005990  ...
32.863722  32.366630  32.190574  32.054511  31.974923  ...
31.577861  31.312120  31.427496  31.781641  32.161238  ...
32.737673  33.072032  33.231178  33.073337  33.202249  ...
33.200134  33.128288  33.259508  33.270580  32.873021  ...
32.263836  31.663929  31.272973  31.072316  30.915429  ...
30.691868  30.390706  30.038390  29.609025  29.408457  ...
29.214768  29.207046  29.223753  29.173473  29.388262  ...
29.573595  29.576596  29.493424  29.349142  29.251266  ...
29.129558  29.053012  28.973528  29.019633  28.951890  ...
28.983488  29.127309  29.128833  29.276681  29.164768  ...
29.098912  29.063631  29.106530  29.102989  29.059270  ...
28.970040  28.930812  28.941737  28.877507  28.819231  ...
28.893457  28.984783  28.921255  28.981435  29.027294  ...
28.988817  28.920192  28.784460  28.807454  28.839635  ...
28.817151  28.797887  28.782035  28.812307  28.796347  ...
28.915899  28.854361  28.847931  28.828017  28.816563  ...
28.777279  28.825355  28.934089  28.879372  28.818783  ...
28.866457  28.859974  28.812520  28.774182  28.763048  ...
28.847104  28.913256  28.964374  28.908590  28.936613  ...
28.893347  28.822551  28.858179  28.807572  28.850385  ...
28.938809  28.974578  28.971360  29.051949  28.982020  ...
28.878832  28.854432  28.845950  28.821689  28.776741  ...
];
 %Average:   30.545795, 35.700990, 36.185410

f_c4 = [ 29.190797  30.337107  30.592374  30.697657  30.702264  ...
30.772776  30.686299  30.671968  30.805432  30.772470  ...
30.853378  30.750604  30.707298  30.728464  30.665983  ...
30.704619  30.787659  30.783099  30.791145  30.694279  ...
30.620230  30.463392  30.378595  30.528249  30.471565  ...
30.430554  30.423085  30.547503  30.528636  30.486334  ...
30.519493  30.544276  30.556771  30.554701  30.618251  ...
30.639045  30.562176  30.595722  30.687056  30.742480  ...
30.787931  30.755769  30.741607  30.689338  30.630581  ...
30.628040  30.704789  30.799897  30.802460  30.781137  ...
30.794678  30.752058  30.664048  30.634190  30.827408  ...
30.740710  30.743049  30.779156  30.765597  30.792768  ...
30.715934  30.667058  30.593504  30.498956  30.421822  ...
30.473454  30.501620  30.470446  30.459813  30.553477  ...
30.564195  30.516112  30.518730  30.647592  30.690650  ...
30.643960  30.596339  30.621829  30.685858  30.654435  ...
30.524492  30.601717  30.515156  30.573952  30.555462  ...
30.571598  30.621178  30.659318  30.772423  30.858603  ...
30.830457  30.867469  30.929113  30.951614  31.007780  ...
31.133009  31.070791  31.058211  31.003023  31.050645  ...
31.069082  31.064126  31.091763  31.020918  31.010300  ...
30.980433  30.937578  30.947901  30.949226  30.861475  ...
30.774776  30.755283  30.658325  30.520985  30.574876  ...
30.530265  30.546080  30.461574  30.518997  30.559747  ...
30.532221  30.641408  30.608506  30.707081  30.716646  ...
30.777054  30.606414  30.582626  30.739267  30.773862  ...
30.782285  30.830728  30.731921  30.731996  30.673420  ...
30.670273  30.651764  30.702602  30.704452  30.662666  ...
30.828301  30.867659  30.747372  30.812798  30.780345  ...
30.877079  30.786898  30.712313  30.596952  30.546636  ...
30.608197  30.553842  30.633775  30.580882  30.473346  ...
30.432947  30.392800  30.423846  30.565383  30.768090  ...
30.773702  30.713757  30.625194  30.611991  30.675870  ...
30.672691  30.605336  30.678834  30.555486  30.434814  ...
30.516581  30.534015  30.585469  30.645883  30.659042  ...
30.720216  30.780402  30.723514  30.660904  30.652600  ...
30.550036  30.454540  30.420988  30.381307  30.179690  ...
30.208932  30.243340  30.110724  30.179943  30.558416  ...
30.627675  30.519425  30.602992  30.746336  30.755744  ...
30.588552  30.664432  30.765480  30.780222  30.679459  ...
30.779607  30.749329  30.821322  30.787969  30.820036  ...
30.873401  30.761720  30.915165  30.984878  30.880547  ...
30.742436  30.789915  30.782276  30.727806  30.811330  ...
30.842925  30.837993  30.830690  30.949190  30.905202  ...
30.880660  30.834489  30.764600  30.787978  30.702391  ...
30.600821  30.505017  30.469597  30.333930  30.238986  ...
30.144190  30.126469  30.089126  30.098910  30.047154  ...
29.978742  30.114323  30.262858  30.279413  30.256937  ...
30.199905  30.380580  30.352908  30.434461  30.639484  ...
30.641512  30.752625  30.922498  30.820218  30.805067  ...
30.828282  30.916809  31.182322  31.379745  31.019494  ...
30.805762  30.856709  30.951522  30.497129  30.375790  ...
30.366493  30.473416  30.552238  30.550538  30.618333  ...
30.566797  30.659659  30.787321  30.795099  30.828157  ...
30.823447  30.844234  30.693976  30.629243  30.540373  ...
30.499275  30.626987  30.671467  30.616924  30.663120  ...
30.940679  31.204080  31.335500  31.265162  31.490385  ...
31.703090  32.189553  32.521704  33.076306  32.895025  ...
32.746766  32.234474  32.063575  31.931181  31.874569  ...
31.512929  31.222053  31.332795  31.678600  32.052033  ...
32.639491  33.003574  33.138525  33.026362  33.159699  ...
33.160485  33.100944  33.234823  33.242411  32.851271  ...
32.237464  31.637253  31.247663  31.050504  30.893075  ...
30.670974  30.360429  30.016533  29.582163  29.374818  ...
29.198444  29.183474  29.198595  29.158100  29.366542  ...
29.551889  29.554700  29.456486  29.330221  29.220757  ...
29.097946  29.006037  28.928732  28.971922  28.919253  ...
28.953308  29.095230  29.103289  29.252648  29.144088  ...
29.092370  29.065560  29.106628  29.090656  29.031435  ...
28.946870  28.899988  28.911463  28.841712  28.766322  ...
28.844488  28.935052  28.866907  28.916415  28.967114  ...
28.921623  28.856121  28.736379  28.750869  28.787535  ...
28.765757  28.748913  28.727382  28.750397  28.731325  ...
28.832729  28.774655  28.766433  28.744034  28.717234  ...
28.681467  28.711695  28.813285  28.771701  28.716675  ...
28.761467  28.752275  28.701421  28.662349  28.639664  ...
28.719192  28.799128  28.858160  28.807596  28.839498  ...
28.787413  28.722442  28.763246  28.703076  28.750330  ...
28.832987  28.870945  28.876683  28.946719  28.893414  ...
28.777602  28.744732  28.747599  28.713850  28.682436  ...
];
 %Average:   30.426925, 35.657138, 36.134606

c4_f = [ 29.201739  30.266432  30.534921  30.640788  30.609552  ...
30.614036  30.625352  30.648951  30.742451  30.735363  ...
30.864050  30.661859  30.735210  30.635007  30.678525  ...
30.682616  30.796008  30.788240  30.704746  30.657951  ...
30.515928  30.406917  30.297341  30.361962  30.295251  ...
30.352800  30.362111  30.393359  30.478103  30.424750  ...
30.421447  30.442837  30.449893  30.488622  30.533347  ...
30.500529  30.425453  30.572275  30.508995  30.621102  ...
30.681746  30.692127  30.764223  30.591157  30.559003  ...
30.553884  30.611208  30.765851  30.799418  30.773015  ...
30.746662  30.771092  30.615833  30.594477  30.699418  ...
30.764421  30.710720  30.675436  30.766204  30.783494  ...
30.762382  30.762772  30.615560  30.365750  30.392390  ...
30.349965  30.364517  30.288714  30.242766  30.333942  ...
30.418121  30.428032  30.457078  30.554333  30.588953  ...
30.580050  30.555028  30.675153  30.630133  30.558149  ...
30.500978  30.618194  30.587315  30.613781  30.552588  ...
30.593519  30.662866  30.649364  30.755650  30.835683  ...
30.809367  30.821255  30.858186  30.872769  30.870482  ...
31.006141  30.996153  30.956492  30.985615  31.003176  ...
31.059882  31.072191  31.059993  30.965975  30.894969  ...
30.870376  30.880760  30.968909  30.916822  30.815099  ...
30.713542  30.716910  30.682067  30.532844  30.511538  ...
30.451220  30.486617  30.379271  30.418373  30.449434  ...
30.477447  30.509845  30.628098  30.681944  30.646718  ...
30.696917  30.636560  30.591079  30.771507  30.856991  ...
30.803887  30.816912  30.733213  30.742955  30.740801  ...
30.806977  30.683513  30.741548  30.719768  30.671667  ...
30.823220  30.950065  30.949577  30.864873  30.911923  ...
30.864995  30.794131  30.786288  30.593332  30.488365  ...
30.485420  30.487171  30.430275  30.345440  30.341940  ...
30.179228  30.174367  30.195192  30.418800  30.541654  ...
30.716951  30.739004  30.624256  30.722061  30.674516  ...
30.644966  30.722061  30.723875  30.571691  30.698103  ...
30.662362  30.756808  30.705698  30.873942  30.860068  ...
30.749808  30.807183  30.656301  30.771413  30.635425  ...
30.505017  30.395576  30.329399  30.299992  30.155360  ...
30.203290  30.164979  30.121924  30.210907  30.511345  ...
30.709311  30.624670  30.551460  30.649927  30.743421  ...
30.617416  30.686336  30.742792  30.749843  30.708117  ...
30.765053  30.809396  30.833540  30.856353  30.867231  ...
30.881987  30.876395  30.916203  30.991054  30.989697  ...
30.763900  30.833611  30.858077  30.766376  30.803237  ...
30.796489  30.719886  30.732121  30.869091  30.917206  ...
30.921537  30.820950  30.884425  30.755537  30.682505  ...
30.518463  30.473872  30.385386  30.273072  30.185173  ...
30.124180  30.062016  30.082893  30.020937  30.026382  ...
29.960134  30.017805  30.202467  30.228299  30.253735  ...
30.349837  30.420257  30.423300  30.399760  30.565284  ...
30.737530  30.811406  31.035296  30.932985  30.941353  ...
30.887760  30.985330  31.211855  31.444950  31.099838  ...
30.689078  30.688423  30.794457  30.325111  30.203447  ...
30.249850  30.355133  30.444013  30.477588  30.434042  ...
30.531471  30.675824  30.855579  30.806469  30.844422  ...
30.751744  30.757667  30.668841  30.662921  30.518671  ...
30.432778  30.427625  30.514806  30.565266  30.715195  ...
30.802641  31.270543  31.190079  31.212298  31.503587  ...
31.757891  32.024635  32.364699  32.944299  32.994862  ...
32.728436  32.380135  32.195831  31.974201  31.849705  ...
31.492462  31.159860  31.279683  31.678154  32.098537  ...
32.616691  32.991886  33.230063  32.979632  33.047685  ...
33.010526  32.944849  33.074268  33.150043  32.694630  ...
32.252294  31.641750  31.255341  31.057966  30.888582  ...
30.623703  30.308231  29.887246  29.542458  29.342550  ...
29.203261  29.181810  29.147513  29.225105  29.230108  ...
29.512671  29.559040  29.531436  29.324370  29.211378  ...
29.068271  28.978203  28.933868  28.901240  28.856447  ...
28.936805  28.981403  29.069634  29.162792  29.019976  ...
28.921380  28.843999  28.880025  28.931663  28.879097  ...
28.874564  28.775081  28.846201  28.812479  28.810505  ...
28.769425  28.853011  28.768552  28.815510  28.860239  ...
28.766373  28.736121  28.607583  28.613169  28.563212  ...
28.650201  28.664931  28.640457  28.652949  28.698168  ...
28.795632  28.801175  28.783245  28.743824  28.683619  ...
28.669131  28.697383  28.766296  28.748423  28.744213  ...
28.767518  28.757714  28.711651  28.719965  28.675968  ...
28.685948  28.712198  28.740439  28.718356  28.764696  ...
28.739002  28.740731  28.745857  28.720088  28.687810  ...
28.811419  28.841954  28.827429  28.879950  28.846643  ...
28.813410  28.739148  28.726647  28.678689  28.666367  ...
];
 %Average:   30.391820, 35.732677, 36.113389

%148115bytes; Comp. ratio: 102.67
%psnr drop: 0.0844 dB
c4_c4 = [ 29.186788  30.274004  30.546023  30.657782  30.635624  ...
30.648792  30.661494  30.687719  30.785486  30.771375  ...
30.902103  30.705323  30.781424  30.664201  30.702115  ...
30.715614  30.833112  30.825932  30.739979  30.690725  ...
30.547425  30.426407  30.330391  30.396958  30.331833  ...
30.389310  30.399720  30.432263  30.520916  30.480340  ...
30.461246  30.489521  30.487289  30.526056  30.578385  ...
30.537160  30.467273  30.616025  30.543887  30.667949  ...
30.727018  30.742708  30.803795  30.631016  30.594259  ...
30.584528  30.643352  30.797714  30.823150  30.792337  ...
30.763752  30.806850  30.643886  30.636234  30.758122  ...
30.822615  30.762602  30.718359  30.796543  30.828084  ...
30.807710  30.808405  30.664057  30.429361  30.437681  ...
30.411380  30.432408  30.351491  30.303800  30.398948  ...
30.473878  30.486239  30.517151  30.621601  30.645678  ...
30.627550  30.619592  30.751914  30.705692  30.619339  ...
30.554537  30.671974  30.624832  30.648813  30.584661  ...
30.641564  30.710186  30.695748  30.812575  30.893189  ...
30.883469  30.905585  30.933930  30.947934  30.934747  ...
31.065598  31.050810  31.019918  31.023942  31.049165  ...
31.122916  31.146580  31.124650  31.052693  30.991962  ...
30.949495  30.929073  31.031599  30.998898  30.871957  ...
30.784315  30.768056  30.753261  30.610143  30.588298  ...
30.537736  30.589352  30.477744  30.522512  30.544078  ...
30.573477  30.611748  30.732314  30.777634  30.731584  ...
30.787801  30.706820  30.660036  30.861006  30.935930  ...
30.888297  30.876963  30.793299  30.790418  30.836114  ...
30.879269  30.743468  30.784065  30.732055  30.698619  ...
30.848663  30.957418  30.954915  30.882242  30.917795  ...
30.922498  30.862992  30.841926  30.659877  30.570273  ...
30.574079  30.585695  30.520551  30.456068  30.452375  ...
30.307577  30.306811  30.348657  30.533347  30.642123  ...
30.790165  30.817099  30.693509  30.774520  30.725177  ...
30.704275  30.781560  30.780733  30.612692  30.734998  ...
30.684911  30.763278  30.743633  30.901970  30.896304  ...
30.840292  30.902369  30.772281  30.880237  30.784855  ...
30.660493  30.544252  30.456612  30.440987  30.300808  ...
30.351116  30.323935  30.260991  30.360627  30.631830  ...
30.780323  30.683615  30.621942  30.744472  30.830760  ...
30.703550  30.744059  30.780153  30.809078  30.766949  ...
30.822341  30.856542  30.885100  30.922267  30.941393  ...
30.950292  30.988158  31.018102  31.095149  31.110422  ...
30.891050  30.950059  30.969419  30.905036  30.967101  ...
30.937323  30.854652  30.848903  30.986151  31.014435  ...
31.030472  30.943426  31.010419  30.895002  30.812172  ...
30.689569  30.635428  30.542403  30.420614  30.320626  ...
30.259278  30.205425  30.262197  30.195007  30.191971  ...
30.120236  30.166896  30.345417  30.351019  30.361566  ...
30.456457  30.529124  30.527437  30.498518  30.666880  ...
30.801345  30.914290  31.131887  31.052149  31.054356  ...
31.053812  31.115727  31.381592  31.583466  31.212082  ...
30.802854  30.809793  30.935129  30.464383  30.358443  ...
30.365010  30.507214  30.601021  30.615165  30.611448  ...
30.680159  30.826047  30.980582  30.930324  30.987712  ...
30.905793  30.920674  30.839080  30.812261  30.664441  ...
30.539027  30.576552  30.645632  30.688535  30.873803  ...
30.994827  31.471265  31.347053  31.335615  31.655876  ...
31.881168  32.140662  32.475955  33.025706  33.041343  ...
32.754004  32.390715  32.170420  31.988557  31.852898  ...
31.510137  31.169029  31.290762  31.692672  32.115356  ...
32.622139  32.995283  33.227636  32.973001  33.054059  ...
33.019823  32.955812  33.107628  33.194070  32.724951  ...
32.272348  31.657331  31.270140  31.078716  30.908663  ...
30.629530  30.320975  29.907321  29.552876  29.355646  ...
29.211813  29.185311  29.152728  29.245725  29.241366  ...
29.517107  29.569667  29.528747  29.337131  29.219277  ...
29.066708  28.974395  28.928944  28.900622  28.866737  ...
28.953527  29.005345  29.111170  29.208045  29.075845  ...
28.986780  28.906666  28.951743  29.001114  28.946140  ...
28.949019  28.822216  28.916626  28.874818  28.873648  ...
28.832244  28.918123  28.829963  28.874545  28.932320  ...
28.815598  28.803293  28.666354  28.663532  28.620524  ...
28.702076  28.711313  28.680810  28.708614  28.747163  ...
28.837453  28.847561  28.819552  28.769092  28.724770  ...
28.705368  28.744172  28.811040  28.783236  28.783520  ...
28.798586  28.789272  28.741995  28.742933  28.702773  ...
28.717357  28.751480  28.795522  28.785719  28.821183  ...
28.805979  28.796420  28.818147  28.779963  28.766858  ...
28.884748  28.921352  28.894623  28.930085  28.912390  ...
28.880441  28.814918  28.809055  28.745881  28.744602  ...
];
 %Average:   30.461380, 35.724579, 36.110939

figure;
plot(f_f, ':r');
hold on;
plot(c4_c4, '-');
legend('H.263+ --> H.263+', 'binDCT C4 --> binDCT C4');
ylabel('PSNR (dB)');
xlabel('Frame');

err = mean(f_f - c4_c4);
s=sprintf(' Average Difference: %8.4fdB.', err);
t=strcat(t1,s);
title(t);

figure;
plot(f_c4,':r');
hold on;
plot(c4_f, '-');
legend('H.263+ --> binDCT C4', 'binDCT C4 --> H.263+');
ylabel('PSNR (dB)');
xlabel('Frame');
err = mean(f_c4 - c4_f);
s=sprintf(' Average Difference: %8.4fdB.', err);
t=strcat(t1,s);
title(t);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Forman: A4 q4
%file size: f      c1       c4       c7     l3
%          771275  796371  792859  793331   792048
%PSNR      36.8361 35.7221 36.0913  36.1270 35.9800
%imp.   
%
%encoder side:
%PSNR      36.8820 36.8738 37.0658  37.0702 37.0253
%imp.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Foreman (Quant. step is 8) ';

f_f = [ 38.873868  37.429856  37.331344  37.236188  37.125676  ...
37.085511  37.096543  37.095072  37.033411  37.121572  ...
37.114949  36.997662  36.991686  36.880041  36.956932  ...
36.886805  36.941072  36.992899  37.102517  36.954552  ...
37.032932  36.885943  36.942948  36.965703  36.906602  ...
36.840331  36.830031  36.972102  36.810250  36.793089  ...
36.802936  36.846777  36.824509  36.817602  36.871852  ...
36.824218  36.785376  36.805044  36.812526  36.797096  ...
36.846446  36.874495  36.857564  36.797197  36.757733  ...
36.834440  36.919107  37.067672  37.071511  36.924010  ...
36.961917  36.940681  36.841426  36.763983  36.918939  ...
36.918977  36.809403  36.968586  37.102922  37.129443  ...
37.036300  36.891285  36.995946  36.860799  36.847632  ...
36.732822  36.789225  36.702574  36.652836  36.674532  ...
36.716076  36.673258  36.761270  36.733742  36.761645  ...
36.769265  36.745721  36.723480  36.892277  36.840267  ...
36.717301  36.806332  36.859265  36.845439  36.859073  ...
36.820997  36.899653  36.887435  36.914857  36.986364  ...
37.020268  37.058720  37.016342  37.110828  37.052606  ...
37.025220  37.073995  36.937594  36.976566  37.000660  ...
37.184051  37.259989  37.207166  37.220972  37.232382  ...
37.098421  37.013108  37.254369  37.061090  37.014645  ...
36.956814  36.989841  36.930959  36.843311  36.845107  ...
36.693826  36.698568  36.722415  36.643834  36.735469  ...
36.774466  36.773137  36.861490  36.840191  36.834453  ...
36.763295  36.712564  36.814373  37.054532  36.951182  ...
36.858549  36.861362  36.934276  36.847096  36.905762  ...
36.882535  36.890139  36.892354  36.882843  36.891336  ...
36.867686  36.973296  36.909136  36.899756  36.968311  ...
36.924828  36.937282  36.907765  36.865445  36.761170  ...
36.764809  36.766448  36.796516  36.733456  36.809883  ...
36.738291  36.675439  36.689102  36.710734  36.803529  ...
36.906964  36.774767  36.826514  36.800273  36.797827  ...
36.807153  36.918303  36.924296  36.881545  36.810781  ...
36.891143  36.906615  36.922142  37.044686  37.054786  ...
37.074627  37.120540  37.058559  37.026084  37.003461  ...
36.958279  36.747004  36.715123  36.702414  36.711649  ...
36.595205  36.668728  36.602141  36.596071  36.782197  ...
36.834783  36.956893  37.017588  37.080866  37.113728  ...
37.018278  37.015931  37.055829  37.130192  37.118558  ...
37.210395  37.251486  37.114854  37.218749  37.088354  ...
37.056231  37.079736  37.195973  37.312724  37.222890  ...
37.095436  37.121015  37.131499  37.075514  37.134794  ...
37.088179  37.075487  37.092008  37.332484  37.316842  ...
37.219499  37.128464  37.201974  37.074492  37.027705  ...
36.991106  36.981429  36.820693  36.789665  36.791150  ...
36.769566  36.773638  36.731419  36.676542  36.613750  ...
36.669499  36.635750  36.778192  36.757945  36.760957  ...
36.748213  36.739248  36.764471  36.843489  37.085578  ...
37.110665  37.262991  37.463760  37.386257  37.270364  ...
37.302743  37.355616  37.592386  37.619933  37.541668  ...
37.194150  37.354427  37.476550  37.043178  36.875932  ...
36.913433  36.892741  36.978971  36.966109  37.027067  ...
37.044953  37.125010  37.289537  37.296022  37.371787  ...
37.315493  37.249443  37.217540  37.248953  37.221639  ...
37.265489  37.348698  37.460073  37.445194  37.464745  ...
37.578466  37.739790  37.857591  37.892179  38.197597  ...
38.483972  38.668103  38.833571  39.125361  39.112839  ...
38.929778  38.668219  38.698578  38.663587  38.593904  ...
38.239773  38.027613  38.085799  38.220698  38.396056  ...
38.693231  38.929572  39.048120  38.911752  38.906320  ...
38.772239  38.616611  38.660798  38.560801  38.376446  ...
37.944707  37.616187  37.385348  37.367142  37.363134  ...
37.245961  37.080059  36.559353  36.251866  36.032564  ...
35.996186  35.917223  35.969090  35.960765  35.963001  ...
36.394775  36.330294  36.087965  35.933455  35.940610  ...
35.757333  35.845286  35.724155  35.740984  35.722954  ...
35.807596  35.736391  35.846754  35.976524  35.751028  ...
35.714095  35.755766  35.828452  35.904858  35.812085  ...
35.763568  35.672712  35.735246  35.788658  35.781798  ...
35.844851  35.961690  35.735058  35.736707  35.724628  ...
35.601102  35.646057  35.528845  35.675029  35.714822  ...
35.747285  35.631229  35.560682  35.544206  35.545897  ...
35.703754  35.619391  35.599169  35.522722  35.466939  ...
35.465009  35.546294  35.626692  35.668560  35.574681  ...
35.645815  35.495110  35.447699  35.474638  35.484075  ...
35.514852  35.683565  35.658908  35.554675  35.617201  ...
35.585444  35.556077  35.488250  35.583546  35.682394  ...
35.776075  35.738000  35.676859  35.798202  35.802661  ...
35.578631  35.546256  35.434084  35.456188  35.419457  ...
];
 %Average:   36.836171, 40.090849, 41.292811

c4_c4 = [ 38.973436  37.676299  37.578859  37.379636  37.349127  ...
37.270252  37.244438  37.312256  37.276215  37.274611  ...
37.305718  37.208607  37.165846  36.990197  37.083894  ...
37.070584  37.087195  37.182853  37.239257  37.193860  ...
37.141475  37.050922  37.106643  37.171365  37.071175  ...
37.046581  37.071309  37.143441  37.023201  37.011519  ...
37.046928  37.080529  37.038778  37.064735  37.085133  ...
36.982297  36.944122  36.955219  36.936188  36.996092  ...
37.011704  37.055134  37.033145  36.986206  36.953664  ...
37.041418  37.055883  37.186091  37.175860  37.192286  ...
37.108024  37.094032  37.086602  36.999788  37.077691  ...
37.051858  36.973677  37.082077  37.172093  37.249317  ...
37.206072  37.162718  37.184451  37.081364  37.087545  ...
37.053943  37.062189  36.928685  36.834491  36.855239  ...
36.933391  37.006820  37.003131  36.959352  37.025313  ...
37.034636  37.024277  36.913484  37.078619  37.078808  ...
36.953037  36.969937  37.011492  37.042525  36.979799  ...
37.112305  37.212794  37.161100  37.189663  37.114013  ...
37.231713  37.266107  37.263257  37.189981  37.148290  ...
37.107388  37.155881  37.160621  37.171035  37.262907  ...
37.402630  37.415357  37.352421  37.362201  37.424464  ...
37.323810  37.301285  37.430906  37.307022  37.238671  ...
37.268832  37.220638  37.177552  37.189222  37.154417  ...
37.012353  36.994377  36.973454  36.869339  37.014022  ...
37.011876  36.955677  37.131471  37.124303  37.087127  ...
36.934419  36.917150  37.013373  37.236146  37.146991  ...
37.087303  37.046528  37.051684  36.935121  37.050655  ...
37.046861  37.140002  37.086386  37.104951  36.966043  ...
37.095045  37.101949  37.059644  37.152282  37.147360  ...
37.121871  37.119562  37.159058  37.074573  37.047396  ...
36.968075  37.014287  36.983837  36.980627  37.075594  ...
37.000620  36.879270  36.907481  36.992886  37.035381  ...
37.152816  37.124942  37.094505  37.073041  37.074560  ...
37.038712  37.156757  37.175874  37.122210  37.042284  ...
37.125689  37.195407  37.253081  37.297634  37.324934  ...
37.332242  37.396533  37.223224  37.285783  37.199885  ...
37.121898  37.001902  36.953585  36.986930  36.961498  ...
36.840751  36.916658  36.889147  36.836284  36.979326  ...
37.084447  37.224183  37.291655  37.337378  37.343806  ...
37.335751  37.265447  37.354412  37.396432  37.347639  ...
37.390764  37.412262  37.345422  37.396562  37.334381  ...
37.394204  37.390764  37.466156  37.571772  37.467862  ...
37.351003  37.310213  37.420519  37.340205  37.421334  ...
37.417945  37.287687  37.292898  37.471423  37.518048  ...
37.441567  37.336322  37.396114  37.285162  37.262401  ...
37.250520  37.291994  37.162416  37.168096  37.034183  ...
37.101381  36.981061  37.021794  36.985811  36.918407  ...
36.996989  36.894842  37.080381  37.014194  36.978274  ...
36.966934  37.000937  36.984153  37.089648  37.312923  ...
37.438220  37.498938  37.738788  37.568609  37.560697  ...
37.575495  37.540501  37.796664  37.888904  37.828787  ...
37.526911  37.674802  37.723596  37.365246  37.117974  ...
37.143864  37.157278  37.305761  37.222473  37.265700  ...
37.292545  37.389073  37.488993  37.511936  37.520027  ...
37.605045  37.527552  37.548152  37.601069  37.575811  ...
37.558233  37.669714  37.717952  37.727577  37.799394  ...
37.880646  38.025455  38.143314  38.212658  38.498513  ...
38.754161  38.968903  39.163122  39.523006  39.345804  ...
39.182705  38.935240  38.855383  38.850264  38.745486  ...
38.556716  38.313046  38.328155  38.522188  38.584572  ...
38.932498  39.214698  39.288897  39.207139  39.071466  ...
38.945936  38.859090  38.906832  38.766007  38.555129  ...
38.207649  37.885664  37.614072  37.579432  37.509098  ...
37.522261  37.325404  36.836131  36.500080  36.358482  ...
36.257128  36.188909  36.199628  36.282402  36.261471  ...
36.596637  36.528993  36.374189  36.232985  36.232343  ...
36.085621  36.016906  35.972686  35.957585  35.996049  ...
36.004317  35.989891  36.112261  36.176271  35.964270  ...
36.009329  36.035937  36.131705  36.202199  36.108817  ...
36.040276  35.977902  36.020636  36.053703  35.996469  ...
36.040647  36.101884  35.916760  35.931038  35.942733  ...
35.781599  35.912974  35.839145  35.879774  35.981577  ...
35.988541  35.866924  35.826093  35.838084  35.777580  ...
35.962834  35.989912  35.866640  35.828270  35.703773  ...
35.704136  35.751751  35.995882  35.953504  35.842796  ...
35.916791  35.826294  35.744040  35.778507  35.822466  ...
35.863243  35.826476  35.911987  35.841805  35.910414  ...
35.889418  35.837053  35.777480  35.945260  35.990257  ...
36.029911  36.054839  35.950930  36.073867  35.975168  ...
35.890932  35.720346  35.660237  35.738534  35.622372  ...
];
 %Average:   37.072388, 40.212010, 41.427469

%only 1 I frame. Error accumulated.
 %C4C4 - C4F: 1.91 dB
c4_f = [ 38.824113  37.547927  37.372507  37.139797  37.076360  ...
36.991001  36.946600  36.968455  36.948348  36.898285  ...
36.913743  36.788872  36.692276  36.524623  36.639602  ...
36.569831  36.601322  36.700367  36.724893  36.621987  ...
36.546805  36.411675  36.472505  36.489698  36.369731  ...
36.305607  36.302805  36.452257  36.266220  36.295948  ...
36.343025  36.426857  36.356933  36.407432  36.380334  ...
36.317069  36.234834  36.193974  36.177025  36.240840  ...
36.235919  36.287477  36.226470  36.166493  36.142435  ...
36.175725  36.203364  36.377941  36.352163  36.299195  ...
36.257606  36.146719  36.190027  36.095691  36.138447  ...
36.126117  36.057050  36.111464  36.144604  36.229355  ...
36.168434  36.121788  36.098931  35.978862  35.916400  ...
35.861982  35.797771  35.662751  35.586874  35.624094  ...
35.705126  35.787269  35.816598  35.871994  35.928282  ...
35.942008  35.873920  35.809674  35.948545  35.947135  ...
35.828442  35.814667  35.818057  35.825891  35.746543  ...
35.839489  35.876815  35.841572  35.878560  35.807305  ...
35.887107  35.887199  35.763151  35.726578  35.729130  ...
35.721881  35.743238  35.771096  35.755250  35.785731  ...
35.838154  35.797701  35.774162  35.737388  35.772091  ...
35.651669  35.697144  35.707459  35.558692  35.513276  ...
35.442381  35.442944  35.426429  35.318464  35.321111  ...
35.208517  35.147508  35.155862  35.027650  35.118636  ...
35.187532  35.141779  35.271141  35.265113  35.206411  ...
35.087395  35.032114  35.101584  35.168959  35.192224  ...
35.107141  35.125116  35.090304  35.030871  35.084157  ...
35.031442  35.124438  35.138422  35.131905  35.051314  ...
35.108081  35.147318  35.140401  35.217681  35.192381  ...
35.228815  35.146086  35.088815  35.020761  34.950955  ...
34.837727  34.862766  34.786793  34.715957  34.681127  ...
34.535470  34.423897  34.457989  34.542485  34.654863  ...
34.746012  34.766402  34.765478  34.776427  34.709421  ...
34.735743  34.797231  34.732819  34.739901  34.678928  ...
34.683815  34.778692  34.784572  34.847629  34.808890  ...
34.722292  34.642703  34.456341  34.455356  34.389165  ...
34.318928  34.254066  34.203049  34.155079  34.018960  ...
33.909436  33.906273  33.938930  33.970932  34.247039  ...
34.399661  34.479528  34.423948  34.497521  34.441712  ...
34.475095  34.430916  34.422671  34.447233  34.546799  ...
34.540385  34.526718  34.429279  34.380160  34.383991  ...
34.383687  34.319141  34.392272  34.394990  34.257064  ...
34.171547  34.195211  34.185203  34.044412  34.102750  ...
34.045630  34.031064  34.021122  34.119477  34.144117  ...
34.033852  33.942253  33.898474  33.845712  33.764925  ...
33.680210  33.683182  33.526124  33.483034  33.309993  ...
33.267235  33.162002  33.151960  33.089029  33.010151  ...
33.015916  32.952685  33.103377  33.183927  33.232387  ...
33.298443  33.358774  33.518421  33.632421  33.823422  ...
33.969183  34.021434  34.120613  33.874414  33.904421  ...
33.777415  33.789280  34.012868  34.211276  34.171265  ...
34.019785  33.929319  33.937429  33.763727  33.551303  ...
33.620692  33.516981  33.601868  33.572008  33.476416  ...
33.531962  33.589986  33.548158  33.666647  33.605547  ...
33.559740  33.445953  33.469920  33.622779  33.701194  ...
33.764505  33.854825  33.912542  33.854434  33.875784  ...
33.788756  34.005140  34.198009  34.271880  34.508224  ...
34.818527  34.957453  35.253702  35.881682  36.253056  ...
36.290258  36.276293  36.425017  36.630482  36.654287  ...
36.728031  36.693285  36.910094  37.207263  37.540307  ...
38.031530  38.422402  38.673167  38.764777  38.715602  ...
38.598291  38.535466  38.596020  38.464757  38.266776  ...
37.889050  37.538288  37.238127  37.166971  37.081579  ...
37.089163  36.902287  36.403746  36.072758  35.922126  ...
35.827887  35.745217  35.716767  35.823956  35.772878  ...
36.105462  36.014200  35.791817  35.651805  35.679548  ...
35.485631  35.424976  35.350416  35.417282  35.360275  ...
35.297334  35.305892  35.390211  35.492355  35.114057  ...
35.158618  35.177398  35.205799  35.305606  35.253004  ...
35.156337  35.074583  35.113809  35.110636  35.020795  ...
35.074566  35.128994  34.992126  34.972895  34.921719  ...
34.710933  34.768345  34.686853  34.751935  34.813311  ...
34.753006  34.606679  34.586380  34.588259  34.499378  ...
34.599735  34.622067  34.527667  34.441008  34.301480  ...
34.267851  34.267450  34.427007  34.407303  34.258040  ...
34.291700  34.192027  34.091006  34.055602  34.055280  ...
34.058150  33.926448  33.951427  33.882576  33.915963  ...
33.927678  33.861918  33.832896  33.905172  33.897188  ...
33.927841  33.990340  33.894350  33.939184  33.919490  ...
33.918151  33.731157  33.641530  33.654972  33.546589  ...
];
 %Average:   35.158225, 40.030821, 40.964414



f_c4 = [ 38.621904  37.219138  37.146090  37.067390  36.966567  ...
36.908205  36.836844  36.855980  36.775908  36.870890  ...
36.843897  36.726109  36.748051  36.668006  36.632703  ...
36.546103  36.559699  36.559818  36.643262  36.516379  ...
36.571997  36.430772  36.498868  36.449673  36.352755  ...
36.312264  36.237481  36.325542  36.309717  36.284496  ...
36.287141  36.316426  36.287724  36.253534  36.335493  ...
36.242271  36.245656  36.220593  36.225652  36.192165  ...
36.194984  36.195050  36.236728  36.191200  36.058421  ...
36.135145  36.177320  36.233760  36.265941  36.078950  ...
36.114576  36.145287  36.064572  35.988384  36.066116  ...
36.081739  35.936835  36.039842  36.196476  36.133695  ...
36.030957  35.956348  36.021753  35.908175  35.922589  ...
35.804686  35.817232  35.711218  35.640993  35.599561  ...
35.575128  35.492019  35.515153  35.408951  35.382433  ...
35.329976  35.395457  35.357070  35.536929  35.469194  ...
35.413311  35.472185  35.496567  35.456345  35.507503  ...
35.406196  35.462969  35.413944  35.488745  35.499072  ...
35.503730  35.498558  35.532621  35.560208  35.480918  ...
35.441135  35.375640  35.290673  35.256591  35.242390  ...
35.366164  35.369656  35.362638  35.421247  35.389026  ...
35.275632  35.173016  35.323265  35.273120  35.269837  ...
35.176460  35.262014  35.187688  35.116410  35.147870  ...
35.076890  35.081872  35.045112  34.964506  34.957288  ...
34.859271  34.877308  34.867338  34.866829  34.888039  ...
34.783811  34.746311  34.758985  34.964183  34.794107  ...
34.722167  34.684620  34.740969  34.660154  34.695196  ...
34.681932  34.640585  34.639228  34.567314  34.596734  ...
34.605286  34.642634  34.642980  34.640317  34.645575  ...
34.538976  34.605142  34.642565  34.584554  34.548339  ...
34.612841  34.563657  34.573730  34.495095  34.537530  ...
34.516805  34.427029  34.285644  34.210567  34.214120  ...
34.173076  34.082599  34.158703  34.086277  34.157810  ...
34.144315  34.149211  34.174378  34.139445  34.113643  ...
34.162123  34.185507  34.043516  34.022093  34.079247  ...
34.126293  34.203153  34.199547  34.193037  34.249051  ...
34.198452  34.008555  33.974359  33.951670  33.974208  ...
33.919750  33.950891  33.809854  33.750151  33.877895  ...
33.846299  33.852156  33.882138  33.801303  33.811065  ...
33.792421  33.728289  33.792314  33.782449  33.748770  ...
33.791046  33.788119  33.739509  33.787294  33.839972  ...
33.784590  33.750457  33.729402  33.746490  33.749570  ...
33.703525  33.605148  33.655229  33.621487  33.576335  ...
33.565924  33.531094  33.479856  33.543394  33.592263  ...
33.496784  33.422024  33.472645  33.307497  33.320498  ...
33.354750  33.311196  33.211955  33.173571  33.126994  ...
33.082609  33.047266  33.039697  32.980957  32.948100  ...
32.929348  32.870535  32.909497  32.863534  32.801096  ...
32.778238  32.794968  32.752906  32.698268  32.847685  ...
32.878980  32.943894  33.059642  33.090623  33.025362  ...
33.030569  33.058411  33.280283  33.466207  33.582096  ...
33.424099  33.503256  33.664833  33.355828  33.199985  ...
33.107407  33.152237  33.125457  33.008339  33.083820  ...
33.038716  32.970990  33.083263  32.979162  33.049440  ...
33.124823  33.110021  33.101708  33.026293  33.056631  ...
33.181991  33.228772  33.257722  33.263680  33.315089  ...
33.403832  33.602605  33.708697  33.855574  34.177177  ...
34.445641  34.791842  35.088807  35.095915  35.201371  ...
35.394544  35.456595  35.684326  35.885288  36.205190  ...
36.251321  36.211309  36.458211  36.787703  37.127090  ...
37.660155  38.145944  38.507792  38.617895  38.739844  ...
38.609297  38.438338  38.508054  38.443509  38.263259  ...
37.846630  37.535852  37.246199  37.266037  37.241239  ...
37.185512  37.013333  36.512175  36.173235  35.941728  ...
35.898171  35.853768  35.864473  35.818942  35.827333  ...
36.125016  36.111863  35.975992  35.786300  35.701696  ...
35.567230  35.640027  35.537721  35.404448  35.424765  ...
35.591694  35.432565  35.529071  35.590625  35.553492  ...
35.459086  35.453690  35.433661  35.381741  35.198509  ...
35.229201  35.085202  35.066054  35.155300  35.123195  ...
35.067019  35.132472  34.866231  34.870556  34.816976  ...
34.768306  34.855239  34.689793  34.721011  34.692952  ...
34.741362  34.606466  34.559039  34.489771  34.434207  ...
34.537118  34.428139  34.334450  34.267302  34.146834  ...
34.086912  34.112603  34.190574  34.143124  34.027326  ...
34.018701  33.883182  33.816322  33.821236  33.772079  ...
33.771407  33.867609  33.815662  33.779894  33.907906  ...
33.829120  33.759955  33.712313  33.732700  33.785258  ...
33.746334  33.605699  33.487550  33.794940  33.652845  ...
33.453015  33.383028  33.310139  33.341527  33.218431  ...
];
 %Average:   34.876907, 39.587839, 40.590981

err = mean(c4_c4 - c4_f);
s=sprintf('(Average Difference: %8.4fdB.)', err);

figure;
plot(f_f,':');
hold on;
plot(c4_c4, '-');
hold on;
legend('H.263+ --> H.263+', 'binDCT C4 --> binDCT C4');
ylabel('PSNR (dB)');
xlabel('Frame');

err = mean(c4_c4 - f_f);
s=sprintf(' Average Difference: %8.4fdB.', err);
t=strcat(t1,s);
title(t);





%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Forman: A2 q2
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Foreman with quantization step of 4: ';

%1812110bytes, ratio: 8.3915, PSNR: 41.1559
f_f = [ 43.564139  41.720710  41.597574  41.495759  41.444336  ...
41.499293  41.359216  41.385132  41.374161  41.431492  ...
41.364012  41.387453  41.329694  41.198267  41.299056  ...
41.241472  41.240841  41.254609  41.373619  41.277819  ...
41.241332  41.223971  41.252956  41.292380  41.260065  ...
41.230753  41.225089  41.318684  41.178414  41.210229  ...
41.086307  41.132270  41.139699  41.203270  41.286457  ...
41.134391  41.131586  41.158755  41.074006  41.014349  ...
41.122431  41.072960  41.023679  41.064197  41.051656  ...
41.105368  41.197676  41.299341  41.332021  41.179244  ...
41.221631  41.190876  41.176686  41.102684  41.260699  ...
41.210055  41.217025  41.207931  41.287308  41.282809  ...
41.209463  41.111151  41.120691  41.075660  40.983007  ...
41.100340  41.119702  40.958391  40.960231  41.024213  ...
40.972313  40.942745  40.974918  41.012419  41.070633  ...
41.037879  41.045986  41.074681  41.178587  41.138260  ...
41.082113  41.068947  41.183741  41.138054  41.080862  ...
41.043271  41.171023  41.184952  41.196149  41.131757  ...
41.238842  41.229773  41.137952  41.224914  41.192367  ...
41.284792  41.217373  41.189871  41.169263  41.313011  ...
41.358135  41.393950  41.361559  41.351187  41.359252  ...
41.265493  41.264294  41.455965  41.182599  41.190391  ...
41.123762  41.119225  41.048099  41.125265  41.102378  ...
41.041997  40.971258  40.926274  40.915491  40.953990  ...
40.945954  40.901944  41.072724  41.118509  41.049608  ...
40.953858  40.967371  40.992402  41.314045  41.282101  ...
41.098915  41.081572  40.997472  40.974753  41.017046  ...
41.007364  40.994025  40.997207  41.039017  41.047730  ...
41.047830  41.113227  41.094640  41.079713  41.208558  ...
41.161337  41.173232  41.138020  41.112751  41.021945  ...
40.994555  41.057871  40.996212  40.952349  41.238702  ...
40.921547  40.931627  40.902301  40.884367  40.968194  ...
41.081031  40.948281  40.950052  40.984494  40.902236  ...
40.953071  40.976732  41.020611  41.000225  40.981520  ...
41.059687  41.153459  41.127382  41.233097  41.240841  ...
41.239613  41.237020  41.219816  41.177204  41.062817  ...
41.120862  40.962368  40.935842  41.001918  40.911133  ...
40.907104  40.903631  40.871046  40.828868  40.970368  ...
40.994025  41.119395  41.125333  41.196253  41.109993  ...
41.139870  41.154972  41.138157  41.390210  41.256861  ...
41.250847  41.314259  41.212702  41.231033  41.177239  ...
41.211239  41.187065  41.265670  41.539827  41.367513  ...
41.170195  41.251655  41.246420  41.109313  41.226451  ...
41.196913  41.149714  41.160752  41.410255  41.325544  ...
41.234848  41.083465  41.243156  41.123455  41.103839  ...
41.090607  41.027483  40.950216  40.896045  40.903826  ...
40.896628  40.929145  41.016879  40.997340  40.893163  ...
40.853176  40.857412  40.818070  40.944316  40.895948  ...
40.868567  40.900031  40.921808  41.040055  41.342312  ...
41.289258  41.291564  41.477575  41.364337  41.243471  ...
41.410839  41.363687  41.517756  41.618411  41.637503  ...
41.353994  41.560387  41.635966  41.289364  41.132373  ...
41.128407  41.179451  41.208349  41.194726  41.212319  ...
41.180281  41.355830  41.365816  41.361595  41.469546  ...
41.464596  41.428855  41.448160  41.399148  41.416057  ...
41.424280  41.617875  41.742698  41.632127  41.628023  ...
41.657605  41.803945  41.870404  41.910601  42.163132  ...
42.293876  42.475909  42.650549  42.931625  42.907675  ...
42.835290  42.752205  42.747887  42.640469  42.633263  ...
42.484352  42.290123  42.389075  42.428677  42.539000  ...
42.686942  42.905462  43.018883  43.013394  42.841318  ...
42.734561  42.589366  42.510439  42.514481  42.379857  ...
42.132107  41.994672  41.814297  41.782003  41.709874  ...
41.654017  41.528683  41.179313  41.010656  40.925589  ...
40.892095  40.815048  40.798674  40.816638  40.912889  ...
41.136411  40.893907  40.801113  40.780153  40.775109  ...
40.640193  40.684269  40.618534  40.635889  40.642759  ...
40.624129  40.624281  40.693008  40.723533  40.666720  ...
40.678781  40.661070  40.678504  40.622364  40.626503  ...
40.565620  40.599342  40.634760  40.642087  40.632199  ...
40.674039  40.640804  40.544031  40.613007  40.555905  ...
40.413191  40.472194  40.477485  40.515925  40.538956  ...
40.495259  40.465559  40.435857  40.373693  40.418991  ...
40.535914  40.492690  40.414031  40.395662  40.353606  ...
40.221194  40.416003  40.462011  40.402278  40.288289  ...
40.455802  40.274680  40.330710  40.255604  40.247869  ...
40.240843  40.248064  40.313794  40.368096  40.444839  ...
40.425061  40.433061  40.325935  40.359556  40.400948  ...
40.504336  40.512187  40.425032  40.568954  40.542358  ...
40.440550  40.348006  40.337996  40.227160  40.201247  ...
];
 %Average:   41.155898, 43.296457, 44.579211

%1874289, 8.3915, 41.7730dB
c1_c1 = [ 43.737539  42.124020  41.938842  41.856925  41.884941  ...
41.852845  41.832825  41.802069  41.702497  41.761713  ...
41.791626  41.786494  41.736876  41.698716  41.669278  ...
41.646464  41.662858  41.747266  41.811977  41.809458  ...
41.816098  41.726079  41.765312  41.784864  41.762306  ...
41.750854  41.657490  41.742265  41.710656  41.661390  ...
41.652744  41.720240  41.699144  41.727216  41.759973  ...
41.659150  41.612103  41.642885  41.544563  41.516971  ...
41.576080  41.544412  41.590385  41.619520  41.646849  ...
41.610576  41.675863  41.781526  41.763255  41.677414  ...
41.778429  41.720005  41.762504  41.645771  41.741123  ...
41.610919  41.590537  41.643270  41.775374  41.757682  ...
41.690151  41.599554  41.692057  41.650624  41.672260  ...
41.667576  41.724197  41.642770  41.636158  41.649931  ...
41.536597  41.594682  41.616537  41.595138  41.635121  ...
41.597803  41.609545  41.619176  41.705774  41.693497  ...
41.669201  41.664095  41.627601  41.650933  41.607904  ...
41.731219  41.788403  41.835036  41.814097  41.805782  ...
41.756576  41.727255  41.726745  41.668582  41.756063  ...
41.725804  41.762108  41.746636  41.754839  41.745966  ...
41.883355  42.005657  41.944282  41.889784  41.886527  ...
41.814657  41.759183  41.932669  41.775295  41.856723  ...
41.809418  41.710031  41.697858  41.704994  41.732868  ...
41.655984  41.663670  41.582714  41.601345  41.569834  ...
41.527971  41.551224  41.759223  41.713900  41.690929  ...
41.600773  41.578770  41.557482  41.733968  41.692680  ...
41.571082  41.588675  41.641500  41.594187  41.675243  ...
41.692913  41.713157  41.667111  41.617799  41.742501  ...
41.655329  41.764956  41.712141  41.678577  41.749552  ...
41.819503  41.789954  41.781486  41.833227  41.727294  ...
41.717773  41.675088  41.678073  41.645001  41.793060  ...
41.556727  41.612982  41.597955  41.555634  41.600354  ...
41.684943  41.638271  41.615963  41.643578  41.630515  ...
41.534871  41.648351  41.676677  41.644617  41.641193  ...
41.736915  41.859351  41.896549  41.855834  41.801311  ...
41.972038  41.914285  41.967186  41.919898  41.981885  ...
41.808499  41.758274  41.661738  41.592514  41.620285  ...
41.602946  41.608667  41.565939  41.584991  41.673189  ...
41.630324  41.741202  41.697547  41.820024  41.907615  ...
41.918177  41.779501  41.797243  41.928723  41.886568  ...
41.906184  41.942509  41.881566  41.919857  41.906348  ...
41.860200  41.902180  41.870931  42.034989  42.044304  ...
41.870241  41.854380  41.898629  41.940819  41.923180  ...
41.920965  41.894632  41.837329  41.931888  41.940902  ...
41.829009  41.750775  41.857370  41.780732  41.868012  ...
41.723335  41.707609  41.703043  41.662897  41.612371  ...
41.627716  41.664366  41.717460  41.632818  41.604928  ...
41.599478  41.648659  41.622391  41.684050  41.633701  ...
41.668659  41.669162  41.679353  41.726667  41.966440  ...
42.034400  42.068889  42.188052  42.131634  42.062740  ...
42.138096  42.172553  42.272833  42.340830  42.356489  ...
42.088069  42.185218  42.260220  42.074494  41.851231  ...
41.828045  41.829170  41.874378  41.880347  41.997093  ...
41.931477  41.946426  42.022796  42.081383  42.123290  ...
42.223876  42.293384  42.293473  42.223788  42.263592  ...
42.241193  42.332345  42.451742  42.336947  42.318975  ...
42.441604  42.473486  42.506073  42.605518  42.774762  ...
42.813727  42.869290  43.102919  43.256690  43.193944  ...
43.270155  43.127378  43.126620  43.083579  43.176769  ...
43.044465  42.892106  42.963992  43.036610  43.116455  ...
43.123211  43.283156  43.413329  43.469791  43.329309  ...
43.125971  42.973022  42.850656  42.945467  42.744217  ...
42.553256  42.395383  42.283029  42.296334  42.228012  ...
42.200063  42.005197  41.810217  41.733143  41.656525  ...
41.587345  41.520896  41.595747  41.621013  41.595481  ...
41.571158  41.458840  41.487103  41.468585  41.377055  ...
41.371920  41.347879  41.337361  41.291847  41.372715  ...
41.397875  41.356118  41.341127  41.330589  41.484320  ...
41.435855  41.426914  41.301438  41.330446  41.332165  ...
41.353454  41.378684  41.370655  41.386474  41.316150  ...
41.261087  41.230718  41.171196  41.074073  41.054040  ...
41.194900  41.301936  41.289506  41.253202  41.215525  ...
41.073162  41.127997  41.172438  41.083262  41.108769  ...
41.130595  41.096879  41.039586  41.103669  41.006334  ...
40.838607  41.015514  41.148513  40.989588  40.915133  ...
40.996511  40.873720  40.891868  40.950577  41.006467  ...
41.008993  40.833400  40.926470  41.110844  41.160442  ...
41.159753  41.164954  41.170954  41.142715  41.168643  ...
41.235794  41.172266  41.177550  41.302968  41.254504  ...
41.173301  41.071543  41.082552  41.026816  40.883818  ...
];
 %Average:   41.772957, 43.457421, 44.789681

 %1857001, 8.1887, 41.9432dB
c4_c4 = [ 43.891212  42.184346  42.115519  42.104167  42.025568  ...
41.965072  41.946096  42.022880  41.919406  41.910519  ...
41.961386  41.962711  41.911174  41.812297  41.764244  ...
41.817220  41.853330  41.800633  41.992129  41.952371  ...
41.942839  41.947747  41.959069  41.911624  41.897120  ...
41.891820  41.805981  41.899853  41.859593  41.872796  ...
41.821226  41.969840  41.880956  41.854299  41.900547  ...
41.769231  41.824153  41.820384  41.712845  41.716482  ...
41.804145  41.748094  41.760092  41.751998  41.746912  ...
41.772440  41.823431  41.867243  41.879616  41.855471  ...
41.883029  41.891005  41.823672  41.729452  41.850827  ...
41.826520  41.779223  41.801231  41.987087  41.915759  ...
41.881282  41.789079  41.867972  41.887545  41.804304  ...
41.892920  41.836122  41.752313  41.783393  41.773431  ...
41.803665  41.766539  41.794971  41.811617  41.860119  ...
41.803226  41.842683  41.846189  41.906961  41.888115  ...
41.795489  41.845262  41.884249  41.872958  41.839099  ...
41.842119  41.885510  41.975484  41.927039  41.955471  ...
41.986129  41.946096  41.835318  41.863072  41.930244  ...
41.933039  41.975899  41.925479  41.898874  41.974404  ...
42.077427  42.131418  42.136156  42.086322  42.099721  ...
42.063800  41.951380  42.127202  41.955595  41.956049  ...
41.939131  41.874094  41.956876  41.943086  41.973242  ...
41.825597  41.878722  41.735264  41.697625  41.723962  ...
41.661274  41.757129  41.900751  41.940407  41.868944  ...
41.791865  41.744706  41.674468  41.915390  41.866473  ...
41.808379  41.781050  41.767291  41.731219  41.834715  ...
41.889987  41.877260  41.817180  41.782440  41.877422  ...
41.889662  41.926793  41.831821  41.857046  41.928394  ...
41.923467  42.048230  41.957207  41.992587  41.858906  ...
41.867648  41.922934  41.795848  41.773947  42.100404  ...
41.759341  41.749001  41.701015  41.733614  41.807979  ...
41.845141  41.769825  41.847318  41.803107  41.731651  ...
41.775850  41.875514  41.843609  41.873851  41.860281  ...
41.961345  41.932135  42.041900  42.071690  42.046710  ...
42.165648  42.176944  42.111103  42.092248  42.093485  ...
42.036168  41.930942  41.847721  41.812897  41.779223  ...
41.755352  41.816179  41.740533  41.677802  41.800752  ...
41.788681  41.930778  41.938801  42.069780  42.125654  ...
42.115305  41.961304  41.915268  42.181210  42.073134  ...
42.021369  42.055458  41.973865  42.110332  42.047512  ...
42.094681  42.069992  42.064817  42.208731  42.122817  ...
42.058759  42.010930  42.081851  42.035031  42.047850  ...
42.049159  42.073007  41.957579  42.044600  42.192023  ...
42.051568  41.923426  41.992962  41.970960  41.976232  ...
41.903977  41.851150  41.896304  41.806900  41.783592  ...
41.783314  41.751800  41.783513  41.746833  41.725255  ...
41.734046  41.813097  41.831580  41.847358  41.849778  ...
41.910805  41.812337  41.881160  41.916128  42.146166  ...
42.192197  42.236692  42.332300  42.326578  42.207898  ...
42.314482  42.381453  42.363023  42.561852  42.594919  ...
42.321178  42.459257  42.548847  42.211142  42.034358  ...
42.025400  42.093272  42.043123  41.935096  42.087941  ...
42.080404  42.194119  42.129783  42.227088  42.280133  ...
42.404221  42.488884  42.520645  42.425452  42.513259  ...
42.447249  42.566417  42.709309  42.468505  42.567940  ...
42.638775  42.729271  42.768426  42.916744  43.085563  ...
43.102058  43.285177  43.447060  43.616605  43.586710  ...
43.519108  43.383303  43.448342  43.376188  43.390258  ...
43.253400  43.091359  43.120399  43.289727  43.319564  ...
43.374984  43.566714  43.563480  43.536565  43.408994  ...
43.295464  43.114187  42.994605  42.969993  42.906594  ...
42.714820  42.528893  42.461346  42.460650  42.429646  ...
42.285437  42.103483  41.918341  41.897120  41.807979  ...
41.714057  41.718204  41.738291  41.693069  41.693225  ...
41.724079  41.632127  41.633547  41.623271  41.526398  ...
41.501452  41.500671  41.510025  41.430173  41.509018  ...
41.518354  41.505401  41.412407  41.467551  41.638848  ...
41.618411  41.594073  41.476131  41.486286  41.443491  ...
41.562161  41.501825  41.514468  41.487177  41.454565  ...
41.361307  41.330625  41.308699  41.300940  41.188208  ...
41.293054  41.394132  41.442278  41.361920  41.294687  ...
41.241612  41.328227  41.365563  41.252780  41.214584  ...
41.231208  41.278067  41.130458  41.232642  41.130697  ...
40.997074  41.219850  41.335855  41.179382  41.015014  ...
41.161784  41.004408  41.047897  41.055519  41.128271  ...
41.167160  40.950479  41.071408  41.230018  41.237756  ...
41.300016  41.355146  41.359108  41.351907  41.297351  ...
41.364084  41.347556  41.372390  41.482800  41.390791  ...
41.293373  41.170402  41.235654  41.157482  41.054074  ...
];
 %Average:   41.943180, 43.637200, 44.956680

 %1857512, 8.1864, 41.9412db
c7_c7 = [ 43.914126  42.274212  42.087089  42.041478  42.024728  ...
42.076449  41.987004  41.966854  41.931189  41.968969  ...
41.850424  41.896345  41.909619  41.839180  41.857531  ...
41.776763  41.824875  41.823150  42.026913  41.981802  ...
41.978101  41.961718  41.910232  41.902303  41.906675  ...
41.913793  41.840025  41.913425  41.818541  41.879453  ...
41.871174  41.873567  41.888359  41.849496  41.934232  ...
41.776207  41.786812  41.830696  41.679663  41.663283  ...
41.765272  41.669201  41.761752  41.744430  41.778429  ...
41.744115  41.822268  41.893858  41.942179  41.820865  ...
41.930614  41.902956  41.802308  41.714487  41.825437  ...
41.807340  41.778906  41.816859  41.863518  41.799675  ...
41.728668  41.759776  41.880103  41.854380  41.777874  ...
41.858138  41.814537  41.770578  41.747660  41.828005  ...
41.771331  41.809178  41.809058  41.772758  41.809418  ...
41.797642  41.796725  41.780375  41.857976  41.858016  ...
41.849738  41.778548  41.790989  41.823150  41.849375  ...
41.824634  41.939542  41.965487  41.945601  41.958159  ...
41.904672  41.962960  41.890069  41.890272  41.932669  ...
41.898139  41.933245  41.877625  41.909742  42.002146  ...
42.105622  42.138398  42.043756  42.091139  42.035494  ...
42.035958  41.911706  42.147333  41.969798  41.951049  ...
41.978517  41.889417  41.877179  41.960517  42.010428  ...
41.837047  41.759855  41.735382  41.721728  41.730237  ...
41.670711  41.745612  41.880184  41.895244  41.882623  ...
41.839301  41.711516  41.683506  41.885510  41.902466  ...
41.766262  41.741202  41.779223  41.725373  41.841555  ...
41.836484  41.850101  41.856764  41.848326  41.884249  ...
41.842884  41.977852  41.906184  41.906715  41.940366  ...
41.934932  41.939295  41.923016  41.986587  41.843851  ...
41.867526  41.873039  41.784665  41.790074  41.979431  ...
41.786772  41.775414  41.777715  41.776168  41.740061  ...
41.912238  41.733182  41.770538  41.807260  41.752629  ...
41.779104  41.871417  41.884046  41.935014  41.880956  ...
41.903242  41.989045  42.068634  42.114661  42.076279  ...
42.166039  42.186177  42.109475  42.098268  42.072455  ...
42.005532  41.901200  41.850989  41.833709  41.889824  ...
41.764798  41.794374  41.765391  41.726667  41.849899  ...
41.799037  41.990670  41.952041  42.071988  42.077639  ...
42.085939  41.997635  41.881891  42.099977  42.073984  ...
42.094638  42.096559  42.031496  42.124794  41.998011  ...
42.136587  42.057108  42.053090  42.204351  42.136070  ...
42.151656  42.047850  42.039623  42.037895  42.079893  ...
41.980803  41.967310  41.981427  42.092376  42.143273  ...
41.999974  41.874581  42.041183  41.947953  41.966315  ...
41.953280  41.885470  41.877179  41.845181  41.816058  ...
41.818301  41.851836  41.843690  41.791586  41.762939  ...
41.726667  41.813617  41.822870  41.882094  41.901772  ...
41.830776  41.790074  41.855430  41.922811  42.114275  ...
42.117321  42.210835  42.277728  42.286285  42.263237  ...
42.344627  42.338482  42.417857  42.587645  42.622789  ...
42.356127  42.542548  42.653072  42.199538  42.031706  ...
42.018599  42.039960  42.078915  42.001268  42.060919  ...
42.055881  42.184085  42.175205  42.257294  42.292982  ...
42.422965  42.542501  42.469575  42.494824  42.515186  ...
42.422689  42.509030  42.579237  42.557386  42.583056  ...
42.631668  42.738123  42.863885  42.897443  43.076349  ...
43.122129  43.235655  43.427115  43.651104  43.613697  ...
43.564438  43.341237  43.408821  43.390603  43.340100  ...
43.316678  43.091305  43.195979  43.192954  43.225675  ...
43.312495  43.582139  43.622306  43.553793  43.391927  ...
43.354739  43.116077  42.949311  42.996233  42.838582  ...
42.606142  42.532007  42.432551  42.442483  42.417628  ...
42.287311  42.196085  41.925930  41.797203  41.742540  ...
41.703940  41.731101  41.694821  41.718282  41.681410  ...
41.783195  41.623578  41.698793  41.616690  41.464263  ...
41.478316  41.478390  41.481057  41.409745  41.501862  ...
41.435231  41.493714  41.413356  41.482577  41.587649  ...
41.646310  41.623999  41.487734  41.427903  41.418760  ...
41.554163  41.533145  41.520672  41.543886  41.464190  ...
41.369716  41.326939  41.276935  41.265070  41.178691  ...
41.323757  41.394132  41.379734  41.352986  41.393188  ...
41.207897  41.316507  41.348706  41.251444  41.193408  ...
41.271458  41.253730  41.142029  41.230088  41.190946  ...
40.979010  41.204939  41.281216  41.159925  41.071746  ...
41.169505  41.082383  41.092640  41.109143  41.081572  ...
41.121783  40.980430  41.053738  41.182426  41.305565  ...
41.281216  41.438386  41.264788  41.259748  41.301936  ...
41.373872  41.344179  41.317113  41.433508  41.435488  ...
41.260065  41.192298  41.240560  41.229109  41.072690  ...
];
 %Average:   41.941187, 43.639264, 44.953586

 %1880914, 8.0846, 41.9714dB
l3_l3 = [ 43.927971  42.259910  42.249635  42.159101  42.034737  ...
42.031875  41.979057  41.962339  41.913015  41.997927  ...
41.936948  41.955057  41.900261  41.894714  41.890843  ...
41.931436  41.957414  41.949935  42.129611  42.043545  ...
42.013108  41.959689  41.960186  41.897120  41.948283  ...
41.924616  41.840830  41.885307  41.859836  41.897935  ...
41.901445  41.905448  41.869552  41.983715  41.943333  ...
41.816979  41.886568  41.881119  41.714448  41.766776  ...
41.834111  41.774621  41.841112  41.832142  41.772559  ...
41.819102  41.903120  41.962380  41.950843  41.937854  ...
41.950967  41.950224  41.971540  41.872958  41.863315  ...
41.895488  41.876895  41.828487  41.868944  41.835961  ...
41.847963  41.810377  41.823872  41.859674  41.889824  ...
41.839542  41.797203  41.792303  41.757168  41.839140  ...
41.770855  41.812697  41.835277  41.819743  41.817380  ...
41.947747  41.874256  41.835519  41.904223  41.933533  ...
41.861252  41.813697  41.890761  41.916251  41.852967  ...
41.838777  41.966191  41.964202  42.039033  42.004779  ...
42.006494  41.927819  41.950430  41.937566  42.039370  ...
41.973782  41.955429  41.941644  41.871539  42.014407  ...
42.095321  42.217548  42.127245  42.080914  42.099849  ...
42.042069  41.998512  42.176727  42.056854  42.022922  ...
42.030234  41.918259  41.916578  42.014952  42.009172  ...
41.882542  41.820865  41.736050  41.772322  41.758669  ...
41.693536  41.767331  41.895325  41.978974  41.908146  ...
41.855067  41.705306  41.701210  41.947087  41.894836  ...
41.800912  41.766856  41.785381  41.785023  41.849496  ...
41.875352  41.881282  41.825076  41.826400  41.903079  ...
41.844617  41.936372  41.915554  41.886120  41.985255  ...
41.990836  42.005490  42.003442  42.003651  41.873121  ...
41.898751  41.963208  41.882867  41.887952  42.070544  ...
41.814257  41.757445  41.781010  41.820585  41.905244  ...
41.924165  41.735186  41.787567  41.771767  41.761910  ...
41.858057  41.891902  41.895203  41.909537  41.906715  ...
41.971126  42.023090  42.035368  42.088495  42.086791  ...
42.056262  42.152694  42.210923  42.099806  42.112689  ...
42.013066  41.907656  41.862587  41.846229  41.832182  ...
41.810537  41.851231  41.867850  41.722042  41.804983  ...
41.835157  41.989086  41.940078  42.084448  42.180687  ...
42.144137  42.025862  41.891372  42.154944  42.193464  ...
42.123676  42.087004  42.107934  42.110632  42.082021  ...
42.119252  42.087600  42.069568  42.309411  42.184695  ...
42.159145  42.102072  42.113032  42.074366  42.085726  ...
42.039244  42.034568  41.942880  42.071308  42.136113  ...
42.133614  41.946757  42.020403  41.964741  42.023006  ...
41.905816  41.905734  41.936784  41.869877  41.805183  ...
41.798319  41.842924  41.906470  41.849253  41.782718  ...
41.741123  41.868539  41.845060  41.906797  41.900792  ...
41.861332  41.893409  41.895162  41.990711  42.218866  ...
42.221986  42.307079  42.381544  42.342909  42.237442  ...
42.325137  42.330497  42.492485  42.584155  42.548088  ...
42.391222  42.556531  42.601294  42.278396  42.092419  ...
41.992003  42.054654  42.149710  42.054443  42.168339  ...
42.100319  42.158841  42.202163  42.237045  42.325497  ...
42.492110  42.478799  42.507715  42.439016  42.504055  ...
42.460185  42.534227  42.605181  42.535975  42.543921  ...
42.617490  42.686746  42.892465  42.873833  43.088031  ...
43.179508  43.222131  43.435303  43.607404  43.553076  ...
43.562822  43.505264  43.503197  43.399068  43.437396  ...
43.288715  43.070146  43.113215  43.262663  43.236322  ...
43.315208  43.490581  43.612063  43.625827  43.433734  ...
43.293663  43.110356  43.060431  43.038360  42.801805  ...
42.679756  42.537818  42.383368  42.504102  42.424300  ...
42.351777  42.225152  41.969466  41.900139  41.802029  ...
41.809698  41.740022  41.732514  41.751958  41.709640  ...
41.785182  41.601154  41.702302  41.727530  41.487956  ...
41.518653  41.514281  41.482318  41.463304  41.508048  ...
41.478167  41.438937  41.442462  41.539150  41.616192  ...
41.610461  41.673228  41.580287  41.520448  41.483319  ...
41.491113  41.588561  41.514318  41.609698  41.522318  ...
41.350001  41.350936  41.285749  41.242489  41.255172  ...
41.349173  41.479501  41.453607  41.426109  41.374270  ...
41.237826  41.387344  41.408542  41.314152  41.248949  ...
41.265599  41.313902  41.123182  41.253308  41.161888  ...
41.029253  41.149714  41.299625  41.166987  41.083601  ...
41.177827  41.172714  41.072758  41.120521  41.053469  ...
41.132168  41.004706  41.122909  41.214340  41.279694  ...
41.308628  41.360658  41.386038  41.289506  41.304035  ...
41.360081  41.293161  41.416349  41.463008  41.393369  ...
41.279517  41.135452  41.176997  41.163575  41.076808  ...
];
 %Average:   41.971404, 43.634521, 44.942142


err1 = mean(c4_c4 - f_f);
err2 = mean(c1_c1 - f_f);

s=sprintf(' Average Improvements: %8.4fdB, %8.4fdB.', err1, err2);

figure;
plot(f_f,'--');
hold on;
plot(c4_c4, '-');
hold on;
plot(c1_c1, ':r');
legend('H.263+', 'binDCT C4',' binDCT C7');
 % IN IEEE SP paper, C7 is the old c1.
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);


break;

%%%%%%%%%%%%%%%%%%%%%%%%5
%
% suzie: A1 q 1
%
%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Suzie (A1 q1) ';

%-0.5939
d_128 = [ 42.612485  47.516173  47.551720  47.588316  47.413424  ...
47.264352  47.246422  47.285599  47.177772  47.189484  ...
47.189898  47.164172  47.120771  47.228427  47.280806  ...
47.221194  47.170898  47.203303  47.232605  47.182453  ...
47.114393  46.988629  47.016116  47.057141  47.010155  ...
47.043245  47.003408  47.079816  47.015851  47.017707  ...
47.034849  46.993770  47.021953  47.024875  46.999709  ...
47.030856  46.965375  46.980207  47.002747  47.007640  ...
47.109243  47.030324  47.113037  47.135871  47.149793  ...
47.178873  47.228288  47.287433  47.276722  47.340534  ...
47.422295  45.199792  47.422440  47.613646  47.561929  ...
47.409068  47.452825  47.436438  47.384612  47.322145  ...
44.083192  45.365565  47.192106  47.127702  47.194315  ...
47.098961  46.992187  46.970226  47.008434  46.549245  ...
46.904612  46.944461  46.885788  46.955036  46.901254  ...
46.908748  46.955820  46.945113  46.899705  46.945243  ...
46.961053  47.032719  46.943939  46.956605  46.912501  ...
46.911465  46.885274  46.823710  46.819527  46.848512  ...
46.822442  46.798419  46.787086  46.857577  46.760507  ...
46.790106  46.698087  46.726270  46.666171  46.611358  ...
]; 

%-0.7073
d_no128 = [ 43.502371  47.649543  47.689917  47.643871  47.517065  ...
47.381871  47.339391  47.312057  47.253557  47.215777  ...
47.208704  47.256078  47.211338  47.394291  47.390532  ...
47.280806  47.296333  47.360148  47.322287  47.249499  ...
47.246143  47.133555  47.191554  47.162252  47.122129  ...
47.151981  47.139006  47.161841  47.133419  47.183418  ...
47.139825  47.145147  47.197079  47.182591  47.128518  ...
47.159648  47.148016  47.072021  47.189760  47.229123  ...
47.256499  47.247261  47.295626  47.270814  47.312625  ...
47.405877  47.402108  47.420985  47.444038  47.526001  ...
47.555020  45.226838  47.559675  47.644791  47.647243  ...
47.488742  47.500434  47.457959  47.412408  47.333254  ...
44.064475  45.383006  47.293364  47.310496  47.279961  ...
47.187691  47.059148  47.137370  47.008831  46.883216  ...
47.028463  47.018238  47.029260  47.043245  47.057810  ...
47.070544  47.031255  46.964065  47.016249  47.075379  ...
47.033118  47.077799  47.042845  46.989156  46.946287  ...
46.971800  46.904999  46.933781  46.942766  46.937685  ...
46.875380  46.887718  46.859623  46.875637  46.825106  ...
46.857833  46.816234  46.863717  46.772774  46.645550  ...
]; 

h263_d = [ 42.577471  48.681446  48.741974  48.717975  48.628663  ...
48.377225  48.320468  48.249448  48.185120  48.158136  ...
48.167285  48.242410  48.187550  48.249977  48.186161  ...
48.092757  48.082408  48.072760  48.097176  48.016482  ...
47.938900  47.795538  47.785556  47.813341  47.760150  ...
47.763770  47.778598  47.863645  47.883834  47.813182  ...
47.789673  47.771335  47.760936  47.754489  47.727858  ...
47.706048  47.738804  47.736769  47.771651  47.754175  ...
47.750405  47.705737  47.731764  47.844191  47.798394  ...
47.845314  47.914213  48.010978  48.005480  48.059928  ...
48.097176  45.460142  48.180611  48.201287  48.142644  ...
48.080714  48.040416  48.032033  47.961914  48.007145  ...
44.319034  45.781569  47.893071  47.759048  47.828499  ...
47.756375  47.718030  47.689143  47.640656  47.225504  ...
47.615776  47.564185  47.602404  47.570958  47.590736  ...
47.601342  47.550670  47.554570  47.563734  47.600128  ...
47.531969  47.552320  47.540786  47.509484  47.436438  ...
47.495990  47.507851  47.432496  47.336678  47.387066  ...
47.409504  47.390532  47.395304  47.327126  47.284753  ...
47.278130  47.233581  47.210644  47.153896  47.046848  ...
]; 


c1 = d_no128;
c2 = d_128; %h263_d;

err = mean(c1 - c2);
mad = max(abs(c1 - c2));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(c1,'r');
  hold on;
  plot(c2, 'b');
%  hold on;
%  plot(c3, 'c');
%  hold on;
%  plot(c4, 'k');
else
  plot(c1,':');
  hold on;
  plot(c2, '-'); 
end
  legend('bindct', 'H.263');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(c1 - c2, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);


%%%%%%%%%%%%%%%%%%%%%%%%5
%
% suzie: A2 q 2
%
%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Suzie (A2 q2) ';

%0.25924
d_128 = [ 44.334664  43.166266  42.777209  42.750815  42.684741  ...
42.709801  42.748581  42.603549  42.545530  42.541034  ...
42.499414  42.613592  42.515892  42.636502  42.713343  ...
42.723150  42.729469  42.750765  42.687284  42.671851  ...
42.722903  42.607054  42.636308  42.618068  42.544347  ...
42.524555  42.508044  42.545152  42.627178  42.580621  ...
42.560046  42.540939  42.617297  42.649724  42.603597  ...
42.633891  42.618212  42.692670  42.613832  42.649045  ...
42.723939  42.716101  42.805071  42.729864  42.820936  ...
42.967643  43.236377  43.248108  43.388820  43.511471  ...
43.750520  43.973984  44.089810  44.017764  44.033012  ...
43.879478  43.756211  43.764542  43.743213  43.696606  ...
43.592131  43.511530  43.492347  43.387211  43.239765  ...
43.168398  43.071910  42.909580  42.873833  42.822147  ...
42.787912  42.857011  42.754540  42.826339  42.756528  ...
42.774712  42.790967  42.815591  42.846391  42.859098  ...
42.833468  42.873323  42.831444  42.867097  42.774612  ...
42.757722  42.756031  42.708915  42.635245  42.579666  ...
42.627468  42.628771  42.675070  42.583630  42.527100  ...
42.496978  42.528421  42.514246  42.424162  42.375711  ...
]; 

%0.30423
d_no128 = [ 44.441426  43.221910  42.879404  42.890465  42.765685  ...
42.717775  42.755137  42.732780  42.604269  42.547425  ...
42.594105  42.597363  42.619513  42.655597  42.768576  ...
42.750467  42.846695  42.760109  42.753845  42.720289  ...
42.688948  42.626985  42.697866  42.661576  42.637034  ...
42.604269  42.627806  42.599328  42.608447  42.610322  ...
42.592046  42.596692  42.685181  42.713048  42.720782  ...
42.638436  42.671802  42.685866  42.735154  42.736837  ...
42.732533  42.727444  42.784408  42.755485  42.886006  ...
43.082722  43.212568  43.316339  43.373493  43.616545  ...
43.731934  44.145034  44.098333  44.119239  44.054408  ...
43.860590  43.872595  43.774838  43.727580  43.702288  ...
43.617030  43.639635  43.563600  43.452717  43.334758  ...
43.193944  43.086904  42.990353  42.900371  42.810504  ...
42.855994  42.884009  42.857011  42.840609  42.884829  ...
42.876337  42.830129  42.839544  42.800047  42.882167  ...
42.794326  42.795881  42.787011  42.886621  42.774962  ...
42.746101  42.771019  42.673460  42.665615  42.630606  ...
42.745605  42.649772  42.650985  42.654577  42.638098  ...
42.589749  42.572417  42.545152  42.515186  42.424070  ...
]; 

h263_d = [ 44.150992  43.046218  42.621729  42.517021  42.484446  ...
42.457075  42.498711  42.387065  42.268565  42.248883  ...
42.254725  42.269632  42.221414  42.386882  42.410873  ...
42.521634  42.528138  42.435505  42.352954  42.372660  ...
42.330046  42.328740  42.401243  42.350780  42.303674  ...
42.319469  42.347024  42.319874  42.313584  42.307707  ...
42.316638  42.280044  42.357306  42.390400  42.409450  ...
42.385741  42.352637  42.379811  42.448268  42.443824  ...
42.443963  42.483558  42.453921  42.506401  42.530827  ...
42.668049  42.851164  42.920098  43.095388  43.240988  ...
43.461655  43.833367  43.879414  43.760030  43.700373  ...
43.517508  43.480467  43.464755  43.440654  43.344367  ...
43.264283  43.152303  43.190536  43.112999  42.988413  ...
42.851621  42.736342  42.620958  42.589797  42.520080  ...
42.626696  42.608736  42.619464  42.560426  42.518056  ...
42.579475  42.566370  42.640469  42.611956  42.575850  ...
42.516503  42.537014  42.565799  42.544678  42.469901  ...
42.472648  42.382228  42.410644  42.400006  42.337488  ...
42.437122  42.348517  42.379264  42.400510  42.290927  ...
42.289007  42.286999  42.296826  42.320323  42.343858  ...
]; 

h263_flt = [ 44.148115  43.046537  42.626358  42.523377  42.494543  ...
42.474651  42.523282  42.408028  42.299913  42.274746  ...
42.298347  42.313898  42.273722  42.424392  42.450723  ...
42.564039  42.566417  42.490848  42.425037  42.446231  ...
42.405872  42.389897  42.473253  42.428954  42.397992  ...
42.391451  42.433890  42.396893  42.398449  42.387156  ...
42.403213  42.371568  42.454988  42.490473  42.505134  ...
42.485099  42.448916  42.470739  42.549510  42.552403  ...
42.549795  42.577853  42.551881  42.614554  42.645118  ...
42.755932  42.957062  43.041651  43.193834  43.317357  ...
43.567793  43.926930  43.978329  43.883730  43.797649  ...
43.654465  43.579614  43.583642  43.534542  43.449800  ...
43.378080  43.264060  43.297998  43.208208  43.110625  ...
42.960968  42.857011  42.732731  42.702675  42.641776  ...
42.745853  42.743275  42.757075  42.700515  42.658950  ...
42.733176  42.707637  42.757175  42.756280  42.710243  ...
42.654674  42.677363  42.688263  42.671558  42.598177  ...
42.579714  42.535502  42.558193  42.527855  42.474604  ...
42.583248  42.500210  42.529364  42.567750  42.460139  ...
42.466551  42.447944  42.464506  42.484539  42.499414  ...
]; 

c1 = d_no128;
c2 = h263_d;
c3 = h263_flt;

err = mean(c1 - c2);
mad = max(abs(c1 - c2));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(c1,'r');
  hold on;
  plot(c2, 'b');
  hold on;
  plot(c3, 'c');
%  hold on;
%  plot(c4, 'k');
else
  plot(c1,':');
  hold on;
  plot(c2, '-'); 
end
  legend('bindct', 'H.263');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(c1 - c2, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%
t1 = 'Suzie (A4 q4) ';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

d_no128 = [ 39.858480  39.048438  38.801137  38.620446  38.588207  ...
38.549313  38.513983  38.501946  38.433485  38.342848  ...
38.326666  38.325752  38.259216  38.361186  38.471425  ...
38.485347  38.556716  38.506503  38.434220  38.487077  ...
38.445296  38.370013  38.371516  38.365001  38.445278  ...
38.352738  38.357032  38.391195  38.431629  38.491953  ...
38.439147  38.374451  38.562826  38.545390  38.529902  ...
38.560385  38.457934  38.453410  38.482727  38.458064  ...
38.353982  38.362777  38.327903  38.271836  38.322205  ...
38.521420  38.566102  38.759208  39.025868  39.008467  ...
39.369625  39.760470  39.823977  39.759847  39.612923  ...
39.539423  39.469129  39.463838  39.364477  39.365137  ...
39.173197  38.971502  39.092627  38.906729  38.804358  ...
38.598787  38.495661  38.284671  38.225038  38.250047  ...
38.156119  38.180334  38.264991  38.272668  38.146374  ...
38.193492  38.060940  38.057939  38.107067  38.100323  ...
37.995968  37.854068  37.875198  37.777966  37.766653  ...
37.648224  37.765235  37.661047  37.760323  37.707726  ...
37.721163  37.815524  37.795284  37.810570  37.699712  ...
37.694083  37.622326  37.585262  37.517914  37.461409  ...
]; 


h263_d = [ 39.796556  39.000567  38.748705  38.562069  38.494468  ...
38.454056  38.426967  38.411749  38.301285  38.349241  ...
38.280856  38.362939  38.264196  38.363879  38.395072  ...
38.418939  38.564265  38.596993  38.476005  38.481872  ...
38.425280  38.393470  38.330773  38.382198  38.429334  ...
38.398224  38.427059  38.422328  38.264708  38.439534  ...
38.414986  38.407875  38.483247  38.515911  38.597623  ...
38.623305  38.545202  38.569096  38.651206  38.565742  ...
38.592074  38.756734  38.624744  38.704109  38.763072  ...
38.891594  39.093974  39.287287  39.473048  39.629758  ...
39.969181  40.398232  40.468963  40.486525  40.260302  ...
40.102241  39.933428  39.917316  39.832083  39.829726  ...
39.656654  39.528085  39.544356  39.377975  39.240994  ...
39.149733  38.992933  38.837864  38.785468  38.761804  ...
38.752263  38.777864  38.856335  38.831034  38.718034  ...
38.707669  38.710586  38.671614  38.728994  38.750840  ...
38.690754  38.669945  38.630047  38.557889  38.604211  ...
38.429830  38.481314  38.390376  38.428857  38.452099  ...
38.471221  38.428178  38.480107  38.503551  38.443583  ...
38.511719  38.414455  38.419690  38.466460  38.419599  ...
]; 


c1 = d_no128;
c2 = h263_d;

err = mean(c1 - c2);
mad = max(abs(c1 - c2));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(c1,'r');
  hold on;
  plot(c2, 'b');
%  hold on;
%  plot(c3, 'c');
%  hold on;
%  plot(c4, 'k');
else
  plot(c1,':');
  hold on;
  plot(c2, '-'); 
end
  legend('bindct', 'H.263');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(c1 - c2, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%
t1 = 'Suzie (A6 q6) ';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

d_no128 = [ 37.263959  36.697533  36.651312  36.464429  36.351435  ...
36.405024  36.430297  36.372759  36.236296  36.245878  ...
36.304188  36.302467  36.317272  36.300421  36.237803  ...
36.242859  36.405646  36.422843  36.401226  36.419548  ...
36.335527  36.310652  36.218000  36.329479  36.351401  ...
36.345626  36.378513  36.333238  36.443220  36.441513  ...
36.386121  36.421270  36.458840  36.484159  36.633637  ...
36.708486  36.602527  36.741550  36.635264  36.561860  ...
36.585554  36.609909  36.552604  36.664618  36.693482  ...
36.922479  36.978025  37.122183  37.422251  37.597309  ...
37.866192  38.527104  38.566879  38.386394  38.195822  ...
38.059793  37.944395  37.901532  37.896902  37.865063  ...
37.569136  37.434248  37.408909  37.282103  37.166408  ...
37.019020  36.887757  36.730314  36.619905  36.713985  ...
36.663420  36.831212  36.889997  36.776059  36.596312  ...
36.627887  36.594170  36.552199  36.593136  36.619542  ...
36.636297  36.410256  36.433912  36.488430  36.422311  ...
36.299420  36.312884  36.199167  36.241295  36.236251  ...
36.282760  36.359086  36.376888  36.341572  36.289977  ...
36.288520  36.332173  36.426244  36.372897  36.397476  ...
]; 


h263_d = [ 37.267722  36.733406  36.657093  36.434191  36.328743  ...
36.379830  36.388644  36.348842  36.251810  36.254579  ...
36.285359  36.241938  36.303502  36.324038  36.244990  ...
36.221432  36.373205  36.361936  36.275913  36.345421  ...
36.298588  36.182788  36.193261  36.238855  36.205641  ...
36.241583  36.347523  36.382842  36.272237  36.344229  ...
36.387416  36.394557  36.346796  36.467443  36.493552  ...
36.639395  36.600286  36.604010  36.542916  36.545389  ...
36.480829  36.581606  36.435304  36.541501  36.507573  ...
36.806901  36.855494  37.117757  37.402615  37.493696  ...
37.828179  38.194865  38.460725  38.393197  38.105857  ...
38.004498  37.842427  37.744209  37.763770  37.711755  ...
37.552800  37.477891  37.364973  37.239480  37.108065  ...
36.905788  36.801775  36.676101  36.534768  36.634439  ...
36.580083  36.617655  36.677928  36.601081  36.400650  ...
36.430250  36.450302  36.452513  36.536810  36.476917  ...
36.472692  36.274673  36.303806  36.331596  36.282637  ...
36.229975  36.165130  36.080189  35.964967  36.104140  ...
36.120861  36.228216  36.249899  36.216589  36.177801  ...
36.151377  36.253278  36.185678  36.153442  36.180447  ...
]; 

c1 = d_no128;
c2 = h263_d;

err = mean(c1 - c2);
mad = max(abs(c1 - c2));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(c1,'r');
  hold on;
  plot(c2, 'b');
%  hold on;
%  plot(c3, 'c');
%  hold on;
%  plot(c4, 'k');
else
  plot(c1,':');
  hold on;
  plot(c2, '-'); 
end
  legend('bindct', 'H.263');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(c1 - c2, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%
t1 = 'Suzie (A8 q8) ';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

d_no128 = [ 35.681371  35.300254  35.320016  35.187584  35.100825  ...
35.089479  35.156648  35.052858  34.969120  34.959690  ...
34.931437  34.968136  34.892321  35.018451  34.926518  ...
34.900939  35.006875  35.064523  35.040467  35.080887  ...
35.089028  35.015815  34.975903  34.996213  34.962589  ...
34.981467  35.078858  35.080292  35.061775  35.163193  ...
35.069669  35.068407  35.053322  35.245484  35.293713  ...
35.386257  35.363988  35.314001  35.268171  35.192102  ...
35.132507  35.148517  35.072303  35.149215  35.310947  ...
35.358926  35.530455  35.649946  35.912686  35.939296  ...
36.443743  37.030883  37.129307  37.068115  36.829637  ...
36.640003  36.533487  36.366397  36.524765  36.474072  ...
36.184714  36.024263  35.902765  35.794768  35.732897  ...
35.502354  35.347319  35.231530  35.176842  35.231099  ...
35.244814  35.267063  35.334798  35.308656  35.163781  ...
35.162051  35.066088  35.069076  35.237141  35.182279  ...
35.093385  34.948492  34.962572  34.876700  34.832929  ...
34.730101  34.796022  34.712001  34.673653  34.728081  ...
34.750660  34.825590  34.887999  34.886797  34.740474  ...
34.782289  34.789936  34.901965  34.830163  34.957453  ...
]; 

h263_d = [ 35.715539  35.337139  35.356935  35.151087  35.048726  ...
35.050530  35.086825  35.051171  35.001036  34.993316  ...
34.891695  34.876652  34.885490  34.992010  34.913722  ...
34.928436  34.934325  35.038205  35.028262  34.973740  ...
34.983094  34.920794  34.927428  34.948121  34.911345  ...
35.003855  35.080258  35.083562  35.070033  35.060532  ...
35.060296  35.122389  35.173120  35.172400  35.206725  ...
35.301370  35.267470  35.220802  35.222828  35.338607  ...
35.195108  35.123426  35.002712  35.168587  35.237212  ...
35.549726  35.561071  35.647759  35.893245  36.087730  ...
36.374314  36.910391  37.064440  37.013254  36.839911  ...
36.609064  36.442930  36.367162  36.355691  36.450034  ...
36.330192  36.077390  35.926693  35.874063  35.714046  ...
35.517414  35.273120  35.177719  35.120392  35.258033  ...
35.269429  35.279150  35.379094  35.250001  35.041148  ...
35.035011  35.031392  34.986474  35.136882  35.227190  ...
35.058361  34.978456  34.927870  34.874036  34.815682  ...
34.744354  34.791858  34.654047  34.676823  34.709857  ...
34.764168  34.823501  34.896250  34.854691  34.774575  ...
34.741746  34.785888  34.852048  34.766773  34.928157  ...
]; 

c1 = d_no128;
c2 = h263_d;

err = mean(c1 - c2);
mad = max(abs(c1 - c2));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(c1,'r');
  hold on;
  plot(c2, 'b');
%  hold on;
%  plot(c3, 'c');
%  hold on;
%  plot(c4, 'k');
else
  plot(c1,':');
  hold on;
  plot(c2, '-'); 
end
  legend('bindct', 'H.263');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(c1 - c2, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%
t1 = 'Suzie (A20 q13) ';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

d_no128 = [ 31.237563  32.092316  32.405258  32.570940  32.577724  ...
32.619850  32.659679  32.652053  32.578960  32.583940  ...
32.615150  32.686223  32.612461  32.698062  32.663074  ...
32.651082  32.767086  32.844346  32.840811  32.949233  ...
32.952087  32.855658  32.906831  32.927016  32.938789  ...
32.949914  32.953070  33.035274  33.011485  33.080996  ...
33.034977  33.031258  33.004558  33.096425  33.093523  ...
33.205225  33.176237  33.264216  33.084839  33.046644  ...
33.000454  32.980240  32.916218  32.995876  33.036414  ...
33.279532  33.317917  33.320588  33.597479  33.755716  ...
34.033358  34.567646  34.848643  34.820533  34.616700  ...
34.341097  34.239360  34.192546  34.272331  34.111320  ...
33.968999  33.849329  33.780825  33.511902  33.401138  ...
33.157038  33.103382  32.932899  32.844610  32.968531  ...
32.967602  33.093942  33.151796  33.077719  32.933556  ...
32.762279  32.752647  32.838399  32.874257  32.915093  ...
32.765820  32.650709  32.634167  32.595815  32.575492  ...
32.555729  32.619667  32.489655  32.567422  32.563882  ...
32.563411  32.559865  32.684472  32.524032  32.496880  ...
32.533155  32.597813  32.746602  32.609836  32.692459  ...
]; 

h263_d = [ 31.290613  32.158118  32.491311  32.634529  32.630814  ...
32.644076  32.633732  32.692606  32.576851  32.629230  ...
32.680562  32.700839  32.654917  32.744633  32.637788  ...
32.730674  32.829320  32.947986  32.866877  32.869356  ...
32.918942  32.872307  32.890793  32.954678  32.908282  ...
32.958103  33.000186  33.009561  33.047510  33.022301  ...
33.074032  33.091042  33.155806  33.192262  33.228007  ...
33.208875  33.320639  33.354288  33.242016  33.154536  ...
32.989525  33.052728  32.915093  32.942996  33.098060  ...
33.230546  33.298364  33.400060  33.705448  33.814622  ...
34.338370  34.849665  34.999744  34.864413  34.605088  ...
34.464548  34.420388  34.178122  34.295531  34.240941  ...
34.003855  33.913924  33.946782  33.644859  33.404052  ...
33.121372  33.085590  32.985619  32.875489  33.023226  ...
32.992038  33.179853  33.199303  33.197602  32.854163  ...
32.768092  32.829851  32.820780  32.932660  33.057052  ...
32.896252  32.746136  32.799098  32.747460  32.603333  ...
32.728140  32.707908  32.652475  32.625630  32.554718  ...
32.630239  32.690324  32.667752  32.617909  32.542813  ...
32.603012  32.723041  32.747083  32.717165  32.827000  ...
]; 


c1 = d_no128;
c2 = h263_d;

err = mean(c1 - c2);
mad = max(abs(c1 - c2));
s=sprintf('(Average Difference %fdB; MAD: %fdB.)', err, mad);

figure;
if (colorplot == 1) 
  plot(c1,'r');
  hold on;
  plot(c2, 'b');
%  hold on;
%  plot(c3, 'c');
%  hold on;
%  plot(c4, 'k');
else
  plot(c1,':');
  hold on;
  plot(c2, '-'); 
end
  legend('bindct', 'H.263');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(c1 - c2, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Forman: A 20 Q 13
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Foreman with default quantization steps: ';

%148115bytes; Comp. ratio: 102.67
%psnr drop: 0.0844 dB
c4_c4 = [ 29.186788  30.274004  30.546023  30.657782  30.635624  ...
30.648792  30.661494  30.687719  30.785486  30.771375  ...
30.902103  30.705323  30.781424  30.664201  30.702115  ...
30.715614  30.833112  30.825932  30.739979  30.690725  ...
30.547425  30.426407  30.330391  30.396958  30.331833  ...
30.389310  30.399720  30.432263  30.520916  30.480340  ...
30.461246  30.489521  30.487289  30.526056  30.578385  ...
30.537160  30.467273  30.616025  30.543887  30.667949  ...
30.727018  30.742708  30.803795  30.631016  30.594259  ...
30.584528  30.643352  30.797714  30.823150  30.792337  ...
30.763752  30.806850  30.643886  30.636234  30.758122  ...
30.822615  30.762602  30.718359  30.796543  30.828084  ...
30.807710  30.808405  30.664057  30.429361  30.437681  ...
30.411380  30.432408  30.351491  30.303800  30.398948  ...
30.473878  30.486239  30.517151  30.621601  30.645678  ...
30.627550  30.619592  30.751914  30.705692  30.619339  ...
30.554537  30.671974  30.624832  30.648813  30.584661  ...
30.641564  30.710186  30.695748  30.812575  30.893189  ...
30.883469  30.905585  30.933930  30.947934  30.934747  ...
31.065598  31.050810  31.019918  31.023942  31.049165  ...
31.122916  31.146580  31.124650  31.052693  30.991962  ...
30.949495  30.929073  31.031599  30.998898  30.871957  ...
30.784315  30.768056  30.753261  30.610143  30.588298  ...
30.537736  30.589352  30.477744  30.522512  30.544078  ...
30.573477  30.611748  30.732314  30.777634  30.731584  ...
30.787801  30.706820  30.660036  30.861006  30.935930  ...
30.888297  30.876963  30.793299  30.790418  30.836114  ...
30.879269  30.743468  30.784065  30.732055  30.698619  ...
30.848663  30.957418  30.954915  30.882242  30.917795  ...
30.922498  30.862992  30.841926  30.659877  30.570273  ...
30.574079  30.585695  30.520551  30.456068  30.452375  ...
30.307577  30.306811  30.348657  30.533347  30.642123  ...
30.790165  30.817099  30.693509  30.774520  30.725177  ...
30.704275  30.781560  30.780733  30.612692  30.734998  ...
30.684911  30.763278  30.743633  30.901970  30.896304  ...
30.840292  30.902369  30.772281  30.880237  30.784855  ...
30.660493  30.544252  30.456612  30.440987  30.300808  ...
30.351116  30.323935  30.260991  30.360627  30.631830  ...
30.780323  30.683615  30.621942  30.744472  30.830760  ...
30.703550  30.744059  30.780153  30.809078  30.766949  ...
30.822341  30.856542  30.885100  30.922267  30.941393  ...
30.950292  30.988158  31.018102  31.095149  31.110422  ...
30.891050  30.950059  30.969419  30.905036  30.967101  ...
30.937323  30.854652  30.848903  30.986151  31.014435  ...
31.030472  30.943426  31.010419  30.895002  30.812172  ...
30.689569  30.635428  30.542403  30.420614  30.320626  ...
30.259278  30.205425  30.262197  30.195007  30.191971  ...
30.120236  30.166896  30.345417  30.351019  30.361566  ...
30.456457  30.529124  30.527437  30.498518  30.666880  ...
30.801345  30.914290  31.131887  31.052149  31.054356  ...
31.053812  31.115727  31.381592  31.583466  31.212082  ...
30.802854  30.809793  30.935129  30.464383  30.358443  ...
30.365010  30.507214  30.601021  30.615165  30.611448  ...
30.680159  30.826047  30.980582  30.930324  30.987712  ...
30.905793  30.920674  30.839080  30.812261  30.664441  ...
30.539027  30.576552  30.645632  30.688535  30.873803  ...
30.994827  31.471265  31.347053  31.335615  31.655876  ...
31.881168  32.140662  32.475955  33.025706  33.041343  ...
32.754004  32.390715  32.170420  31.988557  31.852898  ...
31.510137  31.169029  31.290762  31.692672  32.115356  ...
32.622139  32.995283  33.227636  32.973001  33.054059  ...
33.019823  32.955812  33.107628  33.194070  32.724951  ...
32.272348  31.657331  31.270140  31.078716  30.908663  ...
30.629530  30.320975  29.907321  29.552876  29.355646  ...
29.211813  29.185311  29.152728  29.245725  29.241366  ...
29.517107  29.569667  29.528747  29.337131  29.219277  ...
29.066708  28.974395  28.928944  28.900622  28.866737  ...
28.953527  29.005345  29.111170  29.208045  29.075845  ...
28.986780  28.906666  28.951743  29.001114  28.946140  ...
28.949019  28.822216  28.916626  28.874818  28.873648  ...
28.832244  28.918123  28.829963  28.874545  28.932320  ...
28.815598  28.803293  28.666354  28.663532  28.620524  ...
28.702076  28.711313  28.680810  28.708614  28.747163  ...
28.837453  28.847561  28.819552  28.769092  28.724770  ...
28.705368  28.744172  28.811040  28.783236  28.783520  ...
28.798586  28.789272  28.741995  28.742933  28.702773  ...
28.717357  28.751480  28.795522  28.785719  28.821183  ...
28.805979  28.796420  28.818147  28.779963  28.766858  ...
28.884748  28.921352  28.894623  28.930085  28.912390  ...
28.880441  28.814918  28.809055  28.745881  28.744602  ...
];
 %Average:   30.461380, 35.724579, 36.110939

%150515bytes; Comp. Ratio: 101.03
f_f = [ 29.229463  30.367657  30.622751  30.719441  30.725884  ...
30.794678  30.707078  30.698174  30.838927  30.805295  ...
30.896550  30.788468  30.751976  30.776014  30.716500  ...
30.738785  30.832072  30.827054  30.823625  30.725604  ...
30.656988  30.521487  30.435347  30.587701  30.534542  ...
30.492445  30.492165  30.608391  30.586582  30.532927  ...
30.570252  30.587251  30.602144  30.600773  30.667239  ...
30.676126  30.598068  30.630319  30.730231  30.794622  ...
30.834671  30.799124  30.793878  30.734770  30.686090  ...
30.671685  30.747560  30.839048  30.830952  30.816454  ...
30.842640  30.798139  30.711263  30.688989  30.884328  ...
30.798611  30.810488  30.824571  30.821902  30.846827  ...
30.772996  30.735185  30.644372  30.521704  30.468218  ...
30.522976  30.540116  30.513447  30.493925  30.579945  ...
30.609218  30.559252  30.585991  30.736606  30.779279  ...
30.722758  30.679545  30.705651  30.784747  30.755493  ...
30.640617  30.726831  30.652015  30.705239  30.690107  ...
30.700641  30.754086  30.806434  30.911029  30.975469  ...
30.949855  30.977557  31.011687  31.056093  31.120207  ...
31.267013  31.212274  31.203646  31.152837  31.183097  ...
31.210257  31.222319  31.250541  31.189299  31.166022  ...
31.136685  31.107276  31.112049  31.093589  31.001835  ...
30.894270  30.870798  30.765512  30.626134  30.667153  ...
30.629883  30.653975  30.576802  30.614045  30.661248  ...
30.626320  30.752876  30.731781  30.850037  30.858822  ...
30.906942  30.759779  30.721644  30.874960  30.919654  ...
30.900524  30.968461  30.867762  30.859560  30.820348  ...
30.823937  30.814552  30.903177  30.892616  30.825036  ...
31.010572  31.060498  30.942581  31.006374  30.973117  ...
31.062998  30.970671  30.893351  30.774977  30.690487  ...
30.731694  30.697635  30.755628  30.691475  30.575881  ...
30.548035  30.500340  30.524644  30.683769  30.906367  ...
30.918892  30.868756  30.798072  30.791743  30.849316  ...
30.847218  30.788620  30.870257  30.772423  30.639167  ...
30.735388  30.766596  30.794523  30.883182  30.903242  ...
30.913562  30.972313  30.914619  30.842093  30.778349  ...
30.665264  30.589152  30.578096  30.521436  30.309858  ...
30.352117  30.364638  30.268892  30.336899  30.762998  ...
30.873597  30.761110  30.831973  30.966538  30.971983  ...
30.812251  30.861767  30.992117  30.981186  30.909732  ...
31.031615  30.990601  31.072417  31.059321  31.071081  ...
31.135634  31.001151  31.158583  31.227822  31.113248  ...
30.965313  31.031575  31.003113  30.952477  30.994459  ...
31.029527  31.016723  31.035473  31.163207  31.168956  ...
31.145174  31.076693  31.017719  31.009751  30.926121  ...
30.830221  30.706014  30.665525  30.520744  30.436503  ...
30.325131  30.301627  30.243680  30.256496  30.212180  ...
30.157305  30.303989  30.483110  30.504396  30.509777  ...
30.484330  30.643590  30.647651  30.737118  30.947983  ...
31.021324  31.141169  31.296651  31.159980  31.200688  ...
31.189947  31.255950  31.529013  31.669166  31.171907  ...
30.942060  30.986061  31.079186  30.611083  30.472391  ...
30.489958  30.578391  30.670479  30.681977  30.725118  ...
30.670525  30.811435  30.926395  30.952637  31.022118  ...
31.011477  30.987305  30.834683  30.786582  30.703615  ...
30.623332  30.761424  30.813494  30.755145  30.800473  ...
31.083885  31.308083  31.437469  31.368686  31.626156  ...
31.873400  32.296191  32.611350  33.144267  33.005990  ...
32.863722  32.366630  32.190574  32.054511  31.974923  ...
31.577861  31.312120  31.427496  31.781641  32.161238  ...
32.737673  33.072032  33.231178  33.073337  33.202249  ...
33.200134  33.128288  33.259508  33.270580  32.873021  ...
32.263836  31.663929  31.272973  31.072316  30.915429  ...
30.691868  30.390706  30.038390  29.609025  29.408457  ...
29.214768  29.207046  29.223753  29.173473  29.388262  ...
29.573595  29.576596  29.493424  29.349142  29.251266  ...
29.129558  29.053012  28.973528  29.019633  28.951890  ...
28.983488  29.127309  29.128833  29.276681  29.164768  ...
29.098912  29.063631  29.106530  29.102989  29.059270  ...
28.970040  28.930812  28.941737  28.877507  28.819231  ...
28.893457  28.984783  28.921255  28.981435  29.027294  ...
28.988817  28.920192  28.784460  28.807454  28.839635  ...
28.817151  28.797887  28.782035  28.812307  28.796347  ...
28.915899  28.854361  28.847931  28.828017  28.816563  ...
28.777279  28.825355  28.934089  28.879372  28.818783  ...
28.866457  28.859974  28.812520  28.774182  28.763048  ...
28.847104  28.913256  28.964374  28.908590  28.936613  ...
28.893347  28.822551  28.858179  28.807572  28.850385  ...
28.938809  28.974578  28.971360  29.051949  28.982020  ...
28.878832  28.854432  28.845950  28.821689  28.776741  ...
];
 %Average:   30.545795, 35.700990, 36.185410


f_c4 = [ 29.190797  30.337107  30.592374  30.697657  30.702264  ...
30.772776  30.686299  30.671968  30.805432  30.772470  ...
30.853378  30.750604  30.707298  30.728464  30.665983  ...
30.704619  30.787659  30.783099  30.791145  30.694279  ...
30.620230  30.463392  30.378595  30.528249  30.471565  ...
30.430554  30.423085  30.547503  30.528636  30.486334  ...
30.519493  30.544276  30.556771  30.554701  30.618251  ...
30.639045  30.562176  30.595722  30.687056  30.742480  ...
30.787931  30.755769  30.741607  30.689338  30.630581  ...
30.628040  30.704789  30.799897  30.802460  30.781137  ...
30.794678  30.752058  30.664048  30.634190  30.827408  ...
30.740710  30.743049  30.779156  30.765597  30.792768  ...
30.715934  30.667058  30.593504  30.498956  30.421822  ...
30.473454  30.501620  30.470446  30.459813  30.553477  ...
30.564195  30.516112  30.518730  30.647592  30.690650  ...
30.643960  30.596339  30.621829  30.685858  30.654435  ...
30.524492  30.601717  30.515156  30.573952  30.555462  ...
30.571598  30.621178  30.659318  30.772423  30.858603  ...
30.830457  30.867469  30.929113  30.951614  31.007780  ...
31.133009  31.070791  31.058211  31.003023  31.050645  ...
31.069082  31.064126  31.091763  31.020918  31.010300  ...
30.980433  30.937578  30.947901  30.949226  30.861475  ...
30.774776  30.755283  30.658325  30.520985  30.574876  ...
30.530265  30.546080  30.461574  30.518997  30.559747  ...
30.532221  30.641408  30.608506  30.707081  30.716646  ...
30.777054  30.606414  30.582626  30.739267  30.773862  ...
30.782285  30.830728  30.731921  30.731996  30.673420  ...
30.670273  30.651764  30.702602  30.704452  30.662666  ...
30.828301  30.867659  30.747372  30.812798  30.780345  ...
30.877079  30.786898  30.712313  30.596952  30.546636  ...
30.608197  30.553842  30.633775  30.580882  30.473346  ...
30.432947  30.392800  30.423846  30.565383  30.768090  ...
30.773702  30.713757  30.625194  30.611991  30.675870  ...
30.672691  30.605336  30.678834  30.555486  30.434814  ...
30.516581  30.534015  30.585469  30.645883  30.659042  ...
30.720216  30.780402  30.723514  30.660904  30.652600  ...
30.550036  30.454540  30.420988  30.381307  30.179690  ...
30.208932  30.243340  30.110724  30.179943  30.558416  ...
30.627675  30.519425  30.602992  30.746336  30.755744  ...
30.588552  30.664432  30.765480  30.780222  30.679459  ...
30.779607  30.749329  30.821322  30.787969  30.820036  ...
30.873401  30.761720  30.915165  30.984878  30.880547  ...
30.742436  30.789915  30.782276  30.727806  30.811330  ...
30.842925  30.837993  30.830690  30.949190  30.905202  ...
30.880660  30.834489  30.764600  30.787978  30.702391  ...
30.600821  30.505017  30.469597  30.333930  30.238986  ...
30.144190  30.126469  30.089126  30.098910  30.047154  ...
29.978742  30.114323  30.262858  30.279413  30.256937  ...
30.199905  30.380580  30.352908  30.434461  30.639484  ...
30.641512  30.752625  30.922498  30.820218  30.805067  ...
30.828282  30.916809  31.182322  31.379745  31.019494  ...
30.805762  30.856709  30.951522  30.497129  30.375790  ...
30.366493  30.473416  30.552238  30.550538  30.618333  ...
30.566797  30.659659  30.787321  30.795099  30.828157  ...
30.823447  30.844234  30.693976  30.629243  30.540373  ...
30.499275  30.626987  30.671467  30.616924  30.663120  ...
30.940679  31.204080  31.335500  31.265162  31.490385  ...
31.703090  32.189553  32.521704  33.076306  32.895025  ...
32.746766  32.234474  32.063575  31.931181  31.874569  ...
31.512929  31.222053  31.332795  31.678600  32.052033  ...
32.639491  33.003574  33.138525  33.026362  33.159699  ...
33.160485  33.100944  33.234823  33.242411  32.851271  ...
32.237464  31.637253  31.247663  31.050504  30.893075  ...
30.670974  30.360429  30.016533  29.582163  29.374818  ...
29.198444  29.183474  29.198595  29.158100  29.366542  ...
29.551889  29.554700  29.456486  29.330221  29.220757  ...
29.097946  29.006037  28.928732  28.971922  28.919253  ...
28.953308  29.095230  29.103289  29.252648  29.144088  ...
29.092370  29.065560  29.106628  29.090656  29.031435  ...
28.946870  28.899988  28.911463  28.841712  28.766322  ...
28.844488  28.935052  28.866907  28.916415  28.967114  ...
28.921623  28.856121  28.736379  28.750869  28.787535  ...
28.765757  28.748913  28.727382  28.750397  28.731325  ...
28.832729  28.774655  28.766433  28.744034  28.717234  ...
28.681467  28.711695  28.813285  28.771701  28.716675  ...
28.761467  28.752275  28.701421  28.662349  28.639664  ...
28.719192  28.799128  28.858160  28.807596  28.839498  ...
28.787413  28.722442  28.763246  28.703076  28.750330  ...
28.832987  28.870945  28.876683  28.946719  28.893414  ...
28.777602  28.744732  28.747599  28.713850  28.682436  ...
];
 %Average:   30.426925, 35.657138, 36.134606


%147476 bytes; Comp. Ratio: 103.11
 %PSNR drop: 0.2921 dB
c1_c1 = [ 28.721804  29.905802  30.231552  30.413376  30.373802  ...
30.380695  30.456972  30.486092  30.565815  30.662574  ...
30.640205  30.526291  30.472376  30.389293  30.365532  ...
30.452764  30.473469  30.531337  30.518596  30.497262  ...
30.390123  30.273423  30.177556  30.214752  30.135973  ...
30.165962  30.209828  30.316231  30.282925  30.271509  ...
30.261480  30.273729  30.311336  30.371264  30.345306  ...
30.342622  30.268393  30.338968  30.407725  30.436734  ...
30.543747  30.557175  30.435478  30.423695  30.357301  ...
30.348314  30.316633  30.529630  30.567962  30.574590  ...
30.489958  30.450922  30.361011  30.302345  30.383903  ...
30.348828  30.346045  30.398668  30.417593  30.499379  ...
30.419313  30.485453  30.409607  30.201514  30.154377  ...
30.182932  30.198669  30.170312  30.156587  30.257891  ...
30.212877  30.163676  30.275160  30.340877  30.390841  ...
30.387282  30.350794  30.334420  30.418724  30.364492  ...
30.359310  30.406865  30.333751  30.371505  30.379104  ...
30.463896  30.619506  30.559420  30.741539  30.732168  ...
30.710382  30.645546  30.626621  30.670470  30.757372  ...
30.800575  30.829366  30.876189  30.828256  30.810726  ...
30.922492  30.955940  30.879234  30.864140  30.733765  ...
30.735041  30.664106  30.740135  30.826812  30.712480  ...
30.533079  30.524763  30.515014  30.367129  30.275601  ...
30.292620  30.201835  30.305075  30.170860  30.296500  ...
30.308316  30.356603  30.542938  30.545542  30.596006  ...
30.627334  30.493163  30.533899  30.605003  30.691528  ...
30.666926  30.694183  30.536939  30.535255  30.522732  ...
30.536373  30.560727  30.511428  30.579415  30.515821  ...
30.645583  30.812318  30.715245  30.709711  30.720238  ...
30.722319  30.601478  30.551923  30.508621  30.449376  ...
30.342856  30.324043  30.226691  30.249853  30.255037  ...
30.244349  30.133671  30.209035  30.346950  30.494240  ...
30.556390  30.568930  30.558692  30.490616  30.525319  ...
30.562095  30.559012  30.533434  30.378518  30.381509  ...
30.544174  30.485187  30.498722  30.577184  30.625471  ...
30.607818  30.624658  30.493800  30.511360  30.431215  ...
30.391525  30.311047  30.320918  30.245096  30.096153  ...
30.008255  29.984557  30.033074  30.080293  30.417569  ...
30.527910  30.404504  30.399468  30.495171  30.724081  ...
30.497150  30.549079  30.581897  30.651109  30.691383  ...
30.790270  30.829762  30.824482  30.747200  30.759286  ...
30.770453  30.815147  30.872370  30.849999  30.820577  ...
30.734573  30.697066  30.732477  30.774385  30.737243  ...
30.727099  30.638291  30.629591  30.776080  30.856292  ...
30.825655  30.697208  30.754405  30.717128  30.666892  ...
30.447617  30.361606  30.249976  30.146621  30.022324  ...
30.041694  29.957649  29.933918  29.861547  29.864984  ...
29.914498  30.021917  30.248762  30.242365  30.300495  ...
30.334477  30.390740  30.403556  30.471583  30.645137  ...
30.700071  30.824954  30.973005  30.960645  30.966060  ...
30.863783  30.947042  31.301207  31.332899  30.893542  ...
30.514233  30.578960  30.754957  30.323589  30.322173  ...
30.322911  30.337463  30.482277  30.431390  30.466809  ...
30.382890  30.497986  30.684081  30.693982  30.846110  ...
30.858600  30.749658  30.591399  30.533928  30.449022  ...
30.318014  30.395362  30.522610  30.382107  30.514978  ...
30.738204  31.019914  31.027410  31.120558  31.346546  ...
31.703086  31.895615  32.306492  32.724551  32.714569  ...
32.498758  32.021763  31.905354  31.792060  31.611916  ...
31.229395  30.844592  31.099998  31.422506  31.863230  ...
32.455758  32.817552  32.848396  32.795996  32.643984  ...
32.786830  32.862550  32.953101  32.995839  32.550525  ...
31.990086  31.364925  30.962102  30.791803  30.742051  ...
30.377273  30.001045  29.717509  29.391000  29.109556  ...
29.049805  28.986955  28.961489  28.982683  29.079978  ...
29.382524  29.447662  29.379476  29.140938  29.002762  ...
28.852714  28.791767  28.807334  28.759640  28.754585  ...
28.767560  28.855450  28.949580  29.100099  28.920009  ...
28.840674  28.787752  28.854003  28.872073  28.870258  ...
28.806167  28.749758  28.750624  28.701139  28.668828  ...
28.681290  28.795220  28.728107  28.753016  28.794206  ...
28.705489  28.646725  28.548517  28.566130  28.593456  ...
28.623205  28.623312  28.596514  28.610560  28.593071  ...
28.729545  28.705793  28.671573  28.640448  28.632581  ...
28.613157  28.626600  28.664387  28.680242  28.628913  ...
28.662056  28.626454  28.613824  28.589262  28.654990  ...
28.658481  28.701108  28.718664  28.735589  28.718752  ...
28.637579  28.637820  28.640743  28.676075  28.681761  ...
28.714546  28.782332  28.740120  28.767725  28.728359  ...
28.670229  28.632968  28.642786  28.621113  28.670801  ...
];
 %Average:   30.253741, 35.642754, 35.942767

%149318, 101.84, 30.4835db
c7_c7 = [ 29.224245  30.332374  30.605669  30.661782  30.752738  ...
30.664462  30.679283  30.672682  30.816126  30.836987  ...
30.910061  30.784435  30.769663  30.748233  30.701137  ...
30.596925  30.770075  30.816123  30.844864  30.743909  ...
30.647865  30.518071  30.433844  30.559849  30.599581  ...
30.475289  30.511763  30.615129  30.587580  30.516432  ...
30.519871  30.541752  30.563799  30.575866  30.532394  ...
30.606639  30.585065  30.619701  30.679604  30.758555  ...
30.818187  30.751882  30.726061  30.584715  30.594552  ...
30.586693  30.561159  30.683143  30.748005  30.784671  ...
30.769868  30.790680  30.713306  30.664281  30.745920  ...
30.776997  30.681814  30.701703  30.756494  30.831293  ...
30.709268  30.700050  30.687621  30.493275  30.464758  ...
30.511060  30.500798  30.538007  30.537258  30.502079  ...
30.548977  30.448578  30.537587  30.568458  30.625413  ...
30.656743  30.645877  30.741185  30.706975  30.683686  ...
30.626274  30.703649  30.706609  30.684716  30.618798  ...
30.702019  30.762762  30.784665  30.876592  30.864542  ...
30.950948  31.002402  30.917489  30.977280  30.929912  ...
31.002628  31.075619  31.065106  31.147047  31.225316  ...
31.300862  31.235212  31.171934  31.183429  31.117108  ...
31.143668  30.982481  31.119733  31.018092  30.907134  ...
30.853808  30.775884  30.779021  30.658680  30.490985  ...
30.571751  30.521439  30.457663  30.481344  30.493310  ...
30.566920  30.595480  30.619984  30.788130  30.741567  ...
30.724258  30.672174  30.756786  30.941101  30.989591  ...
30.919260  30.940070  30.876324  30.725158  30.785391  ...
30.834559  30.777634  30.726174  30.762813  30.767697  ...
30.902401  30.915855  30.827124  30.821545  30.901928  ...
30.872076  30.904754  30.848249  30.736153  30.702376  ...
30.643410  30.650353  30.528255  30.540848  30.535765  ...
30.398830  30.421935  30.520114  30.700412  30.821653  ...
30.890089  30.846263  30.740070  30.699882  30.808009  ...
30.774142  30.786156  30.753691  30.631513  30.610838  ...
30.771636  30.682785  30.733946  30.818884  30.916789  ...
30.821278  30.781774  30.778292  30.753991  30.686543  ...
30.545629  30.535317  30.493930  30.472761  30.336074  ...
30.175687  30.229288  30.234928  30.225228  30.652092  ...
30.790902  30.766606  30.794720  30.783396  30.814406  ...
30.793321  30.812410  30.924353  30.944949  30.820504  ...
30.831689  30.904400  30.979396  31.023512  31.004574  ...
31.002571  31.042329  31.117016  31.100228  31.047008  ...
30.896514  30.934155  30.988109  30.960629  31.026438  ...
31.013816  30.895986  30.947659  31.106191  31.157303  ...
31.142320  31.052039  30.923235  30.797866  30.786977  ...
30.638840  30.623234  30.526988  30.488150  30.424895  ...
30.302944  30.256560  30.238306  30.267774  30.221663  ...
30.199613  30.280641  30.383898  30.394782  30.528904  ...
30.527285  30.586069  30.690292  30.694570  30.859843  ...
30.733746  30.966067  31.149319  31.117459  31.009252  ...
31.064338  31.062638  31.433457  31.506281  31.164206  ...
30.805054  30.920583  31.100476  30.520111  30.429332  ...
30.421833  30.417163  30.576498  30.627891  30.622051  ...
30.609146  30.733509  30.870972  30.910974  31.031248  ...
30.948957  30.834278  30.927739  30.773182  30.597881  ...
30.491448  30.660776  30.666450  30.608706  30.763171  ...
30.866095  31.243482  31.326335  31.384940  31.618984  ...
32.079621  32.370995  32.616484  32.996622  32.937063  ...
32.742680  32.476664  32.268570  32.098960  31.851287  ...
31.612073  31.117878  31.271235  31.813105  32.116416  ...
32.593104  33.065537  33.116941  33.019918  32.972249  ...
32.942617  32.929183  33.092341  33.140648  32.805765  ...
32.198760  31.646946  31.210135  31.066376  30.893234  ...
30.667021  30.304549  29.944706  29.540426  29.312074  ...
29.224571  29.111194  29.079604  29.150387  29.257410  ...
29.511727  29.517175  29.518737  29.336016  29.166960  ...
29.027164  29.027659  28.882280  28.892464  28.962485  ...
28.945121  29.057959  29.162790  29.248969  29.049107  ...
28.925963  28.979959  29.008354  29.081942  29.007505  ...
28.955740  28.928923  28.874777  28.778047  28.833765  ...
28.860675  28.926216  28.886556  28.908106  28.943226  ...
28.839649  28.762822  28.703460  28.729405  28.738848  ...
28.781820  28.773735  28.713432  28.705210  28.763133  ...
28.808668  28.803705  28.810836  28.756122  28.774079  ...
28.708982  28.729787  28.820175  28.816373  28.803351  ...
28.770638  28.759260  28.733045  28.734248  28.747874  ...
28.766514  28.783112  28.846092  28.840196  28.843589  ...
28.832393  28.796478  28.841373  28.843187  28.821850  ...
28.902208  28.936405  28.903897  28.959340  28.906014  ...
28.841673  28.763347  28.743848  28.757525  28.686768  ...
];
 %Average:   30.483463, 35.644644, 36.103489


 %148101, 102.68, 30.4334dB
l3_l3 = [ 29.148375  30.268898  30.480016  30.632095  30.652187  ...
30.588881  30.622909  30.540200  30.696190  30.686194  ...
30.845927  30.711713  30.723268  30.638547  30.625574  ...
30.620820  30.816555  30.798221  30.776968  30.622395  ...
30.549171  30.437582  30.285339  30.380962  30.383990  ...
30.374319  30.395714  30.506196  30.590994  30.520429  ...
30.497310  30.490486  30.516652  30.557511  30.584685  ...
30.592797  30.508580  30.599989  30.604975  30.780068  ...
30.829478  30.886600  30.726943  30.669861  30.688658  ...
30.594374  30.622121  30.745445  30.775317  30.842528  ...
30.763922  30.725463  30.639927  30.542391  30.622811  ...
30.756183  30.784498  30.773969  30.835255  30.887786  ...
30.914141  30.826773  30.702410  30.468141  30.415832  ...
30.380444  30.417883  30.448520  30.410273  30.387544  ...
30.498040  30.421906  30.515806  30.614616  30.742376  ...
30.664514  30.660168  30.742996  30.719917  30.672657  ...
30.600546  30.625428  30.604218  30.625349  30.504955  ...
30.575721  30.689616  30.764849  30.843994  30.889587  ...
30.954853  30.903991  30.900679  31.016180  30.982276  ...
31.037394  31.023939  31.062066  31.014512  31.025741  ...
31.169967  31.131436  31.149587  31.070855  31.053063  ...
31.049209  30.973546  31.037183  30.966340  30.845697  ...
30.662767  30.636154  30.704805  30.576925  30.507419  ...
30.492254  30.459289  30.438497  30.473122  30.511994  ...
30.517139  30.595148  30.627608  30.748725  30.666490  ...
30.671710  30.586564  30.618011  30.759095  30.792224  ...
30.794046  30.863802  30.763975  30.638367  30.815789  ...
30.759839  30.656123  30.726127  30.720984  30.696856  ...
30.819947  30.878311  30.810968  30.808675  30.819282  ...
30.803294  30.755660  30.704368  30.562946  30.547001  ...
30.621443  30.519060  30.487068  30.411130  30.397389  ...
30.384355  30.401361  30.410174  30.635846  30.767923  ...
30.843690  30.747166  30.689217  30.764154  30.776395  ...
30.701895  30.803567  30.773283  30.607099  30.621321  ...
30.630346  30.603797  30.668945  30.723063  30.731310  ...
30.741267  30.841834  30.738517  30.852602  30.727688  ...
30.680815  30.467331  30.377201  30.332027  30.232328  ...
30.189446  30.291436  30.205359  30.246008  30.562086  ...
30.708498  30.677484  30.611171  30.765581  30.739298  ...
30.681327  30.692529  30.667316  30.826467  30.800689  ...
30.727167  30.776628  30.811143  30.886328  30.840359  ...
30.924510  30.798978  30.898102  30.985962  30.854995  ...
30.860370  30.805546  30.850755  30.822087  30.915969  ...
30.921602  30.853914  30.890978  31.016813  31.023322  ...
30.998769  30.879321  30.830307  30.819467  30.740004  ...
30.563306  30.494973  30.427925  30.346961  30.319781  ...
30.228982  30.100072  30.230229  30.213503  30.193205  ...
30.064096  30.208208  30.244946  30.352054  30.369874  ...
30.439130  30.482342  30.545264  30.590737  30.782998  ...
30.825011  30.955720  31.081900  31.091197  31.027617  ...
31.046227  31.212469  31.465881  31.472782  31.155952  ...
30.819708  30.895245  31.001539  30.398530  30.342191  ...
30.327083  30.391897  30.538350  30.562535  30.570297  ...
30.576465  30.646213  30.775106  30.810520  30.864957  ...
30.906660  30.842739  30.821644  30.661190  30.505290  ...
30.406628  30.539209  30.691166  30.646289  30.778475  ...
30.966798  31.167601  31.284498  31.308709  31.575883  ...
31.922749  32.171501  32.432141  32.931496  33.014998  ...
32.728629  32.301766  32.119583  31.942942  31.819363  ...
31.424316  31.249181  31.289109  31.665243  32.078587  ...
32.539936  32.891624  33.047909  32.951702  32.943915  ...
32.952368  32.921229  33.122340  33.120680  32.805056  ...
32.219002  31.622632  31.149038  31.006773  30.850396  ...
30.581144  30.246265  29.906632  29.521384  29.310885  ...
29.188335  29.062966  29.172585  29.177187  29.243311  ...
29.490503  29.481413  29.439058  29.256890  29.100137  ...
28.970150  28.968550  28.899386  28.889049  28.875255  ...
28.966478  29.060573  29.121921  29.217373  29.021053  ...
28.951780  28.945807  29.021198  29.066149  28.963365  ...
28.906703  28.811205  28.891270  28.872516  28.794975  ...
28.819687  28.903491  28.806705  28.847880  28.877102  ...
28.828918  28.778455  28.692236  28.753453  28.800389  ...
28.785134  28.773674  28.753770  28.750118  28.788057  ...
28.857445  28.782236  28.763514  28.762864  28.692747  ...
28.689522  28.684386  28.772660  28.787651  28.739771  ...
28.758313  28.754694  28.696948  28.711728  28.720893  ...
28.718566  28.764983  28.814062  28.789940  28.865316  ...
28.785554  28.779899  28.748253  28.772005  28.776144  ...
28.847480  28.914663  28.914275  28.928561  28.905551  ...
28.833265  28.806467  28.725532  28.812233  28.753267  ...
];
 %Average:   30.433412, 35.636437, 36.003638

err = mean(f_f - c4_c4);
s=sprintf(' Average Difference: %fdB.', err);

figure;
if (colorplot == 1) 
  plot(f_f,'r');
  hold on;
  plot(c4_c4, 'b');
  hold on;
  plot(c1_c1, 'k');
  hold on;
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
%  hold on;
%  plot(f_c4,'-.');
end
  legend('Default H.263+ encoder and decoder', 'binDCT-C4-based H.263+');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);

figure;
plot(f_f - c1_c1, 'r');
xlabel('Frame');
ylabel('PSNR');

t2 = ' Difference ';
t=strcat(t1, t2,s);
title(t);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% forman: A4 q4 -f 10
% Force I frame every 10 frames.
% Improve the compatibility of the C4--> F or F --> C4.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Foreman(Q step = 8; An I frame per 10 frames): ';

c4_c4_I10 = [ 38.973436  37.676299  37.578859  37.379636  37.349127  ...
37.270252  37.244438  37.312256  37.276215  37.274611  ...
38.840446  37.398487  37.327255  37.143932  37.147183  ...
37.097651  37.161525  37.303607  37.313817  37.201379  ...
38.842929  37.243222  37.193487  37.193680  37.098245  ...
37.102571  37.105560  37.214833  37.101597  36.977998  ...
38.811247  37.282638  37.161662  37.051123  37.112698  ...
37.105912  37.016925  36.993308  36.985008  37.020016  ...
38.801337  37.454277  37.213876  36.992319  37.017668  ...
37.128110  37.182095  37.262850  37.254159  37.268874  ...
38.816200  37.257185  37.257508  37.136130  37.171269  ...
37.149520  37.055749  37.106819  37.254271  37.289085  ...
38.844625  37.495457  37.354011  37.100745  37.070463  ...
37.070947  37.071927  36.965336  36.883319  36.946104  ...
38.661727  37.075971  36.997781  36.932481  36.998415  ...
37.010433  37.000752  36.932312  37.101935  37.113091  ...
38.703991  37.370421  37.340991  37.192520  37.059068  ...
37.090471  37.184492  37.227912  37.265279  37.192410  ...
38.920046  37.707929  37.383602  37.345665  37.310865  ...
37.250240  37.344092  37.317354  37.275540  37.346709  ...
38.972978  37.777034  37.600053  37.484103  37.540397  ...
37.468730  37.417232  37.572284  37.273809  37.267104  ...
39.066850  37.470452  37.270490  37.269647  37.250212  ...
37.058024  37.043818  36.966423  36.896453  37.055629  ...
38.734170  37.226492  37.356663  37.282878  37.161937  ...
36.972286  37.003289  36.979313  37.255168  37.181751  ...
38.680318  37.528611  37.219902  37.031362  37.179162  ...
37.134658  37.128831  37.180498  37.156867  37.059885  ...
38.920766  37.395347  37.177057  37.184024  37.179685  ...
37.197134  37.149643  37.227272  37.145981  37.044646  ...
38.915856  37.417886  37.161991  37.115030  37.276821  ...
37.033478  36.931063  36.903772  36.958174  37.033651  ...
38.679404  37.186643  37.105533  37.127430  37.125608  ...
37.066398  37.134304  37.146882  37.184851  37.006833  ...
38.912572  37.414630  37.471939  37.451843  37.451125  ...
37.366611  37.490072  37.374522  37.416985  37.358843  ...
38.973894  37.445311  37.137561  37.061171  37.011029  ...
36.965218  36.967472  36.840865  36.954801  37.057435  ...
38.850304  37.404558  37.305038  37.428529  37.440763  ...
37.351433  37.319031  37.281116  37.430615  37.394118  ...
39.113162  37.805893  37.604422  37.545081  37.423328  ...
37.397474  37.425848  37.409460  37.597460  37.511118  ...
39.098319  37.654623  37.529327  37.521144  37.463745  ...
37.450832  37.397257  37.406414  37.544317  37.522991  ...
39.136406  38.087393  37.688369  37.444565  37.403514  ...
37.354025  37.251066  37.135585  37.212267  37.151598  ...
38.807300  37.700768  37.257101  37.111858  36.957468  ...
36.980824  36.894287  37.062122  36.995340  37.063194  ...
38.848282  37.176864  37.132806  37.175544  37.446380  ...
37.502969  37.512367  37.785667  37.588739  37.623332  ...
39.310293  37.766621  37.877978  37.934246  37.881779  ...
37.622173  37.701435  37.739806  37.327653  37.185623  ...
39.000777  37.482140  37.413700  37.310794  37.413352  ...
37.367502  37.373802  37.551375  37.519715  37.604119  ...
39.397430  37.722457  37.631588  37.703842  37.628366  ...
37.553985  37.747973  37.759442  37.683033  37.799887  ...
39.546326  38.187168  38.274032  38.179017  38.468553  ...
38.801157  38.953095  39.194336  39.472652  39.322541  ...
40.944087  39.199045  39.058716  38.894168  38.829504  ...
38.571447  38.333376  38.333448  38.544146  38.654085  ...
40.353034  39.459741  39.420798  39.244336  39.117611  ...
39.026669  38.943869  38.915322  38.801257  38.607365  ...
39.404179  38.243957  37.681271  37.701823  37.611775  ...
37.507005  37.391067  36.859482  36.541537  36.354519  ...
38.051322  36.285359  36.186094  36.293198  36.307340  ...
36.607001  36.530048  36.353062  36.203155  36.189545  ...
37.965525  36.262608  36.020573  36.004096  35.994362  ...
36.046719  36.031602  36.151877  36.255614  36.035366  ...
38.046143  36.211166  36.201397  36.258943  36.117636  ...
36.074742  36.043327  36.045351  36.052981  35.975648  ...
37.929483  36.200760  35.890768  35.970143  36.021395  ...
35.814678  35.868756  35.871373  35.899094  35.922816  ...
37.999857  36.080873  35.980157  35.900078  35.865297  ...
35.990728  35.917758  35.874950  35.860763  35.797180  ...
37.887397  36.649277  36.268608  36.118952  35.932897  ...
35.962699  35.910959  35.830409  35.769812  35.796910  ...
37.952480  36.690037  36.145895  36.034710  35.963687  ...
35.948524  35.864615  35.873818  35.877866  35.991817  ...
37.904052  36.278944  35.994373  36.201463  36.053522  ...
35.884705  35.746078  35.769544  35.847483  35.797921  ...
];
 %Average:   37.323322, 40.576178, 41.923450


c4_f_I10 = [ 38.824113  37.547927  37.372507  37.139797  37.076360  ...
36.991001  36.946600  36.968455  36.948348  36.898285  ...
38.675925  37.206293  37.111356  36.888426  36.887139  ...
36.786445  36.851970  36.972220  36.969806  36.826730  ...
38.652230  37.063475  36.951809  36.951195  36.818248  ...
36.792371  36.805385  36.888606  36.736276  36.648095  ...
38.624322  37.090187  36.934653  36.796692  36.859891  ...
36.821935  36.671678  36.674826  36.644345  36.673920  ...
38.597565  37.265124  36.969819  36.710660  36.691439  ...
36.759982  36.822125  36.960857  36.914261  36.895190  ...
38.616343  37.013943  37.013188  36.846586  36.887461  ...
36.853502  36.725055  36.760207  36.959653  36.967079  ...
38.682302  37.367760  37.186781  36.850464  36.781896  ...
36.774453  36.731047  36.594796  36.468039  36.530522  ...
38.468497  36.885724  36.781695  36.716868  36.782486  ...
36.763020  36.743703  36.624761  36.764871  36.743205  ...
38.502394  37.176878  37.131485  36.938974  36.780539  ...
36.794462  36.870160  36.927152  36.930413  36.850030  ...
38.730273  37.518375  37.148549  37.101273  37.036140  ...
36.985034  37.066787  36.974031  36.915155  36.977630  ...
38.807320  37.592855  37.384309  37.252129  37.278158  ...
37.185747  37.107780  37.252563  36.915181  36.898982  ...
38.883904  37.295272  37.041391  36.965178  36.959705  ...
36.783994  36.702858  36.591741  36.493987  36.636503  ...
38.576248  37.048784  37.139511  37.038139  36.870070  ...
36.658228  36.663041  36.666452  36.906550  36.833283  ...
38.469572  37.355745  37.008169  36.784974  36.920300  ...
36.834936  36.771570  36.816817  36.740629  36.660903  ...
38.722568  37.198088  36.924854  36.925075  36.913653  ...
36.921649  36.836093  36.896389  36.801661  36.659522  ...
38.701079  37.231045  36.930985  36.829332  37.016965  ...
36.752390  36.605179  36.566913  36.634074  36.692633  ...
38.481797  36.978669  36.869544  36.863806  36.851944  ...
36.752565  36.819514  36.803276  36.804476  36.628118  ...
38.752204  37.238085  37.259260  37.209466  37.201739  ...
37.038965  37.136143  37.016262  37.021900  36.960399  ...
38.824776  37.255028  36.912811  36.846408  36.752053  ...
36.611866  36.580119  36.454761  36.514643  36.687025  ...
38.709489  37.247401  37.071376  37.147046  37.150176  ...
37.031335  36.994205  36.940212  37.068517  37.025991  ...
38.945687  37.684455  37.418803  37.317396  37.179892  ...
37.124113  37.127580  37.114243  37.327468  37.215000  ...
38.935363  37.455391  37.292785  37.253487  37.137275  ...
37.115125  37.032812  37.013572  37.216582  37.208413  ...
38.943393  37.920723  37.497501  37.218874  37.142895  ...
37.035741  36.913083  36.723369  36.721337  36.630361  ...
38.594037  37.452283  36.988353  36.785301  36.595759  ...
36.610103  36.519476  36.736078  36.642058  36.696732  ...
38.666997  36.976763  36.916463  36.947304  37.258783  ...
37.279214  37.253109  37.487382  37.268930  37.264464  ...
39.134765  37.567931  37.693619  37.694874  37.599901  ...
37.325603  37.379377  37.401355  36.945569  36.808379  ...
38.812489  37.292291  37.169209  37.071094  37.126723  ...
37.052967  37.008553  37.191388  37.177717  37.235769  ...
39.186986  37.506500  37.403717  37.389507  37.258152  ...
37.181117  37.347095  37.339277  37.240122  37.363364  ...
39.277547  37.926032  37.973996  37.898688  38.122415  ...
38.464350  38.564492  38.788000  39.139713  39.066957  ...
40.818229  38.968653  38.806900  38.632951  38.494282  ...
38.210371  37.930235  37.956017  38.150985  38.294411  ...
40.241986  39.316976  39.272618  39.097420  38.911690  ...
38.821943  38.765094  38.691866  38.552692  38.358404  ...
39.328972  38.088258  37.489229  37.445194  37.319031  ...
37.201960  37.055027  36.529372  36.190213  36.000716  ...
37.911035  36.063081  35.944628  36.023979  36.017938  ...
36.349581  36.221885  35.964052  35.805800  35.789108  ...
37.810061  36.029573  35.743100  35.810819  35.702882  ...
35.650246  35.651805  35.755964  35.864941  35.535449  ...
37.908853  35.980345  35.920766  35.975168  35.798272  ...
35.711119  35.669493  35.670339  35.629755  35.514318  ...
37.724766  36.072992  35.673043  35.702460  35.755617  ...
35.450416  35.503542  35.476768  35.494316  35.478824  ...
37.793001  35.909294  35.711208  35.556143  35.502120  ...
35.600939  35.510089  35.456503  35.404101  35.293071  ...
37.694812  36.528116  36.030619  35.857503  35.634651  ...
35.660480  35.554968  35.408136  35.305141  35.264414  ...
37.767126  36.585686  36.029246  35.807807  35.707018  ...
35.625373  35.499651  35.448586  35.410150  35.472259  ...
37.723191  36.167332  35.800726  35.930573  35.759278  ...
35.537476  35.328933  35.274300  35.285455  35.153478  ...
];
 %Average:   37.033758, 40.538510, 41.842789


f_f_I10 = [ 38.873868  37.429856  37.331344  37.236188  37.125676  ...
37.085511  37.096543  37.095072  37.033411  37.121572  ...
38.782381  37.306526  37.146513  36.997477  36.982403  ...
36.922635  37.003355  37.083706  37.138202  36.946665  ...
38.753014  37.076643  37.010075  37.168536  36.977341  ...
36.940759  36.900505  37.091334  36.878731  36.836335  ...
38.702701  37.146664  36.997702  36.909486  36.986061  ...
36.951795  36.832343  36.873815  36.783667  36.793077  ...
38.758892  37.277693  37.049786  36.866482  36.880928  ...
36.951208  36.934184  37.091091  37.090120  36.999524  ...
38.753825  37.056298  37.011254  36.905736  37.006674  ...
37.015493  36.943235  36.989775  37.151831  37.149055  ...
38.727480  37.401355  37.226061  36.873481  36.913096  ...
36.889804  36.967590  36.746693  36.726691  36.756035  ...
38.603293  36.932208  36.862219  36.824078  36.807014  ...
36.820706  36.814804  36.796629  36.826895  36.872622  ...
38.644315  37.201836  37.243558  37.055588  36.869352  ...
36.977735  36.991278  37.012432  37.019564  37.051270  ...
38.855100  37.596505  37.194730  37.175984  37.129403  ...
37.129389  37.168234  37.054505  37.048918  37.134590  ...
38.896681  37.588013  37.397503  37.360923  37.377676  ...
37.173509  37.157442  37.374522  37.111126  37.127879  ...
38.993371  37.367775  37.049011  36.999326  36.964078  ...
36.846905  36.813488  36.788659  36.697927  36.836017  ...
38.655264  37.014420  37.086238  37.102814  36.979247  ...
36.815437  36.748362  36.798092  37.115776  37.036580  ...
38.615806  37.403586  37.063006  36.841209  37.011691  ...
37.000026  36.936761  36.928633  36.952749  36.829167  ...
38.838328  37.270701  36.980995  37.031961  37.018065  ...
37.026589  37.023958  37.087976  36.936227  36.876227  ...
38.805939  37.204770  37.005669  36.930219  37.098380  ...
36.840916  36.736339  36.739273  36.800071  36.967878  ...
38.536369  36.998824  36.897072  36.956226  36.941658  ...
36.833525  36.887139  36.999207  36.940134  36.881082  ...
38.875170  37.271742  37.313235  37.270786  37.334139  ...
37.112088  37.342691  37.145052  37.158058  37.092278  ...
38.871083  37.181117  36.956566  36.918278  36.808733  ...
36.723790  36.725873  36.689176  36.694491  36.968193  ...
38.771385  37.204895  37.113308  37.184630  37.232118  ...
37.169909  37.134004  37.150313  37.263061  37.198751  ...
39.019787  37.746012  37.370262  37.355459  37.166202  ...
37.260690  37.256415  37.235421  37.488150  37.333839  ...
39.041606  37.422280  37.342734  37.299572  37.268509  ...
37.208302  37.220986  37.239927  37.461571  37.346995  ...
39.082545  37.977782  37.662662  37.362029  37.270828  ...
37.251472  37.112034  36.996039  36.974215  36.955311  ...
38.771147  37.551885  37.097732  36.881262  36.755398  ...
36.825778  36.726989  36.866239  36.845974  36.859392  ...
38.813171  37.022537  36.961197  37.027054  37.334752  ...
37.321604  37.345036  37.565855  37.455626  37.423925  ...
39.230253  37.583690  37.767882  37.768765  37.672257  ...
37.352278  37.471482  37.602753  37.126764  36.944930  ...
38.934332  37.343006  37.266964  37.216652  37.215833  ...
37.160155  37.202984  37.316189  37.355602  37.354670  ...
39.304272  37.495976  37.437898  37.371471  37.326827  ...
37.344106  37.388279  37.536076  37.530551  37.569482  ...
39.467333  37.976873  37.960612  37.978709  38.180628  ...
38.554373  38.758991  38.903678  39.185522  39.088246  ...
40.837712  38.894719  38.766760  38.662541  38.640363  ...
38.259427  38.101497  38.079664  38.214649  38.447342  ...
40.263269  39.266715  39.318147  38.980370  38.838106  ...
38.841799  38.653563  38.691885  38.558305  38.333412  ...
39.330033  38.062508  37.464892  37.472719  37.445677  ...
37.311390  37.110503  36.567439  36.282268  36.049042  ...
37.938686  36.058358  35.979541  36.021954  35.995400  ...
36.429243  36.362631  36.111712  35.957429  35.995054  ...
37.867934  36.053140  35.811522  35.831933  35.747592  ...
35.787439  35.787429  35.895702  36.056412  35.760092  ...
37.976525  35.984754  35.961680  36.022913  35.939959  ...
35.837548  35.790457  35.751266  35.801197  35.798252  ...
37.822669  36.027535  35.671195  35.788128  35.899483  ...
35.628743  35.659869  35.596816  35.673481  35.731378  ...
37.858315  35.902837  35.749958  35.699738  35.675895  ...
35.760757  35.699532  35.706773  35.670446  35.576051  ...
37.819828  36.602828  36.012264  35.872168  35.744673  ...
35.769593  35.666470  35.627048  35.579812  35.593557  ...
37.860263  36.676518  36.069579  35.844830  35.784453  ...
35.762019  35.599886  35.554097  35.677512  35.699620  ...
37.806879  36.168052  35.824954  36.007206  35.902498  ...
35.676236  35.535684  35.491506  35.587418  35.567268  ...
];
 %Average:   37.141683, 40.492854, 41.844999

f_c4_I10 = [ 38.621904  37.219138  37.146090  37.067390  36.966567  ...
36.908205  36.836844  36.855980  36.775908  36.870890  ...
38.497693  37.132738  37.019843  36.899266  36.839618  ...
36.789917  36.809175  36.864485  36.829320  36.677278  ...
38.482727  36.917318  36.896079  36.966751  36.811274  ...
36.753426  36.707313  36.820921  36.688906  36.687467  ...
38.442736  36.995617  36.851650  36.749410  36.787828  ...
36.746207  36.647352  36.684838  36.589746  36.564858  ...
38.498121  37.112278  36.923452  36.742309  36.755635  ...
36.811957  36.753613  36.830043  36.837849  36.716509  ...
38.480200  36.956932  36.905167  36.801560  36.879476  ...
36.902997  36.794097  36.831492  36.899317  36.879283  ...
38.497972  37.211684  37.054278  36.733195  36.791843  ...
36.753376  36.834160  36.595313  36.515363  36.486576  ...
38.353982  36.778054  36.712180  36.631987  36.589373  ...
36.582446  36.578033  36.584521  36.616156  36.613980  ...
38.375974  37.018371  37.054465  36.891517  36.702352  ...
36.799289  36.798583  36.834669  36.783529  36.796894  ...
38.570707  37.387354  37.059791  36.990935  36.949589  ...
36.931635  36.906175  36.775507  36.819514  36.843285  ...
38.652268  37.418279  37.261476  37.190974  37.187649  ...
36.985969  36.912358  37.108511  36.869365  36.839961  ...
38.733992  37.199014  36.897808  36.870544  36.781142  ...
36.656483  36.615430  36.561979  36.453305  36.559031  ...
38.381816  36.882972  36.941775  36.918057  36.795672  ...
36.619276  36.549257  36.566865  36.836424  36.731903  ...
38.340366  37.181544  36.879746  36.675574  36.786256  ...
36.778556  36.682775  36.649496  36.655568  36.568264  ...
38.573002  37.095274  36.890731  36.883820  36.827593  ...
36.822709  36.797751  36.853936  36.703820  36.663151  ...
38.527442  37.075191  36.866200  36.782285  36.878603  ...
36.621370  36.508576  36.487444  36.533854  36.641073  ...
38.328083  36.837442  36.775118  36.800563  36.769178  ...
36.681744  36.668850  36.809883  36.727212  36.660329  ...
38.606753  37.116671  37.136034  37.099948  37.112508  ...
36.907701  37.082319  36.923465  36.962336  36.874418  ...
38.616573  37.025472  36.859508  36.787514  36.605987  ...
36.551127  36.537154  36.455985  36.441339  36.647620  ...
38.541094  37.008831  36.945582  37.016806  37.074989  ...
36.998666  36.938974  36.969190  36.999458  36.963069  ...
38.769439  37.533492  37.195379  37.222111  37.061010  ...
37.139211  37.117390  37.055147  37.200674  37.032134  ...
38.785130  37.250002  37.167781  37.169456  37.152925  ...
37.056860  37.026163  37.034689  37.127988  36.989262  ...
38.818488  37.755149  37.460528  37.183418  37.117526  ...
37.116237  36.934237  36.798306  36.770455  36.704597  ...
38.522995  37.409068  36.981035  36.757496  36.644552  ...
36.668006  36.531174  36.595686  36.579124  36.609620  ...
38.560707  36.866636  36.800589  36.850655  37.045860  ...
37.049613  37.131063  37.327525  37.209244  37.141271  ...
38.988170  37.443482  37.615092  37.614118  37.509291  ...
37.158086  37.282638  37.453631  36.968455  36.766811  ...
38.681427  37.210173  37.138175  37.076105  37.104505  ...
37.053448  37.030657  37.142376  37.140193  37.110475  ...
39.039979  37.324848  37.252479  37.165393  37.119331  ...
37.121042  37.125418  37.219304  37.259751  37.334524  ...
39.203035  37.854068  37.850725  37.837443  38.098690  ...
38.384086  38.624207  38.771147  38.971106  38.812510  ...
40.732258  38.848950  38.689760  38.629682  38.631354  ...
38.225756  38.012562  37.983278  38.062525  38.302675  ...
40.133760  39.194314  39.247859  38.911936  38.735213  ...
38.768586  38.540868  38.591140  38.488249  38.264231  ...
39.233941  38.032770  37.430454  37.441318  37.407763  ...
37.301794  37.074049  36.533677  36.233328  35.981045  ...
37.762274  36.074582  36.004180  36.020130  35.974135  ...
36.302726  36.271712  36.121983  35.933331  35.898745  ...
37.680360  36.007427  35.828896  35.746869  35.726213  ...
35.802711  35.695373  35.770320  35.883408  35.749414  ...
37.764479  35.954666  35.924620  35.951843  35.827837  ...
35.764433  35.681858  35.583842  35.677443  35.679840  ...
37.613798  35.829259  35.560303  35.652057  35.692108  ...
35.472640  35.524612  35.485034  35.479382  35.566954  ...
37.673260  35.742536  35.684091  35.620660  35.591895  ...
35.641379  35.516710  35.473031  35.416594  35.299512  ...
37.599416  36.397120  35.928024  35.752950  35.631634  ...
35.593528  35.505752  35.456651  35.406150  35.353254  ...
37.677318  36.479001  35.872147  35.734969  35.677745  ...
35.662508  35.485649  35.447837  35.522336  35.576327  ...
37.629816  35.952144  35.644317  35.911257  35.784812  ...
35.536042  35.380713  35.335005  35.408063  35.372542  ...
];
 %Average:   36.966199, 40.466248, 41.823618


err = mean(f_f_I10 - f_c4_I10);
s=sprintf(' Average Difference: %fdB.', err);

figure;
if (colorplot == 1) 
  plot(f_f_I10, 'r');
  hold on;
  plot(f_c4_I10, 'b');
else
  plot(f_f_I10,':');
  hold on;
  plot(f_c4_I10, '-');
end
  legend('Encoder: Float DCT; Decoder: Float DCT.', 'Encoder: Float DCT; Decoder: binDCT-C4.');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% forman: A4 q4 -f 30
% Force I frame every 30 frames.
% Improve the compatibility of the C4--> F or F --> C4.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'Foreman (A4 q4 -f 30) ';

c4_c4_I30 = [ 38.973436  37.676299  37.578859  37.379636  37.349127  ...
37.270252  37.244438  37.312256  37.276215  37.274611  ...
37.305718  37.208607  37.165846  36.990197  37.083894  ...
37.070584  37.087195  37.182853  37.239257  37.193860  ...
37.141475  37.050922  37.106643  37.171365  37.071175  ...
37.046581  37.071309  37.143441  37.023201  37.011519  ...
38.811247  37.282638  37.161662  37.051123  37.112698  ...
37.105912  37.016925  36.993308  36.985008  37.020016  ...
37.056592  37.059148  37.025526  36.972955  36.940551  ...
37.125866  37.193280  37.212142  37.187704  37.140302  ...
37.147729  37.143577  37.111749  36.966253  37.093047  ...
37.066881  37.097570  37.087370  37.243865  37.289367  ...
38.844625  37.495457  37.354011  37.100745  37.070463  ...
37.070947  37.071927  36.965336  36.883319  36.946104  ...
37.013055  36.997213  36.958580  36.893243  37.020719  ...
37.001268  36.924426  36.935147  37.033651  37.081404  ...
36.957860  37.000779  37.015414  37.037259  37.017243  ...
37.038485  37.144233  37.109216  37.202804  37.181627  ...
38.920046  37.707929  37.383602  37.345665  37.310865  ...
37.250240  37.344092  37.317354  37.275540  37.346709  ...
37.460117  37.449967  37.519804  37.411130  37.460616  ...
37.370147  37.254397  37.452942  37.252143  37.293605  ...
37.256695  37.234389  37.214917  37.146732  37.127620  ...
37.020002  36.965938  36.984982  36.898453  37.000277  ...
38.734170  37.226492  37.356663  37.282878  37.161937  ...
36.972286  37.003289  36.979313  37.255168  37.181751  ...
37.113267  37.141011  37.070141  36.976172  37.168261  ...
37.144820  37.114650  37.107983  37.128233  37.003726  ...
37.096570  37.148946  37.112495  37.097597  37.080920  ...
37.090417  37.087774  37.108254  37.155881  37.057649  ...
38.915856  37.417886  37.161991  37.115030  37.276821  ...
37.033478  36.931063  36.903772  36.958174  37.033651  ...
37.227091  37.147142  37.095450  37.033358  37.072665  ...
37.040898  37.214500  37.175145  37.160593  37.119399  ...
37.142472  37.247513  37.335308  37.332242  37.357351  ...
37.389420  37.351132  37.356519  37.295117  37.278609  ...
38.973894  37.445311  37.137561  37.061171  37.011029  ...
36.965218  36.967472  36.840865  36.954801  37.057435  ...
37.103044  37.297096  37.269197  37.394118  37.487530  ...
37.345365  37.352650  37.400138  37.430498  37.370205  ...
37.388163  37.404818  37.438716  37.439710  37.308936  ...
37.353065  37.394985  37.405775  37.578346  37.491477  ...
39.098319  37.654623  37.529327  37.521144  37.463745  ...
37.450832  37.397257  37.406414  37.544317  37.522991  ...
37.412901  37.344593  37.377546  37.245360  37.314854  ...
37.286079  37.286276  37.213293  37.199830  37.115179  ...
37.070571  37.083544  36.981561  36.955023  36.898711  ...
36.952553  36.898517  37.050441  37.052339  37.036713  ...
38.848282  37.176864  37.132806  37.175544  37.446380  ...
37.502969  37.512367  37.785667  37.588739  37.623332  ...
37.586078  37.661154  37.817883  37.889731  37.843534  ...
37.539499  37.681395  37.749526  37.366309  37.137779  ...
37.128477  37.197908  37.261840  37.184437  37.278172  ...
37.185457  37.307646  37.544976  37.549096  37.609982  ...
39.397430  37.722457  37.631588  37.703842  37.628366  ...
37.553985  37.747973  37.759442  37.683033  37.799887  ...
37.899728  38.053442  38.171901  38.242744  38.518177  ...
38.730489  39.017642  39.110069  39.419599  39.393280  ...
39.131981  38.896865  38.894127  38.859942  38.743967  ...
38.511850  38.270456  38.270226  38.447102  38.607690  ...
40.353034  39.459741  39.420798  39.244336  39.117611  ...
39.026669  38.943869  38.915322  38.801257  38.607365  ...
38.188436  37.877638  37.614955  37.618593  37.556972  ...
37.482036  37.307844  36.831365  36.503896  36.354655  ...
36.234125  36.142608  36.162341  36.268396  36.194238  ...
36.611165  36.503990  36.354530  36.182503  36.187759  ...
37.965525  36.262608  36.020573  36.004096  35.994362  ...
36.046719  36.031602  36.151877  36.255614  36.035366  ...
35.972571  36.033325  36.080563  36.151529  36.148575  ...
36.043433  36.054414  35.985298  36.051536  36.035821  ...
36.023314  36.090664  35.895006  35.909983  35.950225  ...
35.793897  35.941894  35.854559  35.888416  35.920498  ...
37.999857  36.080873  35.980157  35.900078  35.865297  ...
35.990728  35.917758  35.874950  35.860763  35.797180  ...
35.700080  35.705145  35.911555  35.876826  35.794418  ...
35.891310  35.778288  35.762714  35.739334  35.758187  ...
35.887567  35.866772  35.845792  35.826667  35.931968  ...
35.930439  35.819918  35.809423  35.891321  35.970716  ...
37.904052  36.278944  35.994373  36.201463  36.053522  ...
35.884705  35.746078  35.769544  35.847483  35.797921  ...
];
 %Average:   37.161743, 40.371538, 41.660227

c4_f_I30 = [ 38.824113  37.547927  37.372507  37.139797  37.076360  ...
36.991001  36.946600  36.968455  36.948348  36.898285  ...
36.913743  36.788872  36.692276  36.524623  36.639602  ...
36.569831  36.601322  36.700367  36.724893  36.621987  ...
36.546805  36.411675  36.472505  36.489698  36.369731  ...
36.305607  36.302805  36.452257  36.266220  36.295948  ...
38.624322  37.090187  36.934653  36.796692  36.859891  ...
36.821935  36.671678  36.674826  36.644345  36.673920  ...
36.681179  36.642666  36.574415  36.528424  36.477631  ...
36.617849  36.714270  36.757109  36.699369  36.658546  ...
36.659156  36.618405  36.549483  36.398948  36.524942  ...
36.470809  36.524658  36.536014  36.638933  36.665706  ...
38.682302  37.367760  37.186781  36.850464  36.781896  ...
36.774453  36.731047  36.594796  36.468039  36.530522  ...
36.605794  36.598684  36.542214  36.504344  36.647109  ...
36.609451  36.521144  36.510782  36.614657  36.616905  ...
36.499021  36.561907  36.522528  36.549817  36.517821  ...
36.504073  36.610332  36.552782  36.651299  36.558768  ...
38.730273  37.518375  37.148549  37.101273  37.036140  ...
36.985034  37.066787  36.974031  36.915155  36.977630  ...
37.101908  37.099678  37.150326  37.025047  37.042458  ...
36.905749  36.762507  36.990975  36.764459  36.790521  ...
36.755847  36.679032  36.676898  36.587211  36.582014  ...
36.468740  36.399304  36.390721  36.272002  36.352959  ...
38.576248  37.048784  37.139511  37.038139  36.870070  ...
36.658228  36.663041  36.666452  36.906550  36.833283  ...
36.750282  36.748824  36.690394  36.570034  36.714839  ...
36.659022  36.673871  36.669438  36.641705  36.506076  ...
36.567021  36.674398  36.627317  36.656849  36.619143  ...
36.601985  36.643116  36.587223  36.621963  36.492071  ...
38.701079  37.231045  36.930985  36.829332  37.016965  ...
36.752390  36.605179  36.566913  36.634074  36.692633  ...
36.896582  36.809302  36.706782  36.694429  36.700799  ...
36.651690  36.791616  36.739870  36.660707  36.634147  ...
36.625427  36.738713  36.786319  36.798167  36.838676  ...
36.807482  36.765672  36.675451  36.602551  36.527488  ...
38.824776  37.255028  36.912811  36.846408  36.752053  ...
36.611866  36.580119  36.454761  36.514643  36.687025  ...
36.768865  36.907442  36.888362  36.984811  37.069470  ...
36.914430  36.886264  36.879502  36.932000  36.862270  ...
36.885930  36.912319  36.906731  36.848716  36.724472  ...
36.707585  36.738154  36.772849  36.932546  36.836157  ...
38.935363  37.455391  37.292785  37.253487  37.137275  ...
37.115125  37.032812  37.013572  37.216582  37.208413  ...
37.069779  36.984311  36.939626  36.811375  36.847326  ...
36.747228  36.728391  36.595650  36.557122  36.395936  ...
36.345444  36.298791  36.143248  36.120979  36.023873  ...
36.081183  36.091189  36.278989  36.315027  36.340403  ...
38.666997  36.976763  36.916463  36.947304  37.258783  ...
37.279214  37.253109  37.487382  37.268930  37.264464  ...
37.224586  37.305831  37.489717  37.533298  37.457386  ...
37.173633  37.283047  37.301483  36.910883  36.670356  ...
36.692940  36.718179  36.711735  36.691784  36.700133  ...
36.580119  36.697126  36.928945  36.982600  37.008011  ...
39.186986  37.506500  37.403717  37.389507  37.258152  ...
37.181117  37.347095  37.339277  37.240122  37.363364  ...
37.430162  37.589617  37.689731  37.791162  37.985332  ...
38.194222  38.410268  38.548030  39.009852  39.041733  ...
38.724237  38.468627  38.506540  38.444486  38.283641  ...
38.027780  37.777223  37.840551  37.981208  38.184010  ...
40.241986  39.316976  39.272618  39.097420  38.911690  ...
38.821943  38.765094  38.691866  38.552692  38.358404  ...
37.931004  37.581938  37.309234  37.261083  37.226242  ...
37.116495  36.937685  36.433553  36.098202  35.958603  ...
35.812899  35.703303  35.748889  35.825599  35.764264  ...
36.200430  36.052025  35.812507  35.671049  35.632588  ...
37.810061  36.029573  35.743100  35.810819  35.702882  ...
35.650246  35.651805  35.755964  35.864941  35.535449  ...
35.477428  35.506079  35.533629  35.581050  35.618344  ...
35.469566  35.481728  35.411268  35.380786  35.341356  ...
35.367887  35.434876  35.271044  35.268623  35.255610  ...
34.984173  35.131528  35.050286  35.084148  35.100262  ...
37.793001  35.909294  35.711208  35.556143  35.502120  ...
35.600939  35.510089  35.456503  35.404101  35.293071  ...
35.156294  35.118585  35.292028  35.226830  35.107261  ...
35.203423  35.060769  34.983642  34.925404  34.873979  ...
34.956693  34.877818  34.873429  34.819318  34.897430  ...
34.910692  34.797247  34.771752  34.829330  34.830003  ...
37.723191  36.167332  35.800726  35.930573  35.759278  ...
35.537476  35.328933  35.274300  35.285455  35.153478  ...
];
 %Average:   36.708762, 40.294681, 41.520128

err = mean(c4_c4_I30 - c4_f_I30);
s=sprintf('(Average Difference: %fdB.)', err);

figure;
if (colorplot == 1) 
  plot(c4_c4_I30, 'r');
  hold on;
  plot(c4_f_I30, 'b');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end
  legend('C4-C4 with -f 30','C4-F with -f 30');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% News: A4 q4
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

t1 = 'News (A4 q4) ';

c4_c4 = [ 40.128735  39.185479  39.056531  39.009264  38.913516  ...
38.789635  38.724571  38.753845  38.771465  38.766383  ...
38.736237  38.648560  38.622518  38.668665  38.627318  ...
38.635125  38.576229  38.601479  38.589102  38.589350  ...
38.530165  38.517316  38.554279  38.614734  38.535316  ...
38.521926  38.569228  38.531030  38.567371  38.564397  ...
38.516005  38.443491  38.455884  38.450827  38.390976  ...
38.411073  38.421669  38.473260  38.523070  38.498457  ...
38.534846  38.518777  38.536783  38.538646  38.422383  ...
38.402125  38.403402  38.401524  38.489049  38.494766  ...
38.477749  38.425683  38.508259  38.555375  38.479049  ...
38.451325  38.444357  38.391031  38.445057  38.461761  ...
38.446752  38.445923  38.433062  38.499800  38.496742  ...
38.520763  38.540793  38.604096  38.621482  38.546258  ...
38.520913  38.489105  38.440012  38.490445  38.514863  ...
38.473686  38.469108  38.411895  38.469627  38.353622  ...
38.326720  38.352774  38.312956  38.388066  38.367226  ...
38.391795  38.288792  38.282186  38.380001  38.350070  ...
38.617282  38.383342  38.327975  38.308652  38.350755  ...
38.367370  38.384759  38.473260  38.470998  38.450716  ...
38.437161  38.495903  38.508895  38.496760  38.451675  ...
38.429426  38.412809  38.355462  38.352395  38.329159  ...
38.340797  38.372295  38.352287  38.408697  38.332712  ...
38.432529  38.474929  38.436811  38.537047  38.565325  ...
38.641828  38.699535  38.658591  38.703151  38.646263  ...
38.615366  38.640479  38.528700  38.544806  38.435194  ...
38.390922  38.346106  38.294998  38.336052  38.209777  ...
38.237595  38.190781  38.246438  38.232259  38.186630  ...
38.183732  38.249219  38.343730  38.373545  38.339377  ...
38.261122  38.337957  38.342740  38.357664  38.387830  ...
38.338748  38.305903  38.238227  38.296778  38.214963  ...
38.229682  38.217060  38.237929  38.307492  38.330845  ...
38.350034  38.249202  38.311545  38.351133  38.292152  ...
38.328155  38.246262  38.207213  38.238702  38.183784  ...
38.187203  38.163260  38.194396  38.211209  38.184287  ...
38.167717  38.127087  38.184634  38.266105  38.185155  ...
38.156705  38.110511  38.079528  38.074265  38.124793  ...
38.149367  38.147371  38.199703  38.236436  38.206045  ...
38.220715  38.273678  38.246121  38.303977  38.204127  ...
38.175518  38.204423  38.221275  38.229769  38.269500  ...
38.277097  38.303781  38.391213  38.451195  38.371679  ...
38.356364  38.357447  38.336286  38.404333  38.385504  ...
38.413029  38.382071  38.347223  38.372585  38.367189  ...
38.396493  38.338011  38.401250  38.474669  38.345836  ...
38.346809  38.325304  38.257522  38.233400  38.239492  ...
38.241759  38.271677  38.212972  38.312563  38.239457  ...
38.227876  38.206219  38.266776  38.287069  38.218476  ...
38.246526  38.198693  38.189408  38.191736  38.206480  ...
38.379221  38.251985  38.257398  38.258810  38.223568  ...
38.239668  38.313171  38.331617  38.387866  38.356527  ...
38.361638  38.375757  38.398515  38.395946  38.379185  ...
38.424253  38.372132  38.325394  38.363771  38.276760  ...
38.324480  38.280536  38.251421  38.320719  38.280377  ...
38.309259  38.302123  38.361602  38.407966  38.403968  ...
38.389521  38.357122  38.354145  38.335046  38.227736  ...
38.198345  38.217602  38.152242  38.187342  38.162432  ...
38.180386  38.194292  38.227298  38.222150  38.166732  ...
38.166697  38.158463  38.183646  38.247846  38.245717  ...
38.244696  38.227841  38.223848  38.262341  38.307973  ...
38.299272  38.373002  38.322509  38.339287  38.317873  ...
];
 %Average:   38.382332, 41.313541, 41.707014


f_f = [ 39.973867  39.035123  38.909558  38.869742  38.822887  ...
38.663993  38.581967  38.569266  38.584002  38.604478  ...
38.587522  38.512785  38.484808  38.459708  38.392086  ...
38.368022  38.352612  38.397768  38.404205  38.395454  ...
38.372150  38.359452  38.401250  38.418628  38.322098  ...
38.342686  38.367208  38.286269  38.315566  38.359380  ...
38.333915  38.236682  38.225038  38.237209  38.149212  ...
38.172178  38.234119  38.236155  38.261935  38.262941  ...
38.317283  38.275927  38.322921  38.310991  38.254594  ...
38.207806  38.217183  38.209620  38.258192  38.269182  ...
38.286038  38.240810  38.225984  38.264673  38.241918  ...
38.125341  38.147836  38.166352  38.242656  38.246491  ...
38.238368  38.270951  38.249079  38.295426  38.304583  ...
38.381508  38.380128  38.392614  38.419251  38.373672  ...
38.271677  38.275874  38.245945  38.257222  38.273447  ...
38.225949  38.215068  38.140204  38.185033  38.189877  ...
38.082239  38.068061  38.052365  38.111875  38.108516  ...
38.144276  38.046361  38.027462  38.039610  38.057990  ...
38.265663  38.042615  38.055598  38.079528  38.060653  ...
38.123219  38.262623  38.201932  38.201009  38.272066  ...
38.227298  38.203657  38.260363  38.265680  38.220243  ...
38.200399  38.097856  38.020323  38.035367  38.025889  ...
38.096309  38.102076  38.065225  38.093318  38.112865  ...
38.158929  38.203326  38.158532  38.255669  38.334938  ...
38.360716  38.484511  38.411932  38.484492  38.440086  ...
38.448687  38.390795  38.365308  38.378042  38.250769  ...
38.124844  38.088377  38.053594  38.040382  38.023515  ...
37.988466  37.962128  37.988068  37.968644  37.954190  ...
37.964189  37.959689  38.024903  38.039912  38.065765  ...
38.077937  38.062643  38.077344  38.101497  38.168996  ...
38.078732  38.061766  38.077395  38.089786  38.054099  ...
38.027362  38.007795  38.033926  38.123082  38.169238  ...
38.194013  38.102774  38.113087  38.111790  38.124502  ...
38.062862  38.093641  38.072202  38.077530  38.090227  ...
38.039308  37.969090  37.934262  37.929155  37.985631  ...
37.893785  37.945725  37.918747  37.951904  37.899598  ...
37.870999  37.800014  37.785920  37.805813  37.794761  ...
37.788691  37.950671  38.006046  37.997862  37.983195  ...
38.066998  38.104852  38.103029  38.079139  38.031145  ...
37.946333  37.954256  37.926179  37.934098  38.000638  ...
38.024535  38.048042  38.164089  38.234786  38.233417  ...
38.196466  38.209376  38.192831  38.270668  38.261369  ...
38.253695  38.254100  38.176470  38.186179  38.116211  ...
38.151777  38.176297  38.231996  38.212745  38.152690  ...
38.133821  38.100868  38.012312  37.998078  38.040198  ...
38.079731  38.041272  38.036692  38.094372  38.086189  ...
38.116706  38.058647  38.039057  38.051322  37.980397  ...
37.986609  38.018987  38.006663  37.994656  37.989544  ...
38.074958  37.950819  37.960035  37.992315  37.921376  ...
37.938834  38.068670  38.073199  38.114299  38.053173  ...
38.136496  38.151175  38.169065  38.179398  38.161655  ...
38.177319  38.105789  38.022178  38.019404  38.005780  ...
38.014380  38.035200  37.965640  38.010794  38.021593  ...
38.068095  38.063115  38.071153  38.118022  38.049320  ...
38.037346  38.054486  38.032736  38.023983  37.941688  ...
37.940359  37.908592  37.914686  37.969139  37.865402  ...
37.866805  37.840808  37.908316  37.906460  37.801824  ...
37.830641  37.828835  37.871984  37.918421  37.936867  ...
37.913642  37.900687  37.893948  37.868240  37.907241  ...
37.988930  38.041826  38.016282  38.045521  38.069971  ...
];
 %Average:   38.146635, 41.117277, 41.677742

err = mean(c4_c4 - f_f);
s=sprintf('(Average Difference: %fdB.)', err);

figure;
if (colorplot == 1) 
  plot(c4_c4,'r');
  hold on;
  plot(f_f, 'b');
%  hold on;
%  plot(e_c7_c7, 'c');
%  hold on;
%  plot(e_l3_l3, 'm');
else
  plot(f_f,':');
  hold on;
  plot(c4_c4, '-');
end
  legend('c4-c4', 'f-f');
ylabel('PSNR (dB)');
xlabel('Frame');

t=strcat(t1,s);
title(t);
