function suzie_adv_intra()
%This file shows the performance of the advanced intra mode:
%Sequence: suzie
%Comparison:
%  1: floating DCT, 1 I frame,    w/o  -I option.
%  2: floating DCT, all I frames, w/o  -I option.
%  3: floating DCT, all I frames, with -I option.
%  4: binDCT-C1,    1 I frame,    w/o  -I option.
%  5: binDCT-C1,    all I frames  w/o -I options.
%  6: binDCT-C1,    all I frame,s with -I option.
%  7: binDCT-C4,    1 I frame,    w/o  -I option.
%  8: binDCT-C4,    all I frames  w/o -I options.
%  9: binDCT-C4,    all I frame,s with -I option.
% 10: binDCT-L3,    1 I frame,    w/o  -I option.
% 11: binDCT-L3,    all I frames  w/o -I options.
% 12: binDCT-L3,    all I frame,s with -I option.

% Command:
% ./tmn -i ../suzie.qcif -o suzie_rec_flt.qcif -B suzie_flt.cmp -b 149 -k 0
% Notes: One I frame, all the rest are P frames.
%
s_f_p_noi = [ 31.290322  32.157321  32.491268  32.633727  32.629505  ...
32.642662  32.632789  32.691862  32.576088  32.628848  ...
32.680342  32.700123  32.653135  32.743191  32.637193  ...
32.730334  32.828678  32.948480  32.865863  32.869183  ...
32.918400  32.872608  32.891485  32.954360  32.908550  ...
32.957483  32.999602  33.009582  33.047367  33.022079  ...
33.074278  33.091632  33.155561  33.194334  33.226943  ...
33.207342  33.321596  33.353752  33.243673  33.155631  ...
32.989860  33.054208  32.915496  32.943390  33.101078  ...
33.231527  33.296444  33.402326  33.709501  33.816379  ...
34.341054  34.851348  34.998070  34.862185  34.601506  ...
34.465012  34.419593  34.178204  34.295673  34.239485  ...
34.004398  33.912847  33.948372  33.644713  33.400942  ...
33.123357  33.086072  32.987752  32.877926  33.027192  ...
32.995062  33.180001  33.200943  33.201059  32.857322  ...
32.775746  32.838267  32.831110  32.940516  33.065270  ...
32.902052  32.749003  32.804780  32.754048  32.612442  ...
32.740342  32.712605  32.662729  32.633471  32.563173  ...
32.638828  32.701021  32.678516  32.627463  32.554628  ...
32.613183  32.737153  32.764759  32.728713  32.841577  ...
32.881865  32.889634  32.841298  32.920315  33.070477  ...
33.159453  33.109083  33.286800  33.337195  33.286367  ...
33.334701  33.312003  33.331760  33.317521  33.270457  ...
33.347043  33.349396  33.435070  33.437745  33.576569  ...
33.508124  33.543013  33.433112  33.449211  33.495935  ...
33.464650  33.518154  33.461596  33.497049  33.537987  ...
33.508916  33.436297  33.360071  33.246416  33.331630  ...
33.381793  33.319405  33.420437  33.305838  33.285980  ...
33.296224  33.304789  33.492017  33.508384  33.493508  ...
33.553650  33.484122  33.556290  33.488686  33.520762  ...
]; 

%
%./tmn -i ../suzie.qcif -o suzie_rec_flt.qcif -B suzie_flt.cmp -b 149 -k 0 -f 1
%
s_f_i_noi = [ 31.290322  31.316218  31.334927  31.212946  31.238786  ...
31.223171  31.165881  31.198163  31.193689  31.172483  ...
31.198788  31.252766  31.190540  31.187342  31.242479  ...
31.285398  31.352461  31.297045  31.310865  31.328868  ...
31.365704  31.400436  31.309878  31.304925  31.376100  ...
31.394826  31.393863  31.422535  31.438317  31.493629  ...
31.368766  31.455438  31.531420  31.574546  31.602336  ...
31.670757  31.578224  31.583409  31.653319  31.650933  ...
31.757678  31.868807  31.772623  31.883737  32.032329  ...
32.111823  32.299085  32.617162  32.997458  33.204232  ...
33.422604  33.877328  33.997499  33.990697  33.859667  ...
33.778931  33.812180  33.699508  33.587595  33.584887  ...
33.276605  33.216833  32.980376  32.832324  32.667577  ...
32.310802  32.373748  32.089864  32.032039  31.944463  ...
31.988915  32.052988  32.003964  32.045452  31.838033  ...
31.739094  31.687138  31.699889  31.744710  31.765838  ...
31.726267  31.488079  31.544540  31.535711  31.513392  ...
31.510831  31.497671  31.538486  31.448502  31.444439  ...
31.520522  31.477764  31.522090  31.543950  31.456270  ...
31.509701  31.491748  31.563540  31.593332  31.673825  ...
31.684962  31.732597  31.710101  31.802149  31.827503  ...
31.787782  31.836778  31.838737  31.859314  31.799783  ...
31.856836  31.896875  31.891274  31.923849  31.899143  ...
31.852131  31.808391  31.833838  31.897458  31.986658  ...
31.912422  31.931473  31.837659  31.806149  31.803993  ...
31.948968  31.994318  32.001289  32.029199  32.018058  ...
31.975605  31.985446  31.971271  32.033453  32.121417  ...
32.142531  32.119969  32.049261  31.946092  31.908187  ...
31.953776  32.070646  32.037407  31.916521  31.938229  ...
32.005085  32.077631  32.052464  32.041756  32.058285  ...
]; 

%
%./tmn -i ../suzie.qcif -o suzie_rec_flt.qcif -B suzie_flt.cmp -b 149 -k 0 -f 1 -I
%
s_f_i_i = [ 31.951128  32.030213  32.031534  31.958374  31.992691  ...
31.968181  31.915104  31.910797  31.895880  31.939159  ...
31.940296  32.009184  31.944678  31.886442  31.876550  ...
31.894542  31.964517  32.011165  32.009067  32.032725  ...
31.990495  31.955037  32.001703  31.998796  31.988740  ...
32.107210  32.101507  32.082881  32.070816  32.245067  ...
32.106478  32.170576  32.160583  32.250254  32.398513  ...
32.334803  32.384997  32.488631  32.369180  32.334253  ...
32.368808  32.466998  32.487608  32.671251  32.635501  ...
32.770007  32.839402  33.231361  33.589841  33.763608  ...
34.064703  34.533441  34.382863  34.371809  34.472002  ...
34.256565  34.212771  34.155285  34.188500  34.133373  ...
33.863072  33.797239  33.604206  33.491664  33.243545  ...
33.126463  32.948012  32.720181  32.591003  32.612928  ...
32.667850  32.697562  32.761552  32.702867  32.440365  ...
32.466593  32.470925  32.462554  32.488010  32.477708  ...
32.392036  32.296361  32.296987  32.326902  32.194481  ...
32.370067  32.279491  32.273736  32.276673  32.073861  ...
32.157988  32.245726  32.371759  32.302720  32.213581  ...
32.265003  32.322365  32.330425  32.289726  32.356222  ...
32.353335  32.357755  32.320121  32.421805  32.496734  ...
32.509298  32.620259  32.563012  32.542221  32.632007  ...
32.553721  32.613847  32.594014  32.586693  32.526271  ...
32.578383  32.597775  32.504510  32.521163  32.635665  ...
32.713924  32.576036  32.582025  32.464408  32.529077  ...
32.512873  32.603957  32.572208  32.564876  32.531394  ...
32.557049  32.611855  32.552355  32.658362  32.671314  ...
32.700368  32.758960  32.706772  32.693464  32.646359  ...
32.632306  32.681437  32.697694  32.662403  32.607189  ...
32.521064  32.610591  32.709766  32.699686  32.664023  ...
]; 

%Command:
%./tmn -i ../suzie.qcif -o suzie_rec_c4.qcif -B suzie_c4.cmp -b 149 -k 0 -X c4
%binDCT-C4: 1 I frame, all the rest are P frames, no -I option.
%
s_c4_p_noi = [ 31.237752  32.091229  32.404781  32.568921  32.576517  ...
32.618443  32.659363  32.652155  32.578468  32.583219  ...
32.614703  32.686203  32.611533  32.697586  32.663921  ...
32.650772  32.766961  32.846375  32.841658  32.950709  ...
32.952914  32.855378  32.907278  32.925821  32.937099  ...
32.947882  32.952196  33.034574  33.010204  33.079786  ...
33.033568  33.028918  33.002669  33.095630  33.094807  ...
33.207557  33.177020  33.264171  33.083703  33.046272  ...
32.998656  32.980172  32.915423  32.996512  33.038541  ...
33.258637  33.316209  33.330092  33.558102  33.701219  ...
34.111999  34.564878  34.789348  34.710824  34.558730  ...
34.246220  34.164364  34.219039  34.148991  34.122424  ...
33.872363  33.833514  33.672377  33.491853  33.298978  ...
33.147976  33.100847  32.828218  32.791539  32.873818  ...
32.868188  32.913351  33.060191  32.945103  32.825106  ...
32.858400  32.871245  32.891162  32.985954  32.988628  ...
32.777304  32.676880  32.732385  32.666218  32.663945  ...
32.688743  32.604980  32.637159  32.594967  32.554779  ...
32.656389  32.824419  32.737713  32.615776  32.544266  ...
32.574872  32.615795  32.712083  32.669185  32.690368  ...
32.740743  32.789895  32.841146  32.969820  33.074738  ...
33.080820  33.139443  33.175252  33.177031  33.087456  ...
33.127822  33.147644  33.224761  33.276723  33.287120  ...
33.345295  33.339503  33.421879  33.390494  33.407111  ...
33.461538  33.487632  33.306769  33.376400  33.383056  ...
33.470576  33.473050  33.361642  33.384906  33.508159  ...
33.360802  33.405194  33.366886  33.389850  33.411444  ...
33.455677  33.427985  33.447992  33.316752  33.215595  ...
33.304620  33.329927  33.444607  33.468836  33.480849  ...
33.442021  33.424934  33.419991  33.433118  33.474897  ...
]; 

%Command:
%./tmn -i ../suzie.qcif -o suzie_rec_c4.qcif -B suzie_c4.cmp -b 149 -k 0 -X c4 -f 1
%binDCT-C4: all I frames, no -I option.

s_c4_i_noi = [ 31.237752  31.282373  31.251855  31.208029  31.217844  ...
31.170309  31.156089  31.189993  31.162559  31.186199  ...
31.167432  31.213427  31.174886  31.193682  31.203416  ...
31.284038  31.308652  31.280862  31.274245  31.330614  ...
31.363395  31.373829  31.310277  31.307392  31.332175  ...
31.370008  31.367664  31.400116  31.414272  31.463289  ...
31.373210  31.421819  31.487659  31.554608  31.546519  ...
31.637653  31.532586  31.525050  31.596946  31.623076  ...
31.712935  31.831077  31.771006  31.852099  31.966879  ...
32.046697  32.283961  32.586564  32.984895  33.163798  ...
33.391731  33.862783  33.955075  33.958850  33.829445  ...
33.760494  33.759473  33.648997  33.551571  33.537451  ...
33.205346  33.224069  32.914954  32.784383  32.671500  ...
32.297390  32.310003  32.043950  32.024362  31.918070  ...
31.955165  32.004692  31.999477  32.035444  31.787456  ...
31.730296  31.679136  31.667293  31.707910  31.716869  ...
31.682295  31.453194  31.546722  31.531866  31.470955  ...
31.501106  31.458792  31.532668  31.423764  31.393257  ...
31.496778  31.427548  31.511552  31.516421  31.442829  ...
31.462038  31.449591  31.538688  31.543273  31.636500  ...
31.665367  31.687826  31.676173  31.772666  31.782174  ...
31.742859  31.808223  31.824093  31.827716  31.753820  ...
31.847850  31.863643  31.866684  31.905354  31.856549  ...
31.825697  31.786756  31.815650  31.841301  31.917304  ...
31.875336  31.877033  31.810625  31.755305  31.764659  ...
31.878259  31.969313  31.978363  31.993313  32.005068  ...
31.928851  31.931140  31.930182  32.020139  32.085317  ...
32.121825  32.077074  32.047394  31.922835  31.866692  ...
31.919993  32.010959  32.016293  31.857738  31.887870  ...
31.947970  32.034871  32.015970  32.019212  32.013095  ...
]; 

%Command:
%./tmn -i ../suzie.qcif -o suzie_rec_c4.qcif -B suzie_c4.cmp -b 149 -k 0 -X c4 -f 1 -I
%binDCT-C4: all I frames, with -I option.

s_c4_i_i = [ 31.926743  31.964086  31.998157  31.912123  31.862882  ...
31.900951  31.900033  31.861790  31.869257  31.895704  ...
31.931465  31.977449  31.881948  31.878084  31.844383  ...
31.850185  31.916849  31.947594  31.965980  32.017702  ...
31.944389  31.958647  32.016322  31.947499  31.954809  ...
32.015844  32.071567  32.072608  32.091693  32.177271  ...
32.042971  32.143834  32.129770  32.222324  32.344238  ...
32.292428  32.283506  32.399292  32.322685  32.285237  ...
32.302518  32.407968  32.434988  32.607684  32.612731  ...
32.723964  32.819710  33.168474  33.576743  33.739908  ...
34.056393  34.433731  34.399197  34.303361  34.396259  ...
34.160007  34.163498  34.165278  34.152192  34.090750  ...
33.880360  33.755610  33.548241  33.436256  33.157387  ...
33.004737  32.892490  32.664709  32.590539  32.538773  ...
32.569264  32.670023  32.719067  32.651281  32.422564  ...
32.455103  32.451348  32.432261  32.443963  32.444287  ...
32.409946  32.274754  32.276383  32.268965  32.195211  ...
32.276410  32.229469  32.251604  32.198729  32.100490  ...
32.190975  32.260207  32.339385  32.246597  32.198475  ...
32.233359  32.261440  32.310591  32.250139  32.333901  ...
32.246203  32.313140  32.264444  32.357873  32.431666  ...
32.447874  32.572322  32.568645  32.513926  32.574452  ...
32.599745  32.618992  32.607463  32.537620  32.505768  ...
32.539236  32.543040  32.482116  32.482130  32.614525  ...
32.633364  32.560469  32.560759  32.440550  32.458713  ...
32.491273  32.550041  32.499821  32.583004  32.500754  ...
32.523980  32.548704  32.482027  32.621796  32.599548  ...
32.669287  32.735906  32.698253  32.623426  32.609034  ...
32.626334  32.650228  32.652771  32.626392  32.522873  ...
32.500173  32.588807  32.627844  32.672694  32.588644  ...
]; 

%%%%%%%%%%%%%
%
% binDCT-C1:
%
%%%%%%%%%%%%%

%Command:
%./tmn -i ../suzie.qcif -o suzie_rec_c1.qcif -B suzie_c1.cmp -b 149 -k 0 -X c1

s_c1_p_noi = [ 30.917457  31.830378  32.158005  32.399209  32.421722  ...
32.404703  32.392566  32.451548  32.384751  32.415453  ...
32.464241  32.502329  32.485814  32.494057  32.464734  ...
32.492078  32.613664  32.686326  32.703269  32.788072  ...
32.724857  32.664300  32.687847  32.765436  32.820543  ...
32.816135  32.927460  32.961536  33.000380  33.040753  ...
33.014939  32.976807  32.983690  33.016217  33.141572  ...
33.133073  33.185847  33.165944  33.069718  32.965619  ...
32.911619  32.878238  32.743850  32.784238  33.004942  ...
33.121859  33.179086  33.336365  33.582181  33.575530  ...
34.070996  34.685465  34.933373  34.644454  34.497536  ...
34.372018  34.106053  34.049612  34.020829  33.970695  ...
33.787105  33.593878  33.532663  33.205164  33.113248  ...
32.835821  32.788703  32.597856  32.620731  32.625524  ...
32.668731  32.675099  32.900978  32.725879  32.598733  ...
32.524762  32.581796  32.652072  32.665084  32.676905  ...
32.556673  32.432049  32.515976  32.444541  32.373421  ...
32.417480  32.297506  32.399809  32.346974  32.407298  ...
32.413983  32.515972  32.517449  32.487477  32.507312  ...
32.493299  32.432981  32.521200  32.513315  32.618954  ...
32.643442  32.730052  32.694066  32.831307  32.931573  ...
33.004463  32.978790  33.037278  33.097872  33.023892  ...
32.977634  32.995067  32.960233  33.084281  33.065702  ...
33.061023  33.087945  33.110194  33.079930  33.219896  ...
33.263350  33.199616  33.119696  33.140996  33.103436  ...
33.157256  33.250068  33.198290  33.124899  33.246616  ...
33.105235  33.149913  33.070835  33.064047  33.063578  ...
33.233496  33.205919  33.174305  33.104185  33.190427  ...
33.205429  33.233840  33.301237  33.301919  33.317538  ...
33.359203  33.312382  33.247952  33.319666  33.265172  ...
]; 


%Command:
%./tmn -i ../suzie.qcif -o suzie_rec_c1.qcif -B suzie_c1.cmp -b 149 -k 0 -X c1 -f 1

s_c1_i_noi = [ 30.917457  30.995380  30.986246  30.903754  30.935907  ...
30.925791  30.910529  30.954571  30.906987  30.860016  ...
30.875905  30.933727  30.902103  30.948167  30.968560  ...
30.974228  31.036718  30.975307  31.026782  31.009774  ...
31.047384  31.070373  30.950580  30.984854  31.013876  ...
31.071469  31.036370  31.104267  31.108711  31.189999  ...
31.098389  31.095759  31.172424  31.298491  31.285919  ...
31.333623  31.296445  31.313129  31.349400  31.348505  ...
31.548408  31.571400  31.540822  31.644697  31.704806  ...
31.761863  31.999301  32.220799  32.661921  32.913134  ...
33.161920  33.574174  33.729663  33.788681  33.627692  ...
33.543489  33.522161  33.410739  33.274846  33.262149  ...
33.000275  33.011764  32.657317  32.447948  32.358503  ...
32.046368  32.017262  31.687076  31.726965  31.626348  ...
31.672019  31.757978  31.727632  31.718419  31.449241  ...
31.418851  31.342398  31.410551  31.375626  31.430118  ...
31.440023  31.175546  31.211020  31.227116  31.182139  ...
31.195330  31.198864  31.297404  31.131285  31.106259  ...
31.212437  31.164044  31.251103  31.263910  31.200031  ...
31.217788  31.230742  31.276224  31.332240  31.346744  ...
31.437201  31.508932  31.492071  31.534420  31.599513  ...
31.518739  31.613013  31.545187  31.573554  31.486943  ...
31.614625  31.613330  31.657486  31.658540  31.664072  ...
31.555313  31.476271  31.496042  31.604364  31.685825  ...
31.617523  31.606500  31.539286  31.537231  31.565644  ...
31.670060  31.699113  31.708418  31.744410  31.773923  ...
31.706223  31.704280  31.714354  31.826456  31.827271  ...
31.891368  31.821591  31.755139  31.669809  31.648432  ...
31.673972  31.716771  31.749387  31.677356  31.682415  ...
31.742891  31.807615  31.802572  31.788275  31.796637  ...
]; 


%Command:
%./tmn -i ../suzie.qcif -o suzie_rec_c1.qcif -B suzie_c1.cmp -b 149 -k 0 -X c1 -f 1 -I
 
s_c1_i_i = [ 31.650543  31.611855  31.658605  31.592434  31.601444  ...
31.602481  31.629771  31.574394  31.629449  31.574137  ...
31.617037  31.640170  31.606107  31.553263  31.478834  ...
31.608373  31.683751  31.699168  31.735870  31.688677  ...
31.671938  31.689719  31.709398  31.631360  31.698938  ...
31.811065  31.863109  31.840166  31.820917  31.900714  ...
31.814637  31.874033  31.843251  31.974031  32.059559  ...
32.044321  32.023972  32.012769  32.032034  32.029902  ...
32.070332  32.187825  32.101272  32.242381  32.366753  ...
32.411479  32.651456  32.884542  33.306346  33.517775  ...
33.791134  34.144582  34.130582  34.123834  34.158586  ...
33.947567  33.941032  33.913892  33.884625  33.848504  ...
33.604586  33.516330  33.244107  33.098442  32.895800  ...
32.727162  32.611451  32.351591  32.305112  32.295069  ...
32.335088  32.373097  32.411833  32.318489  32.103556  ...
32.069508  32.115206  32.081387  32.088730  32.141987  ...
32.094911  31.994556  32.019149  31.932270  32.000132  ...
32.006649  31.915055  32.023590  31.902540  31.782777  ...
31.894326  31.987116  32.073942  31.967513  31.961639  ...
31.947322  31.969790  32.041769  32.001920  32.092653  ...
32.044098  32.109026  32.110821  32.167402  32.185048  ...
32.181663  32.222487  32.293737  32.258766  32.288668  ...
32.308492  32.347476  32.329353  32.335137  32.290748  ...
32.327533  32.250396  32.129185  32.257596  32.246738  ...
32.307380  32.352094  32.295641  32.287896  32.215963  ...
32.253627  32.316988  32.284822  32.327285  32.277514  ...
32.305851  32.336789  32.187289  32.350749  32.384363  ...
32.457400  32.467970  32.421013  32.355184  32.347268  ...
32.324548  32.380609  32.415200  32.354214  32.223437  ...
32.257206  32.297680  32.318507  32.350174  32.335426  ...
]; 

%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% binDCT-L3
%
%%%%%%%%%%%%%%%%%%%%%%%%%%

s_l3_p_noi = [ 31.245103  32.086250  32.377350  32.522189  32.563074  ...
32.565123  32.567255  32.610235  32.558825  32.568150  ...
32.546629  32.557618  32.533655  32.562394  32.505031  ...
32.578320  32.633099  32.801348  32.725908  32.731732  ...
32.725819  32.754684  32.754988  32.824040  32.815238  ...
32.823132  32.930952  33.009150  33.003795  33.017109  ...
32.998183  33.021682  33.086083  33.028007  33.058794  ...
33.191460  33.201940  33.239304  33.159033  33.062911  ...
33.031634  32.980763  32.806117  32.912877  32.898994  ...
33.083901  33.235700  33.272623  33.512263  33.785057  ...
34.059660  34.554660  34.848602  34.782487  34.537702  ...
34.374406  34.347238  34.129416  34.151541  34.101415  ...
33.869272  33.875623  33.726716  33.382321  33.340464  ...
33.119356  33.033075  32.772825  32.773609  32.902499  ...
32.981794  32.996759  33.014280  33.005579  32.836596  ...
32.783708  32.695806  32.821088  32.829431  32.825000  ...
32.803855  32.735080  32.684746  32.629659  32.675192  ...
32.538541  32.604548  32.654956  32.580034  32.555036  ...
32.561310  32.640929  32.709894  32.633620  32.563934  ...
32.629181  32.619898  32.643185  32.637387  32.740277  ...
32.811149  32.818369  32.792657  32.938608  33.048674  ...
32.972960  33.080728  33.122768  33.128878  33.082277  ...
33.108339  33.176840  33.176040  33.201880  33.173249  ...
33.197316  33.193708  33.282505  33.372949  33.363054  ...
33.351647  33.361848  33.328498  33.299423  33.360191  ...
33.335315  33.344805  33.371981  33.312337  33.342079  ...
33.374663  33.340322  33.301682  33.269036  33.225852  ...
33.310930  33.327466  33.272483  33.317877  33.239682  ...
33.285014  33.314168  33.486727  33.458446  33.451830  ...
33.473595  33.454106  33.455501  33.430940  33.315440  ...
]; 

s_l3_i_noi = [ 31.245103  31.277480  31.271496  31.171765  31.195170  ...
31.152352  31.134641  31.169360  31.160163  31.172269  ...
31.164099  31.222497  31.154281  31.180565  31.185513  ...
31.241798  31.312644  31.258780  31.263582  31.300016  ...
31.349339  31.359703  31.284828  31.263325  31.305857  ...
31.371071  31.361851  31.380831  31.406913  31.460367  ...
31.320041  31.391964  31.489063  31.542017  31.545902  ...
31.632557  31.529081  31.532383  31.606255  31.608499  ...
31.702458  31.845350  31.722598  31.830615  31.961962  ...
32.033928  32.247463  32.536528  32.960119  33.149113  ...
33.384326  33.823676  33.966181  33.952495  33.797232  ...
33.754546  33.759742  33.645316  33.544038  33.540100  ...
33.229986  33.221744  32.919375  32.783027  32.665931  ...
32.288418  32.321187  32.010398  31.998107  31.914453  ...
31.927339  32.006205  31.989578  31.982305  31.775406  ...
31.701756  31.631912  31.666481  31.681452  31.731415  ...
31.683184  31.428093  31.518185  31.512466  31.459832  ...
31.491730  31.473240  31.488922  31.388802  31.389691  ...
31.472822  31.417072  31.465903  31.490132  31.407478  ...
31.455102  31.446141  31.521955  31.546338  31.636803  ...
31.652432  31.685510  31.684978  31.747972  31.796705  ...
31.789278  31.785082  31.791598  31.828776  31.730182  ...
31.820653  31.878864  31.866275  31.896549  31.845205  ...
31.798906  31.791833  31.779267  31.852724  31.926678  ...
31.852163  31.889104  31.787659  31.763884  31.764184  ...
31.882391  31.960625  31.967331  31.992929  31.988191  ...
31.918767  31.926160  31.950252  31.994147  32.077979  ...
32.105584  32.056448  32.022284  31.916808  31.840250  ...
31.899763  31.997527  31.967704  31.843086  31.885880  ...
31.962860  32.009988  31.991399  32.012249  31.998040  ...
]; 

s_l3_i_i = [ 31.891641  31.950290  31.981806  31.877000  31.876899  ...
31.875746  31.877934  31.874277  31.849201  31.881538  ...
31.911734  31.953491  31.886039  31.819839  31.797598  ...
31.834007  31.892480  31.907901  31.932143  32.001055  ...
31.915780  31.918906  31.927244  31.917271  31.904627  ...
32.000517  32.052261  32.045726  32.046144  32.148880  ...
32.044321  32.094804  32.155303  32.173822  32.327037  ...
32.286481  32.340410  32.435547  32.358889  32.294917  ...
32.301704  32.412067  32.449680  32.605758  32.582574  ...
32.719821  32.846446  33.163388  33.566319  33.689667  ...
34.089729  34.409630  34.430229  34.305860  34.364647  ...
34.170212  34.193716  34.083651  34.130145  34.092913  ...
33.870988  33.781058  33.486909  33.402563  33.157387  ...
33.014966  32.908164  32.663351  32.593928  32.581619  ...
32.575969  32.687646  32.676865  32.640309  32.409193  ...
32.407794  32.439552  32.381658  32.451793  32.415214  ...
32.359673  32.241926  32.276290  32.235475  32.192831  ...
32.240531  32.175953  32.210625  32.139127  32.058170  ...
32.140615  32.219318  32.312933  32.218659  32.191818  ...
32.250577  32.218071  32.276588  32.250267  32.299157  ...
32.252679  32.311502  32.256280  32.357764  32.473835  ...
32.422638  32.573399  32.576799  32.486108  32.598887  ...
32.591410  32.575153  32.566061  32.517449  32.452989  ...
32.525073  32.578731  32.446647  32.462944  32.628264  ...
32.605301  32.528789  32.566827  32.456129  32.462415  ...
32.478557  32.546819  32.517298  32.591031  32.518305  ...
32.528520  32.523688  32.466691  32.632118  32.570131  ...
32.659587  32.730314  32.700711  32.670924  32.588917  ...
32.619040  32.646514  32.676221  32.602119  32.504496  ...
32.412853  32.552967  32.625871  32.654830  32.608914  ...
]; 

%%%%%%%%%%%%%%%%%%%%%%%%
%
% Effect of advanced_intra_coding for 
% each method:
%
%%%%%%%%%%%%%%%%%%%%%%%%

close all;
figure;
plot(s_f_p_noi,'r');
hold on;
plot(s_f_i_noi, 'g');
hold on;
plot(s_f_i_i,'b');
legend('FLT-P-noI', 'FLT-I-noI', 'FLT-I- I');
ylabel('PSNR (dB)');
xlabel('Frame');
title('FLT DCT: Performance of advanced Intra Prediction');


figure;
plot(s_c1_p_noi,'r');
hold on;
plot(s_c1_i_noi, 'g');
hold on;
plot(s_c1_i_i,'b');
legend('C1-P-noI', 'C1-I-noI', 'C1-I- I');
ylabel('PSNR (dB)');
xlabel('Frame');
title('binDCT-C1: Performance of advanced Intra Prediction');

figure;
plot(s_c4_p_noi,'r');
hold on;
plot(s_c4_i_noi, 'g');
hold on;
plot(s_c4_i_i,'b');
legend('C4-P-noI', 'C4-I-noI', 'C4-I- I');
ylabel('PSNR (dB)');
xlabel('Frame');
title('binDCT-C4: Performance of advanced Intra Prediction');


figure;
plot(s_l3_p_noi,'r');
hold on;
plot(s_l3_i_noi, 'g');
hold on;
plot(s_l3_i_i,'b');
legend('L3-P-noI', 'L3-I-noI', 'L3-I- I');
ylabel('PSNR (dB)');
xlabel('Frame');
title('binDCT-L3: Performance of advanced Intra Prediction');

%%%%%%%%%%%%%%%%%%%%%%%
%
% Difference between FLT and binDCT
%
%%%%%%%%%%%%%%%%%%%%%%%

figure;
plot(s_f_p_noi,'r');
hold on;
plot(s_c1_p_noi, 'g');
hold on;
plot(s_c4_p_noi, 'b');
hold on;
plot(s_l3_p_noi, 'm');
legend('FLT-P-noI', 'C1-P-noI', 'C4-P-noI', 'L3-P-noI');
ylabel('PSNR (dB)');
title('Flt DCT vs binDCT-C1, C4 & L3: all(except 1) P frames, no -I option');

flt_c1 = sum(s_f_p_noi - s_c1_p_noi) / length(s_f_p_noi);
flt_c4 = sum(s_f_p_noi - s_c4_p_noi) / length(s_f_p_noi);
flt_l3 = sum(s_f_p_noi - s_l3_p_noi) / length(s_f_p_noi);
s=sprintf('Frame  (Average degradation: C1: %fdB, C4: %fdB, L3: %fdB)', flt_c1, flt_c4, flt_l3);
xlabel(s);

figure;
plot(s_f_i_noi,'r');
hold on;
plot(s_c1_i_noi, 'g');
hold on;
plot(s_c4_i_noi, 'b');
hold on;
plot(s_l3_i_noi, 'm');
legend('FLT-I-noI', 'C1-I-noI', 'C4-I-noI', 'L3-I-noI');
ylabel('PSNR (dB)');
title('Flt DCT vs binDCT-C1, C4 & L3: all I frames, no -I option');

flt_c1 = sum(s_f_i_noi - s_c1_i_noi) / length(s_f_p_noi);
flt_c4 = sum(s_f_i_noi - s_c4_i_noi) / length(s_f_p_noi);
flt_l3 = sum(s_f_i_noi - s_l3_i_noi) / length(s_f_p_noi);
s=sprintf('Frame  (Average degradation: C1: %fdB, C4: %fdB, L3: %fdB)', flt_c1, flt_c4, flt_l3);
xlabel(s);

figure;
plot(s_f_i_i,'r');
hold on;
plot(s_c1_i_i, 'g');
hold on;
plot(s_c4_i_i, 'b');
hold on;
plot(s_l3_i_i, 'm');
legend('FLT-I-I', 'C1-I-I', 'C4-I-I', 'L3-I-I');
ylabel('PSNR (dB)');
title('Flt DCT vs binDCT-C1, C4 & L3: all I frames, with -I option');

flt_c1 = sum(s_f_i_i - s_c1_i_i) / length(s_f_p_noi);
flt_c4 = sum(s_f_i_i - s_c4_i_i) / length(s_f_p_noi);
flt_l3 = sum(s_f_i_i - s_l3_i_i) / length(s_f_p_noi);

s=sprintf('Frame  (Average degradation: C1: %fdB, C4: %fdB, L3: %fdB)', flt_c1, flt_c4, flt_l3);
xlabel(s);

%%%%%%%%%%%%%%%%%%%%%%
%
%  End of file
%
%%%%%%%%%%%%%%%%%%%%%%
