 
/************************************************************************ 
 * 
 *  quant.c, part of tmn (TMN encoder) 
 * 
 *  Copyright (C) 1997  University of BC, Canada 
 * 
 *  Contacts:  
 *  Michael Gallant                   <mikeg@ee.ubc.ca> 
 *  Guy Cote                          <guyc@ee.ubc.ca> 
 *  Berna Erol                        <bernae@ee.ubc.ca> 
 * 
 *  UBC Image Processing Laboratory   http://www.ee.ubc.ca/image 
 *  2356 Main Mall                    tel.: +1 604 822 4051 
 *  Vancouver BC Canada V6T1Z4        fax.: +1 604 822 5949 
 * 
 *  Copyright (C) 1995, 1996  Telenor R&D, Norway 
 * 
 *  Contacts: 
 *  Robert Danielsen                  <Robert.Danielsen@nta.no> 
 * 
 *  Telenor Research and Development  http://www.nta.no/brukere/DVC/ 
 *  P.O.Box 83                        tel.:   +47 63 84 84 00 
 *  N-2007 Kjeller, Norway            fax.:   +47 63 81 00 76 
 * 
 ************************************************************************/ 
 
/* Disclaimer of Warranty 
 *  
 * These software programs are available to the user without any license fee 
 * or royalty on an "as is" basis. The University of British Columbia 
 * disclaims any and all warranties, whether express, implied, or 
 * statuary, including any implied warranties or merchantability or of 
 * fitness for a particular purpose.  In no event shall the 
 * copyright-holder be liable for any incidental, punitive, or 
 * consequential damages of any kind whatsoever arising from the use of 
 * these programs. 
 *  
 * This disclaimer of warranty extends to the user of these programs and 
 * user's customers, employees, agents, transferees, successors, and 
 * assigns. 
 *  
 * The University of British Columbia does not represent or warrant that the 
 * programs furnished hereunder are free of infringement of any 
 * third-party patents. 
 *  
 * Commercial implementations of H.263, including shareware, are subject to 
 * royalty fees to patent holders.  Many of these patents are general 
 * enough such that they are unavoidable regardless of implementation 
 * design. 
 *  
 */ 

 
 
#include"sim.h" 

extern int which_dct;
extern int lossless_codec;

//Define this to use the 128-scaled binDCT matrix
extern int bindct_scaling_matrix_amp_128;

//scaled by 128
#define BINDCT_CST    7

//binDCT-C scaling matrix scaled by 128.
static const int bindct_c_scale[DCTSIZE2] = {
 1024, 710, 669, 602, 512, 871, 784, 738,
  710, 493, 464, 418, 355, 604, 544, 512,
  669, 464, 437, 393, 334, 569, 512, 482,
  602, 418, 393, 354, 301, 512, 461, 434,
  512, 355, 334, 301, 256, 435, 392, 369,
  871, 604, 569, 512, 435, 741, 667, 628,
  784, 544, 512, 461, 392, 667, 600, 565,
  738, 512, 482, 434, 369, 628, 565, 532
};

//binDCT-L scaling matrix scaled by 128.
static const int bindct_l_scale[DCTSIZE2] = {
 1024, 1024, 669, 724, 512, 724, 784, 512,
 1024, 1024, 669, 724, 512, 724, 784, 512,
  669,  669, 437, 473, 334, 473, 512, 334,
  724,  724, 473, 512, 362, 512, 554, 362,
  512,  512, 334, 362, 256, 362, 392, 256,
  724,  724, 473, 512, 362, 512, 554, 362,
  784,  784, 512, 554, 392, 554, 600, 392,
  512,  512, 334, 362, 256, 362, 392, 256
};

//binDCT-C scaling matrix without further scaling.
static const double f_bindct_c_scale[DCTSIZE2] = {
  8.00000000000000,   5.54815938128859,   5.22625185950551,  4.70350240967744,
  4.00000000000000,   6.80344075813805,   6.12293491784144,  5.76767857605558,
  5.54815938128859,   3.84775906502257,   3.62450978541155,  3.26197262739567,
  2.77407969064430,   4.71832170841310,   4.24637735068018,  4.00000000000000,
  5.22625185950551,   3.62450978541155,   3.41421356237309,  3.07271102684567,
  2.61312592975275,   4.44456186415682,   4.00000000000000,  3.76791761039257,
  4.70350240967744,   3.26197262739567,   3.07271102684567,  2.76536686473018,
  2.35175120483872,   4.00000000000000,   3.59990489254566,  3.39103626009029,
  4.00000000000000,   2.77407969064430,   2.61312592975275,  2.35175120483872,
  2.00000000000000,   3.40172037906903,   3.06146745892072,  2.88383928802779,
  6.80344075813805,   4.71832170841310,   4.44456186415682,  4.00000000000000,
  3.40172037906903,   5.78585076868676,   5.20712812243364,  4.90500743802202,
  6.12293491784144,   4.24637735068018,   4.00000000000000,  3.59990489254566,
  3.06146745892072,   5.20712812243364,   4.68629150101524,  4.41439006852709,
  5.76767857605558,   4.00000000000000,   3.76791761039257,  3.39103626009029,
  2.88383928802779,   4.90500743802202,   4.41439006852709,  4.15826451958632
};

//binDCT-L scaling matrix without further scaling.
static const double f_bindct_l_scale[DCTSIZE2] = {
  8.00000000000000,  8.00000000000000,  5.22625185950551,   5.65685424949238,
  4.00000000000000,  5.65685424949238,  6.12293491784144,   4.00000000000000,
  8.00000000000000,  8.00000000000000,  5.22625185950551,   5.65685424949238,
  4.00000000000000,  5.65685424949238,  6.12293491784144,   4.00000000000000,
  5.22625185950551,  5.22625185950551,  3.41421356237309,   3.69551813004515,
  2.61312592975275,  3.69551813004515,  4.00000000000000,   2.61312592975275,
  5.65685424949238,  5.65685424949238,  3.69551813004515,   4.00000000000000,
  2.82842712474619,  4.00000000000000,  4.32956880116958,   2.82842712474619,
  4.00000000000000,  4.00000000000000,  2.61312592975275,   2.82842712474619,
  2.00000000000000,  2.82842712474619,  3.06146745892072,   2.00000000000000,
  5.65685424949238,  5.65685424949238,  3.69551813004515,   4.00000000000000,
  2.82842712474619,  4.00000000000000,  4.32956880116958,   2.82842712474619,
  6.12293491784144,  6.12293491784144,  4.00000000000000,   4.32956880116958,
  3.06146745892072,  4.32956880116958,  4.68629150101524,   3.06146745892072,
  4.00000000000000,  4.00000000000000,  2.61312592975275,   2.82842712474619,
  2.00000000000000,  2.82842712474619,  3.06146745892072,   2.00000000000000
};



static int MQ_chroma_QP_table[32] = {0,1,2,3,4,5,6,6,7,8,9,9,10,10,11,11,12,12,12,13,13,13,14,14,14,14,14,15,15,15,15,15}; 
 
/********************************************************************** 
 * 
 *	Name:        Quant_blk 
 *	Description:	quantizer 
 * 
 *	Input:        pointers to coeff and qcoeff 
 * 
 *	Returns: 
 *	Side effects: 
 * 
 *	Date: 940111	Author:	<klillevo@mailbox.jf.intel.com> 
 * 
 ***********************************************************************/ 
 
void Quant_blk (int *coeff, int *qcoeff, int QP, int Mode, int block) 
{ 
  int i; 
  int level; 
  
  //binDCT:
  //this static variable save the last QP.
  //if the current QP is the same as the last one, use the same Q matrix.
  static int last_lum_QP = 0;
  static int last_chm_QP = 0;
  static int lum_q_table[DCTSIZE2];
  static int chm_q_table[DCTSIZE2];
  int    *scale_ptr;
  double *f_scale_ptr;
  int    *q_table_ptr;

  //if both 'lossless' and 'A'/'q' parameter are specified, 
  //the lossless option will override the others.
  if (lossless_codec) {
    //lossless bindct
      for (i = 0; i < 64; i++) { 
	  qcoeff[block*64 + i] = coeff[block*64 + i]; 
      }
      return;
  }

  /////////////////////////////////////////////////
  // Floating DCT: keep the original code untouched.
  /////////////////////////////////////////////////
  if ( 0 == which_dct) {

	/*Modify the chroma quantizer if modified quantization mode is in use*/ 
	if (modified_quantization && (block == 4 || block == 5)) {
	  QP=MQ_chroma_QP_table[QP];                    
	} 
	if (QP) {
	  if (Mode == MODE_INTRA || Mode == MODE_INTRA_Q) {
		/* Intra */ 
		/* advanced intra coding quantization */ 
		if (advanced_intra_coding) {
		  for (i = 0; i < 64; i++) {
			if (!modified_quantization || QP >= 8) {
			  /* clipping to [-127,+127] */ 
			  qcoeff[block*64 + i] = mmin (127, mmax (-127, (coeff[block*64 + i] + sign(coeff[block*64 + i]) * QP/2) / (2 * QP))); 
			} else {
			  /* no clipping, quantized coefficients  */ 
			  qcoeff[block*64 + i] = (coeff[block*64 + i] + sign(coeff[block*64 + i]) * QP/2) / (2 * QP); 
			} 
		  } 
		} else {
		  qcoeff[block*64] = mmax (1, mmin (254, (coeff[block*64]+4) / 8)); 
 
		  for (i = 1; i < 64; i++) {
			level = (abs (coeff[block*64 + i])) / (2 * QP); 
 
			/* if QP is larger than 8, don't use extended quantization */ 
			if (!modified_quantization || QP >= 8) {
			  /* clipping to [-127,+127] */ 
			  qcoeff[block*64 + i] = mmin (127, mmax (-127, sign (coeff[block*64 + i]) * level)); 
			} else {
			  /* no clipping, quantized coefficients  */ 
			  qcoeff[block*64 + i] = sign (coeff[block*64 + i]) * level; 
			} 
		  } 
		} 
	  } 
       
	  else {
		/* non Intra */ 
		for (i = 0; i < 64; i++) {
		  level = (abs (coeff[block*64 + i]) - QP / 2) / (2 * QP); 
		  /* if QP is larger than 8, don't use extended quantization */ 
		  if (!modified_quantization || QP >= 8) {
			/* clipping to [-127,+127] */ 
			qcoeff[block*64 + i] = mmin (127, mmax (-127, sign (coeff[block*64 + i]) * level)); 
		  } else {
			/* no clipping, quantized coefficients  */ 
			qcoeff[block*64 + i] = sign (coeff[block*64 + i]) * level; 
		  } 
		} 
	  } 
	} 
     
	else {
	  /* No quantizing. Used only for testing. Bitstream will not be 
	   * decodable whether clipping is performed or not */ 
	  for (i = 0; i < 64; i++) {
		qcoeff[block*64 + i] = coeff[block*64 + i]; 
	  } 
	}   


  }

  //////////////////////////////////////////////
  //
  // binDCT 
  //
  //////////////////////////////////////////////
  else { 

  if ( bindct_scaling_matrix_amp_128 ) {
    //use the 128-amplified bindct scaling matrix for quantization

    /*Modify the chroma quantizer if modified quantization mode is in use*/ 	
    if (modified_quantization && (block == 4 || block == 5)) {	
      QP=MQ_chroma_QP_table[QP];                    
    } 

    if (block >= 4) {
      //this cover modified quant mode or normal mode, where chm quant = lum quant.
      q_table_ptr = (int *) &chm_q_table;
    } else {
      q_table_ptr = (int *) &lum_q_table;
    }

    //update the Q table if QP changed.
    if ( ( (block < 4) && (QP != last_lum_QP)) || 
      ( (block >= 4) && (QP != last_chm_QP)) ) {
      
      if (which_dct < 10) {
	scale_ptr = (int *) &bindct_c_scale;
      } else {
	scale_ptr = (int *) &bindct_l_scale;
      }
      
      //generate quantization table.
      for (i = 0; i < 64; i++) {
	*(q_table_ptr + i) = QP * (*(scale_ptr + i));
      }
      
      //update the last QP.
      if (block >= 4) {
	last_chm_QP = QP;
      } else {
	last_lum_QP = QP;
      }
    } 

    /////////////////////////////////////////////////////////////////////

    if (Mode == MODE_INTRA || Mode == MODE_INTRA_Q) {
      /* Intra */ 
      /* advanced intra coding quantization */ 
      if (advanced_intra_coding) {
	for (i = 0; i < 64; i++) {
	  if (!modified_quantization || QP >= 8) {
	    
	    /* clipping to [-127,+127] */ 
	    qcoeff[block*64 + i] = mmin (127, mmax (-127, 
(((coeff[block*64 + i] + sign(coeff[block*64 + i]) * ((*(q_table_ptr + i)) >> BINDCT_CST) / 2) << BINDCT_CST) / (2 * (*(q_table_ptr + i))))
)); 
	    
	  } else {
	    /* no clipping, quantized coefficients  */ 
	    qcoeff[block*64 + i] = (((coeff[block*64 + i] + sign(coeff[block*64 + i]) * ((*(q_table_ptr + i)) >> BINDCT_CST) / 2) << BINDCT_CST) / (2 * (*(q_table_ptr + i))));
	  } 
	} 
      } else {
	qcoeff[block*64] = mmax (1, mmin (254, (coeff[block*64] + 32) / 64)); 
	
	for (i = 1; i < 64; i++) {

	  level = ((abs (coeff[block*64 + i])) << BINDCT_CST ) / (2 * (*(q_table_ptr + i)) ); 
	  
	  /* if QP is larger than 8, don't use extended quantization */ 
	  if (!modified_quantization || QP >= 8) {
	    /* clipping to [-127,+127] */ 
	    qcoeff[block*64 + i] = mmin (127, mmax (-127, sign (coeff[block*64 + i]) * level)); 
	  } else {
	    /* no clipping, quantized coefficients  */ 
	    qcoeff[block*64 + i] = sign (coeff[block*64 + i]) * level; 
	  } 
	} 
      } 
    } 
    
    else {
      /* non Intra */ 
      for (i = 0; i < 64; i++) {
	level = ((abs (coeff[block*64 + i]) - ((*(q_table_ptr + i)) >> BINDCT_CST) / 2) << BINDCT_CST) / (2 * (*(q_table_ptr + i)) ); 
	/* if QP is larger than 8, don't use extended quantization */ 
	if (!modified_quantization || QP >= 8) {
	  /* clipping to [-127,+127] */ 
	  qcoeff[block*64 + i] = mmin (127, mmax (-127, sign (coeff[block*64 + i]) * level)); 
	} else {
	  /* no clipping, quantized coefficients  */ 
	  qcoeff[block*64 + i] = sign (coeff[block*64 + i]) * level; 
	} 
      } 
    } 


  } else {
  //use the unamplified scaling matrix for binDCT quantization.

    /****************************************************************
     * use the unscaled floating matrix to get the final quant matrix
     ****************************************************************/

   /*Modify the chroma quantizer if modified quantization mode is in use*/ 	
    if (modified_quantization && (block == 4 || block == 5)) {	
      QP=MQ_chroma_QP_table[QP];                    
    } 

    if (block >= 4) {
      //this cover modified quant mode or normal mode, where chm quant = lum quant.
      q_table_ptr = (int *) &chm_q_table;
    } else {
      q_table_ptr = (int *) &lum_q_table;
    }

    //update the Q table if QP changed.
    if ( ( (block < 4) && (QP != last_lum_QP)) || 
      ( (block >= 4) && (QP != last_chm_QP)) ) {
      
      if (which_dct < 10) {
	f_scale_ptr = (double *) &f_bindct_c_scale;
      } else {
	f_scale_ptr = (double *) &f_bindct_l_scale;
      }
      
      //generate quantization table.
      for (i = 0; i < 64; i++) {
	*(q_table_ptr + i) = (int) (QP * (*(f_scale_ptr + i)) + 0.5);
      }
      
      //update the last QP.
      if (block >= 4) {
	last_chm_QP = QP;
      } else {
	last_lum_QP = QP;
      }
    } 

    /////////////////////////////////////////////////////////////////////

    if (Mode == MODE_INTRA || Mode == MODE_INTRA_Q) {
      /* Intra */ 
      /* advanced intra coding quantization */ 
      if (advanced_intra_coding) {
	for (i = 0; i < 64; i++) {
	  if (!modified_quantization || QP >= 8) {
	    
	    /* clipping to [-127,+127] */ 
	    qcoeff[block*64 + i] = mmin (127, mmax (-127, 
            ((coeff[block*64 + i] + sign(coeff[block*64 + i]) * (*(q_table_ptr + i)) / 2)  / (2 * (*(q_table_ptr + i))))
)); 
	    
	  } else {
	    /* no clipping, quantized coefficients  */ 
	    qcoeff[block*64 + i] = (coeff[block*64 + i] + sign(coeff[block*64 + i]) * (*(q_table_ptr + i)) / 2)  / (2 * (*(q_table_ptr + i)));
	  } 
	} 
      } else {
	qcoeff[block*64] = mmax (1, mmin (254, (coeff[block*64] + 32) / 64)); 
	
	for (i = 1; i < 64; i++) {

	  level = (abs (coeff[block*64 + i])) / (2 * (*(q_table_ptr + i)) ); 
	  
	  /* if QP is larger than 8, don't use extended quantization */ 
	  if (!modified_quantization || QP >= 8) {
	    /* clipping to [-127,+127] */ 
	    qcoeff[block*64 + i] = mmin (127, mmax (-127, sign (coeff[block*64 + i]) * level)); 
	  } else {
	    /* no clipping, quantized coefficients  */ 
	    qcoeff[block*64 + i] = sign (coeff[block*64 + i]) * level; 
	  } 
	} 
      } 
    } 
    
    else {
      /* non Intra */ 
      for (i = 0; i < 64; i++) {
	level = (abs (coeff[block*64 + i]) - (*(q_table_ptr + i)) / 2) / (2 * (*(q_table_ptr + i)) ); 
	/* if QP is larger than 8, don't use extended quantization */ 
	if (!modified_quantization || QP >= 8) {
	  /* clipping to [-127,+127] */ 
	  qcoeff[block*64 + i] = mmin (127, mmax (-127, sign (coeff[block*64 + i]) * level)); 
	} else {
	  /* no clipping, quantized coefficients  */ 
	  qcoeff[block*64 + i] = sign (coeff[block*64 + i]) * level; 
	} 
      } 
    } 

}

  }  
  ///////////////////////////////////////////////////
  //End of floatDCT & binDCT Quantization processing.
  ///////////////////////////////////////////////////

  return; 

} 
 
/********************************************************************** 
 * 
 *	Name:        Dequant 
 *	Description:	dequantizer 
 * 
 *	Input:        pointers to coeff and qcoeff 
 * 
 *	Returns: 
 *	Side effects: 
 * 
 *	Date: 940111	Author:	Karl.Lillevold@nta.no 
 * 
 ***********************************************************************/ 
 
 
void Dequant (int *qcoeff,int *rcoeff, int QP, int Mode, int block) 
{ 
  int i; 

  //binDCT:
  //this static variable save the last QP.
  //if the current QP is the same as the last one, use the same Q matrix.
  static int last_lum_QP = 0;
  static int last_chm_QP = 0;
  static int lum_q_table[DCTSIZE2];
  static int chm_q_table[DCTSIZE2];
  int    *scale_ptr;
  double *f_scale_ptr;
  int    *q_table_ptr;

  if (lossless_codec) {
    printf("\nBefore Dequant:\n");
    //lossless bindct
      for (i = 0; i < 64; i++) { 
	  rcoeff[block*64 + i] = qcoeff[block*64 + i]; 
      }
      return;
  }

  /////// Float DCT: use original code
  if (0 == which_dct) {

	/* Modify the chorama quantizer if modified quantization mode is in use */ 
	if (modified_quantization && (block == 4 || block == 5)) {
	  QP=MQ_chroma_QP_table[QP]; 
	} 
	if (QP) {
	  for (i = 0; i < 64; i++) {
		if (qcoeff[block * 64 + i]) {
		  if ((advanced_intra_coding) && (Mode == MODE_INTRA || Mode == MODE_INTRA_Q)) {
			/* Advanced intra coding dequantization */ 
			rcoeff[block * 64 + i] = (QP * (2 * qcoeff[block * 64 + i])); 
			
		  } else {
		    if ((QP % 2) == 1) 
		      rcoeff[block * 64 + i] = QP * (2 * abs (qcoeff[block * 64 + i]) + 1); 
		    else 
		      rcoeff[block * 64 + i] = QP * (2 * abs (qcoeff[block * 64 + i]) + 1) - 1; 
		    rcoeff[block * 64 + i] = sign (qcoeff[block * 64 + i]) * rcoeff[block * 64 + i]; 
		  } 
		  
		} else 
		  rcoeff[block * 64 + i] = 0; 
	  } 
 
	  if ((Mode == MODE_INTRA || Mode == MODE_INTRA_Q) && !advanced_intra_coding) {
		/* Intra (except when advanced intra coding is used) */ 
		rcoeff[block * 64] = qcoeff[block * 64] * 8; 
	  } 
	} else {
	  /* No quantizing at all */ 
	  for (i = 0; i < 64; i++) {
		rcoeff[block * 64 + i] = qcoeff[block * 64 + i]; 
	  } 
	} 

  }

  //////////////////////////////////////////////
  //
  // binDCT 
  //
  //////////////////////////////////////////////
 
  else {

    if ( bindct_scaling_matrix_amp_128) {
      //use the 128-amplified scaling matrix.

    /* Modify the chorama quantizer if modified quantization mode is in use */ 
    if (modified_quantization && (block == 4 || block == 5)) {
      QP=MQ_chroma_QP_table[QP]; 
    } 

    if (block >= 4) {
      //this cover modified quant mode or normal mode, where chm quant = lum quant.
      q_table_ptr = (int *) &chm_q_table;
    } else {
      q_table_ptr = (int *) &lum_q_table;
    }

    //update the Q table if QP changed.
    if ( (( block < 4) && (QP != last_lum_QP)) || 
      ( (block >= 4) && (QP != last_chm_QP)) ) {
      
      if (which_dct < 10) {
	scale_ptr = (int *) &bindct_c_scale;
      } else {
	scale_ptr = (int *) &bindct_l_scale;
      }
      
      //generate quantization table.
      for (i = 0; i < 64; i++) {
	*(q_table_ptr + i) = QP * (*(scale_ptr + i));
      }
      
      //update the last QP.
      if (block >= 4) {
	last_chm_QP = QP;
      } else {
	last_lum_QP = QP;
      }
    } 

    /////////////////////////quantization

    for (i = 0; i < 64; i++) {
      if (qcoeff[block * 64 + i]) {
	if ((advanced_intra_coding) && (Mode == MODE_INTRA || Mode == MODE_INTRA_Q)) {
	  /* Advanced intra coding dequantization */ 
	  rcoeff[block * 64 + i] = ((*(q_table_ptr + i)) * (2 * qcoeff[block * 64 + i]) + 64) >> BINDCT_CST; 
	  
	} else {

	  if ((QP % 2) == 1) 

	    rcoeff[block * 64 + i] = ((*(q_table_ptr + i)) * (2 * abs (qcoeff[block * 64 + i]) + 1) + 64) >> BINDCT_CST; 
	  else 
	    rcoeff[block * 64 + i] = (((*(q_table_ptr + i)) * (2 * abs (qcoeff[block * 64 + i]) + 1) + 64) >> BINDCT_CST) - 1; 

	  rcoeff[block * 64 + i] = sign (qcoeff[block * 64 + i]) * rcoeff[block * 64 + i]; 
	} 
	
      } else 
	rcoeff[block * 64 + i] = 0; 
    } 
    
    if ((Mode == MODE_INTRA || Mode == MODE_INTRA_Q) && !advanced_intra_coding) {
      /* Intra (except when advanced intra coding is used) */ 
      rcoeff[block * 64] = qcoeff[block * 64] * 64; 
    } 

    ////////////////// ///////////////////////////////////////////////////////
    } else {
    //use the non-amplified scaling amtrix

   /* Modify the chorama quantizer if modified quantization mode is in use */ 
    if (modified_quantization && (block == 4 || block == 5)) {
      QP=MQ_chroma_QP_table[QP]; 
    } 

    if (block >= 4) {
      //this cover modified quant mode or normal mode, where chm quant = lum quant.
      q_table_ptr = (int *) &chm_q_table;
    } else {
      q_table_ptr = (int *) &lum_q_table;
    }

    //update the Q table if QP changed.
    if ( (( block < 4) && (QP != last_lum_QP)) || 
      ( (block >= 4) && (QP != last_chm_QP)) ) {
      
      if (which_dct < 10) {
	f_scale_ptr = (double *) &f_bindct_c_scale;
      } else {
	f_scale_ptr = (double *) &f_bindct_l_scale;
      }
      
      //generate quantization table.
      for (i = 0; i < 64; i++) {
	*(q_table_ptr + i) = (int) (QP * (*(f_scale_ptr + i)) + 0.5);
      }
      
      //update the last QP.
      if (block >= 4) {
	last_chm_QP = QP;
      } else {
	last_lum_QP = QP;
      }
    } 

    /////////////////////////quantization

    for (i = 0; i < 64; i++) {
      if (qcoeff[block * 64 + i]) {
	if ((advanced_intra_coding) && (Mode == MODE_INTRA || Mode == MODE_INTRA_Q)) {
	  /* Advanced intra coding dequantization */ 
	  rcoeff[block * 64 + i] = (*(q_table_ptr + i)) * (2 * qcoeff[block * 64 + i]);
	  
	} else {

	  if ((QP % 2) == 1) 

	    rcoeff[block * 64 + i] = (*(q_table_ptr + i)) * (2 * abs (qcoeff[block * 64 + i]) + 1);
	  else 
	    rcoeff[block * 64 + i] = (*(q_table_ptr + i)) * (2 * abs (qcoeff[block * 64 + i]) + 1) - 1;

	  rcoeff[block * 64 + i] = sign (qcoeff[block * 64 + i]) * rcoeff[block * 64 + i]; 
	} 
	
      } else 
	rcoeff[block * 64 + i] = 0; 
    } 
    
    if ((Mode == MODE_INTRA || Mode == MODE_INTRA_Q) && !advanced_intra_coding) {
      /* Intra (except when advanced intra coding is used) */ 
      rcoeff[block * 64] = qcoeff[block * 64] * 64; 
    } 

}
    
  }
  ///////////////////////////////////////////////////
  //End of floatDCT & binDCT Quantization processing.
  ///////////////////////////////////////////////////

  return; 
} 
 
/*********************************************
 *
 *
 *
 *********************************************/
int Get_restricted_MQ(int dquant,int QP_prev) 
{ 
  int new_dquant; 
 
  new_dquant=dquant; 
 
  /*recalculate dquant*/ 
 
  if (QP_prev == 31) 
  { 
    if (dquant <= -5) 
      new_dquant=-5; 
    else 
      new_dquant=-3; 
  } 
  else 
  if (QP_prev == 30) 
  { 
    if (dquant <= 0) 
      new_dquant=-3; 
    else 
      new_dquant=1; 
  } 
  else 
  if (QP_prev == 29) 
  { 
    if (dquant <= 0) 
      new_dquant=-3; 
    else 
      new_dquant=2; 
  } 
  else 
  if (QP_prev >= 21) 
  { 
    if (dquant <= 0) 
      new_dquant=-3; 
     else 
      new_dquant=3; 
   } 
   else 
   if (QP_prev >= 11) 
   { 
     if (dquant <= 0) 
       new_dquant=-2; 
     else 
       new_dquant=2; 
   } 
   else 
   if (QP_prev >= 2) 
   { 
     if (dquant <= 0) 
       new_dquant=-1; 
     else 
       new_dquant=1; 
   } 
   else 
   { 
     if (dquant <= 1) 
       new_dquant=1; 
     else 
       new_dquant=2; 
   } 
 
   return new_dquant; 
} 
