/************************************************************************ 
 * 
 *  ring_buf.c, Buffer functions used for Reference Picture Section Mode. 
 * 
 *  Copyright (C) 1997  University of BC, Canada 
 * 
 *  Contacts:  
 *  Michael Gallant                   <mikeg@ee.ubc.ca> 
 *  Guy Cote                          <guyc@ee.ubc.ca> 
 *  Berna Erol                        <bernae@ee.ubc.ca> 
 * 
 *  UBC Image Processing Laboratory   http://www.ee.ubc.ca/image 
 *  2356 Main Mall                    tel.: +1 604 822 4051 
 *  Vancouver BC Canada V6T1Z4        fax.: +1 604 822 5949 
 * 
 ************************************************************************/ 
 
/* 
 * Disclaimer of Warranty 
 * 
 * These software programs are available to the user without any 
 * license fee or royalty on an "as is" basis. The University of 
 * British Columbia disclaims any and all warranties, whether 
 * express, implied, or statuary, including any implied warranties 
 * or merchantability or of fitness for a particular purpose.  In no 
 * event shall the copyright-holder be liable for any incidental, 
 * punitive, or consequential damages of any kind whatsoever arising 
 * from the use of these programs. 
 * 
 * This disclaimer of warranty extends to the user of these programs 
 * and user's customers, employees, agents, transferees, successors, 
 * and assigns. 
 * 
 * The University of British Columbia does not represent or warrant 
 * that the programs furnished hereunder are free of infringement of 
 * any third-party patents. 
 * 
 * Commercial implementations of H.263, including shareware, are 
 * subject to royalty fees to patent holders.  Many of these patents 
 * are general enough such that they are unavoidable regardless of 
 * implementation design. 
 * 
*/ 
 
#include "sim.h" 
#define RING_SIZE 8 
 
int   ring_pointer;                           /* pointer to last picture        */ 
PictImage *ring_orig[RING_SIZE] = {NULL};     /* Ring buffers for original and  */ 
PictImage *ring_recon[RING_SIZE] = {NULL};    /* reconstructed images           */ 
int   ring_temporal_reference[RING_SIZE];     /* TR values for the pictures     */ 
int   ring_quality[RING_SIZE];                /* Picture Quality                */   
 
/********************************************************************** 
 * 
 *	Name:         GetReferencePicture 
 *	Description:  gets the requested prediction picture from 
 *                the ring buffer. 
 *	 
 *	Input:        tr, orig, recon 
 *         
 *	Returns:      0 
 *	Side effects:  
 * 
 *	Date: 980610  Author: Guy Cote <guyc@ece.ubc.ca> 
 * 
 ***********************************************************************/ 
int GetReferencePicture(int tr, PictImage *orig, PictImage *recon) 
{ 
  int i; 
   
  for (i = ring_pointer; i != (ring_pointer+1)%RING_SIZE;  
  i = (i+RING_SIZE-1)%RING_SIZE)  
  { 
    if (tr == ring_temporal_reference[i]) 
      break; 
  } 
   
  if (!ring_orig[i]->lum || tr != ring_temporal_reference[i]) 
    return -1; 
   
  memcpy(orig->lum, ring_orig[i]->lum, pels*lines); 
  memcpy(orig->Cr,  ring_orig[i]->Cr,  pels*lines/4); 
  memcpy(orig->Cb,  ring_orig[i]->Cb,  pels*lines/4); 
  memcpy(recon->lum,ring_recon[i]->lum, pels*lines); 
  memcpy(recon->Cr, ring_recon[i]->Cr,  pels*lines/4); 
  memcpy(recon->Cb, ring_recon[i]->Cb,  pels*lines/4); 
  return 0; 
} 
/********************************************************************** 
 * 
 *	Name:         StorePicture 
 *	Description:  Stores a picture into the ring buffer.                   
 *	 
 *	Input:        tr, orig, recon 
 *         
 *	Returns:      0 
 *	Side effects:  
 * 
 *	Date: 980610  Author: Guy Cote <guyc@ece.ubc.ca> 
 * 
 ***********************************************************************/ 
 
void StorePicture(int tr, PictImage *orig, PictImage *recon) 
{ 
   
  ring_pointer = (ring_pointer+1)%RING_SIZE; 
  if (!ring_orig[ring_pointer])  
  { 
    ring_orig[ring_pointer] = InitImage(pels*lines); 
    ring_recon[ring_pointer] = InitImage(pels*lines); 
  } 
  memcpy(ring_orig[ring_pointer]->lum,orig->lum,  (sizeof (char))*pels*lines); 
  memcpy(ring_orig[ring_pointer]->Cr, orig->Cr,   (sizeof (char))*pels*lines/4); 
  memcpy(ring_orig[ring_pointer]->Cb, orig->Cb,   (sizeof (char))*pels*lines/4); 
  memcpy(ring_recon[ring_pointer]->lum,recon->lum, (sizeof (char))*pels*lines); 
  memcpy(ring_recon[ring_pointer]->Cr, recon->Cr,  (sizeof (char))*pels*lines/4); 
  memcpy(ring_recon[ring_pointer]->Cb, recon->Cb,  (sizeof (char))*pels*lines/4);  
 
  ring_temporal_reference[ring_pointer] = tr; 
} 
