function [gdb,Ryy]=bgtc(H,G);
% [gdb,Ryy]=bgtc(H,G);
% Function to calculate the coding gain of a biorthogonal PRFB
% Rows of H hold the analysis filter coefficients
% Rows of G hold the synthesis filter coefficients

% Trac D. Tran 
% ECE Department, The Johns Hopkins University
% 3400 North Charles Street, 105 Barton Hall,
% Baltimore, MD 21218
% E-mail: trac@jhu.edu
% - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
% Copyright (c) 2000 Trac D Tran
% This program is Copyright (c) by Trac D Tran.
% It may not be redistributed without the consent of the copyright
% holders. In no circumstances may the copyright notice be removed.
% The program may not be sold for profit nor may they be incorporated
% in commercial programs without the written permission of the copyright
% holders. This program is provided as is, without any express or
% implied warranty, without even the warranty of fitness for a
% particular purpose.
%-----------------------------------------------------------------------

[m,n]=size(H);
Rxx=toeplitz(0.95.^[0 : (n-1)]');
Ryy=H*Rxx*H';
s=diag(Ryy);
% g=mean(s)/(prod(s)^(1/m));
% g=1/((prod(s.*sqrt(diag(G*G'))))^(1/m));
gdb=1/((prod(s.*diag(G*G')))^(1/m));
gdb=10*log10(gdb);

