function bp=bplot1(P,L);
% functions to plot basis functions of FB given by P.
% bp=bplot1(P);

% Trac D. Tran and Jie Liang
% ECE Department, The Johns Hopkins University
% 3400 North Charles Street, 105 Barton Hall,
% Baltimore, MD 21218
% E-mail: trac@jhu.edu, jieliang@jhu.edu
% Dec. 2000
% - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
% Copyright (c) 2000 Trac D Tran and Jie Liang
% This program is Copyright (c) by Trac D Tran and Jie Liang.
% It may not be redistributed without the consent of the copyright
% holders. In no circumstances may the copyright notice be removed.
% The program may not be sold for profit nor may they be incorporated
% in commercial programs without the written permission of the copyright
% holders. This program is provided as is, without any express or
% implied warranty, without even the warranty of fitness for a
% particular purpose.
%-----------------------------------------------------------------------

figure;
pos=get(gcf,'Position');
set(gcf,'Position',[pos(1),pos(2),pos(3)/2,pos(4)]);

[M,lth]=size(P);
if nargin == 1
    %use default lth
    L = lth;
    range = [1 : lth];
else    
    range = [(lth-L)/2 + 1 : lth - (lth-L)/2]; %skip zeros at the boundary.
end    

cmax = max(max(P));cmin = min(min(P));

for i=1:M
  subplot(M,1,i);
  stem(P(i,range));
  axis([1 L cmin*1.3 cmax*1.3]);
  axis('off');
end;