% RUNDEMOS Runs all demonstration files the accompany the CompEcon Toolbox
% 
% COMPECON: COMPUTATIONAL ECONOMICS AND FINANCE
% Demonstration files to accompany:
%   Applied Computational Economics and Finance
%   Mario J. Miranda & Paul L. Fackler
%   2002, MIT Press, Cambridge MA
%   ISBN 0-262-13420-9
%
% *********** Introductory problems *********** 
DEMINT01 % Solves inverse demand problem *
DEMINT02 % Solves nonlinear rational expectations agricultural market model
%
% *********** Linear Equations *********** 
DEMLIN01 % Compares effort to solve Ax=b by different methods
DEMLIN02 % Demonstrates ill-conditionsing of Vandermonde matrix
DEMLIN03 % Compares various methods for solving sparse linear equations
%
% *********** Rootfinding Problems *********** 
DEMSLV01 % Compute root of Rosencrantz function via Newton and Broyden methods
DEMSLV02 % Computes root of function using Newton, quasi-Newton and Bisection
DEMSLV03 % Computes fixed point y=[x1^2+x2^3;x1*x2-0.5] via function iteration and Newton methods
DEMSLV04 % Graphical demonstration of computing fixed point y=x^0.5
DEMSLV05 % Compare various linear complementarity algorithms
DEMSLV06 % Demonstrates different NCP methods
DEMSLV07 % Demonstrates different NCP methods with Billup's function
DEMSLV08 % Compute fixedpoint of using function iteration and Newton method
DEMSLV10 % Demonstrates bisection method
DEMSLV11 % Generates figures for Chapter 3
DEMSLV12 % Cournot demonstration
DEMSLV13 % Illustrates CP problems
DEMSLV14 % Illustrates Problematic Complementarity Problems
DEMSLV15 % Illustrates minmax and semi-smooth reformulations of CP problems
DEMSLV16 % Billups Hard NCP
% 
% *********** Optimization Problems ***********
DEMOPT01 % Illustrates maximization via golden search
DEMOPT02 % Displays changes in a simplex
DEMOPT03 % Demonstrates Nelder-Mead simplex method
DEMOPT04 % Demonstrates Quasi-Newton maximization
DEMOPT05 % Step length determination
DEMOPT06 % Illustrates constrained optimization problems
DEMOPT07 % Maximizes function subject to simple bounds via sequential LCP
% 
% *********** Quadrature Methods ***********
DEMQUA01 % Plots equi-distributed sequences in 2-D
DEMQUA02 % Compute expectation of function of random normal vector
DEMQUA03 % Compares quadrature methods
DEMQUA04 % Compare various quadrature methods
DEMQUA05 % Compares Chebyshev and Legendre quadrature nodes and weights
% 
% *********** Derivatives and Differential Equation Examples ***********
DEMDIF01 % Plot to illustrate finite difference Hessian evaluation
DEMDIF02 % Demonstrates errors in finite difference differentiation of e(x)
DEMDIF03 % Commercial Fishery Model (from V.L. Smith)
% 
% *********** Function Approximation ***********
DEMAPP00 % Creates Table 6.1
DEMAPP01 % Plot basis functions and standard nodes for major approximation schemes
DEMAPP02 % Compare polynomial and spline approximation of function exp(-x)
DEMAPP03 % Compare conditioning of Vandermonde and Chebychev matrices
DEMAPP04 % Approximating Runge's function and other comparisons
DEMAPP05 % Demonstrates alternative approximants for various functions
DEMAPP06 % Approximate exp(-x) on [-1,1] via spline and Chebychev approximation
DEMAPP07 % Approximate y=x1/exp(x2) on [0,5]x[-1,1] using spline and Chebychev approximation
DEMAPP08 % Approximate y=(exp(x1*x2)+x3^3)/100 on [0,1]^3 via spline and Chebychev approximation
DEMAPP09 % Cournot oligopolist problem
DEMAPP10 % Approximate function inverse via collocation
DEMAPP11 % Equilibrium Storage Problem
% 
% *********** Boundary Value Problems ***********
DEMBVP01 % BVP illustrative example 
DEMBVP02 % Commodity storage example
% 
% *********** Discrete Dynamic Programming ***********
DEMDDP01 % Mine Management Model
DEMDDP02 % Asset Replacement Model
DEMDDP03 % Asset Replacement with Maintenance Model
DEMDDP04 % Binomial Americal Option Pricing Model
DEMDDP05 % Water Management Model
DEMDDP06 % Bioeconomic Model
DEMDDP07 % Renewable Resource Model 
DEMDDP08 % Job Search Model
DEMDDP09 % Deterministic Cow Replacement Model
DEMDDP10 % Stochastic Cow Replacement Model
DEMDDP11 % Optimal growth model
%
% *********** Dynamic Programming ***********
DEMDP01 % Asset Replacement Model
DEMDP02 % Industry Entry-Exit Model
DEMDP03 % Timber Cutting Model
DEMDP04 % American Option Pricing Model
DEMDP05 % Job Search Model
DEMDP06 % Asset Replacement-Maintanence Model
DEMDP07 % Optimal Growth Model
DEMDP08 % Renewable Resource Model
DEMDP09 % Non-Renewable Resource Model
DEMDP10 % Water Management Model
DEMDP11 % Monetary Policy Model
DEMDP12 % Production-Adjustment Model
DEMDP13 % Producton-Inventory Model
DEMDP14 % Livestock Feeding Model
%
% *********** Dynamic Games ***********
if 0 %  Change to run the games models (these take a long time)
DEMGAME01 % Capital Production Game
DEMGAME02 % Income Redistribution Game
DEMGAME03 % Marketing Board Game
end
% 
% *********** Rational Expectations Models ***********
DEMREM01 % Asset Pricing Model
DEMREM02 % Commodity Storage Model
DEMREM03 % Government Price Support Model
%  
% *********** Financial Asset Pricing ***********
DEMFIN01 % Cox-Ingersoll-Ross bond pricing example
DEMFIN02 % Black-Scholes option pricing model
DEMFIN03 % Heston's stochastic volatility option pricing model
DEMFIN04 % American put option pricing problem
DEMFIN05 % Barrier option pricing problem
DEMFIN06 % Compound option pricing example - option on a bond
DEMFIN07 % Asian option pricing demonstration
DEMFIN08 % Affine asset pricing demonstration
DEMFIN09 % Financial asset calibration demonstration
% 
% *********** Stochastic Control ***********
DEMSC01 % Optimal Growth Model
DEMSC02 % Renewable Resource Model
DEMSC03 % Production-Adjustment Model
DEMSC04 % Optimal Fish Harvest Model
DEMSC05 % Sequential Learning Model
DEMSC06 % Nonrenewable Resource Model (continuous time)
% 
% *********** Regime Switching Problems ***********
DEMRS01 % Asset Abandonment Model
DEMRS02 % Optimal Fish Harvest Model
DEMRS03 % Entry/exit Model
%
% *********** Impulse Control Problems ***********
DEMIC01 % Asset Replacement Demonstration
DEMIC02 % Timber Harvesting Demonstration
DEMIC03 % Storage Management Demonstration
DEMIC04 % Capacity Choice Demonstration
DEMIC05 % Cash Management Demonstration
DEMIC06 % Optimal Fish Harvest problem (infinite harvest rate)