% DDPSIMUL  Monte Carlo simulation of discrete-state/action controlled Markov process
% USAGE
%   spath = dpsimul(pstar,s,N,x)
% INPUTS
%   pstar   : optimal state transition matrix
%   s       : k by 1 vector of initial states
%   N       : number of simulated time periods
%   x       : optimal controls
% OUTPUT
%   spath   : k by N+1 vector of simulated states

% Copyright (c) 1997-2000, Paul L. Fackler & Mario J. Miranda
% paul_fackler@ncsu.edu, miranda.4@osu.edu

function [spath,xpath] = dpsimul(pstar,s,N,x)

l = length(size(pstar));
n = length(pstar);
u = ones(n,1);
k = length(s);
spath=zeros(k,N+1);

if l==2 % Infinite Horizon Model
  cp=cumsum(pstar,2); 
  for t=1:N+1 
    spath(:,t) = s;
    r = rand(k,1); 
    s = n+1-sum(r(:,u)<cp(s,:),2);
  end
else    % Finite Horizon Model
  T = size(pstar,3);
  N = min(N,T);
  for t=1:N+1
    spath(:,t) = s;
    r = rand(k,1);
    s = n+1-sum(r(:,u)<cumsum(pstar(s,:,t),2),2); 
  end
end

if nargout>1
  xpath=zeros(k,N+1);
  xpath(:)=x(spath(:));
end