workfile monte u 1 1000
' set the (fixed) sample size (maximum = 1000)
!series = 500
'
' set the number of monte carlo draws (maximum = 1000)
!draws = 700
'
' set the standard deviation of the explanatory variable
!sigmax = 3
'
smpl 1 !series
' generate the (fixed) x series
series x = 10+!sigmax*nrnd
'
' set the (fixed) model parameters
!sigmau = 1
!alpha = 2
!beta = 3
'
' initialize the beta vector
vector(!draws) betavec = 0
'
' do the monte carlo iterations
for !n = 1 to !draws
   series u = !sigmau*nrnd
   series y = !alpha + !beta*x + u
   equation eq1.ls y c x
   betavec(!n) = @coefs(2)
next
'
' define new default sample size and initialize beta series
smpl 1 !draws
series betaser = 0
'
' convert the monte carlo beta vector to a series
mtos(betavec,betaser)
'
' plot a histogram of the monte carlo results
betaser.hist
'
' save into whatever directory you want
save c:\econ835

