//=============================================================================
// File: _ut_vivaldi.cc
// Author: Andre Dufour
//
// Description: unit test code for the implementation of the Vivaldi coordinate
//              system.
//=============================================================================

#include "vivaldimanager.h"
#include "gnutcoord.h"
#include <iostream>

// IMPORTANT ******
// Must temporarily make GnutCoord::GnutCoord(double, double, double)
// public for this test harness to work.

int main(int argc, const char* argv)
{
    using namespace std;

    {
        GnutCoord gc;
        
        gc += GnutCoord(1,1,1);
        cout << "Expected (1, 1, 1), got " << gc << endl;
        
        gc *= 2.0;
        cout << "Expected (2, 2, 2), got " << gc << endl;
        
        bool equals = gc == gc;
        cout << "Expected 1, got " << equals << endl;

        bool not_equals = gc != gc;
        cout << "Expected 0, got " << not_equals << endl;

        cout << "|gc| Expected 3.4641, got = " << gc.funkyAbs() << endl;

        gc = 2 * gc;
        cout << "Expected (4, 4, 4), got " << gc << endl;

        gc = gc * 2;
        cout << "Expected (8, 8, 8), got " << gc << endl;

        gc = gc - gc;
        cout << "Expected (0, 0, 16), got " << gc << endl;

        cout << "Random unit vector " << GnutCoord(1) << endl;

        cout << "Unit vector in direction (1, 1, 1): " 
             << GnutCoord(1, GnutCoord(1,1,1)) << endl;

        cout << "Length of unit vector: " 
             << GnutCoord(1, GnutCoord(1,1,1)).funkyAbs()
             << endl;
    }


    VivaldiManager viv1;
    VivaldiManager viv2;
    VivaldiManager viv3;
    
    const double rtt12 = 120.0;
    const double rtt23 = 20.0;
    const double rtt31 = 150.0;

    for (int i = 0; i < 200; i++)
    {
        cout << endl << "Iteration " << i << endl
             << "1: Coord: " << viv1.getCoordinates() << endl
             << "\tError: " << viv1.getLocalError() << endl
             << "2: Coord: " << viv2.getCoordinates() << endl
             << "\tError: " << viv2.getLocalError() << endl
             << "3: Coord: " << viv3.getCoordinates() << endl
             << "\tError: " << viv3.getLocalError() << endl
             << "RTT estimate12: " << viv1.estimateRtt(viv2.getCoordinates()) 
             << endl
             << "RTT estimate21: " << viv2.estimateRtt(viv1.getCoordinates()) 
             << endl
             << "RTT estimate23: " << viv2.estimateRtt(viv3.getCoordinates())
             << endl
             << "RTT estimate32: " << viv3.estimateRtt(viv2.getCoordinates()) 
             << endl
             << "RTT estimate13: " << viv1.estimateRtt(viv3.getCoordinates()) 
             << endl
             << "RTT estimate31: " << viv3.estimateRtt(viv1.getCoordinates()) 
             << endl;

        viv1.updateCoordinates(viv2.getCoordinates(), rtt12, 
                               viv2.getLocalError());
        viv1.updateCoordinates(viv3.getCoordinates(), rtt31, 
                               viv3.getLocalError());
        viv2.updateCoordinates(viv1.getCoordinates(), rtt12, 
                               viv1.getLocalError());
        viv2.updateCoordinates(viv3.getCoordinates(), rtt23, 
                               viv3.getLocalError());
        viv3.updateCoordinates(viv1.getCoordinates(), rtt31, 
                               viv1.getLocalError());
        viv3.updateCoordinates(viv2.getCoordinates(), rtt23, 
                               viv2.getLocalError());
    }

    return 0;
}

