// File: activitycontroller.cc
// Original by Qi He
// Modified by Andre Dufour

#include "activitycontroller.h"
#include "gnut_types.h"
#include "gnut_util.h"
#include "peersys.h"

//=============================================================================
/* ActivityController:                                        */
/* dynamically generates events corresponding to peer actions */
ActivityController::ActivityController(PeerSys *sys, GnutellaApp *app, int cl) 
{
  ClassMap_t::iterator ci = sys->classes_.find(cl);
  if(ci==sys->classes_.end()) {
    fprintf(stderr, "WARNING: assigning to nonexistent class\n");
    return;
  }
  if(ci!=sys->classes_.end()) {
      clSpec_ = &(ci->second);
  } 
  sys_ = sys;
  app_ = app;
  state_ = &app_->state_;
  app_->setFreeloader(clSpec_->isFreeloader_); 
}

//=============================================================================
/* change of status triggered by a timer scheduled during last change */
void ActivityController::expire(Event *e) {
  double roff, rdelay;

  if(*state_==PS_ACTIVE) {
    //a certain probability of going offline from active searching
    roff = (double)rand()/(double)RAND_MAX;
    if(roff < clSpec_->poff_) {
      GnutUtil::gnutError("Going offline after successful query\n");
      app_->setState(PS_OFFLINE);
      rdelay = (double)rand()/(double)RAND_MAX * clSpec_->loff_;
      resched(rdelay);
    } else {
      app_->setState(PS_IDLE);
      rdelay = (double)rand()/(double)RAND_MAX * clSpec_->lidle_;
      resched(rdelay);
    }
  } else {
    if(*state_==PS_IDLE) {
      app_->setState(PS_ACTIVE);
      gen_query();
      resched(QUERY_TIMEOUT);
    } else {
      app_->bootstrap();
      app_->setState(PS_IDLE);
      rdelay = (double)rand()/(double)RAND_MAX * clSpec_->lidle_;
      resched(rdelay);
    }
  }
}

//=============================================================================
/* generate a query based on file statistics of the system */
void ActivityController::gen_query() 
{
#ifdef __AD_DISABLE_UMASS__
  double rprob = (double)rand()/(double)RAND_MAX;
  char criteria[4];

  for(int i=0; i<sys_->nFiles_; i++) {
    if (rprob < sys_->cdffile_[i]) {
      app_->search();
      break;
    }
  }
#endif /* __AD_DISABLE_UMASS__ */
}

//=============================================================================
/* returns the popularity of a file */
/*
double ActivityController::find_file(int fnum) {
  if (fnum >=sys_->nFiles_ || fnum < 0) 
    return sys_->cdffile_[fnum];
  else
    return -1;
}
*/
//=============================================================================

