//=============================================================================
// File: _ut_vivaldi.cc
// Author: Andre Dufour
//
// Description: unit test code for the implementation of the Vivaldi coordinate
//              system.
//=============================================================================

#include "vivaldimanager.h"
#include "gnutcoord.h"
#include <iostream>

// IMPORTANT ******
// Must temporarily make GnutCoord::GnutCoord(double, double, double)
// public for this test harness to work.

int main(int argc, const char* argv)
{
    using namespace std;

    {
        GnutCoord gc;
        
        gc += GnutCoord(1,1,1);
        cout << "Expected (1, 1, 1), got " << gc << endl;
        
        gc *= 2.0;
        cout << "Expected (2, 2, 2), got " << gc << endl;
        
        bool equals = gc == gc;
        cout << "Expected 1, got " << equals << endl;

        bool not_equals = gc != gc;
        cout << "Expected 0, got " << not_equals << endl;

        cout << "|gc| Expected 3.4641, got = " << gc.abs() << endl;

        gc = 2 * gc;
        cout << "Expected (4, 4, 4), got " << gc << endl;

        gc = gc * 2;
        cout << "Expected (8, 8, 8), got " << gc << endl;

        gc = gc - gc;
        cout << "Expected (0, 0, 16), got " << gc << endl;

        cout << "Random unit vector " << GnutCoord(1) << endl;

        cout << "Unit vector in direction (1, 1, 1): " 
             << GnutCoord(1, GnutCoord(1,1,1)) << endl;
    }


    VivaldiManager viv1;
    VivaldiManager viv2;
    
    const double rtt = 27.0;

    for (int i = 0; i < 200; i++)
    {
        cout << endl << "Iteration " << i << endl
             << "1: Coord: " << viv1.getCoordinates() << endl
             << "\tError: " << viv1.getLocalError() << endl
             << "2: Coord: " << viv2.getCoordinates() << endl
             << "\tError: " << viv2.getLocalError() << endl
             << "RTT estimate1: " << viv1.estimateRtt(viv2.getCoordinates()) 
             << endl
             << "RTT estimate2: " << viv2.estimateRtt(viv1.getCoordinates())
             << endl;

        viv1.updateCoordinates(viv2.getCoordinates(), rtt, 
                               viv2.getLocalError());
        viv2.updateCoordinates(viv1.getCoordinates(), rtt, 
                               viv1.getLocalError());
    }

    return 0;
}

