// File: gnut_util.h
// Original by Qi He
// Modified by Andre Dufour
#ifndef __GNUT_UTIL_H__
#define __GNUT_UTIL_H__

#include <stdio.h>

#define GNUT_DEBUG

void debug_info(char *format, ...); 

void debug_warning(char *format, ...);

void debug_stat(char *format, ...);

//=============================================================================
namespace GnutUtil
{
    double now(void);
    void gnutTrace(char* format, ...);
    void gnutError(char* format, ...);
};
//=============================================================================


#ifdef GNUT_DEBUG
#define GNUT_ASSERT(condition)                                              \
    do                                                                      \
    {                                                                       \
        if (!(condition))                                                   \
        {                                                                   \
            printf("Assertion failure: %s:%d.",                             \
                   __FILE__, __LINE__);                                     \
            fflush(NULL);                                                   \
            exit(0);                                                        \
        }                                                                   \
    } while(0)
#else /* GNUT_DEBUG */
#define GNUT_ASSERT(condition, note)
#endif /* GNUT_DEBUG */


#endif /* __GNUT_UTIL_H__ */

